from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.domain.beams
import cern.accsoft.commons.domain.lhc
import cern.accsoft.commons.util
import cern.lsa.domain.commons
import cern.lsa.domain.devices
import java.io
import java.lang
import java.util


class BlmCrateInfo(cern.accsoft.commons.util.Named):
    def getBlecfPresent(self) -> int: ...
    def getBlecsFirmwareVersion(self) -> int: ...
    def getBlecsSerial(self) -> int: ...
    def getBletcPresent(self) -> int: ...
    def getChannelCableConnected(self) -> _py_List[int]: ...
    def getExpertNames(self) -> _py_List[_py_List[str]]: ...
    def getHvcfcTestHv(self) -> int: ...
    def getHvcfcTestHvPeak(self) -> int: ...
    def getLastLSAModification(self) -> int: ...
    def getLhcInteractionPoint(self) -> cern.accsoft.commons.domain.lhc.LhcInteractionPoint: ...
    def getMod1GainMax(self) -> _py_List[int]: ...
    def getMod1GainMin(self) -> _py_List[int]: ...
    def getMod1Period(self) -> int: ...
    def getMod1PhaseMax(self) -> _py_List[int]: ...
    def getMod1PhaseMin(self) -> _py_List[int]: ...
    def getMod1Voltage(self) -> int: ...
    def getMod2GainMax(self) -> _py_List[int]: ...
    def getMod2GainMin(self) -> _py_List[int]: ...
    def getMod2Period(self) -> int: ...
    def getMod2PhaseMax(self) -> _py_List[int]: ...
    def getMod2PhaseMin(self) -> _py_List[int]: ...
    def getMod2Voltage(self) -> int: ...
    def getModTestHv(self) -> int: ...
    def getNormalOpHv(self) -> int: ...
    def getNormalOpHv1Hv2Diff(self) -> int: ...
    def getOfficialNames(self) -> _py_List[_py_List[str]]: ...
    def getRdacResetHv(self) -> int: ...
    def getRdacResetHvPeak(self) -> int: ...
    def getRgohResetHv(self) -> int: ...
    def getRgohResetHvPeak(self) -> int: ...

class BlmFamily(cern.accsoft.commons.util.Named):
    def getAmpsFactor(self) -> float: ...
    def getGysFactor(self) -> float: ...
    def getThresholds(self) -> _py_List[int]: ...

class BlmInfo(cern.accsoft.commons.util.Named):
    ALL_THRESHOLDS_INCLUDED: _py_ClassVar[_py_List[bool]] = ...
    NUM_CARDS: _py_ClassVar[int] = ...
    NUM_CHANNELS_PER_CARD: _py_ClassVar[int] = ...
    NUM_ENERGY_LEVELS: _py_ClassVar[int] = ...
    NUM_RUNNING_SUMS: _py_ClassVar[int] = ...
    NUM_MAX_VALUES_PER_CARD: _py_ClassVar[int] = ...
    def getBlecfSerial(self) -> int: ...
    def getBletcFirmwareVersion(self) -> int: ...
    def getBletcSerial(self) -> int: ...
    def getBlmFamily(self) -> BlmFamily: ...
    def getCardIndex(self) -> int: ...
    def getChannelIndex(self) -> int: ...
    def getCrateName(self) -> str: ...
    def getDcum(self) -> int: ...
    def getFilterValueCapacitor(self) -> int: ...
    def getFilterValueResistor(self) -> int: ...
    def getIncludedRunningSums(self) -> _py_List[bool]: ...
    def getLastLSAModification(self) -> int: ...
    def getLhcInteractionPoint(self) -> cern.accsoft.commons.domain.lhc.LhcInteractionPoint: ...
    def getMobileName(self) -> str: ...
    def getOfficialName(self) -> str: ...
    def isCableConnected(self) -> bool: ...
    def isConnectedToBis(self) -> bool: ...
    def isMasked(self) -> bool: ...
    def isSpare(self) -> bool: ...

class CernDevices:
    def __init__(self): ...
    @classmethod
    def isFgc(cls, device: cern.lsa.domain.devices.Device) -> bool: ...

class CollimatorAlignment(cern.lsa.domain.commons.IdentifiedEntity):
    def getAlignmentTime(self) -> java.util.Date: ...
    def getBeamModeCategory(self) -> str: ...
    def getCollimatorName(self) -> str: ...
    def getLeftJawPos(self) -> float: ...
    def getOpticName(self) -> str: ...
    def getRightJawPos(self) -> float: ...
    def getTcp1LeftPos(self) -> float: ...
    def getTcp1RightPos(self) -> float: ...
    def getTcp2LeftPos(self) -> float: ...
    def getTcp2RightPos(self) -> float: ...

class CollimatorRegion(java.lang.Enum['CollimatorRegion']):
    LHC_IP1: _py_ClassVar['CollimatorRegion'] = ...
    LHC_IP2: _py_ClassVar['CollimatorRegion'] = ...
    LHC_IP3: _py_ClassVar['CollimatorRegion'] = ...
    LHC_IP4: _py_ClassVar['CollimatorRegion'] = ...
    LHC_IP5: _py_ClassVar['CollimatorRegion'] = ...
    LHC_IP6: _py_ClassVar['CollimatorRegion'] = ...
    LHC_IP7: _py_ClassVar['CollimatorRegion'] = ...
    LHC_IP8: _py_ClassVar['CollimatorRegion'] = ...
    TI2: _py_ClassVar['CollimatorRegion'] = ...
    TI8: _py_ClassVar['CollimatorRegion'] = ...
    SPS: _py_ClassVar['CollimatorRegion'] = ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'CollimatorRegion': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['CollimatorRegion']: ...

class DeviceGroupTypeEnum(java.lang.Enum['DeviceGroupTypeEnum'], cern.lsa.domain.devices.DeviceGroupType):
    PROCESS: _py_ClassVar['DeviceGroupTypeEnum'] = ...
    WORKING_SET: _py_ClassVar['DeviceGroupTypeEnum'] = ...
    DEVICES: _py_ClassVar['DeviceGroupTypeEnum'] = ...
    SOC: _py_ClassVar['DeviceGroupTypeEnum'] = ...
    OP_CONFIG: _py_ClassVar['DeviceGroupTypeEnum'] = ...
    WORKING_SET_DEVICES: _py_ClassVar['DeviceGroupTypeEnum'] = ...
    def getDescription(self) -> str: ...
    def getName(self) -> str: ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'DeviceGroupTypeEnum': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['DeviceGroupTypeEnum']: ...

class LhcBeamLossMap:
    def getAllEntries(self) -> java.util.List['LhcBeamLossMap.LhcBeamLossMapEntry']: ...
    def getEntry(self, lhcBeam: cern.accsoft.commons.domain.beams.LhcBeam, string: str, string2: str) -> 'LhcBeamLossMap.LhcBeamLossMapEntry': ...
    class LhcBeamLossMapEntry(java.io.Serializable):
        def getBeam(self) -> cern.accsoft.commons.domain.beams.LhcBeam: ...
        def getBeamModeCategory(self) -> str: ...
        def getConfigType(self) -> str: ...
        def getValidFrom(self) -> int: ...
        def getValidTo(self) -> int: ...

class LhcCollimatorInfo(cern.accsoft.commons.util.Named):
    def getAngle(self) -> float: ...
    def getAutoRetractionLeftDown(self) -> float: ...
    def getAutoRetractionLeftUp(self) -> float: ...
    def getAutoRetractionRightDown(self) -> float: ...
    def getAutoRetractionRightUp(self) -> float: ...
    def getAxisLeftDown(self) -> float: ...
    def getAxisLeftUp(self) -> float: ...
    def getAxisRightDown(self) -> float: ...
    def getAxisRightUp(self) -> float: ...
    def getAxisTank(self) -> float: ...
    def getBeam(self) -> cern.accsoft.commons.domain.beams.LhcBeam: ...
    def getBlmi(self) -> str: ...
    def getBlmi2(self) -> str: ...
    def getBlms(self) -> str: ...
    def getBlms2(self) -> str: ...
    def getBpmBtnAttnCoeffLeftDown(self) -> float: ...
    def getBpmBtnAttnCoeffLeftUp(self) -> float: ...
    def getBpmBtnAttnCoeffRightDown(self) -> float: ...
    def getBpmBtnAttnCoeffRightUp(self) -> float: ...
    def getBpmBtnCapacitanceLeftDown(self) -> float: ...
    def getBpmBtnCapacitanceLeftUp(self) -> float: ...
    def getBpmBtnCapacitanceRightDown(self) -> float: ...
    def getBpmBtnCapacitanceRightUp(self) -> float: ...
    def getBpmBtnDiameterLeftDown(self) -> float: ...
    def getBpmBtnDiameterLeftUp(self) -> float: ...
    def getBpmBtnDiameterRightDown(self) -> float: ...
    def getBpmBtnDiameterRightUp(self) -> float: ...
    def getBpmBtnDistToJawLeftDown(self) -> float: ...
    def getBpmBtnDistToJawLeftUp(self) -> float: ...
    def getBpmBtnDistToJawRightDown(self) -> float: ...
    def getBpmBtnDistToJawRightUp(self) -> float: ...
    def getBpmBtnDistToSfcLeftDown(self) -> float: ...
    def getBpmBtnDistToSfcLeftUp(self) -> float: ...
    def getBpmBtnDistToSfcRightDown(self) -> float: ...
    def getBpmBtnDistToSfcRightUp(self) -> float: ...
    def getBpmChannelIdLeftDown(self) -> float: ...
    def getBpmChannelIdLeftUp(self) -> float: ...
    def getBpmChannelIdRightDown(self) -> float: ...
    def getBpmChannelIdRightUp(self) -> float: ...
    def getBpmFrontEndIdDown(self) -> float: ...
    def getBpmFrontEndIdUp(self) -> float: ...
    def getBpmNameDown(self) -> str: ...
    def getBpmNameUp(self) -> str: ...
    def getCercaName(self) -> str: ...
    def getDisplayName(self) -> str: ...
    def getFamily(self) -> str: ...
    def getJawLeftDown(self) -> str: ...
    def getJawLeftUp(self) -> str: ...
    def getJawRightDown(self) -> str: ...
    def getJawRightUp(self) -> str: ...
    def getLastUpdate(self) -> java.util.Date: ...
    def getLength(self) -> float: ...
    def getMaterial(self) -> str: ...
    def getMaxFlatErrLeft(self) -> float: ...
    def getMaxFlatErrRight(self) -> float: ...
    def getMaxTiltLeftMinus(self) -> float: ...
    def getMaxTiltLeftPlus(self) -> float: ...
    def getMaxTiltRightMinus(self) -> float: ...
    def getMaxTiltRightPlus(self) -> float: ...
    def getMechPlayLeftDown(self) -> float: ...
    def getMechPlayLeftUp(self) -> float: ...
    def getMechPlayRightDown(self) -> float: ...
    def getMechPlayRightUp(self) -> float: ...
    def getMtfName(self) -> str: ...
    def getRegion(self) -> CollimatorRegion: ...
    def getScrewSerialNumberLeftDown(self) -> str: ...
    def getScrewSerialNumberLeftUp(self) -> str: ...
    def getScrewSerialNumberRightDown(self) -> str: ...
    def getScrewSerialNumberRightUp(self) -> str: ...
    def getStopAntiDown(self) -> float: ...
    def getStopAntiUp(self) -> float: ...
    def getStopLeftDownIn(self) -> float: ...
    def getStopLeftDownOut(self) -> float: ...
    def getStopLeftUpIn(self) -> float: ...
    def getStopLeftUpOut(self) -> float: ...
    def getStopRightDownIn(self) -> float: ...
    def getStopRightDownOut(self) -> float: ...
    def getStopRightUpIn(self) -> float: ...
    def getStopRightUpOut(self) -> float: ...
    def getSwitchAntiDown(self) -> float: ...
    def getSwitchAntiUp(self) -> float: ...
    def getSwitchLeftDownIn(self) -> float: ...
    def getSwitchLeftDownOut(self) -> float: ...
    def getSwitchLeftUpIn(self) -> float: ...
    def getSwitchLeftUpOut(self) -> float: ...
    def getSwitchRightDownIn(self) -> float: ...
    def getSwitchRightDownOut(self) -> float: ...
    def getSwitchRightUpIn(self) -> float: ...
    def getSwitchRightUpOut(self) -> float: ...
    def getTankCalibration(self) -> float: ...
    def getTankPosSetPoint(self) -> float: ...
    def getTankPosStopDown(self) -> float: ...
    def getTankPosStopUp(self) -> float: ...
    def getTankPosSwitchDown(self) -> float: ...
    def getTankPosSwitchUp(self) -> float: ...
    def isBpmInstalled(self) -> bool: ...

class RfFgcChannel:
    def getChannelName(self) -> str: ...
    def getChannelNumber(self) -> int: ...
    def getDescription(self) -> str: ...
    def getFGCName(self) -> str: ...
    def getMaxSlope(self) -> float: ...
    def getMaxValue(self) -> float: ...
    def getMinValue(self) -> float: ...
    def getParameterName(self) -> str: ...
    def getUnit(self) -> str: ...

class ThresholdsAwareBlmInfo(BlmInfo):
    def getAppliedThresholds(self) -> _py_List[_py_List[int]]: ...
