from typing import Any as _py_Any
from typing import ClassVar as _py_ClassVar
import cern.japc.core
import cern.japc.core.spi
import cern.japc.core.transaction
import cern.japc.value


class AbstractTransaction(cern.japc.core.transaction.Transaction):
    def abort(self) -> None: ...
    def commit(self) -> None: ...
    def commitAndWait(self) -> None: ...
    def getState(self) -> cern.japc.core.transaction.Transaction.State: ...
    def hasFailed(self) -> bool: ...
    def isReady(self) -> bool: ...
    def registerTransactionStateListener(self, transactionStateListener: cern.japc.core.transaction.TransactionStateListener) -> None: ...
    def unregisterTransactionStateListener(self) -> None: ...

class AbstractTransactionalParameter(cern.japc.core.spi.AbstractParameter, cern.japc.core.transaction.TransactionalParameter):
    def __init__(self, string: str): ...
    def prepareValue(self, selector: cern.japc.core.Selector, parameterValue: cern.japc.value.ParameterValue, compositeTransaction: cern.japc.core.transaction.CompositeTransaction) -> None: ...

class HardwareAccessTask:
    def performTask(self) -> None: ...

class TransactionalParameterDecorator(cern.japc.core.spi.ParameterDecorator, cern.japc.core.transaction.TransactionalParameter):
    def __init__(self, transactionalParameter: cern.japc.core.transaction.TransactionalParameter): ...
    def prepareValue(self, selector: cern.japc.core.Selector, parameterValue: cern.japc.value.ParameterValue, compositeTransaction: cern.japc.core.transaction.CompositeTransaction) -> None: ...

class CompositeTransactionImpl(AbstractTransaction, cern.japc.core.transaction.CompositeTransaction):
    def __init__(self): ...
    def add(self, object: _py_Any, transaction: cern.japc.core.transaction.Transaction) -> bool: ...
    def get(self, object: _py_Any) -> cern.japc.core.transaction.Transaction: ...
    def getPendingValueCount(self) -> int: ...

class SequentialTransaction(AbstractTransaction):
    def addSetValueTask(self, hardwareAccessTask: HardwareAccessTask) -> None: ...
    def getPendingValueCount(self) -> int: ...

class TransactionalParameterSupport(AbstractTransactionalParameter):
    def __init__(self, string: str): ...

class AsynchronousParameterSupport(TransactionalParameterSupport):
    DEFAULT_TIMEOUT: _py_ClassVar[int] = ...
    def __init__(self, string: str): ...

class SynchronousParameterSupport(TransactionalParameterSupport):
    SYSPROP_MAXTHREADS: _py_ClassVar[str] = ...
    def __init__(self, string: str): ...
