from typing import Any as _py_Any
from typing import List as _py_List
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.util.collections
import cern.japc.core
import cern.japc.core.spi.cache
import cern.japc.core.spi.provider
import cern.japc.core.spi.transaction
import cern.japc.core.transaction
import cern.japc.value
import cern.japc.value.spi.value.core
import java.io
import java.lang
import java.util


class AbstractImmutableParameter(cern.japc.core.ImmutableParameter, cern.japc.core.spi.cache.JapcCache):
    def __init__(self, string: str): ...
    def clearAll(self) -> None: ...
    def createSubscription(self, selector: cern.japc.core.Selector, parameterValueListener: cern.japc.core.ParameterValueListener) -> cern.japc.core.SubscriptionHandle: ...
    def getDeviceName(self) -> str: ...
    def getName(self) -> str: ...
    def getParameterDescriptor(self) -> cern.japc.core.ParameterDescriptor: ...
    def getPropertyName(self) -> str: ...
    @overload
    def getValue(self, selector: cern.japc.core.Selector) -> cern.japc.core.AcquiredParameterValue: ...
    @overload
    def getValue(self, selector: cern.japc.core.Selector, parameterValueListener: cern.japc.core.ParameterValueListener) -> None: ...
    def getValueDescriptor(self) -> cern.japc.value.ValueDescriptor: ...
    @overload
    def setParameterDescriptor(self, parameterDescriptor: cern.japc.core.ParameterDescriptor, descriptorProvider: cern.japc.core.spi.provider.DescriptorProvider) -> None: ...
    @overload
    def setParameterDescriptor(self, parameterDescriptor: cern.japc.core.ParameterDescriptor) -> None: ...
    @overload
    def setValueDescriptor(self, valueDescriptor: cern.japc.value.ValueDescriptor) -> None: ...
    @overload
    def setValueDescriptor(self, valueDescriptor: cern.japc.value.ValueDescriptor, descriptorProvider: cern.japc.core.spi.provider.DescriptorProvider) -> None: ...
    def toString(self) -> str: ...

class CumulativeWait:
    def __init__(self, long: int): ...
    @classmethod
    def cleanThreadTimeToWait(cls) -> None: ...
    def remainingTimeToWait(self) -> int: ...
    @classmethod
    def setThreadTimeToWait(cls, long: int) -> 'CumulativeWait': ...
    def updateTimeWaited(self, long: int) -> None: ...

class DeviceDescriptorImpl(cern.japc.core.DeviceDescriptor, java.io.Serializable):
    def __init__(self, string: str): ...
    def addExtraCharacteristic(self, string: str, string2: str) -> None: ...
    def getControlProperty(self) -> str: ...
    def getDescription(self) -> str: ...
    def getDeviceClassDescription(self) -> str: ...
    def getDeviceClassName(self) -> str: ...
    def getExtraCharacteristic(self, string: str) -> str: ...
    def getExtraCharacteristicNames(self) -> _py_List[str]: ...
    def getHostName(self) -> str: ...
    def getImplementation(self) -> int: ...
    def getLogicalLocation(self) -> str: ...
    def getName(self) -> str: ...
    def getResetProperty(self) -> str: ...
    def getStatusProperty(self) -> str: ...
    def getTgmName(self) -> str: ...
    def isCycleBound(self) -> bool: ...
    def isMultiplexed(self) -> bool: ...
    def setControlProperty(self, string: str) -> None: ...
    def setCycleBound(self, boolean: bool) -> None: ...
    def setDescription(self, string: str) -> None: ...
    def setDeviceClassDescription(self, string: str) -> None: ...
    def setDeviceClassName(self, string: str) -> None: ...
    def setHostName(self, string: str) -> None: ...
    def setImplementation(self, int: int) -> None: ...
    def setLogicalLocation(self, string: str) -> None: ...
    def setMultiplexed(self, boolean: bool) -> None: ...
    def setResetProperty(self, string: str) -> None: ...
    def setStatusProperty(self, string: str) -> None: ...
    def setTgmName(self, string: str) -> None: ...
    def toString(self) -> str: ...

class DeviceDescriptorSupport(cern.japc.core.DeviceDescriptor, java.io.Serializable):
    def __init__(self): ...
    def getControlProperty(self) -> str: ...
    def getDescription(self) -> str: ...
    def getDeviceClassDescription(self) -> str: ...
    def getDeviceClassName(self) -> str: ...
    def getExtraCharacteristic(self, string: str) -> str: ...
    def getExtraCharacteristicNames(self) -> _py_List[str]: ...
    def getHostName(self) -> str: ...
    def getImplementation(self) -> int: ...
    def getLogicalLocation(self) -> str: ...
    def getName(self) -> str: ...
    def getResetProperty(self) -> str: ...
    def getStatusProperty(self) -> str: ...
    def getTgmName(self) -> str: ...
    def isCycleBound(self) -> bool: ...
    def isMultiplexed(self) -> bool: ...

class FspvCollector(cern.accsoft.commons.util.collections.ValueCollector[cern.japc.core.FailSafeParameterValue], cern.japc.core.ParameterValueListener): ...

class FspvPeekingStrategy(cern.accsoft.commons.util.collections.ValuePeekingStrategy[cern.japc.core.FailSafeParameterValue]): ...

class IgnoreSetParameterDecorator(cern.japc.core.spi.transaction.TransactionalParameterDecorator):
    def __init__(self, transactionalParameter: cern.japc.core.transaction.TransactionalParameter): ...
    @overload
    def setValue(self, selector: cern.japc.core.Selector, parameterValue: cern.japc.value.ParameterValue) -> None: ...
    @overload
    def setValue(self, selector: cern.japc.core.Selector, parameterValue: cern.japc.value.ParameterValue, parameterValueListener: cern.japc.core.ParameterValueListener) -> None: ...

class ImmutableParameterDecorator(cern.japc.core.ImmutableParameter):
    def __init__(self, immutableParameter: cern.japc.core.ImmutableParameter): ...
    def createSubscription(self, selector: cern.japc.core.Selector, parameterValueListener: cern.japc.core.ParameterValueListener) -> cern.japc.core.SubscriptionHandle: ...
    def getDeviceName(self) -> str: ...
    def getName(self) -> str: ...
    def getParameterDescriptor(self) -> cern.japc.core.ParameterDescriptor: ...
    def getPropertyName(self) -> str: ...
    @overload
    def getValue(self, selector: cern.japc.core.Selector) -> cern.japc.core.AcquiredParameterValue: ...
    @overload
    def getValue(self, selector: cern.japc.core.Selector, parameterValueListener: cern.japc.core.ParameterValueListener) -> None: ...
    def getValueDescriptor(self) -> cern.japc.value.ValueDescriptor: ...
    def toString(self) -> str: ...

class ParameterDescriptorImpl(cern.japc.value.spi.value.core.TypedObject, cern.japc.core.ParameterDescriptor):
    def __init__(self, type: cern.japc.value.Type, string: str): ...
    def addExtraCharacteristic(self, string: str, string2: str) -> None: ...
    def getDescription(self) -> str: ...
    def getExtraCharacteristic(self, string: str) -> str: ...
    def getExtraCharacteristicNames(self) -> _py_List[str]: ...
    def getParameterName(self) -> str: ...
    def isCycleBound(self) -> bool: ...
    def isFilterable(self) -> bool: ...
    def isMonitorable(self) -> bool: ...
    def isMultiplexed(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isTransactional(self) -> bool: ...
    def isValueMutable(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def setCycleBound(self, boolean: bool) -> None: ...
    def setDescription(self, string: str) -> None: ...
    def setFilterable(self, boolean: bool) -> None: ...
    def setMonitorable(self, boolean: bool) -> None: ...
    def setMultiplexed(self, boolean: bool) -> None: ...
    def setReadable(self, boolean: bool) -> None: ...
    def setTransactional(self, boolean: bool) -> None: ...
    def setValueMutable(self, boolean: bool) -> None: ...
    def setWritable(self, boolean: bool) -> None: ...
    def toString(self) -> str: ...

class ParameterDescriptorSupport(cern.japc.core.ParameterDescriptor, java.io.Serializable):
    def __init__(self): ...
    def getDescription(self) -> str: ...
    def getExtraCharacteristic(self, string: str) -> str: ...
    def getExtraCharacteristicNames(self) -> _py_List[str]: ...
    def getType(self) -> cern.japc.value.Type: ...
    def isCycleBound(self) -> bool: ...
    def isFilterable(self) -> bool: ...
    def isMonitorable(self) -> bool: ...
    def isMultiplexed(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isTransactional(self) -> bool: ...
    def isValueMutable(self) -> bool: ...
    def isWritable(self) -> bool: ...

class ParameterUrl:
    PROTOCOL_SEPARATOR: _py_ClassVar[str] = ...
    SERVICE_SEPARATOR: _py_ClassVar[str] = ...
    DEVICE_PROPERTY_NAME_SEPARATOR: _py_ClassVar[str] = ...
    PROPERTY_NAME_FIELD_SEPARATOR: _py_ClassVar[str] = ...
    def cloneWithoutField(self) -> 'ParameterUrl': ...
    def getDeviceAndProperty(self) -> str: ...
    def getDeviceName(self) -> str: ...
    def getFieldName(self) -> str: ...
    def getParameterName(self) -> str: ...
    def getPropertyName(self) -> str: ...
    def getProtocolName(self) -> str: ...
    def getServiceName(self) -> str: ...
    def hasFieldName(self) -> bool: ...
    def isDimParameter(self) -> bool: ...
    def isFull(self) -> bool: ...

class SelectorImpl(cern.japc.core.Selector, java.io.Serializable):
    @overload
    def __init__(self, selector: cern.japc.core.Selector): ...
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, parameterValue: cern.japc.value.ParameterValue): ...
    def equals(self, object: _py_Any) -> bool: ...
    def getDataFilter(self) -> cern.japc.value.ParameterValue: ...
    def getId(self) -> str: ...
    def getPeriod(self) -> int: ...
    def hashCode(self) -> int: ...
    def isPeriodic(self) -> bool: ...
    def toString(self) -> str: ...

class SubscriptionConfigurationImpl(cern.japc.core.SubscriptionConfigurator):
    def getDataDeliveryMode(self) -> int: ...
    def getSelector(self) -> cern.japc.core.Selector: ...
    def setDataDeliveryMode(self, int: int) -> None: ...

class SubscriptionHandleDecorator(cern.japc.core.SubscriptionHandle):
    def __init__(self, subscriptionHandle: cern.japc.core.SubscriptionHandle): ...
    def getDataDeliveryMode(self) -> int: ...
    def getListener(self) -> cern.japc.core.ParameterValueListener: ...
    def getParameter(self) -> cern.japc.core.ImmutableParameter: ...
    def getSelector(self) -> cern.japc.core.Selector: ...
    def isMonitoring(self) -> bool: ...
    def peekValue(self, long: int) -> cern.japc.core.AcquiredParameterValue: ...
    def setDataDeliveryMode(self, int: int) -> None: ...
    def startMonitoring(self) -> None: ...
    def stopMonitoring(self) -> None: ...

class SubscriptionSource:
    def getSelector(self) -> cern.japc.core.Selector: ...
    def initializeSubscriptionSource(self, parameterValueListener: cern.japc.core.ParameterValueListener) -> None: ...
    def startSubscription(self) -> None: ...
    def stopSubscription(self) -> None: ...

class SubscriptionStrategy:
    def exceptionOccured(self, string: str, string2: str, parameterException: cern.japc.core.ParameterException) -> None: ...
    def peekValue(self, long: int) -> cern.japc.core.AcquiredParameterValue: ...
    def valueReceived(self, string: str, acquiredParameterValue: cern.japc.core.AcquiredParameterValue) -> None: ...

class UpdatableAcquiredParameterValue:
    def addAdditionalError(self, string: str) -> None: ...
    def setHeader(self, valueHeader: cern.japc.core.ValueHeader) -> None: ...
    def setStatus(self, valueStatus: cern.japc.value.ValueStatus) -> None: ...

class ValueHeaderImpl(cern.japc.core.ValueHeader, java.io.Serializable):
    @overload
    def __init__(self, long: int, selector: cern.japc.core.Selector): ...
    @overload
    def __init__(self, long: int, long2: int, selector: cern.japc.core.Selector): ...
    def getAcqStamp(self) -> int: ...
    def getAcqStampMillis(self) -> int: ...
    def getCycleStamp(self) -> int: ...
    def getCycleStampMillis(self) -> int: ...
    def getSelector(self) -> cern.japc.core.Selector: ...
    def getSetStamp(self) -> int: ...
    def getSetStampMillis(self) -> int: ...
    def isFirstUpdate(self) -> bool: ...
    def isImmediateUpdate(self) -> bool: ...
    def setAcqStamp(self, long: int) -> None: ...
    def setAcqStampMillis(self, long: int) -> None: ...
    def setCycleStamp(self, long: int) -> None: ...
    def setCycleStampMillis(self, long: int) -> None: ...
    def setFirstUpdate(self, boolean: bool) -> None: ...
    def setImmediateUpdate(self, boolean: bool) -> None: ...
    def setSelector(self, selector: cern.japc.core.Selector) -> None: ...
    def setSetStamp(self, long: int) -> None: ...
    def setSetStampMillis(self, long: int) -> None: ...
    def toString(self) -> str: ...

class AbstractParameter(AbstractImmutableParameter, cern.japc.core.Parameter):
    def __init__(self, string: str): ...
    @overload
    def setValue(self, selector: cern.japc.core.Selector, parameterValue: cern.japc.value.ParameterValue) -> None: ...
    @overload
    def setValue(self, selector: cern.japc.core.Selector, parameterValue: cern.japc.value.ParameterValue, parameterValueListener: cern.japc.core.ParameterValueListener) -> None: ...

class AbstractWeakSubscriptionSource(SubscriptionSource, cern.japc.core.ParameterValueListener):
    def __init__(self, string: str, selector: cern.japc.core.Selector): ...
    def exceptionOccured(self, string: str, string2: str, parameterException: cern.japc.core.ParameterException) -> None: ...
    def getSelector(self) -> cern.japc.core.Selector: ...
    def initializeSubscriptionSource(self, parameterValueListener: cern.japc.core.ParameterValueListener) -> None: ...
    def startSubscription(self) -> None: ...
    def stopSubscription(self) -> None: ...
    def valueReceived(self, string: str, acquiredParameterValue: cern.japc.core.AcquiredParameterValue) -> None: ...

class AcquiredParameterValueImpl(cern.japc.core.AcquiredParameterValue, UpdatableAcquiredParameterValue, java.io.Serializable):
    @overload
    def __init__(self, acquiredParameterValue: cern.japc.core.AcquiredParameterValue): ...
    @overload
    def __init__(self, string: str, valueHeader: cern.japc.core.ValueHeader, parameterValue: cern.japc.value.ParameterValue): ...
    @overload
    def __init__(self, string: str, parameterValue: cern.japc.value.ParameterValue): ...
    @overload
    def __init__(self, string: str, parameterValue: cern.japc.value.ParameterValue, long: int, selector: cern.japc.core.Selector): ...
    @overload
    def __init__(self, string: str, parameterValue: cern.japc.value.ParameterValue, long: int, long2: int, selector: cern.japc.core.Selector): ...
    def addAdditionalError(self, string: str) -> None: ...
    def getAdditionalErrors(self) -> _py_List[str]: ...
    def getDescriptor(self) -> cern.japc.value.ValueDescriptor: ...
    def getHeader(self) -> cern.japc.core.ValueHeader: ...
    def getParameterName(self) -> str: ...
    def getStatus(self) -> cern.japc.value.ValueStatus: ...
    def getValue(self) -> cern.japc.value.ParameterValue: ...
    def setDescriptor(self, valueDescriptor: cern.japc.value.ValueDescriptor) -> None: ...
    def setHeader(self, valueHeader: cern.japc.core.ValueHeader) -> None: ...
    def setParameterName(self, string: str) -> None: ...
    def setStatus(self, valueStatus: cern.japc.value.ValueStatus) -> None: ...
    def setValue(self, parameterValue: cern.japc.value.ParameterValue) -> None: ...
    def toString(self) -> str: ...

class CycleStampValuePeekingStrategy(FspvPeekingStrategy):
    def __init__(self, long: int): ...
    def getCycleStamp(self) -> int: ...
    def peek(self, circularBuffer: cern.accsoft.commons.util.collections.CircularBuffer[cern.japc.core.FailSafeParameterValue], boolean: bool) -> java.util.Collection[cern.japc.core.FailSafeParameterValue]: ...

class FirstValueInWindowPeekingStrategy(FspvPeekingStrategy):
    def __init__(self, long: int, long2: int): ...
    def peek(self, circularBuffer: cern.accsoft.commons.util.collections.CircularBuffer[cern.japc.core.FailSafeParameterValue], boolean: bool) -> java.util.Collection[cern.japc.core.FailSafeParameterValue]: ...

class FspvCollectorImpl(cern.accsoft.commons.util.collections.AbstractValueCollector[cern.japc.core.FailSafeParameterValue], FspvCollector):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, parameter: cern.japc.core.Parameter, selector: cern.japc.core.Selector): ...
    @overload
    def __init__(self, parameter: cern.japc.core.Parameter, selector: cern.japc.core.Selector, int: int): ...
    @overload
    def __init__(self, int: int): ...
    def exceptionOccured(self, string: str, string2: str, parameterException: cern.japc.core.ParameterException) -> None: ...
    def startCollection(self) -> None: ...
    def stopCollection(self) -> None: ...
    def valueReceived(self, string: str, acquiredParameterValue: cern.japc.core.AcquiredParameterValue) -> None: ...

class LastBeforeTimestampStrategy(FspvPeekingStrategy):
    def __init__(self, long: int): ...
    def peek(self, circularBuffer: cern.accsoft.commons.util.collections.CircularBuffer[cern.japc.core.FailSafeParameterValue], boolean: bool) -> java.util.Collection[cern.japc.core.FailSafeParameterValue]: ...

class MapParameterDescriptorImpl(ParameterDescriptorImpl, cern.japc.core.MapParameterDescriptor):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, map: java.util.Map[str, cern.japc.core.SimpleParameterDescriptor]): ...
    def equals(self, object: _py_Any) -> bool: ...
    def get(self, string: str) -> cern.japc.core.SimpleParameterDescriptor: ...
    def getNames(self) -> _py_List[str]: ...
    def hashCode(self) -> int: ...
    def put(self, string: str, simpleParameterDescriptor: cern.japc.core.SimpleParameterDescriptor) -> None: ...
    def remove(self, string: str) -> cern.japc.core.SimpleParameterDescriptor: ...
    def size(self) -> int: ...
    def toString(self) -> str: ...

class ParameterDecorator(ImmutableParameterDecorator, cern.japc.core.Parameter):
    def __init__(self, parameter: cern.japc.core.Parameter): ...
    @overload
    def setValue(self, selector: cern.japc.core.Selector, parameterValue: cern.japc.value.ParameterValue) -> None: ...
    @overload
    def setValue(self, selector: cern.japc.core.Selector, parameterValue: cern.japc.value.ParameterValue, parameterValueListener: cern.japc.core.ParameterValueListener) -> None: ...

class ParameterUrlImpl(ParameterUrl, java.io.Serializable):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, string2: str): ...
    @overload
    def __init__(self, string: str, string2: str, string3: str): ...
    @overload
    def __init__(self, string: str, string2: str, string3: str, string4: str): ...
    @overload
    def __init__(self, string: str, string2: str, string3: str, string4: str, string5: str): ...
    def cloneWithoutField(self) -> ParameterUrl: ...
    def equals(self, object: _py_Any) -> bool: ...
    def getDeviceAndProperty(self) -> str: ...
    def getDeviceName(self) -> str: ...
    def getFieldName(self) -> str: ...
    def getParameterName(self) -> str: ...
    def getPropertyName(self) -> str: ...
    def getProtocolName(self) -> str: ...
    def getServiceName(self) -> str: ...
    def hasFieldName(self) -> bool: ...
    def hashCode(self) -> int: ...
    def isDimParameter(self) -> bool: ...
    def isFull(self) -> bool: ...
    def toString(self) -> str: ...

class PullSubscriptionStrategy(SubscriptionStrategy):
    def __init__(self, parameterValueListener: cern.japc.core.ParameterValueListener, string: str): ...
    def exceptionOccured(self, string: str, string2: str, parameterException: cern.japc.core.ParameterException) -> None: ...
    def peekValue(self, long: int) -> cern.japc.core.AcquiredParameterValue: ...
    def valueReceived(self, string: str, acquiredParameterValue: cern.japc.core.AcquiredParameterValue) -> None: ...

class PushSubscriptionStrategy(SubscriptionStrategy):
    def __init__(self, parameterValueListener: cern.japc.core.ParameterValueListener): ...
    def exceptionOccured(self, string: str, string2: str, parameterException: cern.japc.core.ParameterException) -> None: ...
    def peekValue(self, long: int) -> cern.japc.core.AcquiredParameterValue: ...
    def valueReceived(self, string: str, acquiredParameterValue: cern.japc.core.AcquiredParameterValue) -> None: ...

class SimpleParameterDescriptorImpl(ParameterDescriptorImpl, cern.japc.core.SimpleParameterDescriptor):
    def __init__(self, string: str): ...
    def get(self, string: str) -> cern.japc.core.SimpleParameterDescriptor: ...
    def getNames(self) -> _py_List[str]: ...
    def size(self) -> int: ...

class SubscriptionHandleImpl(SubscriptionConfigurationImpl, cern.japc.core.SubscriptionHandle, cern.japc.core.ParameterValueListener):
    @overload
    def __init__(self, immutableParameter: cern.japc.core.ImmutableParameter, subscriptionSource: SubscriptionSource, parameterValueListener: cern.japc.core.ParameterValueListener): ...
    @overload
    def __init__(self, immutableParameter: cern.japc.core.ImmutableParameter, subscriptionSource: SubscriptionSource, parameterValueListener: cern.japc.core.ParameterValueListener, int: int): ...
    def exceptionOccured(self, string: str, string2: str, parameterException: cern.japc.core.ParameterException) -> None: ...
    def getListener(self) -> cern.japc.core.ParameterValueListener: ...
    def getParameter(self) -> cern.japc.core.ImmutableParameter: ...
    def isMonitoring(self) -> bool: ...
    def peekValue(self, long: int) -> cern.japc.core.AcquiredParameterValue: ...
    def startMonitoring(self) -> None: ...
    def stopMonitoring(self) -> None: ...
    def valueReceived(self, string: str, acquiredParameterValue: cern.japc.core.AcquiredParameterValue) -> None: ...

class FailSafeParameterValueImpl(AcquiredParameterValueImpl, cern.japc.core.FailSafeParameterValue):
    @overload
    def __init__(self, acquiredParameterValue: cern.japc.core.AcquiredParameterValue): ...
    @overload
    def __init__(self, string: str, parameterException: cern.japc.core.ParameterException): ...
    @overload
    def __init__(self, string: str, valueHeader: cern.japc.core.ValueHeader, parameterValue: cern.japc.value.ParameterValue): ...
    @overload
    def exception(self) -> cern.japc.core.ParameterException: ...
    @overload
    def exception(self) -> java.lang.Exception: ...
    def getException(self) -> cern.japc.core.ParameterException: ...
    def getString(self) -> str: ...
    def isValue(self) -> bool: ...
    def setValue(self, parameterValue: cern.japc.value.ParameterValue) -> None: ...
    def toString(self) -> str: ...
    @overload
    def value(self) -> cern.japc.core.AcquiredParameterValue: ...
    @overload
    def value(self) -> _py_Any: ...

class PullingSubscriptionSource(AbstractWeakSubscriptionSource):
    def __init__(self, selector: cern.japc.core.Selector, immutableParameter: cern.japc.core.ImmutableParameter): ...
