from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.value
import cern.accsoft.commons.value.expression
import java.lang
import java.util


class BoundedPolynomialOperations:
    @classmethod
    def differentiate(cls, boundedPolynomial: cern.accsoft.commons.value.BoundedPolynomial) -> cern.accsoft.commons.value.BoundedPolynomial: ...
    @classmethod
    def integrate(cls, boundedPolynomial: cern.accsoft.commons.value.BoundedPolynomial, double: float) -> cern.accsoft.commons.value.BoundedPolynomial: ...
    @classmethod
    def neg(cls, boundedPolynomial: cern.accsoft.commons.value.BoundedPolynomial) -> cern.accsoft.commons.value.BoundedPolynomial: ...
    @classmethod
    def scale(cls, boundedPolynomial: cern.accsoft.commons.value.BoundedPolynomial, double: float) -> cern.accsoft.commons.value.BoundedPolynomial: ...
    @classmethod
    def scaleArg(cls, boundedPolynomial: cern.accsoft.commons.value.BoundedPolynomial, double: float) -> cern.accsoft.commons.value.BoundedPolynomial: ...
    @classmethod
    def shift(cls, boundedPolynomial: cern.accsoft.commons.value.BoundedPolynomial, double: float) -> cern.accsoft.commons.value.BoundedPolynomial: ...
    @classmethod
    def shiftArg(cls, boundedPolynomial: cern.accsoft.commons.value.BoundedPolynomial, double: float) -> cern.accsoft.commons.value.BoundedPolynomial: ...

class BoundedPolynomialSequenceBinaryOperations:
    @classmethod
    def add(cls, boundedPolynomialSequence: cern.accsoft.commons.value.BoundedPolynomialSequence, boundedPolynomialSequence2: cern.accsoft.commons.value.BoundedPolynomialSequence) -> cern.accsoft.commons.value.BoundedPolynomialSequence: ...
    @classmethod
    def concat(cls, boundedPolynomialSequence: cern.accsoft.commons.value.BoundedPolynomialSequence, boundedPolynomialSequence2: cern.accsoft.commons.value.BoundedPolynomialSequence) -> cern.accsoft.commons.value.BoundedPolynomialSequence: ...
    @classmethod
    def multiply(cls, boundedPolynomialSequence: cern.accsoft.commons.value.BoundedPolynomialSequence, boundedPolynomialSequence2: cern.accsoft.commons.value.BoundedPolynomialSequence) -> cern.accsoft.commons.value.BoundedPolynomialSequence: ...
    @classmethod
    def subtract(cls, boundedPolynomialSequence: cern.accsoft.commons.value.BoundedPolynomialSequence, boundedPolynomialSequence2: cern.accsoft.commons.value.BoundedPolynomialSequence) -> cern.accsoft.commons.value.BoundedPolynomialSequence: ...

class BoundedPolynomialSequenceOperations:
    @classmethod
    def differentiate(cls, boundedPolynomialSequence: cern.accsoft.commons.value.BoundedPolynomialSequence) -> cern.accsoft.commons.value.BoundedPolynomialSequence: ...
    @classmethod
    def integrate(cls, boundedPolynomialSequence: cern.accsoft.commons.value.BoundedPolynomialSequence, double: float) -> cern.accsoft.commons.value.BoundedPolynomialSequence: ...
    @classmethod
    def neg(cls, boundedPolynomialSequence: cern.accsoft.commons.value.BoundedPolynomialSequence) -> cern.accsoft.commons.value.BoundedPolynomialSequence: ...
    @classmethod
    def scale(cls, boundedPolynomialSequence: cern.accsoft.commons.value.BoundedPolynomialSequence, double: float) -> cern.accsoft.commons.value.BoundedPolynomialSequence: ...
    @classmethod
    def scaleArg(cls, boundedPolynomialSequence: cern.accsoft.commons.value.BoundedPolynomialSequence, double: float) -> cern.accsoft.commons.value.BoundedPolynomialSequence: ...
    @classmethod
    def shift(cls, boundedPolynomialSequence: cern.accsoft.commons.value.BoundedPolynomialSequence, double: float) -> cern.accsoft.commons.value.BoundedPolynomialSequence: ...
    @classmethod
    def shiftArg(cls, boundedPolynomialSequence: cern.accsoft.commons.value.BoundedPolynomialSequence, double: float) -> cern.accsoft.commons.value.BoundedPolynomialSequence: ...

class Operation:
    def getType(self) -> 'OperationType': ...

class OperationException(java.lang.RuntimeException):
    @overload
    def __init__(self, string: str): ...
    @overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @overload
    def __init__(self, throwable: java.lang.Throwable): ...

class OperationType(java.lang.Enum['OperationType']):
    BINARY: _py_ClassVar['OperationType'] = ...
    UNARY: _py_ClassVar['OperationType'] = ...
    INDEXING: _py_ClassVar['OperationType'] = ...
    FUNCTION: _py_ClassVar['OperationType'] = ...
    CUSTOM: _py_ClassVar['OperationType'] = ...
    @classmethod
    @overload
    def valueOf(cls, string: str) -> 'OperationType': ...
    _valueOf_1__T = _py_TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
    @classmethod
    @overload
    def valueOf(cls, class_: _py_Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
    @classmethod
    def values(cls) -> _py_List['OperationType']: ...

class PolynomialBinaryOperations:
    @classmethod
    def add(cls, polynomial: cern.accsoft.commons.value.Polynomial, polynomial2: cern.accsoft.commons.value.Polynomial) -> cern.accsoft.commons.value.Polynomial: ...
    @classmethod
    def multiply(cls, polynomial: cern.accsoft.commons.value.Polynomial, polynomial2: cern.accsoft.commons.value.Polynomial) -> cern.accsoft.commons.value.Polynomial: ...
    @classmethod
    def subtract(cls, polynomial: cern.accsoft.commons.value.Polynomial, polynomial2: cern.accsoft.commons.value.Polynomial) -> cern.accsoft.commons.value.Polynomial: ...

class PolynomialOperations:
    @classmethod
    def differentiate(cls, polynomial: cern.accsoft.commons.value.Polynomial) -> cern.accsoft.commons.value.Polynomial: ...
    @classmethod
    def integrate(cls, polynomial: cern.accsoft.commons.value.Polynomial, double: float) -> cern.accsoft.commons.value.Polynomial: ...
    @classmethod
    @overload
    def invert(cls, polynomial: cern.accsoft.commons.value.Polynomial, double: float) -> float: ...
    @classmethod
    @overload
    def invert(cls, polynomial: cern.accsoft.commons.value.Polynomial, double: float, double2: float) -> float: ...
    @classmethod
    @overload
    def invert(cls, polynomial: cern.accsoft.commons.value.Polynomial, double: float, double2: float, double3: float) -> float: ...
    @classmethod
    def neg(cls, polynomial: cern.accsoft.commons.value.Polynomial) -> cern.accsoft.commons.value.Polynomial: ...
    @classmethod
    def scale(cls, polynomial: cern.accsoft.commons.value.Polynomial, double: float) -> cern.accsoft.commons.value.Polynomial: ...
    @classmethod
    def scaleArg(cls, polynomial: cern.accsoft.commons.value.Polynomial, double: float) -> cern.accsoft.commons.value.Polynomial: ...
    @classmethod
    def shift(cls, polynomial: cern.accsoft.commons.value.Polynomial, double: float) -> cern.accsoft.commons.value.Polynomial: ...
    @classmethod
    def shiftArg(cls, polynomial: cern.accsoft.commons.value.Polynomial, double: float) -> cern.accsoft.commons.value.Polynomial: ...
    @classmethod
    def taylorsExpansion(cls, polynomial: cern.accsoft.commons.value.Polynomial, double: float) -> _py_List[float]: ...

class BinaryOperation(Operation):
    NOT_SAME_LENGTH_MSG: _py_ClassVar[str] = ...
    @overload
    def execute(self, discreteFunction: cern.accsoft.commons.value.DiscreteFunction, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> None: ...
    @overload
    def execute(self, discreteFunctionsArray: cern.accsoft.commons.value.DiscreteFunctionsArray, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> None: ...
    @overload
    def execute(self, scalar: cern.accsoft.commons.value.Scalar, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> None: ...
    @overload
    def execute(self, scalarArray: cern.accsoft.commons.value.ScalarArray, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> None: ...
    @overload
    def execute(self, scalarArray2D: cern.accsoft.commons.value.ScalarArray2D, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> None: ...
    def isSymmetric(self) -> bool: ...

class MultiOperation(Operation):
    _execute__T = _py_TypeVar('_execute__T', bound=cern.accsoft.commons.value.Value)  # <T>
    def execute(self, valueMap: cern.accsoft.commons.value.expression.ValueMap, list: java.util.List[_execute__T]) -> _execute__T: ...

class TypeReducingOperation(Operation):
    @overload
    def execute(self, scalarArray: cern.accsoft.commons.value.ScalarArray) -> cern.accsoft.commons.value.Scalar: ...
    @overload
    def execute(self, scalarArray2D: cern.accsoft.commons.value.ScalarArray2D) -> cern.accsoft.commons.value.ScalarArray: ...

class UnaryOperation(Operation):
    @overload
    def execute(self, discreteFunction: cern.accsoft.commons.value.DiscreteFunction) -> None: ...
    @overload
    def execute(self, discreteFunctionsArray: cern.accsoft.commons.value.DiscreteFunctionsArray) -> None: ...
    @overload
    def execute(self, scalar: cern.accsoft.commons.value.Scalar) -> None: ...
    @overload
    def execute(self, scalarArray: cern.accsoft.commons.value.ScalarArray) -> None: ...
    @overload
    def execute(self, scalarArray2D: cern.accsoft.commons.value.ScalarArray2D) -> None: ...

class AbstractBinaryOperation(BinaryOperation):
    def __init__(self): ...
    @overload
    def execute(self, discreteFunction: cern.accsoft.commons.value.DiscreteFunction, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> None: ...
    @overload
    def execute(self, discreteFunctionsArray: cern.accsoft.commons.value.DiscreteFunctionsArray, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> None: ...
    @overload
    def execute(self, scalar: cern.accsoft.commons.value.Scalar, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> None: ...
    @overload
    def execute(self, scalarArray: cern.accsoft.commons.value.ScalarArray, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> None: ...
    @overload
    def execute(self, scalarArray2D: cern.accsoft.commons.value.ScalarArray2D, immutableValue: cern.accsoft.commons.value.ImmutableValue) -> None: ...
    def getType(self) -> OperationType: ...
    def isSymmetric(self) -> bool: ...

class FunctionBasedOperation(MultiOperation):
    def __init__(self, continuousFunction: cern.accsoft.commons.value.ContinuousFunction): ...
    _execute__T = _py_TypeVar('_execute__T', bound=cern.accsoft.commons.value.Value)  # <T>
    def execute(self, valueMap: cern.accsoft.commons.value.expression.ValueMap, list: java.util.List[_execute__T]) -> _execute__T: ...
    def getType(self) -> OperationType: ...
    def toString(self) -> str: ...

class MathFunctionOperation(UnaryOperation):
    def __init__(self, mathFunction: cern.accsoft.commons.value.MathFunction): ...
    @overload
    def execute(self, discreteFunction: cern.accsoft.commons.value.DiscreteFunction) -> None: ...
    @overload
    def execute(self, discreteFunctionsArray: cern.accsoft.commons.value.DiscreteFunctionsArray) -> None: ...
    @overload
    def execute(self, scalar: cern.accsoft.commons.value.Scalar) -> None: ...
    @overload
    def execute(self, scalarArray: cern.accsoft.commons.value.ScalarArray) -> None: ...
    @overload
    def execute(self, scalarArray2D: cern.accsoft.commons.value.ScalarArray2D) -> None: ...
    def getType(self) -> OperationType: ...
    def toString(self) -> str: ...
