from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import Generic as _py_Generic
from typing import overload
import cern
import cern.accsoft.commons.util.reflect
import java.awt.event
import java.beans
import java.lang
import java.util
import javax.swing.event


_EventListenerSupport__T = _py_TypeVar('_EventListenerSupport__T')  # <T>
class EventListenerSupport(_py_Generic[_EventListenerSupport__T]):
    @overload
    def __init__(self, class_: _py_Type[_EventListenerSupport__T]): ...
    @overload
    def __init__(self, class_: _py_Type[_EventListenerSupport__T], methodInvoker: cern.accsoft.commons.util.reflect.MethodInvoker): ...
    def add(self, t: _EventListenerSupport__T) -> None: ...
    def addAll(self, collection: java.util.Collection[_EventListenerSupport__T]) -> None: ...
    def addAllWeakly(self, collection: java.util.Collection[_EventListenerSupport__T]) -> None: ...
    def addWeakly(self, t: _EventListenerSupport__T) -> None: ...
    def clear(self) -> None: ...
    def getDispatcher(self) -> _EventListenerSupport__T: ...
    def getListenerInvoker(self) -> cern.accsoft.commons.util.reflect.MethodInvoker: ...
    def getListeners(self) -> java.util.List[_EventListenerSupport__T]: ...
    _newInstance__T = _py_TypeVar('_newInstance__T')  # <T>
    @classmethod
    def newInstance(cls, class_: _py_Type[_newInstance__T]) -> 'EventListenerSupport'[_newInstance__T]: ...
    def remove(self, t: _EventListenerSupport__T) -> None: ...
    def removeAll(self, collection: java.util.Collection[_EventListenerSupport__T]) -> None: ...

class EventListeners:
    def __init__(self): ...
    @classmethod
    def actionListener(cls, object: _py_Any, string: str) -> java.awt.event.ActionListener: ...
    @classmethod
    def changeListener(cls, object: _py_Any, string: str) -> javax.swing.event.ChangeListener: ...
    _create_0__T = _py_TypeVar('_create_0__T')  # <T>
    @classmethod
    @overload
    def create(cls, class_: _py_Type[_create_0__T], object: _py_Any, string: str) -> _create_0__T: ...
    _create_1__T = _py_TypeVar('_create_1__T')  # <T>
    @classmethod
    @overload
    def create(cls, class_: _py_Type[_create_1__T], object: _py_Any, string: str, string2: str) -> _create_1__T: ...
    @classmethod
    def listSelectionListener(cls, object: _py_Any, string: str) -> javax.swing.event.ListSelectionListener: ...
    @classmethod
    def propertyChangeListener(cls, object: _py_Any, string: str) -> java.beans.PropertyChangeListener: ...

_SyncEventListenerSupport__T = _py_TypeVar('_SyncEventListenerSupport__T')  # <T>
class SyncEventListenerSupport(EventListenerSupport[_SyncEventListenerSupport__T], _py_Generic[_SyncEventListenerSupport__T]):
    @overload
    def __init__(self, class_: _py_Type[_SyncEventListenerSupport__T]): ...
    @overload
    def __init__(self, class_: _py_Type[_SyncEventListenerSupport__T], methodInvoker: cern.accsoft.commons.util.reflect.MethodInvoker): ...
    def clear(self) -> None: ...
    def getListeners(self) -> java.util.List[_SyncEventListenerSupport__T]: ...
    _newInstance_0__T = _py_TypeVar('_newInstance_0__T')  # <T>
    @classmethod
    @overload
    def newInstance(cls, class_: _py_Type[_newInstance_0__T]) -> EventListenerSupport[_newInstance_0__T]: ...
    _newInstance_1__T = _py_TypeVar('_newInstance_1__T')  # <T>
    @classmethod
    @overload
    def newInstance(cls, class_: _py_Type[_newInstance_1__T]) -> 'SyncEventListenerSupport'[_newInstance_1__T]: ...
    def remove(self, t: _SyncEventListenerSupport__T) -> None: ...

class EventListenerSupportDemo:
    def __init__(self): ...
    @classmethod
    def main(cls, stringArray: _py_List[str]) -> None: ...
    def updateListeners(self) -> None: ...
    class MyListenerImpl(cern.accsoft.commons.util.event.EventListenerSupportDemo.MyListener, cern.accsoft.commons.util.event.EventListenerSupportDemo.ParameterValueListener):
        def __init__(self, eventListenerSupportDemo: 'EventListenerSupportDemo', string: str): ...
        def exceptionOccured(self, string: str, exception: java.lang.Exception) -> None: ...
        def sendUpdate(self, long: int) -> None: ...
        def valueReceived(self, string: str) -> None: ...
    class MyListener(java.util.EventListener):
        def sendUpdate(self, long: int) -> None: ...
    class ParameterValueListener:
        def exceptionOccured(self, string: str, exception: java.lang.Exception) -> None: ...
        def valueReceived(self, string: str) -> None: ...
