from typing import Any as _py_Any
from typing import List as _py_List
from typing import TypeVar as _py_TypeVar
from typing import Type as _py_Type
from typing import Generic as _py_Generic
from typing import overload
import java.lang.reflect
import java.util
import org.springframework.beans.factory
import org.springframework.beans.factory.support
import org.springframework.context
import org.springframework.remoting.rmi


class BusinessService: ...

class BusinessServiceProxy:
    def getServiceDescriptor(self) -> 'BusinessServiceDescriptor': ...

class RemoteServer:
    def equals(self, object: _py_Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class RemoteServiceLookupBeanFactory(org.springframework.beans.factory.FactoryBean[java.util.List[org.springframework.remoting.rmi.RmiProxyFactoryBean]], org.springframework.beans.factory.BeanFactoryAware):
    def __init__(self): ...
    @overload
    def getObject(self) -> _py_Any: ...
    @overload
    def getObject(self) -> java.util.List[org.springframework.remoting.rmi.RmiProxyFactoryBean]: ...
    def getObjectType(self) -> _py_Type[_py_Any]: ...
    def isSingleton(self) -> bool: ...
    def setBeanFactory(self, beanFactory: org.springframework.beans.factory.BeanFactory) -> None: ...
    def setBeansProvider(self, serviceBeansProvider: 'ServiceBeansProvider') -> None: ...

class ServerManager:
    def createRemoteServerFor(self, string: str, list: java.util.List['BusinessServiceDescriptor']) -> RemoteServer: ...

class ServerRegistry:
    _getAllServices__T = _py_TypeVar('_getAllServices__T', bound=BusinessService)  # <T>
    def getAllServices(self, class_: _py_Type[_getAllServices__T]) -> java.util.List[_getAllServices__T]: ...
    _getServiceFor__T = _py_TypeVar('_getServiceFor__T', bound=BusinessService)  # <T>
    def getServiceFor(self, class_: _py_Type[_getServiceFor__T]) -> _getServiceFor__T: ...
    _registerServicesFor__T = _py_TypeVar('_registerServicesFor__T', bound=BusinessService)  # <T>
    def registerServicesFor(self, string: str) -> None: ...

class ServerScheduler:
    _getServiceFrom__T = _py_TypeVar('_getServiceFrom__T', bound=BusinessService)  # <T>
    def getServiceFrom(self, set: java.util.Set[RemoteServer], class_: _py_Type[_getServiceFrom__T]) -> _getServiceFrom__T: ...
    def lockServer(self, remoteServer: RemoteServer) -> None: ...
    def markServerAsUsed(self, remoteServer: RemoteServer) -> None: ...
    def releaseCurrentlyUsedServers(self) -> None: ...

class ServiceBeanReplacer(org.springframework.beans.factory.support.MethodReplacer, org.springframework.context.ApplicationContextAware):
    def __init__(self): ...
    def getServiceRegistry(self) -> 'ServiceRegistry': ...
    def reimplement(self, object: _py_Any, method: java.lang.reflect.Method, objectArray: _py_List[_py_Any]) -> _py_Any: ...
    def setApplicationContext(self, applicationContext: org.springframework.context.ApplicationContext) -> None: ...

class ServiceBeansProvider:
    def getBeanNames(self) -> java.util.List[str]: ...
    def getServers(self) -> java.util.List[str]: ...

_ServiceDescriptor__T = _py_TypeVar('_ServiceDescriptor__T', bound=BusinessService)  # <T>
class ServiceDescriptor(_py_Generic[_ServiceDescriptor__T]):
    def toString(self) -> str: ...

class ServiceRegistry:
    def __init__(self): ...
    def getRawServices(self) -> java.util.List[org.springframework.remoting.rmi.RmiProxyFactoryBean]: ...

class BusinessServiceDescriptor(ServiceDescriptor[BusinessService]): ...

class DefaultServiceBeansProvider(ServiceBeansProvider):
    def __init__(self, list: java.util.List[str], list2: java.util.List[str]): ...
    def getBeanNames(self) -> java.util.List[str]: ...
    def getServers(self) -> java.util.List[str]: ...

class ServerRegistryImpl(ServerRegistry):
    def __init__(self, serviceBeansProvider: ServiceBeansProvider, serverScheduler: ServerScheduler): ...
    _getAllServices__T = _py_TypeVar('_getAllServices__T', bound=BusinessService)  # <T>
    def getAllServices(self, class_: _py_Type[_getAllServices__T]) -> java.util.List[_getAllServices__T]: ...
    def getServerServices(self, string: str) -> java.util.List[BusinessServiceDescriptor]: ...
    _getServiceFor__T = _py_TypeVar('_getServiceFor__T', bound=BusinessService)  # <T>
    def getServiceFor(self, class_: _py_Type[_getServiceFor__T]) -> _getServiceFor__T: ...
    def init(self) -> None: ...
    _registerServicesFor__T = _py_TypeVar('_registerServicesFor__T', bound=BusinessService)  # <T>
    def registerServicesFor(self, string: str) -> None: ...

class SimpleServerScheduler(ServerScheduler):
    def __init__(self): ...
    _getServiceFrom__T = _py_TypeVar('_getServiceFrom__T', bound=BusinessService)  # <T>
    def getServiceFrom(self, set: java.util.Set[RemoteServer], class_: _py_Type[_getServiceFrom__T]) -> _getServiceFrom__T: ...
    def lockServer(self, remoteServer: RemoteServer) -> None: ...
    def markServerAsUsed(self, remoteServer: RemoteServer) -> None: ...
    def releaseCurrentlyUsedServers(self) -> None: ...
    def setLockedTimeSeconds(self, int: int) -> None: ...
    def setNumberOfAttemptsBeforeLock(self, int: int) -> None: ...
