from typing import TypeVar as _py_TypeVar
from typing import Generic as _py_Generic
from typing import overload
import java.io
import java.util


_JsonDeserializer__S = _py_TypeVar('_JsonDeserializer__S')  # <S>
_JsonDeserializer__T = _py_TypeVar('_JsonDeserializer__T')  # <T>
class JsonDeserializer(_py_Generic[_JsonDeserializer__S, _JsonDeserializer__T]):
    def deserializeFromSource(self, s2: _JsonDeserializer__S) -> _JsonDeserializer__T: ...

_JsonReader__T = _py_TypeVar('_JsonReader__T')  # <T>
class JsonReader(java.io.Closeable, _py_Generic[_JsonReader__T]):
    def close(self) -> None: ...
    def hasNext(self) -> bool: ...
    def read(self) -> _JsonReader__T: ...
    def readAll(self) -> java.util.List[_JsonReader__T]: ...

_JsonSerializer__S = _py_TypeVar('_JsonSerializer__S')  # <S>
_JsonSerializer__T = _py_TypeVar('_JsonSerializer__T')  # <T>
class JsonSerializer(_py_Generic[_JsonSerializer__S, _JsonSerializer__T]):
    def serializeToTarget(self, s2: _JsonSerializer__S, t: _JsonSerializer__T) -> None: ...

_JsonWriter__T = _py_TypeVar('_JsonWriter__T')  # <T>
class JsonWriter(java.io.Closeable, _py_Generic[_JsonWriter__T]):
    def close(self) -> None: ...
    def flush(self) -> None: ...
    @overload
    def write(self, t: _JsonWriter__T) -> None: ...
    @overload
    def write(self, collection: java.util.Collection[_JsonWriter__T]) -> None: ...
