from typing import List as _py_List
from typing import ClassVar as _py_ClassVar
from typing import overload
import cern.accsoft.commons.domain
import cern.accsoft.commons.util
import java.util


class AcceleratorMode(cern.accsoft.commons.util.Named):
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    def isOperational(self) -> bool: ...

class BeamMode(cern.accsoft.commons.util.Named):
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...

class LeirAcceleratorMode(cern.accsoft.commons.util.AbstractImmutableNamedSerializable['LeirAcceleratorMode'], AcceleratorMode):
    ACCESS: _py_ClassVar['LeirAcceleratorMode'] = ...
    BEAM_SETUP: _py_ClassVar['LeirAcceleratorMode'] = ...
    ION_PHYSICS: _py_ClassVar['LeirAcceleratorMode'] = ...
    MACHINE_DEVELOPMENT: _py_ClassVar['LeirAcceleratorMode'] = ...
    SHUTDOWN: _py_ClassVar['LeirAcceleratorMode'] = ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.CernAccelerator: ...
    def isOperational(self) -> bool: ...
    @classmethod
    def valueOf(cls, string: str) -> 'LeirAcceleratorMode': ...
    @classmethod
    def values(cls) -> _py_List['LeirAcceleratorMode']: ...

class LhcAcceleratorMode(cern.accsoft.commons.util.AbstractImmutableNamedSerializable['LhcAcceleratorMode'], AcceleratorMode):
    ACCESS: _py_ClassVar['LhcAcceleratorMode'] = ...
    BEAM_SETUP: _py_ClassVar['LhcAcceleratorMode'] = ...
    CALIBRATION: _py_ClassVar['LhcAcceleratorMode'] = ...
    COOLDOWN: _py_ClassVar['LhcAcceleratorMode'] = ...
    ION_PHYSICS: _py_ClassVar['LhcAcceleratorMode'] = ...
    MACHINE_CHECKOUT: _py_ClassVar['LhcAcceleratorMode'] = ...
    MACHINE_DEVELOPMENT: _py_ClassVar['LhcAcceleratorMode'] = ...
    MACHINE_TEST: _py_ClassVar['LhcAcceleratorMode'] = ...
    NO_MODE: _py_ClassVar['LhcAcceleratorMode'] = ...
    PROTON_PHYSICS: _py_ClassVar['LhcAcceleratorMode'] = ...
    PROTON_NUCLEUS_PHYSICS: _py_ClassVar['LhcAcceleratorMode'] = ...
    RECOVERY: _py_ClassVar['LhcAcceleratorMode'] = ...
    SECTOR_DEPENDENT: _py_ClassVar['LhcAcceleratorMode'] = ...
    SHUTDOWN: _py_ClassVar['LhcAcceleratorMode'] = ...
    SPECIAL_OPTICS_PHYSICS: _py_ClassVar['LhcAcceleratorMode'] = ...
    WARMUP: _py_ClassVar['LhcAcceleratorMode'] = ...
    PO_PHASE_1: _py_ClassVar['LhcAcceleratorMode'] = ...
    PO_PHASE_2: _py_ClassVar['LhcAcceleratorMode'] = ...
    CSCM_TEST: _py_ClassVar['LhcAcceleratorMode'] = ...
    COLD: _py_ClassVar['LhcAcceleratorMode'] = ...
    @classmethod
    def findByName(cls, string: str) -> 'LhcAcceleratorMode': ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.CernAccelerator: ...
    @classmethod
    def getLhcSectorModes(cls) -> java.util.Set['LhcAcceleratorMode']: ...
    def isApplicableToSectors(self) -> bool: ...
    def isOperational(self) -> bool: ...
    @classmethod
    def valueOf(cls, string: str) -> 'LhcAcceleratorMode': ...
    @classmethod
    def values(cls) -> _py_List['LhcAcceleratorMode']: ...

class LhcBeamMode(cern.accsoft.commons.util.AbstractImmutableNamedSerializable['LhcBeamMode'], BeamMode):
    NO_MODE: _py_ClassVar['LhcBeamMode'] = ...
    SETUP: _py_ClassVar['LhcBeamMode'] = ...
    INJECTION_PROBE_BEAM: _py_ClassVar['LhcBeamMode'] = ...
    INJECTION_SETUP_BEAM: _py_ClassVar['LhcBeamMode'] = ...
    INJECTION_PHYSICS_BEAM: _py_ClassVar['LhcBeamMode'] = ...
    PREPARE_RAMP: _py_ClassVar['LhcBeamMode'] = ...
    RAMP: _py_ClassVar['LhcBeamMode'] = ...
    FLAT_TOP: _py_ClassVar['LhcBeamMode'] = ...
    SQUEEZE: _py_ClassVar['LhcBeamMode'] = ...
    ADJUST: _py_ClassVar['LhcBeamMode'] = ...
    STABLE_BEAMS: _py_ClassVar['LhcBeamMode'] = ...
    UNSTABLE_BEAMS: _py_ClassVar['LhcBeamMode'] = ...
    BEAM_DUMP: _py_ClassVar['LhcBeamMode'] = ...
    RAMP_DOWN: _py_ClassVar['LhcBeamMode'] = ...
    RECOVERY: _py_ClassVar['LhcBeamMode'] = ...
    INJECT_AND_DUMP: _py_ClassVar['LhcBeamMode'] = ...
    CIRCULATE_AND_DUMP: _py_ClassVar['LhcBeamMode'] = ...
    ABORT: _py_ClassVar['LhcBeamMode'] = ...
    CYCLING: _py_ClassVar['LhcBeamMode'] = ...
    NO_BEAM: _py_ClassVar['LhcBeamMode'] = ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.CernAccelerator: ...
    @classmethod
    def valueOf(cls, string: str) -> 'LhcBeamMode': ...
    @classmethod
    def values(cls) -> _py_List['LhcBeamMode']: ...

class PsAcceleratorMode(cern.accsoft.commons.util.AbstractImmutableNamedSerializable['PsAcceleratorMode'], AcceleratorMode):
    SHUTDOWN: _py_ClassVar['PsAcceleratorMode'] = ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.CernAccelerator: ...
    def isOperational(self) -> bool: ...
    @classmethod
    def valueOf(cls, string: str) -> 'PsAcceleratorMode': ...
    @classmethod
    def values(cls) -> _py_List['PsAcceleratorMode']: ...

class PsbAcceleratorMode(cern.accsoft.commons.util.AbstractImmutableNamedSerializable['PsbAcceleratorMode'], AcceleratorMode):
    SHUTDOWN: _py_ClassVar['PsbAcceleratorMode'] = ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.CernAccelerator: ...
    def isOperational(self) -> bool: ...
    @classmethod
    def valueOf(cls, string: str) -> 'PsbAcceleratorMode': ...
    @classmethod
    def values(cls) -> _py_List['PsbAcceleratorMode']: ...

class SpsAcceleratorMode(cern.accsoft.commons.util.AbstractImmutableNamedSerializable['SpsAcceleratorMode'], AcceleratorMode):
    BEAM_OPERATION: _py_ClassVar['SpsAcceleratorMode'] = ...
    SHUTDOWN: _py_ClassVar['SpsAcceleratorMode'] = ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.Accelerator: ...
    @overload
    def getAccelerator(self) -> cern.accsoft.commons.domain.CernAccelerator: ...
    def isOperational(self) -> bool: ...
    @classmethod
    def valueOf(cls, string: str) -> 'SpsAcceleratorMode': ...
    @classmethod
    def values(cls) -> _py_List['SpsAcceleratorMode']: ...
