from typing import List as _py_List
from typing import ClassVar as _py_ClassVar
import cern.accsoft.commons.domain.beamdestinations
import cern.accsoft.commons.domain.beams
import cern.accsoft.commons.domain.modes
import cern.accsoft.commons.domain.particletransfers
import cern.accsoft.commons.domain.zones
import cern.accsoft.commons.util
import java.util


class Accelerator(cern.accsoft.commons.util.Named):
    def getAcceleratorModes(self) -> java.util.Set[cern.accsoft.commons.domain.modes.AcceleratorMode]: ...
    def getAcceleratorZones(self) -> java.util.Set[cern.accsoft.commons.domain.zones.AcceleratorZone]: ...
    def getBeamDestinations(self) -> java.util.Set[cern.accsoft.commons.domain.beamdestinations.BeamDestination]: ...
    def getBeams(self) -> java.util.Set[cern.accsoft.commons.domain.beams.Beam]: ...
    def getCode(self) -> str: ...
    def getParticleTransfers(self) -> java.util.Set[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]: ...
    def getTimingDomain(self) -> 'TimingDomain': ...
    def isMultiplexed(self) -> bool: ...

class ParticleType(cern.accsoft.commons.util.AbstractImmutableNamedSerializable['ParticleType']):
    ELECTRON: _py_ClassVar['ParticleType'] = ...
    PROTON: _py_ClassVar['ParticleType'] = ...
    PBAR: _py_ClassVar['ParticleType'] = ...
    MUON: _py_ClassVar['ParticleType'] = ...
    PION_PLUS: _py_ClassVar['ParticleType'] = ...
    PION_MINUS: _py_ClassVar['ParticleType'] = ...
    KAON: _py_ClassVar['ParticleType'] = ...
    PB54: _py_ClassVar['ParticleType'] = ...
    PB80: _py_ClassVar['ParticleType'] = ...
    PB81: _py_ClassVar['ParticleType'] = ...
    PB82: _py_ClassVar['ParticleType'] = ...
    XE39: _py_ClassVar['ParticleType'] = ...
    XE54: _py_ClassVar['ParticleType'] = ...
    AR11: _py_ClassVar['ParticleType'] = ...
    AR18: _py_ClassVar['ParticleType'] = ...
    HMINUS: _py_ClassVar['ParticleType'] = ...
    O4: _py_ClassVar['ParticleType'] = ...
    O8: _py_ClassVar['ParticleType'] = ...
    def getNumberOfCharges(self) -> int: ...
    def getRestMassEV(self) -> float: ...
    @classmethod
    def valueOf(cls, string: str) -> 'ParticleType': ...
    @classmethod
    def values(cls) -> _py_List['ParticleType']: ...

class TimingDomain(cern.accsoft.commons.util.Named):
    def isCycling(self) -> bool: ...
    def isMultiplexed(self) -> bool: ...

class CernAccelerator(cern.accsoft.commons.util.AbstractImmutableNamedSerializable['CernAccelerator'], Accelerator):
    AD: _py_ClassVar['CernAccelerator'] = ...
    CTF: _py_ClassVar['CernAccelerator'] = ...
    ISOLDE: _py_ClassVar['CernAccelerator'] = ...
    LEIR: _py_ClassVar['CernAccelerator'] = ...
    LHC: _py_ClassVar['CernAccelerator'] = ...
    PS: _py_ClassVar['CernAccelerator'] = ...
    PSB: _py_ClassVar['CernAccelerator'] = ...
    SPS: _py_ClassVar['CernAccelerator'] = ...
    NORTH: _py_ClassVar['CernAccelerator'] = ...
    AWAKE: _py_ClassVar['CernAccelerator'] = ...
    ELENA: _py_ClassVar['CernAccelerator'] = ...
    LINAC3: _py_ClassVar['CernAccelerator'] = ...
    LINAC4: _py_ClassVar['CernAccelerator'] = ...
    REX: _py_ClassVar['CernAccelerator'] = ...
    @classmethod
    def byCcsName(cls, string: str) -> 'CernAccelerator': ...
    @classmethod
    def byCode(cls, string: str) -> 'CernAccelerator': ...
    @classmethod
    def fromNameOrCode(cls, string: str) -> 'CernAccelerator': ...
    def getAcceleratorModes(self) -> java.util.Set[cern.accsoft.commons.domain.modes.AcceleratorMode]: ...
    def getAcceleratorZones(self) -> java.util.Set[cern.accsoft.commons.domain.zones.AcceleratorZone]: ...
    def getBeamDestinations(self) -> java.util.Set[cern.accsoft.commons.domain.beamdestinations.BeamDestination]: ...
    def getBeams(self) -> java.util.Set[cern.accsoft.commons.domain.beams.Beam]: ...
    def getCcsName(self) -> str: ...
    def getCode(self) -> str: ...
    def getParticleTransfers(self) -> java.util.Set[cern.accsoft.commons.domain.particletransfers.ParticleTransfer]: ...
    def getTimingDomain(self) -> TimingDomain: ...
    def isMultiplexed(self) -> bool: ...
    @classmethod
    def valueOf(cls, string: str) -> 'CernAccelerator': ...
    @classmethod
    def values(cls) -> _py_List['CernAccelerator']: ...

class CernTimingDomain(cern.accsoft.commons.util.AbstractImmutableNamedSerializable['CernTimingDomain'], TimingDomain):
    LHC: _py_ClassVar['CernTimingDomain'] = ...
    SPS: _py_ClassVar['CernTimingDomain'] = ...
    CPS: _py_ClassVar['CernTimingDomain'] = ...
    PSB: _py_ClassVar['CernTimingDomain'] = ...
    LEI: _py_ClassVar['CernTimingDomain'] = ...
    ADE: _py_ClassVar['CernTimingDomain'] = ...
    SCT: _py_ClassVar['CernTimingDomain'] = ...
    LNA: _py_ClassVar['CernTimingDomain'] = ...
    def isCycling(self) -> bool: ...
    @classmethod
    def valueOf(cls, string: str) -> 'CernTimingDomain': ...
    @classmethod
    def values(cls) -> _py_List['CernTimingDomain']: ...
