"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WafwebaclToApiGateway = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
// Imports
const constructs_1 = require("constructs");
const waf = require("aws-cdk-lib/aws-wafv2");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * @summary The WafwebaclToApiGateway class.
 */
class WafwebaclToApiGateway extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the WafwebaclToApiGateway class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {WafwebaclToApiGatewayProps} props - user provided props for the construct.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckWafWebAclProps(props);
        // Build the Web ACL
        this.webacl = defaults.buildWebacl(this, 'REGIONAL', {
            existingWebaclObj: props.existingWebaclObj,
            webaclProps: props.webaclProps,
        });
        const resourceArn = `arn:${aws_cdk_lib_1.Aws.PARTITION}:apigateway:${aws_cdk_lib_1.Aws.REGION}::/restapis/${props.existingApiGatewayInterface.restApiId}/stages/${props.existingApiGatewayInterface.deploymentStage.stageName}`;
        const aclAssociationId = `${id}-WebACLAssociation`;
        const aclAssociationProps = {
            webAclArn: this.webacl.attrArn,
            resourceArn
        };
        // Before turning off SonarQube for the line, reduce the line to it's minimum
        new waf.CfnWebACLAssociation(scope, aclAssociationId, aclAssociationProps); // NOSONAR
        this.apiGateway = props.existingApiGatewayInterface;
    }
}
exports.WafwebaclToApiGateway = WafwebaclToApiGateway;
_a = JSII_RTTI_SYMBOL_1;
WafwebaclToApiGateway[_a] = { fqn: "@aws-solutions-constructs/aws-wafwebacl-apigateway.WafwebaclToApiGateway", version: "2.91.0" };
//# sourceMappingURL=data:application/json;base64,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