"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbController = exports.AlbScheme = exports.AlbControllerVersion = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const iam = require("@aws-cdk/aws-iam");
const helm_chart_1 = require("./helm-chart");
const service_account_1 = require("./service-account");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_1 = require("@aws-cdk/core");
/**
 * Controller version.
 *
 * Corresponds to the image tag of 'amazon/aws-load-balancer-controller' image.
 *
 * @stability stable
 */
class AlbControllerVersion {
    constructor(
    /**
     * The version string.
     */
    version, 
    /**
     * Whether or not its a custom version.
     */
    custom) {
        this.version = version;
        this.custom = custom;
    }
    /**
     * Specify a custom version.
     *
     * Use this if the version you need is not available in one of the predefined versions.
     * Note that in this case, you will also need to provide an IAM policy in the controller options.
     *
     * @param version The version number.
     * @stability stable
     */
    static of(version) {
        return new AlbControllerVersion(version, true);
    }
}
exports.AlbControllerVersion = AlbControllerVersion;
_a = JSII_RTTI_SYMBOL_1;
AlbControllerVersion[_a] = { fqn: "@aws-cdk/aws-eks.AlbControllerVersion", version: "1.134.0" };
/**
 * v2.0.0.
 *
 * @stability stable
 */
AlbControllerVersion.V2_0_0 = new AlbControllerVersion('v2.0.0', false);
/**
 * v2.0.1.
 *
 * @stability stable
 */
AlbControllerVersion.V2_0_1 = new AlbControllerVersion('v2.0.1', false);
/**
 * v2.1.0.
 *
 * @stability stable
 */
AlbControllerVersion.V2_1_0 = new AlbControllerVersion('v2.1.0', false);
/**
 * v2.1.1.
 *
 * @stability stable
 */
AlbControllerVersion.V2_1_1 = new AlbControllerVersion('v2.1.1', false);
/**
 * v2.1.2.
 *
 * @stability stable
 */
AlbControllerVersion.V2_1_2 = new AlbControllerVersion('v2.1.2', false);
/**
 * v2.1.3.
 *
 * @stability stable
 */
AlbControllerVersion.V2_1_3 = new AlbControllerVersion('v2.1.3', false);
/**
 * v2.0.0.
 *
 * @stability stable
 */
AlbControllerVersion.V2_2_0 = new AlbControllerVersion('v2.2.0', false);
/**
 * v2.2.1.
 *
 * @stability stable
 */
AlbControllerVersion.V2_2_1 = new AlbControllerVersion('v2.2.1', false);
/**
 * v2.2.2.
 *
 * @stability stable
 */
AlbControllerVersion.V2_2_2 = new AlbControllerVersion('v2.2.2', false);
/**
 * v2.2.3.
 *
 * @stability stable
 */
AlbControllerVersion.V2_2_3 = new AlbControllerVersion('v2.2.3', false);
/**
 * v2.2.4.
 *
 * @stability stable
 */
AlbControllerVersion.V2_2_4 = new AlbControllerVersion('v2.2.4', false);
/**
 * v2.3.0.
 *
 * @stability stable
 */
AlbControllerVersion.V2_3_0 = new AlbControllerVersion('v2.3.0', false);
/**
 * ALB Scheme.
 *
 * @see https://kubernetes-sigs.github.io/aws-load-balancer-controller/v2.3/guide/ingress/annotations/#scheme
 * @stability stable
 */
var AlbScheme;
(function (AlbScheme) {
    AlbScheme["INTERNAL"] = "internal";
    AlbScheme["INTERNET_FACING"] = "internet-facing";
})(AlbScheme = exports.AlbScheme || (exports.AlbScheme = {}));
/**
 * Construct for installing the AWS ALB Contoller on EKS clusters.
 *
 * Use the factory functions `get` and `getOrCreate` to obtain/create instances of this controller.
 *
 * @see https://kubernetes-sigs.github.io/aws-load-balancer-controller
 * @stability stable
 */
class AlbController extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _c, _d;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_eks_AlbControllerProps(props);
        const namespace = 'kube-system';
        const serviceAccount = new service_account_1.ServiceAccount(this, 'alb-sa', { namespace, name: 'aws-load-balancer-controller', cluster: props.cluster });
        if (props.version.custom && !props.policy) {
            throw new Error("'albControllerOptions.policy' is required when using a custom controller version");
        }
        // https://kubernetes-sigs.github.io/aws-load-balancer-controller/v2.2/deploy/installation/#iam-permissions
        const policy = (_c = props.policy) !== null && _c !== void 0 ? _c : JSON.parse(fs.readFileSync(path.join(__dirname, 'addons', `alb-iam_policy-${props.version.version}.json`), 'utf8'));
        for (const statement of policy.Statement) {
            serviceAccount.addToPrincipalPolicy(iam.PolicyStatement.fromJson(statement));
        }
        // https://kubernetes-sigs.github.io/aws-load-balancer-controller/v2.2/deploy/installation/#add-controller-to-cluster
        const chart = new helm_chart_1.HelmChart(this, 'Resource', {
            cluster: props.cluster,
            chart: 'aws-load-balancer-controller',
            repository: 'https://aws.github.io/eks-charts',
            namespace,
            release: 'aws-load-balancer-controller',
            // latest at the time of writing. We intentionally don't
            // want to expose this since helm here is just an implementation detail
            // for installing a specific version of the controller itself.
            // https://github.com/aws/eks-charts/blob/v0.0.65/stable/aws-load-balancer-controller/Chart.yaml
            version: '1.2.7',
            wait: true,
            timeout: core_1.Duration.minutes(15),
            values: {
                clusterName: props.cluster.clusterName,
                serviceAccount: {
                    create: false,
                    name: serviceAccount.serviceAccountName,
                },
                region: core_1.Stack.of(this).region,
                vpcId: props.cluster.vpc.vpcId,
                repository: (_d = props.repository) !== null && _d !== void 0 ? _d : '602401143452.dkr.ecr.us-west-2.amazonaws.com/amazon/aws-load-balancer-controller',
                tag: props.version.version,
            },
        });
        // the controller relies on permissions deployed using these resources.
        chart.node.addDependency(serviceAccount);
        chart.node.addDependency(props.cluster.openIdConnectProvider);
        chart.node.addDependency(props.cluster.awsAuth);
    }
    /**
     * Create the controller construct associated with this cluster and scope.
     *
     * Singleton per stack/cluster.
     *
     * @stability stable
     */
    static create(scope, props) {
        jsiiDeprecationWarnings._aws_cdk_aws_eks_AlbControllerProps(props);
        const stack = core_1.Stack.of(scope);
        const uid = AlbController.uid(props.cluster);
        return new AlbController(stack, uid, props);
    }
    static uid(cluster) {
        return `${core_1.Names.nodeUniqueId(cluster.node)}-AlbController`;
    }
}
exports.AlbController = AlbController;
_b = JSII_RTTI_SYMBOL_1;
AlbController[_b] = { fqn: "@aws-cdk/aws-eks.AlbController", version: "1.134.0" };
//# sourceMappingURL=data:application/json;base64,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