"""
The MIT License

Copyright (c) 2017-2020 Mark Douthwaite

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
"""

import numpy as np


class Colors:
    HEADER = "\033[95m"
    OKBLUE = "\033[94m"
    OKGREEN = "\033[92m"
    WARNING = "\033[93m"
    FAIL = "\033[91m"
    ENDC = "\033[0m"
    BOLD = "\033[1m"
    UNDERLINE = "\033[4m"


def pprint_marginals(network, marginals, n=4, percent=True):
    for variable, marginal in marginals.items():
        print("=" * 50)
        if len(network[variable].parents) > 0:
            print(variable, "|", ", ".join(network[variable].parents))
        else:
            print(variable)

        print("-" * 50)
        probs = np.asarray(list(marginal.values()))

        if percent:
            statement = lambda x, y: ("{0}: {1:." + str(n) + "}%").format(x, y * 100)
        else:
            statement = lambda x, y: ("{0}: {1:." + str(n) + "}").format(x, y)

        if np.max(probs) == 1.0:
            idx = np.argmax(probs)
            for i, (state, prob) in enumerate(marginal.items()):
                if i == idx:
                    print(
                        Colors.BOLD
                        + Colors.OKGREEN
                        + statement(state, prob)
                        + Colors.ENDC
                    )
                else:
                    print(Colors.FAIL + statement(state, prob) + Colors.ENDC)

        elif np.allclose(*probs):
            for i, (state, prob) in enumerate(marginal.items()):
                print(Colors.OKBLUE + statement(state, prob) + Colors.ENDC)
        else:
            idx = np.argmax(probs)
            for i, (state, prob) in enumerate(marginal.items()):
                if i == idx:
                    print(Colors.OKGREEN + statement(state, prob) + Colors.ENDC)
                else:
                    print(Colors.OKBLUE + statement(state, prob) + Colors.ENDC)
    print("-" * 50)
