# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['epr']
extras_require = \
{':platform_system == "Windows"': ['windows-curses']}

entry_points = \
{'console_scripts': ['epr = epr:main']}

setup_kwargs = {
    'name': 'epr-reader',
    'version': '2.4.15',
    'description': 'CLI Ebook Reader',
    'long_description': '# `$ epr`\n\n![Screenshot](https://raw.githubusercontent.com/wustho/epr/master/screenshot.png)\n\nTerminal/CLI Epub reader written in Python 3.6 with features:\n\n- Remembers last read file (just run `epr` without any argument)\n- Remembers last reading state for each file (per file saved state written to `$HOME/.config/epr/config` or `$HOME/.epr` respectively depending on availability)\n- Adjustable text area width\n- Adaptive to terminal resize\n- Supports EPUB3 (no audio support)\n- Secondary vim-like bindings\n- Supports opening images\n- Dark/Light colorscheme (depends on terminal color capability)\n\n## Limitations\n\n- Minimum width: 22 cols\n- Supports regex search only\n- Supports only horizontal left-to-right text\n- Currently, only supports language with latin alphabet (see [issue30](https://github.com/wustho/epr/issues/30))\n- Doesn\'t support hyperlinks\n- <sup>Superscript</sup> and <sub>subscript</sub> displayed as `^{Superscript}` and `_{subscript}`.\n- Some known issues mentioned below\n\n## Dependencies\n\n- Windows: `windows-curses`\n\n## Installation\n\n  - Via PyPI\n\n    ```shell\n    $ pip3 install epr-reader\n    ```\n\n  - Via Pip+Git\n\n    ```shell\n    $ pip3 install git+https://github.com/wustho/epr.git\n    ```\n\n  - Via [Homebrew](https://formulae.brew.sh/formula/epr) for macOS or Linux\n\n    ```shell\n    $ brew install epr\n    ```\n\n  - Via Chocolatey\n\n    Maintained by [cybercatgurrl](https://github.com/cybercatgurrl/chocolatey-pkgs/tree/master/epr)\n\n    ```shell\n    $ choco install epr\n    ```\n\n  - Via AUR\n\n    Maintained by [jneidel](https://aur.archlinux.org/packages/epr-git/)\n\n    ```shell\n    $ yay -S epr-git\n    ```\n\n  - Manually\n\n    Clone this repo, tweak `epr.py` as much as you see fit, rename it to `epr`, make it executable and put it somewhere in `PATH`.\n\n## Checkout [`epy`](https://github.com/wustho/epy)!\n\nIt\'s just a fork of this `epr` with little more features:\n\n- Formats supported: epub, epub3, fb2, mobi, azw3, url.\n- Reading progress percentage\n- Bookmarks\n- External dictionary integration\n- Table of contents scheme like regular ebook reader\n- Inline formats: **bold** and _italic_ (depend on terminal and font capability. Italic only supported in python>=3.7)\n- Text-to-Speech (with additional setup)\n- Page flip animation\n- Seamless between chapter\n\nInstall it with:\n\n```shell\n$ pip3 install git+https://github.com/wustho/epy\n```\n\n## Quickly Read from History\n\nRather than invoking `epr /path/to/file` each time you are going to read, you might find it easier to do just `epr STRINGS.`\n\nExample:\n\n``` shell\n$ epr dumas count mont\n```\n\nIf `STRINGS` is not any file, `epr` will choose from reading history, best matched `path/to/file` with those `STRINGS.` So, the more `STRINGS` given the more accurate it will find.\n\nRun `epr -r` to show list of all reading history.\n\n## Opening an Image\n\nJust hit `o` when `[IMG:n]` (_n_ is any number) comes up on a page. If there\'s only one of those, it will automatically open the image using viewer, but if there are more than one, cursor will appear to help you choose which image then press `RET` to open it and `q` to cancel.\n\n## Colorscheme\n\nThis is just a simple colorscheme involving foreground dan background color only, no syntax highlighting.\nYou can cycle color between default terminal color, dark or light respectively by pressing `c`.\nYou can also switch color to default, dark or light by pressing `0c`, `1c` or `2c` respectively.\n\nCustomizing dark/light colorscheme needs to be done inside the source code by editing these lines:\n\n```python\n# colorscheme\n# DARK/LIGHT = (fg, bg)\n# -1 is default terminal fg/bg\nDARK = (252, 235)\nLIGHT = (239, 223)\n```\n\nTo see available values assigned to colors, you can run this one-liner on bash:\n\n```shell\n$ i=0; for j in {1..16}; do for k in {1..16}; do printf "\\e[1;48;05;${i}m %03d \\e[0m" $i; i=$((i+1)); done; echo; done\n```\n\n## Known Issues\n\n1. Search function can\'t find occurrences that span across multiple lines\n\n   Only capable of finding pattern that span inside a single line, not sentence.\n   So works more effectively for finding word or letter rather than long phrase or sentence.\n\n   As workarounds, You can increase text area width to increase its reach or dump\n   the content of epub using `-d` option, which will dump each paragraph into a single line separated by empty line\n   (or lines depending on the epub), to be later piped into `grep`, `rg` etc. Pretty useful to find book quotes.\n\n   Example:\n\n   ```shell\n   # to get 1 paragraph before and after a paragraph containing "Overdue"\n   $ epr -d the_girl_next_door.epub | grep Overdue -C 2\n   ```\n\n2. Some TOC issues (Checkout [`epy`](https://github.com/wustho/epy) if you\'re bothered with these issues):\n\n   - "-" chapters in TOC\n\n     This happens because not every chapter file (inside some epubs) is given navigation points.\n     Some epubs even won\'t let you navigate between chapter, thus you\'ll find all chapters named as\n     "-" using `epr` for these kind of epubs.\n\n   - Skipped chapters in TOC\n\n     Example:\n\n     ```\n     Table of Contents\n     -----------------\n\n         1. Title Page\n         2. Chapter I\n         3. Chapter V\n     ```\n\n     This happens because Chapter II to Chapter IV is probably in the same file with Chapter I,\n     but in different sections, e. g. `ch000.html#section1` and `ch000.html#section2.`\n\n     But don\'t worry, you should not miss any part to read. This just won\'t let you navigate\n     to some points using TOC.\n\n   - Sometimes page flipping itself to new chapter when scrolling\n\n     This might be disorienting. To avoid this issue, you can use [`epy`](https://github.com/wustho/epy) instead\n     which fixed this issue by setting its config `SeamlessBetweenChapters`.\n\n## Inspirations\n\n- https://github.com/aerkalov/ebooklib\n- https://github.com/rupa/epub\n',
    'author': 'Benawi Adha',
    'author_email': 'benawiadha@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'py_modules': modules,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
