"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProviderAttribute = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * An attribute available from a third party identity provider.
 *
 * @stability stable
 */
class ProviderAttribute {
    constructor(attributeName) {
        this.attributeName = attributeName;
    }
    /**
     * Use this to specify an attribute from the identity provider that is not pre-defined in the CDK.
     *
     * @param attributeName the attribute value string as recognized by the provider.
     * @stability stable
     */
    static other(attributeName) {
        return new ProviderAttribute(attributeName);
    }
}
exports.ProviderAttribute = ProviderAttribute;
_a = JSII_RTTI_SYMBOL_1;
ProviderAttribute[_a] = { fqn: "@aws-cdk/aws-cognito.ProviderAttribute", version: "1.98.0" };
/**
 * The email attribute provided by Apple.
 *
 * @stability stable
 */
ProviderAttribute.APPLE_EMAIL = new ProviderAttribute('email');
/**
 * The name attribute provided by Apple.
 *
 * @stability stable
 */
ProviderAttribute.APPLE_NAME = new ProviderAttribute('name');
/**
 * The first name attribute provided by Apple.
 *
 * @stability stable
 */
ProviderAttribute.APPLE_FIRST_NAME = new ProviderAttribute('firstName');
/**
 * The last name attribute provided by Apple.
 *
 * @stability stable
 */
ProviderAttribute.APPLE_LAST_NAME = new ProviderAttribute('lastName');
/**
 * The user id attribute provided by Amazon.
 *
 * @stability stable
 */
ProviderAttribute.AMAZON_USER_ID = new ProviderAttribute('user_id');
/**
 * The email attribute provided by Amazon.
 *
 * @stability stable
 */
ProviderAttribute.AMAZON_EMAIL = new ProviderAttribute('email');
/**
 * The name attribute provided by Amazon.
 *
 * @stability stable
 */
ProviderAttribute.AMAZON_NAME = new ProviderAttribute('name');
/**
 * The postal code attribute provided by Amazon.
 *
 * @stability stable
 */
ProviderAttribute.AMAZON_POSTAL_CODE = new ProviderAttribute('postal_code');
/**
 * The user id attribute provided by Facebook.
 *
 * @stability stable
 */
ProviderAttribute.FACEBOOK_ID = new ProviderAttribute('id');
/**
 * The birthday attribute provided by Facebook.
 *
 * @stability stable
 */
ProviderAttribute.FACEBOOK_BIRTHDAY = new ProviderAttribute('birthday');
/**
 * The email attribute provided by Facebook.
 *
 * @stability stable
 */
ProviderAttribute.FACEBOOK_EMAIL = new ProviderAttribute('email');
/**
 * The name attribute provided by Facebook.
 *
 * @stability stable
 */
ProviderAttribute.FACEBOOK_NAME = new ProviderAttribute('name');
/**
 * The first name attribute provided by Facebook.
 *
 * @stability stable
 */
ProviderAttribute.FACEBOOK_FIRST_NAME = new ProviderAttribute('first_name');
/**
 * The last name attribute provided by Facebook.
 *
 * @stability stable
 */
ProviderAttribute.FACEBOOK_LAST_NAME = new ProviderAttribute('last_name');
/**
 * The middle name attribute provided by Facebook.
 *
 * @stability stable
 */
ProviderAttribute.FACEBOOK_MIDDLE_NAME = new ProviderAttribute('middle_name');
/**
 * The gender attribute provided by Facebook.
 *
 * @stability stable
 */
ProviderAttribute.FACEBOOK_GENDER = new ProviderAttribute('gender');
/**
 * The locale attribute provided by Facebook.
 *
 * @stability stable
 */
ProviderAttribute.FACEBOOK_LOCALE = new ProviderAttribute('locale');
/**
 * The name attribute provided by Google.
 *
 * @stability stable
 */
ProviderAttribute.GOOGLE_NAMES = new ProviderAttribute('names');
/**
 * The gender attribute provided by Google.
 *
 * @stability stable
 */
ProviderAttribute.GOOGLE_GENDER = new ProviderAttribute('gender');
/**
 * The birthday attribute provided by Google.
 *
 * @stability stable
 */
ProviderAttribute.GOOGLE_BIRTHDAYS = new ProviderAttribute('birthdays');
/**
 * The phone number attribute provided by Google.
 *
 * @stability stable
 */
ProviderAttribute.GOOGLE_PHONE_NUMBERS = new ProviderAttribute('phoneNumbers');
/**
 * The email attribute provided by Google.
 *
 * @stability stable
 */
ProviderAttribute.GOOGLE_EMAIL = new ProviderAttribute('email');
/**
 * The name attribute provided by Google.
 *
 * @stability stable
 */
ProviderAttribute.GOOGLE_NAME = new ProviderAttribute('name');
/**
 * The picture attribute provided by Google.
 *
 * @stability stable
 */
ProviderAttribute.GOOGLE_PICTURE = new ProviderAttribute('picture');
/**
 * The given name attribute provided by Google.
 *
 * @stability stable
 */
ProviderAttribute.GOOGLE_GIVEN_NAME = new ProviderAttribute('given_name');
/**
 * The family name attribute provided by Google.
 *
 * @stability stable
 */
ProviderAttribute.GOOGLE_FAMILY_NAME = new ProviderAttribute('family_name');
//# sourceMappingURL=data:application/json;base64,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