# Splitter

## How to install or update the lib

```
# The .h5 models are installed along with the pip installation. 
    # There's no need to hardcode their path anywhere.
pip install git+https://gitlab.com/gpam/victor/SERVICES/splitter.git
# Or
pip install victor-services-splitter 
```
<!-- git clone https://gitlab.com/gpam/victor/SERVICES/splitter
cd splitter
pip install . -->

## How to uninstall the lib

```
pip uninstall victor-services-splitter
```

## How to generate predictions

```
from splitter.model import ModelSplitter

# Setup the threading of the TensorFlow model operations
# (...)

model_splitter = ModelSplitter("path/to/model/page/image/features",
                               "path/to/model/page/classification")

# Create the image list. See the supported image types section
image_list = [...]


prediction_list = model_splitter.predict_pdf_pages(
    image_list
    )
# [1, 0, 0, 1, 1, 1, 0]

grouped_prediction_list = model_splitter.predict_pdf_pages(
    image_list,
    has_to_group_predictions=True
    )
# [[1, 0, 0], [1], [1], [1, 0]]

precise_prediction_list = model_splitter.predict_pdf_pages(
    image_list,
    prediction_decimals=3
    )
# [1.0, 0.312, 0.0, 0.963, 0.534, 0.744, 0.23]
```

## Setup the threading of the TensorFlow model operations. 
#### Read more at the [TensorFlow docs about threading](https://www.tensorflow.org/api_docs/python/tf/config/threading).

```
import tensorflow as tf

# a value of 0 means the system picks an appropriate number.
tf.config.threading.set_intra_op_parallelism_threads(
    num_threads=0
    )

# a value of 0 means the system picks an appropriate number.
tf.config.threading.set_inter_op_parallelism_threads(
    num_threads=0
    )
```

## Supported image types

```
- Pillow
- Base64
- Bytes
- Image path ending with '.jpg', '.png' or '.jpeg'
```
