__author__ = "Paulo Antunes"
__copyright__ = "Copyright 2018, XTCryptoSignals"
__credits__ = [
    "Paulo Antunes",
]
__license__ = "GPL"
__maintainer__ = "Paulo Antunes"
__email__ = "pjmlantunes@gmail.com"


import random
from datetime import datetime
from flask import (
    render_template,
    Blueprint,
    current_app,
    g,
)
from xtcryptosignals.client import service
from xtcryptosignals import __version__


bp = Blueprint("home", __name__)


@bp.before_request
def before_request():
    g.SYMBOLS_PER_EXCHANGE, _ = service.get_symbols_per_exchange()
    g.HISTORY_FREQUENCY, _ = service.get_history_frequency()


@bp.context_processor
def context_processor():
    return dict(
        socket_base_url=current_app.config["SOCKET_BASE_URL"],
        version=__version__,
        ga_tracking_id=current_app.config["GA_TRACKING_ID"],
        current_year=datetime.utcnow().year,
        frequencies=g.HISTORY_FREQUENCY,
    )


@bp.route("/")
def index():
    symbols_per_exchange = []
    for x in g.SYMBOLS_PER_EXCHANGE:
        for exchange, item in x.items():
            if not item["pairs"]:
                continue
            random_list = [x[0] + x[1] for x in item["pairs"]]
            random.shuffle(random_list)
            symbols_per_exchange.append({exchange: random_list[:3]})
    return render_template(
        template_name_or_list="index.html",
        symbols_per_exchange=symbols_per_exchange,
    )
