"""Jacobian matrix for Kinova Gen3

Functions
---------
jocobian(joint_position)

"""

import math
import numpy as np


def jacobian(joint_position):
    """The Jacobian of the Kinova Gen3 robot

    Arguments
    ---------
    joint_position (array_like): The joint angles of the robot

    Returns
    -------
    ndarray: The kinematic Jacobian matrix expressed in the base frame

    """

    x_0 = math.cos(joint_position[0])
    x_1 = math.sin(joint_position[0])
    x_2 = math.sin(joint_position[1])
    x_3 = 0.4208 * x_2
    x_4 = math.cos(joint_position[2])
    x_5 = x_0 * x_4
    x_6 = 0.0128 * x_5
    x_7 = math.cos(joint_position[3])
    x_8 = x_1 * x_2
    x_9 = x_7 * x_8
    x_10 = math.cos(joint_position[1])
    x_11 = math.sin(joint_position[2])
    x_12 = x_1 * x_11
    x_13 = x_10 * x_12
    x_14 = math.sin(joint_position[3])
    x_15 = x_0 * x_11
    x_16 = 0.3143 * x_15
    x_17 = x_1 * x_4
    x_18 = x_10 * x_17
    x_19 = -x_16 - 0.3143 * x_18
    x_20 = math.cos(joint_position[5])
    x_21 = -0.1674 * x_9
    x_22 = x_15 + x_18
    x_23 = x_14 * x_22
    x_24 = math.sin(joint_position[5])
    x_25 = x_13 - x_5
    x_26 = math.sin(joint_position[4])
    x_27 = 0.1674 * x_26
    x_28 = x_14 * x_2
    x_29 = x_1 * x_28
    x_30 = -x_15 - x_18
    x_31 = x_29 + x_30 * x_7
    x_32 = math.cos(joint_position[4])
    x_33 = 0.1674 * x_32
    x_34 = x_31 * x_33
    x_35 = 0.4208 * x_10
    x_36 = 0.0128 * x_15
    x_37 = x_10 * x_7
    x_38 = 0.3143 * x_37
    x_39 = 0.3143 * x_5
    x_40 = 0.1674 * x_37
    x_41 = 0.1674 * x_28
    x_42 = x_2 * x_27
    x_43 = x_10 * x_14
    x_44 = x_2 * x_7
    x_45 = 0.0128 * x_12
    x_46 = 0.3143 * x_17
    x_47 = x_10 * x_15
    x_48 = x_17 + x_47
    x_49 = 0.1674 * x_20
    x_50 = x_14 * x_49
    x_51 = x_10 * x_5
    x_52 = x_12 - x_51
    x_53 = x_33 * (-x_17 - x_47)
    x_54 = x_0 * x_28
    x_55 = 0.3143 * x_12
    x_56 = 0.3143 * x_51
    x_57 = x_52 * x_7
    x_58 = x_0 * x_2
    x_59 = x_58 * x_7
    x_60 = -x_12 + x_51
    x_61 = x_14 * x_60
    x_62 = -x_59 - x_61
    x_63 = x_24 * x_33
    x_64 = -x_54 + x_60 * x_7
    x_65 = x_26 * x_64
    x_66 = 0.1674 * x_59
    x_67 = 0.1674 * x_61
    x_68 = x_26 * x_48
    x_69 = 0.1674 * x_68
    x_70 = x_32 * x_64
    x_71 = -x_13 + x_5
    x_72 = x_25 * x_33
    x_73 = x_22 * x_7
    x_74 = x_14 * x_30
    x_75 = x_26 * x_71
    x_76 = 0.3143 * x_44
    x_77 = x_10 * x_11
    x_78 = 0.3143 * x_43
    x_79 = 0.1674 * x_44
    x_80 = 0.1674 * x_43
    x_81 = x_2 * x_4
    x_82 = x_11 * x_28
    x_83 = x_11 * x_2
    x_84 = x_33 * x_83
    x_85 = x_28 * x_4
    x_86 = -x_37 + x_85
    x_87 = x_4 * x_44
    x_88 = -x_43 - x_87
    x_89 = x_23 + x_9
    x_90 = x_29 - x_73
    x_91 = x_43 + x_87

    return np.array(
        [
            [
                -0.0118 * x_0
                - x_1 * x_3
                + 0.0128 * x_13
                + x_14 * x_19
                + x_20 * (x_21 - 0.1674 * x_23)
                + x_24 * (x_25 * x_27 + x_34)
                - x_6
                - 0.3143 * x_9,
                x_0 * x_35
                + x_0 * x_38
                + x_2 * x_36
                + x_20 * (x_0 * x_40 - x_41 * x_5)
                + x_24 * (x_15 * x_42 + x_33 * (-x_0 * x_43 - x_44 * x_5))
                - x_28 * x_39,
                -x_10 * x_6
                + x_14 * (-x_10 * x_16 - x_46)
                + x_24 * (x_27 * x_52 + x_53 * x_7)
                + x_45
                - x_48 * x_50,
                x_20 * (-0.1674 * x_54 - 0.1674 * x_57)
                - 0.3143 * x_54
                + x_62 * x_63
                + x_7 * (-x_55 + x_56),
                x_24 * (x_53 - 0.1674 * x_65),
                x_20 * (-x_69 + 0.1674 * x_70) - x_24 * (x_66 + x_67),
                0,
            ],
            [
                -x_0 * x_3
                + 0.0118 * x_1
                + x_14 * (x_55 - x_56)
                + 0.0128 * x_17
                + x_20 * (-x_66 - x_67)
                + x_24 * (x_33 * (x_54 + x_57) + x_69)
                + 0.0128 * x_47
                - 0.3143 * x_59,
                -x_1 * x_35
                - x_1 * x_38
                - x_2 * x_45
                + x_20 * (-x_1 * x_40 + x_17 * x_41)
                + x_24 * (-x_12 * x_42 + x_33 * (x_1 * x_43 + x_17 * x_44))
                + x_28 * x_46,
                x_14 * (0.3143 * x_13 - x_39)
                + 0.0128 * x_18
                + x_24 * (x_22 * x_27 + x_7 * x_72)
                + x_36
                - x_50 * x_71,
                x_19 * x_7
                + x_20 * (0.1674 * x_29 - 0.1674 * x_73)
                + 0.3143 * x_29
                + x_63 * (-x_74 + x_9),
                x_24 * (-x_27 * x_31 + x_72),
                x_20 * (x_34 - 0.1674 * x_75) - x_24 * (x_21 + 0.1674 * x_74),
                0,
            ],
            [
                0,
                x_20 * (-x_4 * x_80 - x_79)
                + x_24 * (x_27 * x_77 + x_33 * (x_28 - x_37 * x_4))
                - x_3
                - x_4 * x_78
                - x_76
                + 0.0128 * x_77,
                x_24 * (x_27 * x_81 + x_7 * x_84)
                + x_49 * x_82
                + 0.0128 * x_81
                + 0.3143 * x_82,
                x_20 * (-x_4 * x_79 - x_80) - x_4 * x_76 + x_63 * x_86 - x_78,
                x_24 * (-x_27 * x_88 + x_84),
                x_20 * (x_27 * x_83 + x_33 * x_88) - x_24 * (x_40 - 0.1674 * x_85),
                0,
            ],
            [
                0,
                x_1,
                -x_58,
                x_48,
                x_62,
                x_32 * x_48 + x_65,
                x_20 * x_62 - x_24 * (-x_68 + x_70),
            ],
            [
                0,
                x_0,
                x_8,
                x_71,
                x_89,
                x_26 * x_90 + x_32 * x_71,
                x_20 * x_89 - x_24 * (x_32 * x_90 - x_75),
            ],
            [
                -1,
                0,
                -x_10,
                -x_83,
                x_86,
                -x_26 * x_91 - x_32 * x_83,
                x_20 * x_86 - x_24 * (x_26 * x_83 - x_32 * x_91),
            ],
        ]
    )
