"""Gravity term for Kinova Gen3 robot

Functions
---------
gravity(joint_position)

"""

import math
import numpy as np


def gravity(joint_position):
    """The gravity term of the Kinova Gen3 robot

    Arguments
    ---------
    joint_position (array_like): The joint angles of the robot [rad]

    Returns
    -------
    ndarray: The gravity term of the robot

    """

    x_0 = math.cos(joint_position[2])
    x_1 = math.sin(joint_position[1])
    x_2 = x_0 * x_1
    x_3 = math.cos(joint_position[1])
    x_4 = 0.0178304 * x_3
    x_5 = math.sin(joint_position[2])
    x_6 = x_1 * x_5
    x_7 = 1.1636 * x_3
    x_8 = math.sin(joint_position[3])
    x_9 = x_3 * x_8
    x_10 = 0.2084 * x_0
    x_11 = math.cos(joint_position[3])
    x_12 = x_1 * x_11
    x_13 = x_11 * x_3
    x_14 = x_2 * x_8
    x_15 = -x_13 + x_14
    x_16 = x_11 * x_2
    x_17 = 1.8e-5 * x_0
    x_18 = 0.075478 * x_0
    x_19 = 0.93 * x_6
    x_20 = 0.93 * x_15
    x_21 = -x_16 - x_9
    x_22 = 0.93 * x_21
    x_23 = 1.856 * x_21
    x_24 = math.cos(joint_position[4])
    x_25 = 0.1059 * x_9
    x_26 = math.sin(joint_position[4])
    x_27 = x_26 * x_5
    x_28 = x_0 * x_11
    x_29 = x_24 * x_28 - x_27
    x_30 = 0.1059 * x_1
    x_31 = x_24 * x_5
    x_32 = x_1 * x_31
    x_33 = x_21 * x_26
    x_34 = x_32 - x_33
    x_35 = 1.178 * x_34
    x_36 = x_25 * x_26
    x_37 = x_26 * x_28
    x_38 = -x_31 - x_37
    x_39 = x_1 * x_27
    x_40 = x_21 * x_24
    x_41 = x_39 + x_40
    x_42 = 1.178 * x_41
    x_43 = 0.063883 * x_1
    x_44 = 0.678 * x_34
    x_45 = x_26 * x_9
    x_46 = 0.678 * x_41
    x_47 = 1.0e-6 * x_45
    x_48 = 0.009432 * x_24
    x_49 = 0.678 * x_15
    x_50 = x_31 + x_37
    x_51 = math.sin(joint_position[5])
    x_52 = x_15 * x_51
    x_53 = math.cos(joint_position[5])
    x_54 = x_41 * x_53
    x_55 = x_52 + x_54
    x_56 = 0.5 * x_55
    x_57 = x_11 * x_51
    x_58 = x_53 * x_8
    x_59 = x_24 * x_58
    x_60 = x_3 * (x_57 + x_59)
    x_61 = x_51 * x_8
    x_62 = x_11 * x_53
    x_63 = x_24 * x_62 - x_61
    x_64 = x_0 * x_63 - x_27 * x_53
    x_65 = -x_32 + x_33
    x_66 = 0.5 * x_65
    x_67 = x_1 * x_50
    x_68 = x_1 * x_64
    x_69 = x_15 * x_53
    x_70 = x_41 * x_51
    x_71 = x_69 - x_70
    x_72 = 0.678 * x_71
    x_73 = x_24 * x_61
    x_74 = x_62 - x_73
    x_75 = x_3 * x_74
    x_76 = -x_24 * x_57 - x_58
    x_77 = x_0 * x_76 + x_27 * x_51
    x_78 = x_1 * x_77
    x_79 = 0.678 * x_55
    x_80 = 0.678 * x_65
    x_81 = math.cos(joint_position[6])
    x_82 = x_57 * x_81
    x_83 = math.sin(joint_position[6])
    x_84 = x_26 * x_83
    x_85 = x_24 * x_81
    x_86 = x_53 * x_85 - x_84
    x_87 = x_8 * x_86
    x_88 = x_82 + x_87
    x_89 = x_24 * x_83
    x_90 = x_26 * x_81
    x_91 = x_53 * x_90
    x_92 = x_89 + x_91
    x_93 = x_11 * x_86 - x_61 * x_81
    x_94 = x_0 * x_93 - x_5 * x_92
    x_95 = x_65 * x_81
    x_96 = x_55 * x_83
    x_97 = -x_95 - x_96
    x_98 = 0.5 * x_97
    x_99 = 0.011402 * x_3
    x_100 = x_57 * x_83
    x_101 = -x_53 * x_89 - x_90
    x_102 = x_101 * x_8
    x_103 = x_3 * (-x_100 + x_102)
    x_104 = 0.011402 * x_1
    x_105 = x_53 * x_84
    x_106 = -x_105 + x_85
    x_107 = x_101 * x_11 + x_61 * x_83
    x_108 = x_1 * (x_0 * x_107 - x_106 * x_5)
    x_109 = 0.5 * x_71
    x_110 = x_65 * x_83
    x_111 = x_55 * x_81
    x_112 = -x_110 + x_111
    x_113 = 0.5 * x_112
    x_114 = x_5**2
    x_115 = 0.7233535312 * x_1
    x_116 = x_5 * x_8
    x_117 = x_11 * x_5
    x_118 = 0.1059 * x_0
    x_119 = 0.1059 * x_11
    x_120 = x_118 * x_24 - x_119 * x_27
    x_121 = x_118 * x_26
    x_122 = 0.009432 * x_26
    x_123 = 0.009432 * x_11
    x_124 = 1.0e-6 * x_24
    x_125 = 1.0e-6 * x_11
    x_126 = x_0 * x_124 - x_125 * x_27
    x_127 = 0.063883 * x_0
    x_128 = x_11 * x_27
    x_129 = x_5 * x_63
    x_130 = x_26 * x_51
    x_131 = 1.0e-6 * x_130
    x_132 = x_26 * x_53
    x_133 = 0.045483 * x_132
    x_134 = x_5 * x_76
    x_135 = 0.00965 * x_132
    x_136 = 0.045483 * x_24
    x_137 = 0.00965 * x_130
    x_138 = x_0 * x_92
    x_139 = x_0 * x_106
    x_140 = 0.011402 * x_5
    x_141 = x_107 * x_5
    x_142 = 0.000281 * x_130
    x_143 = 0.011402 * x_130
    x_144 = x_26 * x_8
    x_145 = 1.0e-6 * x_144
    x_146 = 0.063883 * x_8
    x_147 = 0.05295 * x_55
    x_148 = 0.05295 * x_65
    x_149 = 0.000281 * x_53
    x_150 = 0.011402 * x_53
    x_151 = 0.029798 * x_51

    return np.array(
        [
            [
                -0.5861744 * x_0 * x_1**2 * x_5
                - x_109
                * (0.000281 * x_103 - x_104 * x_94 + 0.000281 * x_108 - x_88 * x_99)
                - x_113
                * (-0.029798 * x_103 + x_104 * x_77 - 0.029798 * x_108 + x_74 * x_99)
                - 1.856 * x_15 * (0.0064 * x_16 + 0.0064 * x_9)
                + x_19
                * (-x_1 * x_17 * x_8 - x_12 * x_18 + 1.8e-5 * x_13 - 0.075478 * x_9)
                + x_2 * x_4
                + 2.786 * x_2 * (-0.0064 * x_3 + 0.2104 * x_6)
                + 1.1636 * x_2 * (0.006641 * x_3 + 0.117892 * x_6)
                - x_20 * (0.015006 * x_16 - 1.8e-5 * x_6 + 0.015006 * x_9)
                - x_22 * (-0.015006 * x_13 + 0.015006 * x_14 + 0.075478 * x_6)
                - x_23 * (-0.0064 * x_13 + 0.0064 * x_14 + 0.2084 * x_6)
                - x_35 * (x_24 * x_25 + x_29 * x_30)
                - x_42 * (-x_30 * x_38 + x_36)
                - x_44
                * (1.0e-6 * x_13 - 1.0e-6 * x_14 + 0.063883 * x_24 * x_9 + x_29 * x_43)
                - x_46
                * (0.009432 * x_13 - 0.009432 * x_14 - x_38 * x_43 + 0.063883 * x_45)
                - x_49
                * (-0.009432 * x_1 * x_29 - 1.0e-6 * x_1 * x_38 + x_47 - x_48 * x_9)
                - x_56 * (x_30 * x_50 + x_36)
                - 1.1636 * x_6 * (0.117892 * x_2 - 4.4e-5 * x_3)
                + 1.856 * x_6 * (-x_10 * x_12 - 0.2084 * x_9)
                - x_66 * (-x_30 * x_64 - 0.1059 * x_60)
                + x_7 * (-0.006641 * x_2 - 4.4e-5 * x_6)
                - x_72 * (x_47 + 0.00965 * x_60 + 1.0e-6 * x_67 + 0.00965 * x_68)
                - x_79
                * (0.045483 * x_45 + 0.045483 * x_67 - 0.00965 * x_75 - 0.00965 * x_78)
                - x_80
                * (-0.045483 * x_60 - 0.045483 * x_68 - 1.0e-6 * x_75 - 1.0e-6 * x_78)
                - x_98
                * (
                    0.029798 * x_1 * x_94
                    + 0.029798 * x_3 * x_88
                    - 0.000281 * x_75
                    - 0.000281 * x_78
                )
            ],
            [
                x_0**2 * x_115
                + 0.946867128 * x_1
                - x_109
                * (
                    0.011402 * x_138
                    - 0.000281 * x_139
                    + x_140 * x_93
                    - 0.000281 * x_141
                )
                - x_113
                * (x_0 * x_143 + 0.029798 * x_139 - x_140 * x_76 + 0.029798 * x_141)
                + x_114 * x_115
                + 0.3867904 * x_114 * x_12
                + 0.0118784 * x_117 * x_15
                - x_120 * x_42
                - x_120 * x_56
                + x_19 * (1.8e-5 * x_116 + 0.075478 * x_117)
                - x_20 * (-0.015006 * x_117 - x_17)
                - x_22 * (-0.015006 * x_116 + x_18)
                - x_23 * (x_10 - 0.0064 * x_116)
                - 5.11984e-5 * x_3
                - x_35 * (-x_119 * x_31 - x_121)
                - x_4 * x_5
                - x_44 * (-0.063883 * x_11 * x_31 + 1.0e-6 * x_116 - x_127 * x_26)
                - x_46 * (0.009432 * x_116 + x_127 * x_24 - 0.063883 * x_128)
                - x_49 * (x_0 * x_122 + x_123 * x_31 + x_126)
                - x_66 * (x_121 * x_53 + 0.1059 * x_129)
                + x_7 * (-4.4e-5 * x_0 + 0.006641 * x_5)
                - x_72 * (-x_0 * x_135 + x_126 - 0.00965 * x_129)
                - x_79
                * (x_0 * x_136 - x_0 * x_137 - 0.045483 * x_128 + 0.00965 * x_134)
                - x_80
                * (-x_0 * x_131 + x_0 * x_133 + 0.045483 * x_129 + 1.0e-6 * x_134)
                - x_98
                * (
                    -x_0 * x_142
                    + 0.000281 * x_134
                    - 0.029798 * x_138
                    - 0.029798 * x_5 * x_93
                )
            ],
            [
                -x_109
                * (
                    -0.000281 * x_100
                    + 0.000281 * x_102
                    - 0.011402 * x_82
                    - 0.011402 * x_87
                )
                + 0.02583398 * x_11 * x_21
                - x_113
                * (
                    0.029798 * x_100
                    - 0.029798 * x_102
                    + 0.011402 * x_62
                    - 0.011402 * x_73
                )
                - x_144 * x_147
                - 0.1247502 * x_144 * x_41
                - 0.02583398 * x_15 * x_8
                + x_19 * (1.8e-5 * x_11 - 0.075478 * x_8)
                - 0.0101029324 * x_2
                - 0.1247502 * x_24 * x_34 * x_8
                - x_44 * (x_125 + x_146 * x_24)
                - x_46 * (x_123 + x_146 * x_26)
                - x_49 * (x_145 - x_48 * x_8)
                - 0.3867904 * x_6 * x_8
                + 5.11984e-5 * x_6
                - x_66 * (-0.1059 * x_57 - 0.1059 * x_59)
                - x_72 * (x_145 + 0.00965 * x_57 + 0.00965 * x_59)
                - x_79 * (0.045483 * x_144 - 0.00965 * x_62 + 0.00965 * x_73)
                - x_80 * (x_124 * x_61 - x_136 * x_58 - 0.045483 * x_57 - 1.0e-6 * x_62)
                - x_98
                * (
                    -0.000281 * x_62
                    + 0.000281 * x_73
                    + 0.029798 * x_82
                    + 0.029798 * x_87
                )
            ],
            [
                -x_109
                * (x_149 * x_84 + x_150 * x_90 - 0.000281 * x_85 + 0.011402 * x_89)
                - x_113 * (-0.029798 * x_105 + x_143 + 0.029798 * x_85)
                - 1.674e-5 * x_13
                - x_132 * x_148
                + 1.674e-5 * x_14
                - x_147 * x_24
                + 0.45698494 * x_16
                - 0.168062874 * x_24 * x_41
                + 0.168062874 * x_26 * x_34
                - x_49 * (x_122 + x_124)
                - x_72 * (x_124 - x_135)
                - x_79 * (x_136 - x_137)
                - x_80 * (-x_131 + x_133)
                + 0.45698494 * x_9
                - x_98 * (-x_142 - 0.029798 * x_89 - 0.029798 * x_91)
            ],
            [
                -x_109 * (-0.011402 * x_51 * x_81 - 0.000281 * x_51 * x_83)
                - x_113 * (x_150 + x_151 * x_83)
                + x_148 * x_51
                - 6.78e-7 * x_32
                + 6.78e-7 * x_33
                - 0.006394896 * x_39
                - 0.006394896 * x_40
                - 0.0065427 * x_51 * x_71
                + 0.0065427 * x_53 * x_55
                - x_80 * (-0.045483 * x_51 - 1.0e-6 * x_53)
                - x_98 * (-x_149 + x_151 * x_81)
            ],
            [
                -x_109 * (-0.000281 * x_81 + 0.011402 * x_83)
                - 0.014899 * x_112 * x_81
                - 0.083787474 * x_52
                - 0.083787474 * x_54
                - 6.78e-7 * x_69
                + 6.78e-7 * x_70
                + 0.014899 * x_83 * x_97
            ],
            [0.005701 * x_110 - 0.005701 * x_111 - 0.0001405 * x_95 - 0.0001405 * x_96],
        ]
    )
