# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['rsm', 'rsm.scripts']

package_data = \
{'': ['*'], 'rsm': ['static/*']}

install_requires = \
['fs>=2.4.16,<3.0.0',
 'icecream>=2.1.3,<3.0.0',
 'livereload>=2.6.3,<3.0.0',
 'tree-sitter>=0.20.1,<0.21.0']

entry_points = \
{'console_scripts': ['rsm-lint = rsm.scripts.lint:main',
                     'rsm-make = rsm.scripts.make:main',
                     'rsm-render = rsm.scripts.render:main']}

setup_kwargs = {
    'name': 'rsm-markup',
    'version': '0.1.0',
    'description': 'ReStructured Manuscript (RSM) markup language',
    'long_description': '# RSM: (R)e-(S)tructured (M)anuscripts\n\nRSM is a suite of tools that aims to change the format of scientific publications using\nmodern web technology. Currently, most scientific publications are made with LaTeX and\npublished in PDF format. While the capabilities of LaTeX and related software are\nundeniable, there are many pitfalls. RSM aims to cover this gap.\n\n\n## What\'s wrong with LaTeX + PDF?\n\nThere\'s nothing inherently wrong with writing scientific manuscripts in LaTeX and\npublishing them in PDF format.  However, the LaTeX ecosystem was designed at a time\nwhere the main medium of scientific publication was physically printed books and\nmagazines.  Today, this is far from the truth as more and more scientists read papers\nonline.  The PDF format and many of LaTeX\'s features are designed to output documents\nthat will be physically printed, and this is not necessarily the best option when\nreading a digital document.  These are some of the problems that arise when reading PDFs\non a digital device:\n\n1. A PDF file has a fixed geometry (page size, margins, etc), while digital devices\n   (laptops, tablets, mobile phones) have a variety of screen sizes and shapes.  The\n   same PDF file may be read easily in, for example, a laptop screen, but not in a\n   tablet or mobile screen.\n\n2. A PDF file has a fixed layout (the relative positions of text, headers, figures,\n   tables, etc).  In contrast, in the last decade, digital documents and especially web\n   pages are moving toward being *responsive*, that is, their layout adapts to the\n   features of the devices they are being read on.\n\n3. A PDF file has a fixed typography (font family, weight, size, color, etc).  For\n   accessibility reasons, a reader may prefer different typographic choices.  For\n   example, some font families are designed to be read more easily by people with\n   dyslexia, while high-contrast color schemes are preferred by people with certain\n   sight conditions.  PDF files cannot adapt to the preferences of the user without\n   using external tools.\n\n4. While there are ways to configure LaTeX to output files in a format different than\n   PDF (e.g. EPS, DVI), most of the above critiques still hold true.\n   \n5. While there are ways to transform the output of LaTeX to a web-ready format\n   (i.e. HTML), this is always an extra step that must be done outside of the LaTeX\n   ecosystem.  As a result, not all of the LaTeX features translate transparently to the\n   final output and some post-processing is sometimes necessary.\n\n\n## What RSM does differently\n\nOne of the main aims of the RSM suite is to provide scientists with tools to author\nscientific manuscripts in a format that is web-ready in a transparent, native way that\nis both easy to use and easy to learn.  In particular, RSM is a suite of tools that\nallow the user to write a plain text file (in a special `.rsm` format) and convert the\nfile into a web page (i.e. a set of .html, .css, and .js files).  These files can then\nbe opened natively by any web browser on any device.  In the rest of this README, and in\nthe documentation, the files output by RSM are referred to as *the document*, or *the\noutput document*.\n\n\n## Features\n\nRSM\'s output document has the following features:\n\n1. Responsive: its geometry and layout adapt to the device it is being read on.\n\n2. Accessible: the user is free to change the geometry, layout, typography and other\n   settings of a RSM document.\n\n3. Separation of concerns: internally, the structure and content of an RSM document are\n   separate from the style and look-and-feel.  The former are stored in HTML format,\n   while the latter are treated with CSS and Javascript.\n\n4. Interactive: RSM documents support context-relevant tooltips, embedded video or\n   animations, enhanced document navigation, smart search, content folding, smart\n   context menus, and many other opportunities for interaction.\n\n5. Extensible: potential to extend using the entire ecosystem of modern web technologies\n\n\n## Components\n\nThe RSM framework is comprised of several components, each of which can be used in\nisolation, though using them in unison yields best results.\n\n1. **The RSM file format, `.rsm`** is a format that allows writers to produce technical\n   documents that get rendered directly into web-ready formats. RSM is a plain text\n   format so you can edit a .`rsm` file with your favorite text editor. Fundamentally,\n   the `.rsm` file format is essentially an extension of the `.rst` file format.\n\n1. **The RSM project** is simply a folder that contains a `.rsm` file and its `.html`\n   output.  When sharing your RSM document, you should always share *the entire* RSM\n   folder, not just one file.\n\n2. **rsm-edit, the RSM text editor,** is a text editor specifically designed to edit\n   `.rsm` files. Besides having basic text editing features, rsm-edit has features\n   specific to producing `.rsm` files.  *Currently work in progress.*\n\n3. **rsm-view, the RSM reader,** is a file viewer specifically designed to show `.rsm`\n   files. It is essentially a web browser, though it has some extra features.\n   *Currently work in progress.*\n\n4. **rsm-make, the RSM command line utility,** is for now the main way to execute all the\n   core functionality of the RSM framework.\n\n\n## Basic usage\n\nOne of the objectives of the RSM project is to make it possible to produce and share\ndocuments that can be viewed easily at any time anywhere, without restriction of device,\nsoftware, software versions, operating system, internet connection, etc. Therefore, the\nonly required component is a `.rsm` file. An basic `.rsm` file can be produced with any\ntext editor, and it can be viewed on any modern web browser, even without internet\nconnection.\n\n\n## Advanced usage\n\nAdditionally to the basic features, the RSM project also provides advanced features that\ndo require the adoption of some of the other components. For example, writers using the\n`.rsm` format may find it useul to use rsm-edit. Accordingly, some of the features of\nrsm-edit can only be fully enjoyed by readers via rsm-view.\n\nAdopting the rsm-edit and rsm-view is not necessarily the most accessible\nthing. However, the project is currently in proof-of-concept stage. If it proves to be a\nuseful tool and the community starts adopting it, then care will be placed to guarantee\nthat adopting the rsm-view and rsm-edit tools is as easy and accessible as\npossible. Specifically, there should be cloud versions of both tools where all that\'s\nnecessary is an internet connection.\n\n\n## Examples\n\nThe following is a short `.rsm` file:\n\n```rst\n.. default-role:: math\n\n\n##########################\nThis is the document title\n##########################\n\nThis is some content, with inline math like `G` or `2m\\times2m` matrix,\nand display-style equations\n\n.. math::\n   :label: eqn-nbm\n\n   B_{k \\to l,i \\to j} := \\delta_{jk}\\left(1-\\delta_{il}\\right).\n\n\n.. _sec-zero-one:\n\n******************************\nThis is a section title\n******************************\n\nThis is the section\'s content.\n\n.. _sec-trees:\n\nSub-section title\n=================\n\nThis is the sub-section content\n\n\n```\n\n\n## Getting started\n\nCurrently, the easiest way of using RSM is as follows:\n\n1. Create a new folder in your file system. For this example, we will use\n   `project/`. This folder contains all files pertaining to your manuscript, both the\n   `.rsm` source files and the `.html` output files.\n\n2. Create a new text file in your project folder, for example\n   `project/manuscript.rsm`. This file contains your source code. It is the equivalent\n   of the `.tex` files if you are using LaTeX.\n\n3. Write some RSM in your `project/manuscript.rsm` file using your favorite text\n   editor. Save your changes.\n\n4. Run the `rsm-make` command line utility from your project folder: \n   ```bash\n   ~$ cd project/ \n   project/$ rsm-make manuscript.rsm\n   Building RSM...\n   Done.\n   project/$\n   ```\n   \n   This will create, among other things, a new file `project/index.html`. This is the\n   equivalent of the PDF file if you are using LaTeX.\n\n5. To see your rendered manuscript, simply open the `project/index.html` file with any\n   web browser. For example, in Firefox, you can click on the File menu, click Open, and\n   navigate to your file.\n\n\n\n<!-- ## Design philosophy -->\n\n<!-- The RSM project follows a set of principles. Features are designed with these principles -->\n<!-- in mind. If you think a feature could be improved, or a new feature could be -->\n<!-- implemented, following these principles, please get in touch. -->\n\n<!-- 1. RSM documents should be easily readable in any device, regardless of screen size, -->\n<!--    operating system, or internet connection. -->\n\n<!-- 2. RSM documents should ship with the source code that generated them. -->\n\n<!-- 3. WHAT ELSE? -->\n\n\n\n<!-- ## Under the hood -->\n\n<!-- + .rst extensions implemented in sphinx -->\n<!-- + WHAT ELSE? -->\n\n<!-- -> Only show what the writer intended to show, unlews the writer asks for more via -->\n<!-- "details on demand" interactions. For example don\'t show menus, buttons, other things -->\n<!-- unless the reader is hovering or selecting somehow -->\n\n\n## Related projects\n\nThis is a list of other projects or ideas that have inspired RSM or are somehow related.\n\n+ https://lamport.azurewebsites.net/pubs/proof.pdf\n+ https://github.com/Mathpix/mathpix-markdown-it\n+ distill.pub\n\n\n\n\n<!-- # -- Remember ----------------------------------------------------------- -->\n\n<!-- # the doctree is the model, the html/css is the view -->\n<!-- # as much as possible, only use margin-bottom -->\n<!-- # Use margins when pushing blocks away from each other -->\n<!-- # Use padding when pushing things into their own block -->\n<!-- # only use JS for complex selectors and adding/removing classes -->\n<!-- # anything more complicated goes to rsm-read (exception tooltips/tree) -->\n\n\n<!-- Only show what the writer intended to show, unlews the writer asks for more via "details -->\n<!-- on demand" interactions. For example don\'t show menus, buttons, other things unless the -->\n<!-- reader is hovering or selecting somehow -->\n\n<!-- + mathematical writing should be accessible, as opposed to obfuscated by notation, -->\n<!--   convention, or implicit assumption -->\n<!-- + the core will NOT be extended for aesthetic purposes. All aesthetics will be handled -->\n<!--   via CSS. We want to avoid a situation like LaTeX where migrating from one journal -->\n<!--   template to another is a PITA -->\n<!-- + learn Lean, but remember RSM is about publishing, writing, and reading, not about -->\n<!--   proof checking/assisting -->\n<!-- + Lean is about checking correctness, RSM is about making a proof easy to read for a human -->\n<!-- + Lean is about writing/checking math, RSM is about publishing/sharing math -->\n<!-- + the proof markup language (PMUL) should be writeable by hand, if at all possible -->\n<!-- + quote Mason Porter: \'a proof should _always_ have accompanying prose\' -->\n<!-- + quote Lamport: \'get to a level where every step is obviously true, and then go one -->\n<!--   level further\' -->\n<!-- + write a short paper for a math education or math software meeting -->\n<!-- + the document should only show what the writer intended, all other bells and whistles -->\n<!--   should only happen "on demand", when the reader requests them -->\n<!-- + the core extensions should take care of the model, the theme should take care of the -->\n<!--   view. In particular, all css and js belongs to the theme -->\n<!-- + the UI should be seamless and out of your way. The user should be able to hide -->\n<!--   navigations/menus/buttons and maximize screen real state to show CONTENT. -->\n<!-- + from Conor: how to date/timestamp versions of a web-paper? -->\n',
    'author': 'leotrs',
    'author_email': 'leo@leotrs.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
