"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Match = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Partial and special matching during assertions.
 */
class Match {
    /**
     * Matches the specified pattern with the array found in the same relative path of the target.
     * The set of elements (or matchers) must be in the same order as would be found.
     * @param pattern the pattern to match
     */
    static arrayWith(pattern) {
        return { $ArrayWith: pattern };
    }
    /**
     * Matches the specified pattern to an object found in the same relative path of the target.
     * The keys and their values (or matchers) must be present in the target but the target can be a superset.
     * @param pattern the pattern to match
     */
    static objectLike(pattern) {
        return { $ObjectLike: pattern };
    }
    /**
     * Matches targets according to a regular expression
     */
    static stringLikeRegexp(pattern) {
        return { $StringLike: pattern };
    }
    /**
     * Matches any string-encoded JSON and applies the specified pattern after parsing it.
     * @param pattern the pattern to match after parsing the encoded JSON.
     */
    static serializedJson(pattern) {
        return { $SerializedJson: pattern };
    }
}
exports.Match = Match;
_a = JSII_RTTI_SYMBOL_1;
Match[_a] = { fqn: "@aws-cdk/integ-tests-alpha.Match", version: "2.57.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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