import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::ResilienceHub::App`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html
 */
export interface CfnAppProps {
    /**
     * `AWS::ResilienceHub::App.AppTemplateBody`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-apptemplatebody
     */
    readonly appTemplateBody: string;
    /**
     * `AWS::ResilienceHub::App.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-name
     */
    readonly name: string;
    /**
     * `AWS::ResilienceHub::App.ResourceMappings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-resourcemappings
     */
    readonly resourceMappings: Array<CfnApp.ResourceMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ResilienceHub::App.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-description
     */
    readonly description?: string;
    /**
     * `AWS::ResilienceHub::App.ResiliencyPolicyArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-resiliencypolicyarn
     */
    readonly resiliencyPolicyArn?: string;
    /**
     * `AWS::ResilienceHub::App.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::ResilienceHub::App`.
 *
 * @external
 * @cloudformationResource AWS::ResilienceHub::App
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html
 */
export declare class CfnApp extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ResilienceHub::App";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApp;
    /**
     * @external
     * @cloudformationAttribute AppArn
     */
    readonly attrAppArn: string;
    /**
     * `AWS::ResilienceHub::App.AppTemplateBody`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-apptemplatebody
     */
    appTemplateBody: string;
    /**
     * `AWS::ResilienceHub::App.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-name
     */
    name: string;
    /**
     * `AWS::ResilienceHub::App.ResourceMappings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-resourcemappings
     */
    resourceMappings: Array<CfnApp.ResourceMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ResilienceHub::App.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-description
     */
    description: string | undefined;
    /**
     * `AWS::ResilienceHub::App.ResiliencyPolicyArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-resiliencypolicyarn
     */
    resiliencyPolicyArn: string | undefined;
    /**
     * `AWS::ResilienceHub::App.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ResilienceHub::App`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAppProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ResilienceHub::App`.
 *
 * @external
 * @cloudformationResource AWS::ResilienceHub::App
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html
 */
export declare namespace CfnApp {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-physicalresourceid.html
     */
    interface PhysicalResourceIdProperty {
        /**
         * `CfnApp.PhysicalResourceIdProperty.AwsAccountId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-physicalresourceid.html#cfn-resiliencehub-app-physicalresourceid-awsaccountid
         */
        readonly awsAccountId?: string;
        /**
         * `CfnApp.PhysicalResourceIdProperty.AwsRegion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-physicalresourceid.html#cfn-resiliencehub-app-physicalresourceid-awsregion
         */
        readonly awsRegion?: string;
        /**
         * `CfnApp.PhysicalResourceIdProperty.Identifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-physicalresourceid.html#cfn-resiliencehub-app-physicalresourceid-identifier
         */
        readonly identifier: string;
        /**
         * `CfnApp.PhysicalResourceIdProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-physicalresourceid.html#cfn-resiliencehub-app-physicalresourceid-type
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::ResilienceHub::App`.
 *
 * @external
 * @cloudformationResource AWS::ResilienceHub::App
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html
 */
export declare namespace CfnApp {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html
     */
    interface ResourceMappingProperty {
        /**
         * `CfnApp.ResourceMappingProperty.LogicalStackName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html#cfn-resiliencehub-app-resourcemapping-logicalstackname
         */
        readonly logicalStackName?: string;
        /**
         * `CfnApp.ResourceMappingProperty.MappingType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html#cfn-resiliencehub-app-resourcemapping-mappingtype
         */
        readonly mappingType: string;
        /**
         * `CfnApp.ResourceMappingProperty.PhysicalResourceId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html#cfn-resiliencehub-app-resourcemapping-physicalresourceid
         */
        readonly physicalResourceId: CfnApp.PhysicalResourceIdProperty | cdk.IResolvable;
        /**
         * `CfnApp.ResourceMappingProperty.ResourceName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html#cfn-resiliencehub-app-resourcemapping-resourcename
         */
        readonly resourceName?: string;
    }
}
/**
 * Properties for defining a `AWS::ResilienceHub::ResiliencyPolicy`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html
 */
export interface CfnResiliencyPolicyProps {
    /**
     * `AWS::ResilienceHub::ResiliencyPolicy.Policy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-policy
     */
    readonly policy: {
        [key: string]: (CfnResiliencyPolicy.FailurePolicyProperty | cdk.IResolvable);
    } | cdk.IResolvable;
    /**
     * `AWS::ResilienceHub::ResiliencyPolicy.PolicyName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-policyname
     */
    readonly policyName: string;
    /**
     * `AWS::ResilienceHub::ResiliencyPolicy.Tier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-tier
     */
    readonly tier: string;
    /**
     * `AWS::ResilienceHub::ResiliencyPolicy.DataLocationConstraint`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-datalocationconstraint
     */
    readonly dataLocationConstraint?: string;
    /**
     * `AWS::ResilienceHub::ResiliencyPolicy.PolicyDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-policydescription
     */
    readonly policyDescription?: string;
    /**
     * `AWS::ResilienceHub::ResiliencyPolicy.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::ResilienceHub::ResiliencyPolicy`.
 *
 * @external
 * @cloudformationResource AWS::ResilienceHub::ResiliencyPolicy
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html
 */
export declare class CfnResiliencyPolicy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ResilienceHub::ResiliencyPolicy";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnResiliencyPolicy;
    /**
     * @external
     * @cloudformationAttribute PolicyArn
     */
    readonly attrPolicyArn: string;
    /**
     * `AWS::ResilienceHub::ResiliencyPolicy.Policy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-policy
     */
    policy: {
        [key: string]: (CfnResiliencyPolicy.FailurePolicyProperty | cdk.IResolvable);
    } | cdk.IResolvable;
    /**
     * `AWS::ResilienceHub::ResiliencyPolicy.PolicyName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-policyname
     */
    policyName: string;
    /**
     * `AWS::ResilienceHub::ResiliencyPolicy.Tier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-tier
     */
    tier: string;
    /**
     * `AWS::ResilienceHub::ResiliencyPolicy.DataLocationConstraint`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-datalocationconstraint
     */
    dataLocationConstraint: string | undefined;
    /**
     * `AWS::ResilienceHub::ResiliencyPolicy.PolicyDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-policydescription
     */
    policyDescription: string | undefined;
    /**
     * `AWS::ResilienceHub::ResiliencyPolicy.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ResilienceHub::ResiliencyPolicy`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnResiliencyPolicyProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ResilienceHub::ResiliencyPolicy`.
 *
 * @external
 * @cloudformationResource AWS::ResilienceHub::ResiliencyPolicy
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html
 */
export declare namespace CfnResiliencyPolicy {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-resiliencypolicy-failurepolicy.html
     */
    interface FailurePolicyProperty {
        /**
         * `CfnResiliencyPolicy.FailurePolicyProperty.RpoInSecs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-resiliencypolicy-failurepolicy.html#cfn-resiliencehub-resiliencypolicy-failurepolicy-rpoinsecs
         */
        readonly rpoInSecs: number;
        /**
         * `CfnResiliencyPolicy.FailurePolicyProperty.RtoInSecs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-resiliencypolicy-failurepolicy.html#cfn-resiliencehub-resiliencypolicy-failurepolicy-rtoinsecs
         */
        readonly rtoInSecs: number;
    }
}
