/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.executor.util;

import com.alibaba.alink.common.VectorTypes;
import com.alibaba.alink.common.utils.Types;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.types.Row;

public class FlinkTypeUtil {
    public static TypeInformation<?> makeTypeInfo(String typeString) {
        switch (typeString.toUpperCase()) {
            case "VOID": {
                return Types.VOID;
            }
            case "BOOL": 
            case "BOOLEAN": {
                return Types.BOOLEAN;
            }
            case "BYTE": 
            case "TINYINT": {
                return Types.BYTE;
            }
            case "SHORT": 
            case "SMALLINT": {
                return Types.SHORT;
            }
            case "INT": 
            case "INTEGER": {
                return Types.INT;
            }
            case "LONG": 
            case "BIGINT": {
                return Types.LONG;
            }
            case "FLOAT": {
                return Types.FLOAT;
            }
            case "DOUBLE": {
                return Types.DOUBLE;
            }
            case "STRING": 
            case "VARCHAR": {
                return Types.STRING;
            }
            case "CHAR": 
            case "CHARACTER": {
                return Types.CHAR;
            }
            case "DECIMAL": 
            case "BIG_DEC": 
            case "BIGDECIMAL": {
                return Types.BIG_DEC;
            }
            case "BIG_INT": 
            case "BIGINTEGER": {
                return Types.BIG_INT;
            }
            case "DATE": {
                return Types.SQL_DATE;
            }
            case "TIME": {
                return Types.SQL_TIME;
            }
            case "DATETIME": 
            case "TIMESTAMP": {
                return Types.SQL_TIMESTAMP;
            }
        }
        TypeInformation vecType = VectorTypes.getTypeInformation((String)typeString);
        if (vecType != null) {
            return vecType;
        }
        throw new RuntimeException("Invalid Type: " + typeString);
    }

    public static TypeInformation<Row> makeRowTypes(String[] types) {
        TypeInformation[] t = new TypeInformation[types.length];
        for (int i = 0; i < types.length; ++i) {
            t[i] = FlinkTypeUtil.makeTypeInfo(types[i]);
        }
        return Types.getRowType(t);
    }

    public static Object castTo(Object x, TypeInformation t) {
        if (x == null) {
            return null;
        }
        if (t.equals(Types.BOOLEAN)) {
            if (x instanceof Boolean) {
                return x;
            }
            return Boolean.valueOf(x.toString());
        }
        if (t.equals(Types.BYTE)) {
            if (x instanceof Number) {
                return ((Number)x).byteValue();
            }
            return Byte.valueOf(x.toString());
        }
        if (t.equals(Types.SHORT)) {
            if (x instanceof Number) {
                return ((Number)x).shortValue();
            }
            return Short.valueOf(x.toString());
        }
        if (t.equals(Types.INT)) {
            if (x instanceof Number) {
                return ((Number)x).intValue();
            }
            return Integer.valueOf(x.toString());
        }
        if (t.equals(Types.LONG)) {
            if (x instanceof Number) {
                return ((Number)x).longValue();
            }
            return Long.valueOf(x.toString());
        }
        if (t.equals(Types.FLOAT)) {
            if (x instanceof Number) {
                return Float.valueOf(((Number)x).floatValue());
            }
            return Float.valueOf(x.toString());
        }
        if (t.equals(Types.DOUBLE)) {
            if (x instanceof Number) {
                return ((Number)x).doubleValue();
            }
            return Double.valueOf(x.toString());
        }
        if (t.equals(Types.BIG_INT)) {
            if (x instanceof BigInteger) {
                return x;
            }
            return new BigInteger(x.toString());
        }
        if (t.equals(Types.BIG_DEC)) {
            if (x instanceof BigDecimal) {
                return x;
            }
            return new BigDecimal(x.toString());
        }
        if (t.equals(Types.STRING)) {
            if (x instanceof String) {
                return x;
            }
            return x.toString();
        }
        if (t.equals(Types.SQL_DATE)) {
            if (x instanceof Number) {
                return new Date(((Number)x).longValue());
            }
            if (x instanceof Date) {
                return x;
            }
            return Date.valueOf(x.toString());
        }
        if (t.equals(Types.SQL_TIME)) {
            if (x instanceof Number) {
                return new Time(((Number)x).longValue());
            }
            if (x instanceof Time) {
                return x;
            }
            return Time.valueOf(x.toString());
        }
        if (t.equals(Types.SQL_TIMESTAMP)) {
            if (x instanceof Number) {
                return new Timestamp(((Number)x).longValue());
            }
            if (x instanceof Timestamp) {
                return x;
            }
            return Timestamp.valueOf(x.toString());
        }
        throw new RuntimeException("unsupported type: " + t.getClass().getName());
    }
}

