"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDeploymentConfig = void 0;
const utils_1 = require("../utils");
/**
 * A custom Deployment Configuration for a Lambda Deployment Group.
 *
 * Note: This class currently stands as namespaced container of the default configurations
 * until CloudFormation supports custom Lambda Deployment Configs. Until then it is closed
 * (private constructor) and does not extend {@link cdk.Construct}
 *
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
class LambdaDeploymentConfig {
    constructor() {
        // nothing to do until CFN supports custom lambda deployment configurations
    }
    /**
     * Import a custom Deployment Configuration for a Lambda Deployment Group defined outside the CDK.
     *
     * @param _scope the parent Construct for this new Construct
     * @param _id the logical ID of this new Construct
     * @param props the properties of the referenced custom Deployment Configuration
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     */
    static import(_scope, _id, props) {
        return deploymentConfig(props.deploymentConfigName);
    }
}
exports.LambdaDeploymentConfig = LambdaDeploymentConfig;
LambdaDeploymentConfig.ALL_AT_ONCE = deploymentConfig('CodeDeployDefault.LambdaAllAtOnce');
LambdaDeploymentConfig.CANARY_10PERCENT_30MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent30Minutes');
LambdaDeploymentConfig.CANARY_10PERCENT_5MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent5Minutes');
LambdaDeploymentConfig.CANARY_10PERCENT_10MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent10Minutes');
LambdaDeploymentConfig.CANARY_10PERCENT_15MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent15Minutes');
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_10MINUTES = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery10Minutes');
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_1MINUTE = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery1Minute');
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_2MINUTES = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery2Minutes');
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_3MINUTES = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery3Minutes');
function deploymentConfig(name) {
    return {
        deploymentConfigName: name,
        deploymentConfigArn: utils_1.arnForDeploymentConfig(name),
    };
}
//# sourceMappingURL=data:application/json;base64,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