"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolResourceServer = exports.ResourceServerScope = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const cognito_generated_1 = require("./cognito.generated");
/**
 * A scope for ResourceServer.
 *
 * @stability stable
 */
class ResourceServerScope {
    /**
     * @stability stable
     */
    constructor(props) {
        this.scopeName = props.scopeName;
        this.scopeDescription = props.scopeDescription;
    }
}
exports.ResourceServerScope = ResourceServerScope;
_a = JSII_RTTI_SYMBOL_1;
ResourceServerScope[_a] = { fqn: "@aws-cdk/aws-cognito.ResourceServerScope", version: "1.130.0" };
/**
 * Defines a User Pool OAuth2.0 Resource Server.
 *
 * @stability stable
 */
class UserPoolResourceServer extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _c;
        super(scope, id, {
            physicalName: props.identifier,
        });
        const resource = new cognito_generated_1.CfnUserPoolResourceServer(this, 'Resource', {
            identifier: this.physicalName,
            name: (_c = props.userPoolResourceServerName) !== null && _c !== void 0 ? _c : this.physicalName,
            scopes: props.scopes,
            userPoolId: props.userPool.userPoolId,
        });
        this.userPoolResourceServerId = resource.ref;
    }
    /**
     * Import a user pool resource client given its id.
     *
     * @stability stable
     */
    static fromUserPoolResourceServerId(scope, id, userPoolResourceServerId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.userPoolResourceServerId = userPoolResourceServerId;
            }
        }
        return new Import(scope, id);
    }
}
exports.UserPoolResourceServer = UserPoolResourceServer;
_b = JSII_RTTI_SYMBOL_1;
UserPoolResourceServer[_b] = { fqn: "@aws-cdk/aws-cognito.UserPoolResourceServer", version: "1.130.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXNlci1wb29sLXJlc291cmNlLXNlcnZlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInVzZXItcG9vbC1yZXNvdXJjZS1zZXJ2ZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSx3Q0FBb0Q7QUFFcEQsMkRBQWdFOzs7Ozs7QUFtQmhFLE1BQWEsbUJBQW1COzs7O0lBTzlCLFlBQVksS0FBK0I7UUFDekMsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO1FBQ2pDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUMsZ0JBQWdCLENBQUM7SUFDakQsQ0FBQzs7QUFWSCxrREFXQzs7Ozs7Ozs7QUFzQkQsTUFBYSxzQkFBdUIsU0FBUSxlQUFROzs7O0lBWWxELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBa0M7O1FBQzFFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsWUFBWSxFQUFFLEtBQUssQ0FBQyxVQUFVO1NBQy9CLENBQUMsQ0FBQztRQUVILE1BQU0sUUFBUSxHQUFHLElBQUksNkNBQXlCLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUMvRCxVQUFVLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDN0IsSUFBSSxRQUFFLEtBQUssQ0FBQywwQkFBMEIsbUNBQUksSUFBSSxDQUFDLFlBQVk7WUFDM0QsTUFBTSxFQUFFLEtBQUssQ0FBQyxNQUFNO1lBQ3BCLFVBQVUsRUFBRSxLQUFLLENBQUMsUUFBUSxDQUFDLFVBQVU7U0FDdEMsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLHdCQUF3QixHQUFHLFFBQVEsQ0FBQyxHQUFHLENBQUM7SUFDL0MsQ0FBQzs7Ozs7O0lBdkJNLE1BQU0sQ0FBQyw0QkFBNEIsQ0FBQyxLQUFnQixFQUFFLEVBQVUsRUFBRSx3QkFBZ0M7UUFDdkcsTUFBTSxNQUFPLFNBQVEsZUFBUTtZQUE3Qjs7Z0JBQ2tCLDZCQUF3QixHQUFHLHdCQUF3QixDQUFDO1lBQ3RFLENBQUM7U0FBQTtRQUVELE9BQU8sSUFBSSxNQUFNLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0lBQy9CLENBQUM7O0FBUkgsd0RBMEJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSVJlc291cmNlLCBSZXNvdXJjZSB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBDZm5Vc2VyUG9vbFJlc291cmNlU2VydmVyIH0gZnJvbSAnLi9jb2duaXRvLmdlbmVyYXRlZCc7XG5pbXBvcnQgeyBJVXNlclBvb2wgfSBmcm9tICcuL3VzZXItcG9vbCc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBJVXNlclBvb2xSZXNvdXJjZVNlcnZlciBleHRlbmRzIElSZXNvdXJjZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdXNlclBvb2xSZXNvdXJjZVNlcnZlcklkOiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFJlc291cmNlU2VydmVyU2NvcGVQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzY29wZU5hbWU6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc2NvcGVEZXNjcmlwdGlvbjogc3RyaW5nO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgUmVzb3VyY2VTZXJ2ZXJTY29wZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgc2NvcGVOYW1lOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBzY29wZURlc2NyaXB0aW9uOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3IocHJvcHM6IFJlc291cmNlU2VydmVyU2NvcGVQcm9wcykge1xuICAgIHRoaXMuc2NvcGVOYW1lID0gcHJvcHMuc2NvcGVOYW1lO1xuICAgIHRoaXMuc2NvcGVEZXNjcmlwdGlvbiA9IHByb3BzLnNjb3BlRGVzY3JpcHRpb247XG4gIH1cbn1cblxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBVc2VyUG9vbFJlc291cmNlU2VydmVyT3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBpZGVudGlmaWVyOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdXNlclBvb2xSZXNvdXJjZVNlcnZlck5hbWU/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzY29wZXM/OiBSZXNvdXJjZVNlcnZlclNjb3BlW107XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFVzZXJQb29sUmVzb3VyY2VTZXJ2ZXJQcm9wcyBleHRlbmRzIFVzZXJQb29sUmVzb3VyY2VTZXJ2ZXJPcHRpb25zIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdXNlclBvb2w6IElVc2VyUG9vbDtcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFVzZXJQb29sUmVzb3VyY2VTZXJ2ZXIgZXh0ZW5kcyBSZXNvdXJjZSBpbXBsZW1lbnRzIElVc2VyUG9vbFJlc291cmNlU2VydmVyIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgZnJvbVVzZXJQb29sUmVzb3VyY2VTZXJ2ZXJJZChzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCB1c2VyUG9vbFJlc291cmNlU2VydmVySWQ6IHN0cmluZyk6IElVc2VyUG9vbFJlc291cmNlU2VydmVyIHtcbiAgICBjbGFzcyBJbXBvcnQgZXh0ZW5kcyBSZXNvdXJjZSBpbXBsZW1lbnRzIElVc2VyUG9vbFJlc291cmNlU2VydmVyIHtcbiAgICAgIHB1YmxpYyByZWFkb25seSB1c2VyUG9vbFJlc291cmNlU2VydmVySWQgPSB1c2VyUG9vbFJlc291cmNlU2VydmVySWQ7XG4gICAgfVxuXG4gICAgcmV0dXJuIG5ldyBJbXBvcnQoc2NvcGUsIGlkKTtcbiAgfVxuXG4gIHB1YmxpYyByZWFkb25seSB1c2VyUG9vbFJlc291cmNlU2VydmVySWQ6IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogVXNlclBvb2xSZXNvdXJjZVNlcnZlclByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICBwaHlzaWNhbE5hbWU6IHByb3BzLmlkZW50aWZpZXIsXG4gICAgfSk7XG5cbiAgICBjb25zdCByZXNvdXJjZSA9IG5ldyBDZm5Vc2VyUG9vbFJlc291cmNlU2VydmVyKHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgIGlkZW50aWZpZXI6IHRoaXMucGh5c2ljYWxOYW1lLFxuICAgICAgbmFtZTogcHJvcHMudXNlclBvb2xSZXNvdXJjZVNlcnZlck5hbWUgPz8gdGhpcy5waHlzaWNhbE5hbWUsXG4gICAgICBzY29wZXM6IHByb3BzLnNjb3BlcyxcbiAgICAgIHVzZXJQb29sSWQ6IHByb3BzLnVzZXJQb29sLnVzZXJQb29sSWQsXG4gICAgfSk7XG5cbiAgICB0aGlzLnVzZXJQb29sUmVzb3VyY2VTZXJ2ZXJJZCA9IHJlc291cmNlLnJlZjtcbiAgfVxufVxuIl19