"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Plone = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const kplus = require("cdk8s-plus-24");
const constructs_1 = require("constructs");
const deployment_1 = require("./deployment");
const k8s_1 = require("./imports/k8s");
const service_1 = require("./service");
class Plone extends constructs_1.Construct {
    constructor(scope, id, options = {}) {
        super(scope, id);
        // ------------------------------------------------------------------------
        // Backend
        const backend = options.backend ?? {};
        const backendPort = 8080;
        const backendLabels = {
            'app.kubernetes.io/name': 'plone-backend',
            'app.kubernetes.io/component': 'backend',
            'app.kubernetes.io/version': options.version ?? 'undefined',
        };
        // Probing
        const backendLivenessProbe = {
            httpGet: {
                path: '/',
                port: k8s_1.IntOrString.fromNumber(backendPort),
            },
            initialDelaySeconds: 30,
            timeoutSeconds: 1,
            periodSeconds: 10,
            successThreshold: 1,
            failureThreshold: 3,
        };
        const backendReadinessProbe = {
            httpGet: {
                path: '/',
                port: k8s_1.IntOrString.fromNumber(backendPort),
            },
            initialDelaySeconds: 10,
            timeoutSeconds: 15,
            periodSeconds: 10,
            successThreshold: 1,
            failureThreshold: 3,
        };
        // Deployment
        const backendDeployment = new deployment_1.PloneDeployment(this, 'backend', {
            labels: backendLabels,
            image: {
                image: backend.image ?? 'plone/plone-backend:latest',
                imagePullSecrets: options.imagePullSecrets ?? [],
                imagePullPolicy: backend.imagePullPolicy ?? 'IfNotPresent',
            },
            replicas: backend.replicas,
            limitCpu: backend.limitCpu ?? 1,
            limitMemory: backend.limitMemory ?? '512Mi',
            pdb: {
                maxUnavailable: backend.maxUnavailable ?? undefined,
                minAvailable: backend.minAvailable ?? undefined,
            },
            port: backendPort,
            environment: backend.environment,
            livenessProbe: backendLivenessProbe,
            readinessProbe: backendReadinessProbe,
        });
        // Service
        const backendService = new service_1.PloneService(backendDeployment, 'service', {
            labels: {
                'app.kubernetes.io/name': 'plone-backend-service',
                'app.kubernetes.io/component': 'service',
            },
            targetPort: backendPort,
            selectorLabel: { app: cdk8s_1.Names.toLabelValue(backendDeployment) },
        });
        this.backendServiceName = backendService.name;
        // ------------------------------------------------------------------------
        // Frontend
        const frontend = options.frontend ?? {};
        const frontendPort = 3000;
        const frontendLabels = {
            'app.kubernetes.io/name': 'plone-frontend',
            'app.kubernetes.io/component': 'frontend',
            'app.kubernetes.io/version': options.version ?? 'undefined',
        };
        // Probing
        const frontendLivenessProbe = {
            httpGet: {
                path: '/',
                port: k8s_1.IntOrString.fromNumber(frontendPort),
            },
            initialDelaySeconds: 30,
            timeoutSeconds: 1,
            periodSeconds: 10,
            successThreshold: 1,
            failureThreshold: 3,
        };
        const frontendReadinessProbe = {
            httpGet: {
                path: '/',
                port: k8s_1.IntOrString.fromNumber(frontendPort),
            },
            initialDelaySeconds: 10,
            timeoutSeconds: 15,
            periodSeconds: 10,
            successThreshold: 1,
            failureThreshold: 3,
        };
        // Environment for RAZZLE
        var frontendEnvironment = frontend.environment ?? new kplus.Env([], {});
        if (frontendEnvironment.variables.RAZZLE_INTERNAL_API_PATH === undefined) {
            frontendEnvironment?.addVariable('RAZZLE_INTERNAL_API_PATH', kplus.EnvValue.fromValue(`http://${backendService.name}:80`));
        }
        // Deployment
        const frontendDeployment = new deployment_1.PloneDeployment(this, 'frontend', {
            labels: frontendLabels,
            image: {
                image: frontend.image ?? 'plone/plone-frontend:latest',
                imagePullSecrets: options.imagePullSecrets ?? [],
                imagePullPolicy: frontend.imagePullPolicy ?? 'IfNotPresent',
            },
            replicas: frontend.replicas,
            limitCpu: frontend.limitCpu ?? 1,
            limitMemory: frontend.limitMemory ?? '1Gi',
            pdb: {
                maxUnavailable: frontend.maxUnavailable ?? undefined,
                minAvailable: frontend.minAvailable ?? undefined,
            },
            port: frontendPort,
            environment: frontendEnvironment,
            livenessProbe: frontendLivenessProbe,
            readinessProbe: frontendReadinessProbe,
        });
        // Service
        const frontendService = new service_1.PloneService(frontendDeployment, 'service', {
            labels: {
                'app.kubernetes.io/name': 'plone-frontend-service',
                'app.kubernetes.io/component': 'service',
            },
            targetPort: frontendPort,
            selectorLabel: { app: cdk8s_1.Names.toLabelValue(frontendDeployment) },
        });
        this.frontendServiceName = frontendService.name;
    }
}
exports.Plone = Plone;
_a = JSII_RTTI_SYMBOL_1;
Plone[_a] = { fqn: "@bluedynamics/cdk8s-plone.Plone", version: "0.0.1" };
//# sourceMappingURL=data:application/json;base64,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