"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlonePDB = void 0;
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
class PlonePDB extends constructs_1.Construct {
    constructor(scope, id, selectorLabel, options) {
        super(scope, id);
        var spec = {};
        if (typeof options.maxUnavailable === 'number') {
            spec = {
                maxUnavailable: k8s.IntOrString.fromNumber(options.maxUnavailable),
            };
        }
        else if (typeof options.maxUnavailable === 'string') {
            spec = {
                maxUnavailable: k8s.IntOrString.fromString(options.maxUnavailable),
            };
        }
        if (typeof options.minAvailable === 'number') {
            spec = {
                ...spec,
                minAvailable: k8s.IntOrString.fromNumber(options.minAvailable),
            };
        }
        else if (typeof options.minAvailable === 'string') {
            spec = {
                ...spec,
                minAvailable: k8s.IntOrString.fromString(options.minAvailable),
            };
        }
        if (options.maxUnavailable === undefined && options.minAvailable === undefined) {
            spec = {
                minAvailable: k8s.IntOrString.fromNumber(1),
            };
        }
        spec = {
            ...spec,
            selector: { matchLabels: selectorLabel },
        };
        const pdb_labels = {
            ...options.labels ?? {},
            'app.kubernetes.io/part-of': 'plone',
            'app.kubernetes.io/managed-by': 'cdk8s-plone',
        };
        new k8s.KubePodDisruptionBudget(this, 'PDB', {
            metadata: {
                labels: pdb_labels,
            },
            spec: spec,
        });
    }
}
exports.PlonePDB = PlonePDB;
//# sourceMappingURL=data:application/json;base64,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