import * as kplus from 'cdk8s-plus-24';
import { Construct } from 'constructs';
import * as k8s from './imports/k8s';
import { PlonePDBOptions } from './pdb';
export interface PloneImageOptions {
    /**
     * Specify a custom image for Plone .
     * @default ""
     */
    readonly image?: string;
    /**
     * Specify Secret to pull image .
     * @default ""
     */
    readonly imagePullSecrets?: string[];
    /**
     * Specify Pull Policy .
     * @default ""
     */
    readonly imagePullPolicy?: string;
}
export interface PloneDeploymentOptions {
    /**
     * Specify a custom image for Plone .
     * @default "plone/plone-backend:latest"
     */
    readonly image?: PloneImageOptions;
    /**
     * Specify an environment for Plone .
     * @default - none
    */
    readonly environment?: kplus.Env;
    /**
   * Number of replicas.
   * @default 2
   */
    readonly replicas?: number;
    /**
   * CPU limit
   * @default 1
   */
    readonly limitCpu?: number;
    /**
   * memory limit
   * @default 1
   */
    readonly limitMemory?: string;
    /**
     * Port number.
     */
    readonly port: number;
    /**
     * Extra labels to associate with resources.
     * @default - none
     */
    readonly labels?: {
        [name: string]: string;
    };
    /**
     * Extra container spec to use for ploencontainer.
     * @default - []
     */
    readonly ploneContainer?: k8s.Container;
    /**
     * Sidecar container spec to associate with resources.
     * @default - []
     */
    readonly sidecars?: k8s.Container[];
    /**
     * Create a PodDisruptionBugdet for the deployment?
     * If given
     * @default - none
     */
    readonly pdb?: PlonePDBOptions;
    /**
     * Liveness Probe for the pod.
     * @default - generated
     */
    readonly livenessProbe?: k8s.Probe;
    /**
     * Readiness Probe for the pod.
     * @default - generated
     */
    readonly readinessProbe?: k8s.Probe;
}
export declare class PloneDeployment extends Construct {
    constructor(scope: Construct, id: string, options: PloneDeploymentOptions);
}
