"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFormationTemplate = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const s3_assets = require("aws-cdk-lib/aws-s3-assets");
const util_1 = require("./private/util");
/**
 * (experimental) Represents the Product Provisioning Artifact Template.
 *
 * @experimental
 */
class CloudFormationTemplate {
    /**
     * (experimental) Template from URL.
     *
     * @param url The url that points to the provisioning artifacts template.
     * @experimental
     */
    static fromUrl(url) {
        return new CloudFormationUrlTemplate(url);
    }
    /**
     * (experimental) Loads the provisioning artifacts template from a local disk path.
     *
     * @param path A file containing the provisioning artifacts.
     * @experimental
     */
    static fromAsset(path, options) {
        return new CloudFormationAssetTemplate(path, options);
    }
    /**
     * (experimental) Creates a product with the resources defined in the given product stack.
     *
     * @experimental
     */
    static fromProductStack(productStack) {
        jsiiDeprecationWarnings._aws_cdk_aws_servicecatalog_alpha_ProductStack(productStack);
        return new CloudFormationProductStackTemplate(productStack);
    }
}
exports.CloudFormationTemplate = CloudFormationTemplate;
_a = JSII_RTTI_SYMBOL_1;
CloudFormationTemplate[_a] = { fqn: "@aws-cdk/aws-servicecatalog-alpha.CloudFormationTemplate", version: "2.4.0-alpha.0" };
/**
 * Template code from a Url.
 */
class CloudFormationUrlTemplate extends CloudFormationTemplate {
    constructor(url) {
        super();
        this.url = url;
    }
    bind(_scope) {
        return {
            httpUrl: this.url,
        };
    }
}
/**
 * Template from a local file.
 */
class CloudFormationAssetTemplate extends CloudFormationTemplate {
    /**
     * @param path The path to the asset file.
     */
    constructor(path, options = {}) {
        super();
        this.path = path;
        this.options = options;
    }
    bind(scope) {
        // If the same AssetCode is used multiple times, retain only the first instantiation.
        if (!this.asset) {
            this.asset = new s3_assets.Asset(scope, `Template${util_1.hashValues(this.path)}`, {
                path: this.path,
                ...this.options,
            });
        }
        return {
            httpUrl: this.asset.httpUrl,
        };
    }
}
/**
 * Template from a CDK defined product stack.
 */
class CloudFormationProductStackTemplate extends CloudFormationTemplate {
    /**
     * @param stack A service catalog product stack.
    */
    constructor(productStack) {
        super();
        this.productStack = productStack;
    }
    bind(_scope) {
        return {
            httpUrl: this.productStack._getTemplateUrl(),
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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