
from geobr.utils import select_metadata, download_gpkg


def read_pop_arrangements(year=2015, simplified=False, verbose=False):
    r""" Download population arrangements in Brazil
    
    This function reads the official data on population arrangements (Arranjos
    Populacionais) of Brazil. Original data were generated by the Institute of
    Geography and Statistics (IBGE)  For more information about the methodology,
    see details at \url{https://www.ibge.gov.br/apps/arranjos_populacionais/2015/pdf/publicacao.pdf}

    Parameters
    ----------
    year : int, optional
        Year of the data, by default 2015
    simplified: boolean, by default True
        Data 'type', indicating whether the function returns the 'original' dataset 
        with high resolution or a dataset with 'simplified' borders (Default)
    verbose : bool, optional
        by default False
    
    Returns
    -------
    gpd.GeoDataFrame
        Metadata and geopackage of selected states
    
    Raises
    ------
    Exception
        If parameters are not found or not well defined

    Example
    -------
    >>> from geobr import read_pop_arrangements

    # Read specific state at a given year
    >>> df = read_pop_arrangements(year=2015)
    """

    metadata = select_metadata('pop_arrengements', year=year, simplified=simplified)

    gdf = download_gpkg(metadata)

    return gdf