"""
RenertPy Python Package
Copyright (C) 2022 Assaf Gordon (assafgordon@gmail.com)
License: BSD (See LICENSE file)
"""

import os
import copy

capital_cities = {
    'Afghanistan': 'Kabul',
    'Albania': 'Tirana (Tirane)',
    'Algeria': 'Algiers',
    'Andorra': 'Andorra la Vella',
    'Angola': 'Luanda',
    'Antigua and Barbuda': 'Saint John\'s',
    'Argentina': 'Buenos Aires',
    'Armenia': 'Yerevan',
    'Australia': 'Canberra',
    'Austria': 'Vienna',
    'Azerbaijan': 'Baku',
    'Bahamas': 'Nassau',
    'Bahrain': 'Manama',
    'Bangladesh': 'Dhaka',
    'Barbados': 'Bridgetown',
    'Belarus': 'Minsk',
    'Belgium': 'Brussels',
    'Belize': 'Belmopan',
    'Benin': 'Porto Novo[1]',
    'Bhutan': 'Thimphu',
    'Bolivia': 'La Paz (administrative), Sucre (official)',
    'Bosnia and Herzegovina': 'Sarajevo',
    'Botswana': 'Gaborone',
    'Brazil': 'Brasilia',
    'Brunei': 'Bandar Seri Begawan',
    'Bulgaria': 'Sofia',
    'Burkina Faso': 'Ouagadougou',
    'Burundi': 'Gitega',
    'Cambodia': 'Phnom Penh',
    'Cameroon': 'Yaounde',
    'Canada': 'Ottawa',
    'Cape Verde': 'Praia',
    'Central African Republic': 'Bangui',
    'Chad': 'N\'Djamena',
    'Chile': 'Santiago',
    'China': 'Beijing',
    'Colombia': 'Bogota',
    'Comoros': 'Moroni',
    'Congo, Democratic Republic of the': 'Kinshasa',
    'Congo, Republic of the': 'Brazzaville',
    'Costa Rica': 'San Jose',
    'Côte d\'Ivoire (Ivory Coast)': 'Yamoussoukro',
    'Croatia': 'Zagreb',
    'Cuba': 'Havana',
    'Cyprus': 'Nicosia',
    'Czech Republic (Czechia)': 'Prague',
    'Denmark': 'Copenhagen',
    'Djibouti': 'Djibouti',
    'Dominica': 'Roseau',
    'Dominican Republic': 'Santo Domingo',
    'East Timor': 'Dili',
    'Ecuador': 'Quito',
    'Egypt': 'Cairo',
    'El Salvador': 'San Salvador',
    'England[6]': 'London',
    'Equatorial Guinea': 'Malabo',
    'Eritrea': 'Asmara',
    'Estonia': 'Tallinn',
    'Eswatini (Swaziland)[7]': 'Mbabana[8]',
    'Ethiopia': 'Addis Ababa',
    'Federated States of Micronesia': 'Palikir',
    'Fiji': 'Suva',
    'Finland': 'Helsinki',
    'France': 'Paris',
    'Gabon': 'Libreville',
    'Gambia': 'Banjul',
    'Georgia': 'Tbilisi',
    'Germany': 'Berlin',
    'Ghana': 'Accra',
    'Greece': 'Athens',
    'Grenada': 'Saint George\'s',
    'Guatemala': 'Guatemala City',
    'Guinea': 'Conakry',
    'Guinea-Bissau': 'Bissau',
    'Guyana': 'Georgetown',
    'Haiti': 'Port au Prince',
    'Honduras': 'Tegucigalpa',
    'Hungary': 'Budapest',
    'Iceland': 'Reykjavik',
    'India': 'New Delhi',
    'Indonesia': 'Jakarta',
    'Iran': 'Tehran',
    'Iraq': 'Baghdad',
    'Ireland': 'Dublin',
    'Israel': 'Jerusalem',
    'Italy': 'Rome',
    'Jamaica': 'Kingston',
    'Japan': 'Tokyo',
    'Jordan': 'Amman',
    'Kazakhstan': 'Nur-Sultan',
    'Kenya': 'Nairobi',
    'Kiribati': 'Tarawa Atoll',
    'Kosovo': 'Pristina',
    'Kuwait': 'Kuwait City',
    'Kyrgyzstan': 'Bishkek',
    'Laos': 'Vientiane',
    'Latvia': 'Riga',
    'Lebanon': 'Beirut',
    'Lesotho': 'Maseru',
    'Liberia': 'Monrovia',
    'Libya': 'Tripoli',
    'Liechtenstein': 'Vaduz',
    'Lithuania': 'Vilnius',
    'Luxembourg': 'Luxembourg',
    'Madagascar': 'Antananarivo',
    'Malawi': 'Lilongwe',
    'Malaysia': 'Kuala Lumpur',
    'Maldives': 'Male',
    'Mali': 'Bamako',
    'Malta': 'Valletta',
    'Marshall Islands': 'Majuro',
    'Mauritania': 'Nouakchott',
    'Mauritius': 'Port Louis',
    'Mexico': 'Mexico City',
    'Moldova': 'Chisinau',
    'Monaco': 'Monaco',
    'Mongolia': 'Ulaanbaatar',
    'Montenegro': 'Podgorica',
    'Morocco': 'Rabat',
    'Mozambique': 'Maputo',
    'Myanmar (Burma)': 'Nay Pyi Taw',
    'Namibia': 'Windhoek',
    'Nauru': 'No official capital',
    'Nepal': 'Kathmandu',
    'Netherlands': 'Amsterdam[13]',
    'New Zealand': 'Wellington',
    'Nicaragua': 'Managua',
    'Niger': 'Niamey',
    'Nigeria': 'Abuja',
    'North Korea': 'Pyongyang',
    'North Macedonia (Macedonia)': 'Skopje',
    'Northern Ireland[15]': 'Belfast',
    'Norway': 'Oslo',
    'Oman': 'Muscat',
    'Pakistan': 'Islamabad',
    'Palau': 'Melekeok',
    'Panama': 'Panama City',
    'Papua New Guinea': 'Port Moresby',
    'Paraguay': 'Asuncion',
    'Peru': 'Lima',
    'Philippines': 'Manila',
    'Poland': 'Warsaw',
    'Portugal': 'Lisbon',
    'Qatar': 'Doha',
    'Romania': 'Bucharest',
    'Russia': 'Moscow',
    'Rwanda': 'Kigali',
    'Saint Kitts and Nevis': 'Basseterre',
    'Saint Lucia': 'Castries',
    'Saint Vincent and the Grenadines': 'Kingstown',
    'Samoa': 'Apia',
    'San Marino': 'San Marino',
    'Sao Tome and Principe': 'Sao Tome',
    'Saudi Arabia': 'Riyadh',
    'Scotland[16]': 'Edinburgh',
    'Senegal': 'Dakar',
    'Serbia': 'Belgrade',
    'Seychelles': 'Victoria',
    'Sierra Leone': 'Freetown',
    'Singapore': 'Singapore',
    'Slovakia': 'Bratislava',
    'Slovenia': 'Ljubljana',
    'Solomon Islands': 'Honiara',
    'Somalia': 'Mogadishu',
    'South Africa': 'Pretoria, Bloemfontein, Cape Town',
    'South Korea': 'Seoul',
    'South Sudan': 'Juba',
    'Spain': 'Madrid',
    'Sri Lanka': 'Sri Jayawardenapura Kotte',
    'Sudan': 'Khartoum',
    'Suriname': 'Paramaribo',
    'Sweden': 'Stockholm',
    'Switzerland': 'Bern',
    'Syria': 'Damascus',
    'Taiwan': 'Taipei',
    'Tajikistan': 'Dushanbe',
    'Tanzania': 'Dodoma',
    'Thailand': 'Bangkok',
    'Togo': 'Lome',
    'Tonga': 'Nuku\'alofa',
    'Trinidad and Tobago': 'Port of Spain',
    'Tunisia': 'Tunis',
    'Türkiye (Turkey)': 'Ankara',
    'Turkmenistan': 'Ashgabat',
    'Tuvalu': 'Funafuti',
    'Uganda': 'Kampala',
    'Ukraine': 'Kyiv or Kiev',
    'United Arab Emirates': 'Abu Dhabi',
    'United Kingdom': 'London',
    'United States': 'Washington D.C.',
    'Uruguay': 'Montevideo',
    'Uzbekistan': 'Tashkent',
    'Vanuatu': 'Port Vila',
    'Vatican City': 'Vatican City',
    'Venezuela': 'Caracas',
    'Vietnam': 'Hanoi',
    'Wales[23]': 'Cardiff',
    'Yemen': 'Sana\'a',
    'Zambia': 'Lusaka',
    'Zimbabwe': 'Harare'
        }

def get_capital_cities():
    return copy.deepcopy(capital_cities)


pokemon_abilities = {
    "Air Lock": "Eliminates the effects of weather.",
    "Arena Trap": "Prevents non-Flying-type opposing Pokémon from fleeing.",
    "Battle Armor": "Protects the Pokémon from critical hits.",
    "Blaze": "Powers up Fire-type moves when the Pokémon's HP is low.",
    "Cacophony": "The Pokémon is immune to sound-based moves.",
    "Chlorophyll": "Boosts the Pokémon's Speed stat in harsh sunlight.",
    "Clear Body": "Prevents other Pokémon's moves or Abilities from lowering the Pokémon's stats.",
    "Cloud Nine": "Eliminates the effects of weather.",
    "Color Change": "The Pokémon's type becomes the type of the move used on it.",
    "Compound Eyes": "Boosts the Pokémon's Accuracy stat.",
    "Cute Charm": "Contact with the Pokémon may cause infatuation.",
    "Damp": "Prevents the use of Explosion and Self-Destruct.",
    "Drizzle": "Activates rain when the Pokémon enters battle.",
    "Drought": "Activates harsh sunlight when the Pokémon enters battle.",
    "Early Bird": "The Pokémon awakens twice as fast from sleep.",
    "Effect Spore": "Contact with the Pokémon may inflict poison, sleep, or paralysis on its attacker.",
    "Flame Body": "Contact with the Pokémon may inflict burn the attacker.",
    "Flash Fire": "Powers up the Pokémon's Fire-type moves if hit by a Fire-type move.",
    "Forecast": "The Pokémon transforms with the weather to change its type to Water, Fire, or Ice.",
    "Guts": "Boosts the Pokémon's Attack stat when it has a status condition.",
    "Huge Power": "Doubles the Pokémon's Attack stat.",
    "Hustle": "Boosts the Pokémon's Attack stat but lowers the Pokémon's Accuracy stat.",
    "Hyper Cutter": "The Pokémon's Attack stat cannot be lowered by other Pokémon.",
    "Illuminate": "Raises the likelihood of meeting wild Pokémon outside of battle.",
    "Immunity": "The Pokémon cannot be poisoned.",
    "Inner Focus": "The Pokémon cannot flinch.",
    "Insomnia": "The Pokémon cannot sleep.",
    "Intimidate": "When the Pokémon enters battle, it lowers opposing Pokémon's Attack stats.",
    "Keen Eye": "The Pokémon's Accuracy stat cannot be lowered by other Pokémon.",
    "Levitate": "The Pokémon is immune to Ground-type moves and Abilities.",
    "Lightning Rod": "The Pokémon draws in all Electric-type moves. Instead of receiving damage by Electric-type moves, it boosts the Pokémon's Sp. Atk.",
    "Limber": "The Pokémon cannot be paralyzed.",
    "Liquid Ooze": "HP draining moves used on the Pokémon damage instead of heal.",
    "Magma Armor": "The Pokémon cannot be frozen.",
    "Magnet Pull": "Prevents Steel-type opposing Pokémon from fleeing.",
    "Marvel Scale": "Boosts the Pokémon's Defense stat when it has a status condition.",
    "Minus": "Boosts the Pokémon's Sp. Atk if an ally with the Plus or Minus Ability is also in battle.",
    "Natural Cure": "The Pokémon loses any status condition after switching out.",
    "Oblivious": "The Pokémon cannot be infatuated or taunted.",
    "Overgrow": "Powers up Grass-type moves when the Pokémon's HP is low.",
    "Own Tempo": "The Pokémon cannot be confused.",
    "Pickup": "The Pokémon may pick up the item an opposing Pokémon used during a battle. The Pokémon may also pick up items outside of battle.",
    "Plus": "Boosts the Pokémon's Sp. Atk if an ally with the Plus or Minus Ability is also in battle.",
    "Poison Point": "Contact with the Pokémon may poison the attacker.",
    "Pressure": "Raises opposing Pokémon's PP usage.",
    "Pure Power": "Doubles the Pokémon's Attack stat.",
    "Rain Dish": "The Pokémon gradually regains HP in rain.",
    "Rock Head": "Protects the Pokémon from recoil damage.",
    "Rough Skin": "Contact with the Pokémon will damage the attacker.",
    "Run Away": "Enables a sure getaway from wild Pokémon.",
    "Sand Stream": "Activates sandstorm when the Pokémon enters battle.",
    "Sand Veil": "Boosts the Pokémon's Evasion stat in a sandstorm.",
    "Serene Grace": "Boosts the likelihood of additional effects occurring when attacking.",
    "Shadow Tag": "Prevents opposing Pokémon from fleeing.",
    "Shed Skin": "The Pokémon may heal its status condition.",
    "Shell Armor": "Protects the Pokémon from critical hits.",
    "Shield Dust": "Protects the Pokémon from additional effects.",
    "Soundproof": "The Pokémon is immune to sound-based moves.",
    "Speed Boost": "The Pokémon's Speed stat is boosted every turn.",
    "Static": "Contact with the Pokémon may paralyze the attacker.",
    "Stench": "Lowers the likelihood of meeting wild Pokémon outside of battle. The Pokémon may also cause a Pokémon to flinch after attacking it.",
    "Sticky Hold": "The Pokémon's item cannot be removed.",
    "Sturdy": "The Pokémon is immune to one-hit KO moves. The Pokémon cannot be knocked out with one hit while at full health either.",
    "Suction Cups": "The Pokémon cannot be forced to switch out or flee.",
    "Swarm": "Powers up Bug-type moves when the Pokémon's HP is low.",
    "Swift Swim": "Boosts the Pokémon's Speed stat in rain.",
    "Synchronize": "The attacker will receive the same status condition if it inflicts a burn, poison, or paralysis to the Pokémon.",
    "Thick Fat": "The Pokémon receives half damage from Fire and Ice-type moves.",
    "Torrent": "Powers up Water-type moves when the Pokémon's HP is low.",
    "Trace": "Copies an opposing Pokémon's Ability.",
    "Truant": "The Pokémon cannot use a move two turns in a row.",
    "Vital Spirit": "The Pokémon cannot sleep.",
    "Volt Absorb": "Restores the Pokémon's HP when hit by an Electric-type move, instead of taking damage.",
    "Water Absorb": "Restores the Pokémon's HP when hit by a Water-type move, instead of taking damage.",
    "Water Veil": "The Pokémon cannot be burned.",
    "White Smoke": "Prevents other Pokémon's moves or Abilities from lowering the Pokémon's stats.",
    "Wonder Guard": "The Pokémon is immune to damaging moves that are not super effective.",
    "Adaptability": "Powers up moves of the same type as the Pokémon.",
    "Aftermath": "Damages the attacker if it contacts the Pokémon with a finishing hit.",
    "Anger Point": "A critical hit maxes the Pokémon's Attack stat.",
    "Anticipation": "The Pokémon can sense an opposing Pokémon's super effective moves.",
    "Bad Dreams": "Damages sleeping opposing Pokémon.",
    "Download": "Boosts the Pokémon's Attack or Sp. Atk stat based on the opposing Pokémon's Defense and Sp. Def stats.",
    "Dry Skin": "Restores the Pokémon's HP in rain, or when hit by a Water-type move. Damages the Pokémon in harsh sunlight, and increases the damage received from Fire-type moves.",
    "Filter": "Reduces the damage taken from super effective moves.",
    "Flower Gift": "Boosts the Attack and Sp. Def stats of the Pokémon and its allies in harsh sunlight.",
    "Forewarn": "The Pokémon can tell one of the moves an opposing Pokémon has.",
    "Frisk": "The Pokémon knows opposing Pokémon's held items.",
    "Gluttony": "The Pokémon eats its held Berry at half HP or less.",
    "Heatproof": "The Pokémon receives half damage from Fire-type moves.",
    "Honey Gather": "The Pokémon may gather Honey after a battle.",
    "Hydration": "Heals the Pokémon's status condition in the rain.",
    "Ice Body": "Restores the Pokémon's HP in a hailstorm.",
    "Iron Fist": "Powers up the Pokémon's punching moves.",
    "Klutz": "The Pokémon cannot use any held items.",
    "Leaf Guard": "Prevents status conditions in sunny weather.",
    "Magic Guard": "The Pokémon only takes damage from attacks.",
    "Mold Breaker": "Moves can be used on the target regardless of its Abilities.",
    "Motor Drive": "Boosts its Speed stat if hit by an Electric-type, instead of taking damage.",
    "Multitype": "Changes the Pokémon's type to match the Plate or Z-Crystal it holds.",
    "No Guard": "The Pokémon employs no-guard tactics to ensure incoming and outgoing attacks always land.",
    "Normalize": "All the Pokémon's moves become Normal-type. The power of those moves is boosted a little.",
    "Poison Heal": "Restores HP if the Pokémon is poisoned, instead of losing HP.",
    "Quick Feet": "Boosts the Speed stat if the Pokémon has a status condition.",
    "Reckless": "Powers up moves that have recoil damage.",
    "Rivalry": "Becomes competitive and deals more damage to Pokémon of the same gender, but deals less to Pokémon of the opposite gender.",
    "Scrappy": "The Pokémon can hit Ghost-type Pokémon with Normal and Fighting-type moves.",
    "Simple": "The stat changes the Pokémon receives are doubled.",
    "Skill Link": "Increases the number of times multi-stike moves hit.",
    "Slow Start": "For five turns, the Pokémon's Attack and Speed stats are halved.",
    "Sniper": "Powers up moves if they become critical hits.",
    "Snow Cloak": "Boosts evasion in a hailstorm.",
    "Snow Warning": "The Pokémon summons a hailstorm when it enters a battle.",
    "Solar Power": "Boosts the Sp. Atk stat in sunny weather, but HP decreases every turn.",
    "Solid Rock": "Reduces the power of supereffective attacks taken.",
    "Stall": "The Pokémon moves after all other Pokémon do.",
    "Steadfast": "The Pokémon's determination boosts the Speed stat each time the Pokémon flinches.",
    "Storm Drain": "Draws in all Water-type moves. Instead of being hit by Water-type moves, it boosts its Sp. Atk.",
    "Super Luck": "The Pokémon is so lucky that the critical-hit ratios of its moves are boosted.",
    "Tangled Feet": "Raises evasion if the Pokémon is confused.",
    "Technician": "Powers up the Pokémon's weaker moves.",
    "Unaware": "When attacking, the Pokémon ignores the target Pokémon's stat changes.",
    "Unburden": "Boosts the Speed stat if the Pokémon's held item is used or lost.",
    "Analytic": "Boosts move power when the Pokémon moves last.",
    "Big Pecks": "Protects the Pokémon from Defense-lowering effects.",
    "Contrary": "Makes stat changes have an opposite effect.",
    "Cursed Body": "May disable a move used on the Pokémon.",
    "Defeatist": "Halves the Pokémon's Attack and Sp. Atk stats when its HP becomes half or less.",
    "Defiant": "Boosts the Pokémon's Attack stat sharply when its stats are lowered.",
    "Flare Boost": "Powers up special attacks when the Pokémon is burned.",
    "Friend Guard": "Reduces damage done to allies.",
    "Harvest": "May create another Berry after one is used.",
    "Healer": "Sometimes heals an ally's status condition.",
    "Heavy Metal": "Doubles the Pokémon's weight.",
    "Illusion": "Comes out disguised as the Pokémon in the party's last spot.",
    "Imposter": "The Pokémon transforms itself into the Pokémon it's facing.",
    "Infiltrator": "Passes through the opposing Pokémon's barrier, substitute, and the like and strikes.",
    "Iron Barbs": "Inflicts damage to the attacker on contact with iron barbs.",
    "Justified": "Being hit by a Dark-type move boosts the Attack stat of the Pokémon, for justice.",
    "Light Metal": "Halves the Pokémon's weight.",
    "Magic Bounce": "Reflects status moves, instead of getting hit by them.",
    "Moody": "Raises one stat sharply and lowers another every turn.",
    "Moxie": "The Pokémon shows moxie, and that boosts the Attack stat after knocking out any Pokémon.",
    "Multiscale": "Reduces the amount of damage the Pokémon takes when its HP is full.",
    "Mummy": "Contact with the Pokémon changes the attacker's Ability to Mummy.",
    "Overcoat": "Protects the Pokémon from things like sand, hail, and powder.",
    "Pickpocket": "Steals an item from an attacker that made direct contact.",
    "Poison Touch": "May poison a target when the Pokémon makes contact.",
    "Prankster": "Gives priority to a status move.",
    "Rattled": "Dark, Ghost, and Bug-type moves scare the Pokémon and boost its Speed stat.",
    "Regenerator": "Restores a little HP when withdrawn from battle.",
    "Sand Force": "Boosts the power of Rock, Ground, and Steel-type moves in a sandstorm.",
    "Sand Rush": "Boosts the Pokémon's Speed stat in a sandstorm.",
    "Sap Sipper": "Boosts the Attack stat if hit by a Grass-type move, instead of taking damage.",
    "Sheer Force": "Removes additional effects to increase the power of moves when attacking.",
    "Telepathy": "Anticipates an ally's attack and dodges it.",
    "Teravolt": "Moves can be used on the target regardless of its Abilities.",
    "Toxic Boost": "Powers up physical attacks when the Pokémon is poisoned.",
    "Turboblaze": "Moves can be used on the target regardless of its Abilities.",
    "Unnerve": "Opponents cannot eat Berries.",
    "Victory Star": "Boosts the accuracy of the Pokémon and its allies.",
    "Weak Armor": "Physical attacks lower the Pokémon's Defense stat but raises its Speed stat.",
    "Wonder Skin": "Makes status moves more likely to miss.",
    "Zen Mode": "The Pokémon changes forme when its HP is half or less.",
        }




def get_pokemon_abilities():
    return copy.deepcopy(pokemon_abilities)

l_words = {
   "Law-fall": "Depression of the jaw; hence, depression of spirits.",
   "L": "An extension at right angles to the length of a main building, giving to the ground plan a form resembling the letter L; sometimes less properly applied to a narrower, or lower, extension in the direction of the length of the main building; a wing.",
   "L": "A short right-angled pipe fitting, used in connecting two pipes at right angles.",
   "La": "A syllable applied to the sixth tone of the scale in music in solmization.",
   "La": "The tone A; -- so called among the French and Italians.",
   "Laas": "A lace. See Lace.",
   "Lab": "A telltale; a prater; a blabber.",
   "Labadist": "A follower of Jean de Labadie, a religious teacher of the 17th century, who left the Roman Catholic Church and taught a kind of mysticism, and the obligation of community of property among Christians.",
   "Labarum": "The standard adopted by the Emperor Constantine after his conversion to Christianity. It is described as a pike bearing a silk banner hanging from a crosspiece, and surmounted by a golden crown. It bore a monogram of the first two letters (CHR) of the name of Christ in its Greek form. Later, the name was given to various modifications of this standard.",
   "Labdanum": "See Ladanum.",
   "Labefaction": "The act of labefying or making weak; the state of being weakened; decay; ruin.",
   "Label": "A tassel.",
   "Label": "A slip of silk, paper, parchment, etc., affixed to anything, usually by an inscription, the contents, ownership, destination, etc.; as, the label of a bottle or a package.",
   "Label": "A slip of ribbon, parchment, etc., attached to a document to hold the appended seal; also, the seal.",
   "Label": "A writing annexed by way of addition, as a codicil added to a will.",
   "Label": "A barrulet, or, rarely, a bendlet, with pendants, or points, usually three, especially used as a mark of cadency to distinguish an eldest or only son while his father is still living.",
   "Label": "A brass rule with sights, formerly used, in connection with a circumferentor, to take altitudes.",
   "Label": "The name now generally given to the projecting molding by the sides, and over the tops, of openings in mediaeval architecture. It always has a /quare form, as in the illustration.",
   "Label": "In mediaeval art, the representation of a band or scroll containing an inscription.",
   "Labeler": "One who labels.",
   "Labellum": "The lower or apparently anterior petal of an orchidaceous flower, often of a very curious shape.",
   "Labellum": "A small appendage beneath the upper lip or labrum of certain insects.",
   "Labial": "A letter or character representing an articulation or sound formed or uttered chiefly with the lips, as b, p, w.",
   "Labial": "An organ pipe that is furnished with lips; a flue pipe.",
   "Labial": "One of the scales which border the mouth of a fish or reptile.",
   "Labialism": "The quality of being labial; as, the labialism of an articulation; conversion into a labial, as of a sound which is different in another language.",
   "Labialization": "The modification of an articulation by contraction of the lip opening.",
   "Labiate": "A plant of the order Labiatae.",
   "Labidometer": "A forceps with a measuring attachment for ascertaining the size of the fetal head.",
   "Lability": "Liability to lapse, err, or apostatize.",
   "Labimeter": "See Labidometer.",
   "Labiodental": "A labiodental sound or letter.",
   "Labionasal": "A labionasal sound or letter.",
   "Labipalpus": "One of the labial palpi of an insect. See Illust. under Labium.",
   "Labium": "A lip, or liplike organ.",
   "Labium": "The lip of an organ pipe.",
   "Labium": "The folds of integument at the opening of the vulva.",
   "Labium": "The organ of insects which covers the mouth beneath, and serves as an under lip. It consists of the second pair of maxillae, usually closely united in the middle line, but bearing a pair of palpi in most insects. It often consists of a thin anterior part (ligula or palpiger) and a firmer posterior plate (mentum).",
   "Labium": "Inner margin of the aperture of a shell.",
   "Lablab": "an East Indian name for several twining leguminous plants related to the bean, but commonly applied to the hyacinth bean (Dolichos Lablab).",
   "Labor": "Physical toil or bodily exertion, especially when fatiguing, irksome, or unavoidable, in distinction from sportive exercise; hard, muscular effort directed to some useful end, as agriculture, manufactures, and like; servile toil; exertion; work.",
   "Labor": "Intellectual exertion; mental effort; as, the labor of compiling a history.",
   "Labor": "That which requires hard work for its accomplishment; that which demands effort.",
   "Labor": "Travail; the pangs and efforts of childbirth.",
   "Labor": "Any pang or distress.",
   "Labor": "The pitching or tossing of a vessel which results in the straining of timbers and rigging.",
   "Labor": "A measure of land in Mexico and Texas, equivalent to an area of 177/ acres.",
   "Labor": "To exert muscular strength; to exert one's strength with painful effort, particularly in servile occupations; to work; to toil.",
   "Labor": "To exert one's powers of mind in the prosecution of any design; to strive; to take pains.",
   "Labor": "To be oppressed with difficulties or disease; to do one's work under conditions which make it especially hard, wearisome; to move slowly, as against opposition, or under a burden; to be burdened; -- often with under, and formerly with of.",
   "Labor": "To be in travail; to suffer the pangs of childbirth.",
   "Labor": "To pitch or roll heavily, as a ship in a turbulent sea.",
   "Laborant": "A chemist.",
   "Laboratory": "The workroom of a chemist; also, a place devoted to experiments in any branch of natural science; as, a chemical, physical, or biological laboratory. Hence, by extension, a place where something is prepared, or some operation is performed; as, the liver is the laboratory of the bile.",
   "Laborer": "One who labors in a toilsome occupation; a person who does work that requires strength rather than skill, as distinguished from that of an artisan.",
   "Labrador": "A region of British America on the Atlantic coast, north of Newfoundland.",
   "Labradorite": "A kind of feldspar commonly showing a beautiful play of colors, and hence much used for ornamental purposes. The finest specimens come from Labrador. See Feldspar.",
   "Labrum": "A lip or edge, as of a basin.",
   "Labrum": "An organ in insects and crustaceans covering the upper part of the mouth, and serving as an upper lip. See Illust. of Hymenoptera.",
   "Labrum": "The external margin of the aperture of a shell. See Univalve.",
   "Labrus": "A genus of marine fishes, including the wrasses of Europe. See Wrasse.",
   "Laburnine": "A poisonous alkaloid found in the unripe seeds of the laburnum.",
   "Laburnum": "A small leguminous tree (Cytisus Laburnum), native of the Alps. The plant is reputed to be poisonous, esp. the bark and seeds. It has handsome racemes of yellow blossoms.",
   "Labyrinth": "An edifice or place full of intricate passageways which render it difficult to find the way from the interior to the entrance; as, the Egyptian and Cretan labyrinths.",
   "Labyrinth": "Any intricate or involved inclosure; especially, an ornamental maze or inclosure in a park or garden.",
   "Labyrinth": "Any object or arrangement of an intricate or involved form, or having a very complicated nature.",
   "Labyrinth": "An inextricable or bewildering difficulty.",
   "Labyrinth": "The internal ear. See Note under Ear.",
   "Labyrinth": "A series of canals through which a stream of water is directed for suspending, carrying off, and depositing at different distances, the ground ore of a metal.",
   "Labyrinth": "A pattern or design representing a maze, -- often inlaid in the tiled floor of a church, etc.",
   "Labyrinthibranch": "One of the Labyrinthici.",
   "Labyrinthodon": "A genus of very large fossil amphibians, of the Triassic period, having bony plates on the under side of the body. It is the type of the order Labyrinthodonta. Called also Mastodonsaurus.",
   "Labyrinthodont": "One of the Labyrinthodonta.",
   "Lac": "Alt. of Lakh",
   "Lakh": "One hundred thousand; also, a vaguely great number; as, a lac of rupees.",
   "Lac": "A resinous substance produced mainly on the banyan tree, but to some extent on other trees, by the Coccus lacca, a scale-shaped insect, the female of which fixes herself on the bark, and exudes from the margin of her body this resinous substance.",
   "Laccin": "A yellow amorphous substance obtained from lac.",
   "Laccolite": "Alt. of Laccolith",
   "Laccolith": "A mass of igneous rock intruded between sedimentary beds and resulting in a mammiform bulging of the overlying strata.",
   "Lace": "That which binds or holds, especially by being interwoven; a string, cord, or band, usually one passing through eyelet or other holes, and used in drawing and holding together parts of a garment, of a shoe, of a machine belt, etc.",
   "Lace": "A snare or gin, especially one made of interwoven cords; a net.",
   "Lace": "A fabric of fine threads of linen, silk, cotton, etc., often ornamented with figures; a delicate tissue of thread, much worn as an ornament of dress.",
   "Lace": "Spirits added to coffee or some other beverage.",
   "Lace-bark": "A shrub in the West Indies (Lagetta Iintearia); -- so called from the lacelike layers of its inner bark.",
   "Lacedaemonian": "A Spartan.",
   "Laceman": "A man who deals in lace.",
   "Laceration": "The act of lacerating.",
   "Laceration": "A breach or wound made by lacerating.",
   "Lacert": "A muscle of the human body.",
   "Lacerta": "A fathom.",
   "Lacerta": "A genus of lizards. See Lizard.",
   "Lacerta": "The Lizard, a northern constellation.",
   "Lacertian": "One of the Lacertilia.",
   "Lacertus": "A bundle or fascicle of muscular fibers.",
   "Lacewing": "Any one of several species of neuropterous insects of the genus Chrysopa and allied genera. They have delicate, lacelike wings and brilliant eyes. Their larvae are useful in destroying aphids. Called also lace-winged fly, and goldeneyed fly.",
   "Laches": "Alt. of Lache",
   "Lache": "Neglect; negligence; remissness; neglect to do a thing at the proper time; delay to assert a claim.",
   "Lacrymal": "Alt. of Lacrymal",
   "Lacrymal": "See Lachrymatory.",
   "Lachrymation": "The act of shedding tears; weeping.",
   "Lacing": "The act of securing, fastening, or tightening, with a lace or laces.",
   "Lacing": "A lace; specifically (Mach.), a thong of thin leather for uniting the ends of belts.",
   "Lacing": "A rope or line passing through eyelet holes in the edge of a sail or an awning to attach it to a yard, gaff, etc.",
   "Lacing": "A system of bracing bars, not crossing each other in the middle, connecting the channel bars of a compound strut.",
   "Lacinia": "One of the narrow, jagged, irregular pieces or divisions which form a sort of fringe on the borders of the petals of some flowers.",
   "Lacinia": "A narrow, slender portion of the edge of a monophyllous calyx, or of any irregularly incised leaf.",
   "Lacinia": "The posterior, inner process of the stipes on the maxillae of insects.",
   "Lacinula": "A diminutive lacinia.",
   "Lack": "Blame; cause of blame; fault; crime; offense.",
   "Lack": "Deficiency; want; need; destitution; failure; as, a lack of sufficient food.",
   "Lackbrain": "One who is deficient in understanding; a witless person.",
   "Lacker": "One who lacks or is in want.",
   "Lackluster": "Alt. of Lacklustre",
   "Lacklustre": "A want of luster.",
   "Lacmus": "See Litmus.",
   "Laconian": "An inhabitant of Laconia; esp., a Spartan.",
   "Laconic": "Laconism.",
   "LaconIcism": "Same as Laconism.",
   "Laconism": "A vigorous, brief manner of expression; laconic style.",
   "Laconism": "An instance of laconic style or expression.",
   "Lacquer": "A varnish, consisting of a solution of shell-lac in alcohol, often colored with gamboge, saffron, or the like; -- used for varnishing metals, papier-mache, and wood. The name is also given to varnishes made of other ingredients, esp. the tough, solid varnish of the Japanese, with which ornamental objects are made.",
   "Lacquerer": "One who lacquers, especially one who makes a business of lacquering.",
   "Lacquering": "The act or business of putting on lacquer; also, the coat of lacquer put on.",
   "Lactage": "The produce of animals yielding milk; milk and that which is made from it.",
   "Lactam": "One of a series of anhydrides of an amido type, analogous to the lactones, as oxindol.",
   "Lactamide": "An acid amide derived from lactic acid, and obtained as a white crystalline substance having a neutral reaction. It is metameric with alanine.",
   "Lactarene": "A preparation of casein from milk, used in printing calico.",
   "Lactary": "a dairyhouse.",
   "Lactate": "A salt of lactic acid.",
   "Lactation": "A giving suck; the secretion and yielding of milk by the mammary gland.",
   "Lacteal": "One of the lymphatic vessels which convey chyle from the small intestine through the mesenteric glands to the thoracic duct; a chyliferous vessel.",
   "Lactescence": "The state or quality of producing milk, or milklike juice; resemblance to milk; a milky color.",
   "Lactescence": "The latex of certain plants. See Latex.",
   "Lactide": "A white, crystalline substance, obtained from also, by extension, any similar substance.",
   "Lactifuge": "A medicine to check the secretion of milk, or to dispel a supposed accumulation of milk in any part of the body.",
   "Lactim": "One of a series of anhydrides resembling the lactams, but of an imido type; as, isatine is a lactim. Cf. Lactam.",
   "Lactimide": "A white, crystalline substance obtained as an anhydride of alanine, and regarded as an imido derivative of lactic acid.",
   "Lactin": "See Lactose.",
   "Lactoabumin": "The albumin present on milk, apparently identical with ordinary serum albumin. It is distinct from the casein of milk.",
   "Lactobutyrometer": "An instrument for determining the amount of butter fat contained in a given sample of milk.",
   "Lactodensimeter": "A form of hydrometer, specially graduated, for finding the density of milk, and thus discovering whether it has been mixed with water or some of the cream has been removed.",
   "Lactometer": "An instrument for estimating the purity or richness of milk, as a measuring glass, a specific gravity bulb, or other apparatus.",
   "Lactone": "One of a series of organic compounds, regarded as anhydrides of certain hydroxy acids. In general, they are colorless liquids, having a weak aromatic odor. They are so called because the typical lactone is derived from lactic acid.",
   "Lactoprotein": "A peculiar albuminous body considered a normal constituent of milk.",
   "Lactoscope": "An instrument for estimating the amount of cream contained in milk by ascertaining its relative opacity.",
   "Lactose": "Sugar of milk or milk sugar; a crystalline sugar present in milk, and separable from the whey by evaporation and crystallization. It has a slightly sweet taste, is dextrorotary, and is much less soluble in water than either cane sugar or glucose. Formerly called lactin.",
   "Lactose": "See Galactose.",
   "Lactuca": "A genus of composite herbs, several of which are cultivated foe salad; lettuce.",
   "Lactucarium": "The inspissated juice of the common lettuce, sometimes used as a substitute for opium.",
   "Lactucin": "A white, crystalline substance, having a bitter taste and a neutral reaction, and forming one of the essential ingredients of lactucarium.",
   "Lactucone": "A white, crystalline, tasteless substance, found in the milky sap of species of Lactuca, and constituting an essential ingredient of lactucarium.",
   "Lactyl": "An organic residue or radical derived from lactic acid.",
   "Lacuna": "A small opening; a small pit or depression; a small blank space; a gap or vacancy; a hiatus.",
   "Lacuna": "A small opening; a small depression or cavity; a space, as a vacant space between the cells of plants, or one of the spaces left among the tissues of the lower animals, which serve in place of vessels for the circulation of the body fluids, or the cavity or sac, usually of very small size, in a mucous membrane.",
   "Lacunar": "The ceiling or under surface of any part, especially when it consists of compartments, sunk or hollowed without spaces or bands between the panels.",
   "Lacunar": "One of the sunken panels in such a ceiling.",
   "Lacune": "A lacuna.",
   "Lacwork": "Ornamentation by means of lacquer painted or carved, or simply colored, sprinkled with gold or the like; -- said especially of Oriental work of this kind.",
   "Lad": "A boy; a youth; a stripling.",
   "Lad": "A companion; a comrade; a mate.",
   "Ladanum": "A gum resin gathered from certain Oriental species of Cistus. It has a pungent odor and is chiefly used in making plasters, and for fumigation.",
   "Laddie": "A lad; a male sweetheart.",
   "Lade": "The mouth of a river.",
   "Lade": "A passage for water; a ditch or drain.",
   "Lademan": "One who leads a pack horse; a miller's servant.",
   "Ladin": "A Romansch dialect spoken in some parts of Switzerland and the Tyrol.",
   "Lading": "The act of loading.",
   "Lading": "That which lades or constitutes a load or cargo; freight; burden; as, the lading of a ship.",
   "Ladino": "One of the half-breed descendants of whites and Indians; a mestizo; -- so called throughout Central America. They are usually of a yellowish orange tinge.",
   "Ladkin": "A little lad.",
   "Ladleful": "A quantity sufficient to fill a ladle.",
   "Ladrone": "A robber; a pirate; hence, loosely, a rogue or rascal.",
   "Lady": "A woman who looks after the domestic affairs of a family; a mistress; the female head of a household.",
   "Lady": "A woman having proprietary rights or authority; mistress; -- a feminine correlative of lord.",
   "Lady": "A woman to whom the particular homage of a knight was paid; a woman to whom one is devoted or bound; a sweetheart.",
   "Lady": "A woman of social distinction or position. In England, a title prefixed to the name of any woman whose husband is not of lower rank than a baron, or whose father was a nobleman not lower than an earl. The wife of a baronet or knight has the title of Lady by courtesy, but not by right.",
   "Lady": "A woman of refined or gentle manners; a well-bred woman; -- the feminine correlative of gentleman.",
   "Lady": "A wife; -- not now in approved usage.",
   "Lady": "The triturating apparatus in the stomach of a lobster; -- so called from a fancied resemblance to a seated female figure. It consists of calcareous plates.",
   "Ladybird": "Any one of numerous species of small beetles of the genus Coccinella and allied genera (family Coccinellidae); -- called also ladybug, ladyclock, lady cow, lady fly, and lady beetle. Coccinella seplempunctata in one of the common European species. See Coccinella.",
   "Ladybug": "Same as Ladybird.",
   "Ladyclock": "See Ladyrird.",
   "Ladyfish": "A large, handsome oceanic fish (Albula vulpes), found both in the Atlantic and Pacific oceans; -- called also bonefish, grubber, French mullet, and macabe.",
   "Ladyfish": "A labroid fish (Harpe rufa) of Florida and the West Indies.",
   "Ladyhood": "The state or quality of being a lady; the personality of a lady.",
   "Lady-killer": "A gallant who captivates the hearts of women.",
   "Lady-killing": "The art or practice of captivating the hearts of women.",
   "Ladykin": "A little lady; -- applied by the writers of Queen Elizabeth's time, in the abbreviated form Lakin, to the Virgin Mary.",
   "Ladylikeness": "The quality or state of being ladylike.",
   "Ladylove": "A sweetheart or mistress.",
   "Ladyship": "The rank or position of a lady; -- given as a title (preceded by her or your).",
   "Laelaps": "A genus of huge, carnivorous, dinosaurian reptiles from the Cretaceous formation of the United States. They had very large hind legs and tail, and are supposed to have been bipedal. Some of the species were about eighteen feet high.",
   "Laemmergeyer": "See Lammergeir.",
   "Laemodipod": "One of the Laemodipoda.",
   "Laevulose": "See Levulose.",
   "Lafayette": "The dollar fish.",
   "Lafayette": "A market fish, the goody, or spot (Liostomus xanthurus), of the southern coast of the United States.",
   "Lag": "One who lags; that which comes in last.",
   "Lag": "The fag-end; the rump; hence, the lowest class.",
   "Lag": "The amount of retardation of anything, as of a valve in a steam engine, in opening or closing.",
   "Lag": "A stave of a cask, drum, etc.; especially (Mach.), one of the narrow boards or staves forming the covering of a cylindrical object, as a boiler, or the cylinder of a carding machine or a steam engine.",
   "Lag": "See Graylag.",
   "Lag": "One transported for a crime.",
   "Lagarto": "An alligator.",
   "Lagena": "The terminal part of the cochlea in birds and most reptiles; an appendage of the sacculus, corresponding to the cochlea, in fishes and amphibians.",
   "Lager": "Lager beer.",
   "Laggard": "One who lags; a loiterer.",
   "Lagger": "A laggard.",
   "Lagging": "The clothing (esp., an outer, wooden covering), as of a steam cylinder, applied to prevent the radiation of heat; a covering of lags; -- called also deading and cleading.",
   "Lagging": "Lags, collectively; narrow planks extending from one rib to another in the centering of arches.",
   "Lagomorph": "One of the Lagomorpha.",
   "Lagoon": "A shallow sound, channel, pond, or lake, especially one into which the sea flows; as, the lagoons of Venice.",
   "Lagoon": "A lake in a coral island, often occupying a large portion of its area, and usually communicating with the sea. See Atoll.",
   "Lagophthalmia": "Alt. of Lagophthalmos",
   "Lagophthalmos": "A morbid condition in which the eye stands wide open, giving a peculiar staring appearance.",
   "Lagune": "See Lagoon.",
   "Laic": "A layman.",
   "Laicality": "The state or quality of being laic; the state or condition of a layman.",
   "Lainere": "See Lanier.",
   "Lair": "A place in which to lie or rest; especially, the bed or couch of a wild beast.",
   "Lair": "A burying place.",
   "Lair": "A pasture; sometimes, food.",
   "Laird": "A lord; a landholder, esp. one who holds land directly of the crown.",
   "Lairdship": "The state of being a laird; an estate; landed property.",
   "Laism": "See Lamaism.",
   "Lakao": "Sap green.",
   "Lake": "A pigment formed by combining some coloring matter, usually by precipitation, with a metallic oxide or earth, esp. with aluminium hydrate; as, madder lake; Florentine lake; yellow lake, etc.",
   "Lake": "A kind of fine white linen, formerly in use.",
   "Lake": "A large body of water contained in a depression of the earth's surface, and supplied from the drainage of a more or less extended area.",
   "Lake-dweller": "See Lake dwellers, under Lake.",
   "Lakelet": "A little lake.",
   "Lakeweed": "The water pepper (Polygonum Hydropiper), an aquatic plant of Europe and North America.",
   "Lakh": "Same as Lac, one hundred thousand.",
   "Lakin": "See Ladykin.",
   "Lallation": "An imperfect enunciation of the letter r, in which it sounds like l.",
   "Lalo": "The powdered leaves of the baobab tree, used by the Africans to mix in their soup, as the southern negroes use powdered sassafras. Cf. Couscous.",
   "Lama": "See Llama.",
   "Lama": "In Thibet, Mongolia, etc., a priest or monk of the belief called Lamaism.",
   "Lamaism": "A modified form of Buddhism which prevails in Thibet, Mongolia, and some adjacent parts of Asia; -- so called from the name of its priests. See 2d Lama.",
   "Lamaist": "Alt. of Lamaite",
   "Lamaite": "One who believes in Lamaism.",
   "Lamantin": "The manatee.",
   "Lamarckianism": "Lamarckism.",
   "Lamarckism": "The theory that structural variations, characteristic of species and genera, are produced in animals and plants by the direct influence of physical environments, and esp., in the case of animals, by effort, or by use or disuse of certain organs.",
   "Lamasery": "A monastery or convent of lamas, in Thibet, Mongolia, etc.",
   "Lamb": "The young of the sheep.",
   "Lamb": "Any person who is as innocent or gentle as a lamb.",
   "Lamb": "A simple, unsophisticated person; in the cant of the Stock Exchange, one who ignorantly speculates and is victimized.",
   "Lambale": "A feast at the time of shearing lambs.",
   "Lambative": "A medicine taken by licking with the tongue; a lincture.",
   "Lambda": "The name of the Greek letter /, /, corresponding with the English letter L, l.",
   "Lambda": "The point of junction of the sagittal and lambdoid sutures of the skull.",
   "Lambdacism": "A fault in speaking or in composition, which consists in too frequent use of the letter l, or in doubling it erroneously.",
   "Lambdacism": "A defect in pronunciation of the letter l when doubled, which consists in giving it a sound as if followed by y, similar to that of the letters lli in billion.",
   "Lambdacism": "The use of the sound of l for that of r in pronunciation; lallation; as, Amelican for American.",
   "Lambkin": "A small lamb.",
   "Lambrequin": "A kind of pendent scarf or covering attached to the helmet, to protect it from wet or heat.",
   "Lambrequin": "A leather flap hanging from a cuirass.",
   "Lambrequin": "A piece of ornament drapery or short decorative hanging, pendent from a shelf or from the casing above a window, hiding the curtain fixtures, or the like.",
   "Lambskin": "The skin of a lamb; especially, a skin dressed with the wool on, and used as a mat. Also used adjectively.",
   "Lambskin": "A kind of woolen.",
   "Lambskinnet": "See Lansquenet.",
   "Lamb's-quarters": "A name given to several plants of the Goosefoot family, sometimes used as pot herbs, as Chenopodium album and Atriplex patulsa.",
   "Lamel": "See Lamella.",
   "Lamella": "a thin plate or scale of anything, as a thin scale growing from the petals of certain flowers; or one of the thin plates or scales of which certain shells are composed.",
   "Lamellibranch": "One of the Lamellibranchia. Also used adjectively.",
   "Lamellibranchiate": "One of the Lamellibranchia.",
   "Lamellicorn": "A lamellicorn insect.",
   "Lameness": "The condition or quality of being lame; as, the lameness of an excuse or an argument.",
   "Lamentation": "The act of bewailing; audible expression of sorrow; wailing; moaning.",
   "Lamentation": "A book of the Old Testament attributed to the prophet Jeremiah, and taking its name from the nature of its contents.",
   "Lamenter": "One who laments.",
   "Lamentin": "See Lamantin.",
   "Lamenting": "Lamentation.",
   "Lametta": "Foil or wire made of gold, silver, or brass.",
   "Lamia": "A monster capable of assuming a woman's form, who was said to devour human beings or suck their blood; a vampire; a sorceress; a witch.",
   "Lamina": "A thin plate or scale; a layer or coat lying over another; -- said of thin plates or platelike substances, as of bone or minerals.",
   "Lamina": "The blade of a leaf; the broad, expanded portion of a petal or sepal of a flower.",
   "Lamina": "A thin plate or scale; specif., one of the thin, flat processes composing the vane of a feather.",
   "Laminability": "The quality or state of being laminable.",
   "Laminaria": "A genus of great seaweeds with long and broad fronds; kelp, or devil's apron. The fronds commonly grow in clusters, and are sometimes from thirty to fifty feet in length. See Illust. of Kelp.",
   "Laminarite": "A broad-leafed fossil alga.",
   "Lamination": "The process of laminating, or the state of being laminated.",
   "Laminitis": "Inflammation of the laminae or fleshy plates along the coffin bone of a horse; founder.",
   "Lammas": "The first day of August; -- called also Lammas day, and Lammastide.",
   "Lammergeir": "Alt. of Lammergeier",
   "Lammergeier": "A very large vulture (Gypaetus barbatus), which inhabits the mountains of Southern Europe, Asia, and Northern Africa. When full-grown it is nine or ten feet in extent of wings. It is brownish black above, with the under parts and neck rusty yellow; the forehead and crown white; the sides of the head and beard black. It feeds partly on carrion and partly on small animals, which it kills. It has the habit of carrying tortoises and marrow bones to a great height, and dropping them on stones to obtain the contents, and is therefore called bonebreaker and ossifrage. It is supposed to be the ossifrage of the Bible. Called also bearded vulture and bearded eagle.",
   "Lamp": "A thin plate or lamina.",
   "Lamp": "A light-producing vessel, instrument or apparatus; especially, a vessel with a wick used for the combustion of oil or other inflammable liquid, for the purpose of producing artificial light.",
   "Lamp": "Figuratively, anything which enlightens intellectually or morally; anything regarded metaphorically a performing the uses of a lamp.",
   "Lamp": "A device or mechanism for producing light by electricity. See Incandescent lamp, under Incandescent.",
   "Lampad": "A lamp or candlestick.",
   "Lampadist": "One who gained the prize in the lampadrome.",
   "Lampadrome": "A race run by young men with lighted torches in their hands. He who reached the goal first, with his torch unextinguished, gained the prize.",
   "Lampas": "An inflammation and swelling of the soft parts of the roof of the mouth immediately behind the fore teeth in the horse; -- called also lampers.",
   "Lampate": "A supposed salt of lampic acid.",
   "Lampblack": "The fine impalpable soot obtained from the smoke of carbonaceous substances which have been only partly burnt, as in the flame of a smoking lamp. It consists of finely divided carbon, with sometimes a very small proportion of various impurities. It is used as an ingredient of printers' ink, and various black pigments and cements.",
   "Lampern": "The river lamprey (Ammocoetes, / Lampetra, fluviatilis).",
   "Lampers": "See Lampas.",
   "Lamplight": "Light from a lamp.",
   "Lamplighter": "One who, or that which, lights a lamp; esp., a person who lights street lamps.",
   "Lamplighter": "The calico bass.",
   "Lampoon": "A personal satire in writing; usually, malicious and abusive censure written only to reproach and distress.",
   "Lampooner": "The writer of a lampoon.",
   "Lampoonry": "The act of lampooning; a lampoon, or lampoons.",
   "Lamp-post": "A post (generally a pillar of iron) supporting a lamp or lantern for lighting a street, park, etc.",
   "Lamprel": "See Lamprey.",
   "Lamprey": "An eel-like marsipobranch of the genus Petromyzon, and allied genera. The lampreys have a round, sucking mouth, without jaws, but set with numerous minute teeth, and one to three larger teeth on the palate (see Illust. of Cyclostomi). There are seven small branchial openings on each side.",
   "Lampron": "See Lamprey.",
   "Lampyrine": "An insect of the genus Lampyris, or family Lampyridae. See Lampyris.",
   "Lampyris": "A genus of coleopterous insects, including the glowworms.",
   "Lanarkite": "A mineral consisting of sulphate of lead, occurring either massive or in long slender prisms, of a greenish white or gray color.",
   "Lanary": "A place for storing wool.",
   "Lance": "A weapon of war, consisting of a long shaft or handle and a steel blade or head; a spear carried by horsemen, and often decorated with a small flag; also, a spear or harpoon used by whalers and fishermen.",
   "Lance": "A soldier armed with a lance; a lancer.",
   "Lance": "A small iron rod which suspends the core of the mold in casting a shell.",
   "Lance": "An instrument which conveys the charge of a piece of ordnance and forces it home.",
   "Lance": "One of the small paper cases filled with combustible composition, which mark the outlines of a figure.",
   "Lancegay": "Alt. of Lancegaye",
   "Lancegaye": "A kind of spear anciently used. Its use was prohibited by a statute of Richard II.",
   "Lancelet": "A small fishlike animal (Amphioxus lanceolatus), remarkable for the rudimentary condition of its organs. It is the type of the class Leptocardia. See Amphioxus, Leptocardia.",
   "Lancepesade": "An assistant to a corporal; a private performing the duties of a corporal; -- called also lance corporal.",
   "Lancer": "One who lances; one who carries a lance; especially, a member of a mounted body of men armed with lances, attached to the cavalry service of some nations.",
   "Lancer": "A lancet.",
   "Lancer": "A set of quadrilles of a certain arrangement.",
   "Lancet": "A surgical instrument of various forms, commonly sharp-pointed and two-edged, used in venesection, and in opening abscesses, etc.",
   "Lancet": "An iron bar used for tapping a melting furnace.",
   "Lancewood": "A tough, elastic wood, often used for the shafts of gigs, archery bows, fishing rods, and the like. Also, the tree which produces this wood, Duguetia Quitarensis (a native of Guiana and Cuba), and several other trees of the same family (Anonaseae).",
   "Lancination": "A tearing; laceration.",
   "Land": "Urine. See Lant.",
   "Land": "The solid part of the surface of the earth; -- opposed to water as constituting a part of such surface, especially to oceans and seas; as, to sight land after a long voyage.",
   "Land": "Any portion, large or small, of the surface of the earth, considered by itself, or as belonging to an individual or a people, as a country, estate, farm, or tract.",
   "Land": "Ground, in respect to its nature or quality; soil; as, wet land; good or bad land.",
   "Land": "The inhabitants of a nation or people.",
   "Land": "The mainland, in distinction from islands.",
   "Land": "The ground or floor.",
   "Land": "The ground left unplowed between furrows; any one of several portions into which a field is divided for convenience in plowing.",
   "Land": "Any ground, soil, or earth whatsoever, as meadows, pastures, woods, etc., and everything annexed to it, whether by nature, as trees, water, etc., or by the hand of man, as buildings, fences, etc.; real estate.",
   "Land": "The lap of the strakes in a clinker-built boat; the lap of plates in an iron vessel; -- called also landing.",
   "Land": "In any surface prepared with indentations, perforations, or grooves, that part of the surface which is not so treated, as the level part of a millstone between the furrows, or the surface of the bore of a rifled gun between the grooves.",
   "Landamman": "A chief magistrate in some of the Swiss cantons.",
   "Landamman": "The president of the diet of the Helvetic republic.",
   "Landau": "A four-wheeled covered vehicle, the top of which is divided into two sections which can be let down, or thrown back, in such a manner as to make an open carriage.",
   "Landaulet": "A small landau.",
   "Lander": "One who lands, or makes a landing.",
   "Lander": "A person who waits at the mouth of the shaft to receive the kibble of ore.",
   "Landfall": "A sudden transference of property in land by the death of its owner.",
   "Landfall": "Sighting or making land when at sea.",
   "Landflood": "An overflowing of land by river; an inundation; a freshet.",
   "Landgrave": "A German nobleman of a rank corresponding to that of an earl in England and of a count in France.",
   "Landgraviate": "The territory held by a landgrave.",
   "Landgraviate": "The office, jurisdiction, or authority of a landgrave.",
   "Landgravine": "The wife of a landgrave.",
   "Landholder": "A holder, owner, or proprietor of land.",
   "Landing": "A going or bringing on shore.",
   "Landing": "A place for landing, as from a ship, a carriage. etc.",
   "Landing": "The level part of a staircase, at the top of a flight of stairs, or connecting one flight with another.",
   "Landlady": "A woman having real estate which she leases to a tenant or tenants.",
   "Landlady": "The mistress of an inn or lodging house.",
   "Landleaper": "See Landlouper.",
   "Landloper": "Same as Landlouper.",
   "Landlord": "The lord of a manor, or of land; the owner of land or houses which he leases to a tenant or tenants.",
   "Landlord": "The master of an inn or of a lodging house.",
   "Landlordism": "The state of being a landlord; the characteristics of a landlord; specifically, in Great Britain, the relation of landlords to tenants, especially as regards leased agricultural lands.",
   "Landlordry": "The state of a landlord.",
   "Landlouper": "A vagabond; a vagrant.",
   "Landlubber": "One who passes his life on land; -- so called among seamen in contempt or ridicule.",
   "Landman": "A man who lives or serves on land; -- opposed to seaman.",
   "Landman": "An occupier of land.",
   "Landmark": "A mark to designate the boundary of land; any , mark or fixed object (as a marked tree, a stone, a ditch, or a heap of stones) by which the limits of a farm, a town, or other portion of territory may be known and preserved.",
   "Landmark": "Any conspicuous object on land that serves as a guide; some prominent object, as a hill or steeple.",
   "Landowner": "An owner of land.",
   "Landowning": "The owning of land.",
   "Landreeve": "A subordinate officer on an extensive estate, who acts as an assistant to the steward.",
   "Landscape": "A portion of land or territory which the eye can comprehend in a single view, including all the objects it contains.",
   "Landscape": "A picture representing a scene by land or sea, actual or fancied, the chief subject being the general aspect of nature, as fields, hills, forests, water. etc.",
   "Landscape": "The pictorial aspect of a country.",
   "Landscapist": "A painter of landscapes.",
   "Landskip": "A landscape.",
   "Landslip": "Alt. of Landslide",
   "Landslide": "The slipping down of a mass of land from a mountain, hill, etc.",
   "Landslide": "The land which slips down.",
   "Landsman": "One who lives on the land; -- opposed to seaman.",
   "Landsman": "A sailor on his first voyage.",
   "Landstreight": "A narrow strip of land.",
   "Landsturm": "That part of the reserve force in Germany which is called out last.",
   "Landtag": "The diet or legislative body; as, the Landtag of Prussia.",
   "Landwaiter": "See Landing waiter, under Landing, a.",
   "Landwehr": "That part of the army, in Germany and Austria, which has completed the usual military service and is exempt from duty in time of peace, except that it is called out occasionally for drill.",
   "Lane": "A passageway between fences or hedges which is not traveled as a highroad; an alley between buildings; a narrow way among trees, rocks, and other natural obstructions; hence, in a general sense, a narrow passageway; as, a lane between lines of men, or through a field of ice.",
   "Langaha": "A curious colubriform snake of the genus Xyphorhynchus, from Madagascar. It is brownish red, and its nose is prolonged in the form of a sharp blade.",
   "Langarey": "One of numerous species of long-winged, shrikelike birds of Australia and the East Indies, of the genus Artamus, and allied genera; called also wood swallow.",
   "Langate": "A linen roller used in dressing wounds.",
   "Langdak": "A wolf (Canis pallipes), found in India, allied to the jackal.",
   "Langrage": "Alt. of Langrel",
   "Langrel": "A kind of shot formerly used at sea for tearing sails and rigging. It consisted of bolts, nails, and other pieces of iron fastened together or inclosed in a canister.",
   "Langret": "A kind of loaded die.",
   "Langridge": "See Langrage.",
   "Langteraloo": "An old game at cards. See Loo (a).",
   "Language": "Any means of conveying or communicating ideas; specifically, human speech; the expression of ideas by the voice; sounds, expressive of thought, articulated by the organs of the throat and mouth.",
   "Language": "The expression of ideas by writing, or any other instrumentality.",
   "Language": "The forms of speech, or the methods of expressing ideas, peculiar to a particular nation.",
   "Language": "The characteristic mode of arranging words, peculiar to an individual speaker or writer; manner of expression; style.",
   "Language": "The inarticulate sounds by which animals inferior to man express their feelings or their wants.",
   "Language": "The suggestion, by objects, actions, or conditions, of ideas associated therewith; as, the language of flowers.",
   "Language": "The vocabulary and phraseology belonging to an art or department of knowledge; as, medical language; the language of chemistry or theology.",
   "Language": "A race, as distinguished by its speech.",
   "Languet": "Anything resembling the tongue in form or office; specif., the slip of metal in an organ pipe which turns the current of air toward its mouth.",
   "Languet": "That part of the hilt, in certain kinds of swords, which overlaps the scabbard.",
   "Languish": "See Languishiment.",
   "Languisher": "One who languishes.",
   "Languishment": "The state of languishing.",
   "Languishment": "Tenderness of look or mien; amorous pensiveness.",
   "Languishness": "Languishment.",
   "Languor": "A state of the body or mind which is caused by exhaustion of strength and characterized by a languid feeling; feebleness; lassitude; laxity.",
   "Languor": "Any enfeebling disease.",
   "Languor": "Listless indolence; dreaminess. Pope.",
   "Langya": "One of several species of East Indian and Asiatic fresh-water fishes of the genus Ophiocephalus, remarkable for their power of living out of water, and for their tenacity of life; -- called also walking fishes.",
   "Laniard": "See Lanyard.",
   "Laniation": "A tearing in pieces.",
   "Lanier": "A thong of leather; a whip lash.",
   "Lanier": "A strap used to fasten together parts of armor, to hold the shield by, and the like.",
   "Laniferous": "Bearing or producing wool.",
   "Lanifice": "Anything made of wool.",
   "Lankiness": "The condition or quality or being lanky.",
   "Lankness": "The state or quality of being lank.",
   "Lanolin": "A peculiar fatlike body, made up of cholesterin and certain fatty acids, found in feathers, hair, wool, and keratin tissues generally.",
   "Lanseh": "The small, whitish brown fruit of an East Indian tree (Lansium domesticum). It has a fleshy pulp, with an agreeable subacid taste.",
   "Lansquenet": "A German foot soldier in foreign service in the 15th and 16th centuries; a soldier of fortune; -- a term used in France and Western Europe.",
   "Lansquenet": "A game at cards, vulgarly called lambskinnet.",
   "Lant": "Urine.",
   "Lant": "Any one of several species of small, slender, marine fishes of the genus Ammedytes. The common European species (A. tobianus) and the American species (A. Americanus) live on sandy shores, buried in the sand, and are caught in large quantities for bait. Called also launce, and sand eel.",
   "Lant": "See Lanterloo.",
   "Lantanium": "Alt. of Lantanum",
   "Lantanum": "See Lanthanum.",
   "Lanterloo": "An old name of loo (a).",
   "Lantern": "Something inclosing a light, and protecting it from wind, rain, etc. ; -- sometimes portable, as a closed vessel or case of horn, perforated tin, glass, oiled paper, or other material, having a lamp or candle within; sometimes fixed, as the glazed inclosure of a street light, or of a lighthouse light.",
   "Lantern": "An open structure of light material set upon a roof, to give light and air to the interior.",
   "Lantern": "A cage or open chamber of rich architecture, open below into the building or tower which it crowns.",
   "Lantern": "A smaller and secondary cupola crowning a larger one, for ornament, or to admit light; such as the lantern of the cupola of the Capitol at Washington, or that of the Florence cathedral.",
   "Lantern": "A lantern pinion or trundle wheel. See Lantern pinion (below).",
   "Lantern": "A kind of cage inserted in a stuffing box and surrounding a piston rod, to separate the packing into two parts and form a chamber between for the reception of steam, etc. ; -- called also lantern brass.",
   "Lantern": "A perforated barrel to form a core upon.",
   "Lantern": "See Aristotle's lantern.",
   "Lanthanite": "Hydrous carbonate of lanthanum, found in tabular while crystals.",
   "Lanthanum": "A rare element of the group of the earth metals, allied to aluminium. It occurs in certain rare minerals, as cerite, gadolinite, orthite, etc., and was so named from the difficulty of separating it from cerium, didymium, and other rare elements with which it is usually associated. Atomic weight 138.5. Symbol La.",
   "Lanthopine": "An alkaloid found in opium in small quantities, and extracted as a white crystalline substance.",
   "Lanthorn": "See Lantern.",
   "Lanugo": "The soft woolly hair which covers most parts of the mammal fetus, and in man is shed before or soon after birth.",
   "Lanyard": "A short piece of rope or line for fastening something in ships; as, the lanyards of the gun ports, of the buoy, and the like; esp., pieces passing through the dead-eyes, and used to extend shrouds, stays, etc.",
   "Lanyard": "A strong cord, about twelve feet long, with an iron hook at one end a handle at the other, used in firing cannon with a friction tube.",
   "Lanyer": "See Lanier.",
   "Laocoon": "A priest of Apollo, during the Trojan war. (See 2.)",
   "Laocoon": "A marble group in the Vatican at Rome, representing the priest Laocoon, with his sons, infolded in the coils of two serpents, as described by Virgil.",
   "Lap": "The loose part of a coat; the lower part of a garment that plays loosely; a skirt; an apron.",
   "Lap": "An edge; a border; a hem, as of cloth.",
   "Lap": "The part of the clothing that lies on the knees or thighs when one sits down; that part of the person thus covered; figuratively, a place of rearing and fostering; as, to be reared in the lap of luxury.",
   "Lap": "That part of any substance or fixture which extends over, or lies upon, or by the side of, a part of another; as, the lap of a board; also, the measure of such extension over or upon another thing.",
   "Lap": "The amount by which a slide valve at its half stroke overlaps a port in the seat, being equal to the distance the valve must move from its mid stroke position in order to begin to open the port. Used alone, lap refers to outside lap. See Outside lap (below).",
   "Lap": "The state or condition of being in part extended over or by the side of something else; or the extent of the overlapping; as, the second boat got a lap of half its length on the leader.",
   "Lap": "One circuit around a race track, esp. when the distance is a small fraction of a mile; as, to run twenty laps; to win by three laps. See Lap, to fold, 2.",
   "Lap": "In card playing and other games, the points won in excess of the number necessary to complete a game; -- so called when they are counted in the score of the following game.",
   "Lap": "A sheet, layer, or bat, of cotton fiber prepared for the carding machine.",
   "Lap": "A piece of brass, lead, or other soft metal, used to hold a cutting or polishing powder in cutting glass, gems, and the like, or in polishing cutlery, etc. It is usually in the form of wheel or disk, which revolves on a vertical axis.",
   "Lap": "To fold; to bend and lay over or on something; as, to lap a piece of cloth.",
   "Lap": "To wrap or wind around something.",
   "Lap": "To infold; to hold as in one's lap; to cherish.",
   "Lap": "To lay or place over anything so as to partly or wholly cover it; as, to lap one shingle over another; to lay together one partly over another; as, to lap weather-boards; also, to be partly over, or by the side of (something); as, the hinder boat lapped the foremost one.",
   "Lap": "To lay together one over another, as fleeces or slivers for further working.",
   "Lap": "The act of lapping with, or as with, the tongue; as, to take anything into the mouth with a lap.",
   "Lap": "The sound of lapping.",
   "Laparocele": "A rupture or hernia in the lumbar regions.",
   "Laparotomy": "A cutting through the walls of the abdomen, as in the Caesarean section.",
   "Lapboard": "A board used on the lap as a substitute for a table, as by tailors.",
   "Lapdog": "A small dog fondled in the lap.",
   "Lapel": "That part of a garment which is turned back; specifically, the lap, or fold, of the front of a coat in continuation of collar.",
   "Lapful": "As much as the lap can contain.",
   "Lapicide": "A stonecutter.",
   "Lapidary": "An artificer who cuts, polishes, and engraves precious stones; hence, a dealer in precious stones.",
   "Lapidary": "A virtuoso skilled in gems or precious stones; a connoisseur of lapidary work.",
   "Lapidation": "The act of stoning.",
   "Lapidescence": "The state or quality of being lapidescent.",
   "Lapidescence": "A hardening into a stone substance.",
   "Lapidescence": "A stony concretion.",
   "Lapidescent": "Any substance which has the quality of petrifying other bodies, or of converting or being converted into stone.",
   "Lapidification": "The act or process of lapidifying; fossilization; petrifaction.",
   "Lapidist": "A lapidary.",
   "Lapillation": "The state of being, or the act of making, stony.",
   "Lapis": "A stone.",
   "Laplander": "A native or inhabitant of Lapland; -- called also Lapp.",
   "Lapling": "One who has been fondled to excess; one fond of ease and sensual delights; -- a term of contempt.",
   "Lapp": "Same as Laplander. Cf. Lapps.",
   "Lapper": "One who takes up food or liquid with his tongue.",
   "Lappet": "A small decorative fold or flap, esp, of lace or muslin, in a garment or headdress.",
   "Lappic": "The language of the Lapps. See Lappish.",
   "Lapping": "A kind of machine blanket or wrapping material used by calico printers.",
   "Lappish": "The language spoken by the Lapps in Lapland. It is related to the Finnish and Hungarian, and is not an Aryan language.",
   "Lapse": "A gliding, slipping, or gradual falling; an unobserved or imperceptible progress or passing away,; -- restricted usually to immaterial things, or to figurative uses.",
   "Lapse": "A slip; an error; a fault; a failing in duty; a slight deviation from truth or rectitude.",
   "Lapse": "The termination of a right or privilege through neglect to exercise it within the limited time, or through failure of some contingency; hence, the devolution of a right or privilege.",
   "Lapse": "A fall or apostasy.",
   "Lapstone": "A stone for the lap, on which shoemakers beat leather.",
   "Lapwork": "Work in which one part laps over another.",
   "Laguay": "A lackey.",
   "Laquear": "A lacunar.",
   "Lar": "A tutelary deity; a deceased ancestor regarded as a protector of the family. The domestic Lares were the tutelar deities of a house; household gods. Hence, Eng.: Hearth or dwelling house.",
   "Lar": "A species of gibbon (Hylobates lar), found in Burmah. Called also white-handed gibbon.",
   "Larboard": "The left-hand side of a ship to one on board facing toward the bow; port; -- opposed to starboard.",
   "Larcener": "Alt. of Larcenist",
   "Larcenist": "One who commits larceny.",
   "Larceny": "The unlawful taking and carrying away of things personal with intent to deprive the right owner of the same; theft. Cf. Embezzlement.",
   "Larch": "A genus of coniferous trees, having deciduous leaves, in fascicles (see Illust. of Fascicle).",
   "Lard": "Bacon; the flesh of swine.",
   "Lard": "The fat of swine, esp. the internal fat of the abdomen; also, this fat melted and strained.",
   "Lard": "To stuff with bacon; to dress or enrich with lard; esp., to insert lardons of bacon or pork in the surface of, before roasting; as, to lard poultry.",
   "Lard": "To fatten; to enrich.",
   "Lard": "To smear with lard or fat.",
   "Lard": "To mix or garnish with something, as by way of improvement; to interlard.",
   "Lardacein": "A peculiar amyloid substance, colored blue by iodine and sulphuric acid, occurring mainly as an abnormal infiltration into the spleen, liver, etc.",
   "Larder": "A room or place where meat and other articles of food are kept before they are cooked.",
   "Larderer": "One in charge of the larder.",
   "Lardery": "A larder.",
   "Lardon": "Alt. of Lardoon",
   "Lardoon": "A bit of fat pork or bacon used in larding.",
   "Lardry": "A larder.",
   "Lare": "Lore; learning.",
   "Lare": "Pasture; feed. See Lair.",
   "Large": "A musical note, formerly in use, equal to two longs, four breves, or eight semibreves.",
   "Largeness": "The quality or state of being large.",
   "Larget": "A sport piece of bar iron for rolling into a sheet; a small billet.",
   "Largo": "A movement or piece in largo time.",
   "Lariat": "A long, slender rope made of hemp or strips of hide, esp. one with a noose; -- used as a lasso for catching cattle, horses, etc., and for picketing a horse so that he can graze without wandering.",
   "Lark": "Any one numerous species of singing birds of the genus Alauda and allied genera (family Alaudidae). They mostly belong to Europe, Asia, and Northern Africa. In America they are represented by the shore larks, or horned by the shore larks, or horned larks, of the genus Otocoris. The true larks have holaspidean tarsi, very long hind claws, and usually, dull, sandy brown colors.",
   "Larker": "A catcher of larks.",
   "Larker": "One who indulges in a lark or frolic.",
   "Lark's-heel": "Indian cress.",
   "Larkspur": "A genus of ranunculaceous plants (Delphinium), having showy flowers, and a spurred calyx. They are natives of the North Temperate zone. The commonest larkspur of the gardens is D. Consolida. The flower of the bee larkspur (D. elatum) has two petals bearded with yellow hairs, and looks not unlike a bee.",
   "Larmier": "See Tearpit.",
   "Larry": "Same as Lorry, or Lorrie.",
   "Larum": "See Alarum, and Alarm.",
   "Larva": "Any young insect from the time that it hatches from the egg until it becomes a pupa, or chrysalis. During this time it usually molts several times, and may change its form or color each time. The larvae of many insects are much like the adults in form and habits, but have no trace of wings, the rudimentary wings appearing only in the pupa stage. In other groups of insects the larvae are totally unlike the parents in structure and habits, and are called caterpillars, grubs, maggots, etc.",
   "Larva": "The early, immature form of any animal when more or less of a metamorphosis takes place, before the assumption of the mature shape.",
   "Larve": "A larva.",
   "Lary": "A guillemot; -- called also lavy.",
   "Larypgismus": "A spasmodic state of the glottis, giving rise to contraction or closure of the opening.",
   "Laryngitis": "Inflammation of the larynx.",
   "Laryngologist": "One who applies himself to laryngology.",
   "Laryngology": "Systematized knowledge of the action and functions of the larynx; in pathology, the department which treats of the diseases of the larynx.",
   "Laryngophony": "The sound of the voice as heard through a stethoscope when the latter is placed upon the larynx.",
   "Larungoscope": "An instrument, consisting of an arrangement of two mirrors, for reflecting light upon the larynx, and for examining its image.",
   "Laryngoscopist": "One skilled in laryngoscopy.",
   "Laryngoscopy": "The art of using the laryngoscope; investigations made with the laryngoscope.",
   "Laryngotome": "An instrument for performing laryngotomy.",
   "Laryngotomy": "The operation of cutting into the larynx, from the outside of the neck, for assisting respiration when obstructed, or for removing foreign bodies.",
   "Laryngotracheotomy": "The operation of cutting into the larynx and the upper part of the trachea, -- a frequent operation for obstruction to breathing.",
   "Larynx": "The expanded upper end of the windpipe or trachea, connected with the hyoid bone or cartilage. It contains the vocal cords, which produce the voice by their vibrations, when they are stretched and a current of air passes between them. The larynx is connected with the pharynx by an opening, the glottis, which, in mammals, is protected by a lidlike epiglottis.",
   "Las": "A lace. See Lace.",
   "Lascar": "A native sailor, employed in European vessels; also, a menial employed about arsenals, camps, camps, etc.; a camp follower.",
   "Lasciviency": "Lasciviousness; wantonness.",
   "Laserwort": "Any plant of the umbelliferous genus Laserpitium, of several species (as L. glabrum, and L. siler), the root of which yields a resinous substance of a bitter taste. The genus is mostly European.",
   "Lash": "The thong or braided cord of a whip, with which the blow is given.",
   "Lash": "A leash in which an animal is caught or held; hence, a snare.",
   "Lash": "A stroke with a whip, or anything pliant and tough; as, the culprit received thirty-nine lashes.",
   "Lash": "A stroke of satire or sarcasm; an expression or retort that cuts or gives pain; a cut.",
   "Lash": "A hair growing from the edge of the eyelid; an eyelash.",
   "Lash": "In carpet weaving, a group of strings for lifting simultaneously certain yarns, to form the figure.",
   "Lash": "To bind with a rope, cord, thong, or chain, so as to fasten; as, to lash something to a spar; to lash a pack on a horse's back.",
   "Lasher": "One who whips or lashes.",
   "Lasher": "A piece of rope for binding or making fast one thing to another; -- called also lashing.",
   "Lasher": "A weir in a river.",
   "Lashing": "The act of one who, or that which, lashes; castigation; chastisement.",
   "Lashing": "See 2d Lasher.",
   "Lask": "A diarrhea or flux.",
   "Lasket": "latching.",
   "Lass": "A youth woman; a girl; a sweetheart.",
   "Lassie": "A young girl; a lass.",
   "Lassitude": "A condition of the body, or mind, when its voluntary functions are performed with difficulty, and only by a strong exertion of the will; languor; debility; weariness.",
   "Lasso": "A rope or long thong of leather with, a running noose, used for catching horses, cattle, etc.",
   "Last": "A load; a heavy burden; hence, a certain weight or measure, generally estimated at 4,000 lbs., but varying for different articles and in different countries. In England, a last of codfish, white herrings, meal, or ashes, is twelve barrels; a last of corn, ten quarters, or eighty bushels, in some parts of England, twenty-one quarters; of gunpowder, twenty-four barrels, each containing 100 lbs; of red herrings, twenty cades, or 20,000; of hides, twelve dozen; of leather, twenty dickers; of pitch and tar, fourteen barrels; of wool, twelve sacks; of flax or feathers, 1,700 lbs.",
   "Last": "The burden of a ship; a cargo.",
   "Lastage": "A duty exacted, in some fairs or markets, for the right to carry things where one will.",
   "Lastage": "A tax on wares sold by the last.",
   "Lastage": "The lading of a ship; also, ballast.",
   "Lastage": "Room for stowing goods, as in a ship.",
   "Laster": "A workman whose business it is to shape boots or shoes, or place leather smoothly, on lasts; a tool for stretching leather on a last.",
   "Lastery": "A red color.",
   "Lasting": "Continuance; endurance.",
   "Lasting": "A species of very durable woolen stuff, used for women's shoes; everlasting.",
   "Lasting": "The act or process of shaping on a last.",
   "Latakia": "A superior quality of Turkish smoking tobacco, so called from the place where produced, the ancient Laodicea.",
   "Latch": "That which fastens or holds; a lace; a snare.",
   "Latch": "A movable piece which holds anything in place by entering a notch or cavity; specifically, the catch which holds a door or gate when closed, though it be not bolted.",
   "Latch": "A latching.",
   "Latch": "A crossbow.",
   "Latch": "To catch so as to hold.",
   "Latch": "To catch or fasten by means of a latch.",
   "Latchet": "The string that fastens a shoe; a shoestring.",
   "Latching": "A loop or eye formed on the head rope of a bonnet, by which it is attached to the foot of a sail; -- called also latch and lasket.",
   "Latchkey": "A key used to raise, or throw back, the latch of a door, esp. a night latch.",
   "Latchstring": "A string for raising the latch of a door by a person outside. It is fastened to the latch and passed through a hole above it in the door.",
   "Latence": "Latency.",
   "Latency": "The state or quality of being latent.",
   "Lateness": "The state, condition, or quality, of being late; as, the lateness of his arrival; the lateness of the hour; the lateness of the season.",
   "Later": "A brick or tile.",
   "Laterality": "The state or condition of being lateral.",
   "Lateran": "The church and palace of St. John Lateran, the church being the cathedral church of Rome, and the highest in rank of all churches in the Catholic world.",
   "Laterite": "An argillaceous sandstone, of a red color, and much seamed; -- found in India.",
   "Lates": "A genus of large percoid fishes, of which one species (Lates Niloticus) inhabits the Nile, and another (L. calcarifer) is found in the Ganges and other Indian rivers. They are valued as food fishes.",
   "Latescence": "A slight withdrawal from view or knowledge.",
   "Latewake": "See Lich wake, under Lich.",
   "Latex": "A milky or colored juice in certain plants in cavities (called latex cells or latex tubes). It contains the peculiar principles of the plants, whether aromatic, bitter, or acid, and in many instances yields caoutchouc upon coagulation.",
   "Lath": "A thin, narrow strip of wood, nailed to the rafters, studs, or floor beams of a building, for the purpose of supporting the tiles, plastering, etc. A corrugated metallic strip or plate is sometimes used.",
   "Lathe": "Formerly, a part or division of a county among the Anglo-Saxons. At present it consists of four or five hundreds, and is confined to the county of Kent.",
   "Lathe": "A granary; a barn.",
   "Lathe": "A machine for turning, that is, for shaping articles of wood, metal, or other material, by causing them to revolve while acted upon by a cutting tool.",
   "Lathe": "The movable swing frame of a loom, carrying the reed for separating the warp threads and beating up the weft; -- called also lay and batten.",
   "Lather": "Foam or froth made by soap moistened with water.",
   "Lather": "Foam from profuse sweating, as of a horse.",
   "Lather": "To spread over with lather; as, to lather the face.",
   "Lathereeve": "Alt. of Lathreeve",
   "Lathreeve": "Formerly, the head officer of a lathe. See 1st Lathe.",
   "Lathing": "The act or process of covering with laths; laths, collectively; a covering of laths.",
   "Lathwork": "Same as Lathing.",
   "Latibulum": "A concealed hiding place; a burrow; a lair; a hole.",
   "Laticlave": "A broad stripe of purple on the fore part of the tunic, worn by senators in ancient Rome as an emblem of office.",
   "Latimer": "An interpreter. [Obs.] Coke.",
   "Latin": "A native or inhabitant of Latium; a Roman.",
   "Latin": "The language of the ancient Romans.",
   "Latin": "An exercise in schools, consisting in turning English into Latin.",
   "Latin": "A member of the Roman Catholic Church.",
   "Latinism": "A Latin idiom; a mode of speech peculiar to Latin; also, a mode of speech in another language, as English, formed on a Latin model.",
   "Latinist": "One skilled in Latin; a Latin scholar.",
   "Latinitaster": "One who has but a smattering of Latin.",
   "Latinity": "The Latin tongue, style, or idiom, or the use thereof; specifically, purity of Latin style or idiom.",
   "Latinization": "The act or process of Latinizing, as a word, language, or country.",
   "Lation": "Transportation; conveyance.",
   "Latitancy": "Act or state of lying hid, or lurking.",
   "Latitat": "A writ based upon the presumption that the person summoned was hiding.",
   "Latitation": "A lying in concealment; hiding.",
   "Latitude": "Extent from side to side, or distance sidewise from a given point or line; breadth; width.",
   "Latitude": "Room; space; freedom from confinement or restraint; hence, looseness; laxity; independence.",
   "Latitude": "Extent or breadth of signification, application, etc.; extent of deviation from a standard, as truth, style, etc.",
   "Latitude": "Extent; size; amplitude; scope.",
   "Latitude": "Distance north or south of the equator, measured on a meridian.",
   "Latitude": "The angular distance of a heavenly body from the ecliptic.",
   "Latitudinarian": "One who is moderate in his notions, or not restrained by precise settled limits in opinion; one who indulges freedom in thinking.",
   "Latitudinarian": "A member of the Church of England, in the time of Charles II., who adopted more liberal notions in respect to the authority, government, and doctrines of the church than generally prevailed.",
   "Latitudinarian": "One who departs in opinion from the strict principles of orthodoxy.",
   "Latitudinarianism": "A latitudinarian system or condition; freedom of opinion in matters pertaining to religious belief.",
   "Laton": "Alt. of Latoun",
   "Latoun": "Latten, 1.",
   "Latration": "A barking.",
   "Latria": "The highest kind of worship, or that paid to God; -- distinguished by the Roman Catholics from dulia, or the inferior worship paid to saints.",
   "Latrine": "A privy, or water-closet, esp. in a camp, hospital, etc.",
   "Latrociny": "Theft; larceny.",
   "Latten": "A kind of brass hammered into thin sheets, formerly much used for making church utensils, as candlesticks, crosses, etc.; -- called also latten brass.",
   "Latten": "Sheet tin; iron plate, covered with tin; also, any metal in thin sheets; as, gold latten.",
   "Latterkin": "A pointed wooden tool used in glazing leaden lattice.",
   "Lattermath": "The latter, or second, mowing; the aftermath.",
   "Lattice": "Any work of wood or metal, made by crossing laths, or thin strips, and forming a network; as, the lattice of a window; -- called also latticework.",
   "Lattice": "The representation of a piece of latticework used as a bearing, the bands being vertical and horizontal.",
   "Latticework": "Same as Lattice, n., 1.",
   "Latticing": "The act or process of making a lattice of, or of fitting a lattice to.",
   "Latticing": "A system of bars crossing in the middle to form braces between principal longitudinal members, as of a strut.",
   "Laudability": "Laudableness; praiseworthiness.",
   "Laudableness": "The quality of being laudable; praiseworthiness; commendableness.",
   "Laudanine": "A white organic base, resembling morphine, and obtained from certain varieties of opium.",
   "Laudanum": "Tincture of opium, used for various medical purposes.",
   "Laudative": "A panegyric; a eulogy.",
   "Laudator": "One who lauds.",
   "Laudator": "An arbitrator.",
   "Lauder": "One who lauds.",
   "Laugh": "An expression of mirth peculiar to the human species; the sound heard in laughing; laughter. See Laugh, v. i.",
   "Laugher": "One who laughs.",
   "Laugher": "A variety of the domestic pigeon.",
   "Laughingstock": "An object of ridicule; a butt of sport.",
   "Laumontite": "A mineral, of a white color and vitreous luster. It is a hydrous silicate of alumina and lime. Exposed to the air, it loses water, becomes opaque, and crumbles.",
   "Launce": "A lance.",
   "Launce": "A balance.",
   "Launce": "See Lant, the fish.",
   "Launcegaye": "See Langegaye.",
   "Launch": "The act of launching.",
   "Launch": "The movement of a vessel from land into the water; especially, the sliding on ways from the stocks on which it is built.",
   "Launch": "The boat of the largest size belonging to a ship of war; also, an open boat of any size driven by steam, naphtha, electricity, or the like.",
   "Laund": "A plain sprinkled with trees or underbrush; a glade.",
   "Launder": "A washerwoman.",
   "Launder": "A trough used by miners to receive the powdered ore from the box where it is beaten, or for carrying water to the stamps, or other apparatus, for comminuting, or sorting, the ore.",
   "Launderer": "One who follows the business of laundering.",
   "Laundering": "The act, or occupation, of one who launders; washing and ironing.",
   "Laundress": "A woman whose employment is laundering.",
   "Laundry": "A laundering; a washing.",
   "Laundry": "A place or room where laundering is done.",
   "Laundryman": "A man who follows the business of laundering.",
   "Laura": "A number of hermitages or cells in the same neighborhood occupied by anchorites who were under the same superior.",
   "Laurate": "A salt of lauric acid.",
   "Laureate": "One crowned with laurel; a poet laureate.",
   "Laureateship": "State, or office, of a laureate.",
   "Laureation": "The act of crowning with laurel; the act of conferring an academic degree, or honorary title.",
   "Laurel": "An evergreen shrub, of the genus Laurus (L. nobilis), having aromatic leaves of a lanceolate shape, with clusters of small, yellowish white flowers in their axils; -- called also sweet bay.",
   "Laurel": "A crown of laurel; hence, honor; distinction; fame; -- especially in the plural; as, to win laurels.",
   "Laurel": "An English gold coin made in 1619, and so called because the king's head on it was crowned with laurel.",
   "Laurer": "Laurel.",
   "Laurestine": "The Viburnum Tinus, an evergreen shrub or tree of the south of Europe, which flowers during the winter mouths.",
   "Laurin": "A white crystalline substance extracted from the fruit of the bay (Laurus nobilis), and consisting of a complex mixture of glycerin ethers of several organic acids.",
   "Laurinol": "Ordinary camphor; -- so called in allusion to the family name (Lauraceae) of the camphor trees. See Camphor.",
   "Lauriol": "Spurge laurel.",
   "Laurite": "A rare sulphide of osmium and ruthenium found with platinum in Borneo and Oregon.",
   "Laurone": "The ketone of lauric acid.",
   "Laurus": "A genus of trees including, according to modern authors, only the true laurel (Laurus nobilis), and the larger L. Canariensis of Madeira and the Canary Islands. Formerly the sassafras, the camphor tree, the cinnamon tree, and several other aromatic trees and shrubs, were also referred to the genus Laurus.",
   "Lava": "The melted rock ejected by a volcano from its top or fissured sides. It flows out in streams sometimes miles in length. It also issues from fissures in the earth's surface, and forms beds covering many square miles, as in the Northwestern United States.",
   "Lavaret": "A European whitefish (Coregonus laveretus), found in the mountain lakes of Sweden, Germany, and Switzerland.",
   "Lavation": "A washing or cleansing.",
   "Lavatory": "A place for washing.",
   "Lavatory": "A basin or other vessel for washing in.",
   "Lavatory": "A wash or lotion for a diseased part.",
   "Lavatory": "A place where gold is obtained by washing.",
   "Lavature": "A wash or lotion.",
   "Lave": "The remainder; others.",
   "Lavement": "A washing or bathing; also, a clyster.",
   "Lavender": "An aromatic plant of the genus Lavandula (L. vera), common in the south of Europe. It yields and oil used in medicine and perfumery. The Spike lavender (L. Spica) yields a coarser oil (oil of spike), used in the arts.",
   "Lavender": "The pale, purplish color of lavender flowers, paler and more delicate than lilac.",
   "Laver": "A vessel for washing; a large basin.",
   "Laver": "A large brazen vessel placed in the court of the Jewish tabernacle where the officiating priests washed their hands and feet.",
   "Laver": "One of several vessels in Solomon's Temple in which the offerings for burnt sacrifices were washed.",
   "Laver": "That which washes or cleanses.",
   "Laver": "One who laves; a washer.",
   "Laver": "The fronds of certain marine algae used as food, and for making a sauce called laver sauce. Green laver is the Ulva latissima; purple laver, Porphyra laciniata and P. vulgaris. It is prepared by stewing, either alone or with other vegetables, and with various condiments; -- called also sloke, or sloakan.",
   "Laverock": "The lark.",
   "Lavisher": "One who lavishes.",
   "Lavishment": "The act of lavishing.",
   "Lavishness": "The quality or state of being lavish.",
   "Lav/sium": "A supposed new metallic element. It is said to have been discovered in pyrites, and some other minerals, and to be of a silver-white color, and malleable.",
   "Lavolt": "Alt. of Lavolta",
   "Lavolta": "An old dance, for two persons, being a kind of waltz, in which the woman made a high spring or bound.",
   "Lavoltateer": "A dancer of the lavolta.",
   "Lavour": "A laver.",
   "Lavrock": "Same as Laverock.",
   "Law": "In general, a rule of being or of conduct, established by an authority able to enforce its will; a controlling regulation; the mode or order according to which an agent or a power acts.",
   "Law": "In morals: The will of God as the rule for the disposition and conduct of all responsible beings toward him and toward each other; a rule of living, conformable to righteousness; the rule of action as obligatory on the conscience or moral nature.",
   "Law": "The Jewish or Mosaic code, and that part of Scripture where it is written, in distinction from the gospel; hence, also, the Old Testament.",
   "Law": "An organic rule, as a constitution or charter, establishing and defining the conditions of the existence of a state or other organized community.",
   "Law": "Any edict, decree, order, ordinance, statute, resolution, judicial, decision, usage, etc., or recognized, and enforced, by the controlling authority.",
   "Law": "In philosophy and physics: A rule of being, operation, or change, so certain and constant that it is conceived of as imposed by the will of God or by some controlling authority; as, the law of gravitation; the laws of motion; the law heredity; the laws of thought; the laws of cause and effect; law of self-preservation.",
   "Law": "In matematics: The rule according to which anything, as the change of value of a variable, or the value of the terms of a series, proceeds; mode or order of sequence.",
   "Law": "In arts, works, games, etc.: The rules of construction, or of procedure, conforming to the conditions of success; a principle, maxim; or usage; as, the laws of poetry, of architecture, of courtesy, or of whist.",
   "Law": "Collectively, the whole body of rules relating to one subject, or emanating from one source; -- including usually the writings pertaining to them, and judicial proceedings under them; as, divine law; English law; Roman law; the law of real property; insurance law.",
   "Law": "Legal science; jurisprudence; the principles of equity; applied justice.",
   "Law": "Trial by the laws of the land; judicial remedy; litigation; as, to go law.",
   "Law": "An oath, as in the presence of a court.",
   "Lawbreaker": "One who disobeys the law; a criminal.",
   "Lawer": "A lawyer.",
   "Lawgiver": "One who makes or enacts a law or system of laws; a legislator.",
   "Lawing": "Going to law; litigation.",
   "Lawing": "Expeditation.",
   "Lawmaker": "A legislator; a lawgiver.",
   "Lammaking": "The enacting of laws; legislation.",
   "Lawmonger": "A trader in law; one who practices law as if it were a trade.",
   "Lawn": "An open space between woods.",
   "Lawn": "Ground (generally in front of or around a house) covered with grass kept closely mown.",
   "Lawm": "A very fine linen (or sometimes cotton) fabric with a rather open texture. Lawn is used for the sleeves of a bishop's official dress in the English Church, and, figuratively, stands for the office itself.",
   "Lawnd": "See Laund.",
   "Lawsonia": "An Asiatic and North African shrub (Lawsonia inermis), with smooth oval leaves, and fragrant white flowers. Henna is prepared from the leaves and twigs. In England the shrub is called Egyptian privet, and in the West Indies, Jamaica mignonette.",
   "Lawsuit": "An action at law; a suit in equity or admiralty; any legal proceeding before a court for the enforcement of a claim.",
   "Lawyer": "One versed in the laws, or a practitioner of law; one whose profession is to conduct lawsuits for clients, or to advise as to prosecution or defence of lawsuits, or as to legal rights and obligations in other matters. It is a general term, comprehending attorneys, counselors, solicitors, barristers, sergeants, and advocates.",
   "Lawyer": "The black-necked stilt. See Stilt.",
   "Lawyer": "The bowfin (Amia calva).",
   "Lawyer": "The burbot (Lota maculosa).",
   "Lax": "A looseness; diarrhea.",
   "Laxation": "The act of loosening or slackening, or the state of being loosened or slackened.",
   "Laxative": "A laxative medicine. See the Note under Cathartic.",
   "Laxativeness": "The quality of being laxative.",
   "Laxator": "That which loosens; -- esp., a muscle which by its contraction loosens some part.",
   "Laxness": "The state of being lax; laxity.",
   "Lay": "The laity; the common people.",
   "Lay": "A meadow. See Lea.",
   "Lay": "Faith; creed; religious profession.",
   "Lay": "A law.",
   "Lay": "An obligation; a vow.",
   "Lay": "That which lies or is laid or is conceived of as having been laid or placed in its position; a row; a stratum; a layer; as, a lay of stone or wood.",
   "Layer": "One who, or that which, lays.",
   "Layer": "That which is laid; a stratum; a bed; one thickness, course, or fold laid over another; as, a layer of clay or of sand in the earth; a layer of bricks, or of plaster; the layers of an onion.",
   "Layer": "A shoot or twig of a plant, not detached from the stock, laid under ground for growth or propagation.",
   "Layer": "An artificial oyster bed.",
   "Layering": "A propagating by layers.",
   "Laying": "The act of one who, or that which, lays.",
   "Laying": "The act or period of laying eggs; the eggs laid for one incubation; a clutch.",
   "Laying": "The first coat on laths of plasterer's two-coat work.",
   "Layland": "Land lying untilled; fallow ground.",
   "Layman": "One of the people, in distinction from the clergy; one of the laity; sometimes, a man not belonging to some particular profession, in distinction from those who do.",
   "Layman": "A lay figure. See under Lay, n. (above).",
   "Layner": "A whiplash.",
   "Layship": "The condition of being a layman.",
   "Laystall": "A place where rubbish, dung, etc., are laid or deposited.",
   "Laystall": "A place where milch cows are kept, or cattle on the way to market are lodged.",
   "Lazar": "A person infected with a filthy or pestilential disease; a leper.",
   "Lazaret": "Alt. of Lazaretto",
   "Lazaretto": "A public building, hospital, or pesthouse for the reception of diseased persons, particularly those affected with contagious diseases.",
   "Lazarist": "Alt. of Lazarite",
   "Lazarite": "One of the Congregation of the Priests of the Mission, a religious institute founded by Vincent de Paul in 1624, and popularly called Lazarists or Lazarites from the College of St. Lazare in Paris, which was occupied by them until 1792.",
   "Lazarwort": "Laserwort.",
   "Laziness": "The state or quality of being lazy.",
   "Lazuli": "A mineral of a fine azure-blue color, usually in small rounded masses. It is essentially a silicate of alumina, lime, and soda, with some sodium sulphide, is often marked by yellow spots or veins of sulphide of iron, and is much valued for ornamental work. Called also lapis lazuli, and Armenian stone.",
   "Lazulite": "A mineral of a light indigo-blue color, occurring in small masses, or in monoclinic crystals; blue spar. It is a hydrous phosphate of alumina and magnesia.",
   "Lazyback": "A support for the back, attached to the seat of a carriage.",
   "Lazybones": "A lazy person.",
   "Lea": "A measure of yarn; for linen, 300 yards; for cotton, 120 yards; a lay.",
   "Lea": "A set of warp threads carried by a loop of the heddle.",
   "Lea": "A meadow or sward land; a grassy field.",
   "Leach": "See 3d Leech.",
   "Leach": "A quantity of wood ashes, through which water passes, and thus imbibes the alkali.",
   "Leach": "A tub or vat for leaching ashes, bark, etc.",
   "Leach": "See Leech, a physician.",
   "Lead": "One of the elements, a heavy, pliable, inelastic metal, having a bright, bluish color, but easily tarnished. It is both malleable and ductile, though with little tenacity, and is used for tubes, sheets, bullets, etc. Its specific gravity is 11.37. It is easily fusible, forms alloys with other metals, and is an ingredient of solder and type metal. Atomic weight, 206.4. Symbol Pb (L. Plumbum). It is chiefly obtained from the mineral galena, lead sulphide.",
   "Lead": "An article made of lead or an alloy of lead",
   "Lead": "A plummet or mass of lead, used in sounding at sea.",
   "Lead": "A thin strip of type metal, used to separate lines of type in printing.",
   "Lead": "Sheets or plates of lead used as a covering for roofs; hence, pl., a roof covered with lead sheets or terne plates.",
   "Lead": "A small cylinder of black lead or plumbago, used in pencils.",
   "Lead": "The act of leading or conducting; guidance; direction; as, to take the lead; to be under the lead of another.",
   "Lead": "precedence; advance position; also, the measure of precedence; as, the white horse had the lead; a lead of a boat's length, or of half a second.",
   "Lead": "The act or right of playing first in a game or round; the card suit, or piece, so played; as, your partner has the lead.",
   "Lead": "An open way in an ice field.",
   "Lead": "A lode.",
   "Lead": "The course of a rope from end to end.",
   "Lead": "The width of port opening which is uncovered by the valve, for the admission or release of steam, at the instant when the piston is at end of its stroke.",
   "Lead": "the distance of haul, as from a cutting to an embankment.",
   "Lead": "The action of a tooth, as a tooth of a wheel, in impelling another tooth or a pallet.",
   "Leader": "One who, or that which, leads or conducts; a guide; a conductor.",
   "Leader": "One who goes first.",
   "Leader": "One having authority to direct; a chief; a commander.",
   "Leader": "A performer who leads a band or choir in music; also, in an orchestra, the principal violinist; the one who plays at the head of the first violins.",
   "Leader": "A block of hard wood pierced with suitable holes for leading ropes in their proper places.",
   "Leader": "The principal wheel in any kind of machinery.",
   "Leader": "A horse placed in advance of others; one of the forward pair of horses.",
   "Leader": "A pipe for conducting rain water from a roof to a cistern or to the ground; a conductor.",
   "Leader": "A net for leading fish into a pound, weir, etc. ; also, a line of gut, to which the snell of a fly hook is attached.",
   "Leader": "A branch or small vein, not important in itself, but indicating the proximity of a better one.",
   "Leader": "The first, or the principal, editorial article in a newspaper; a leading or main editorial article.",
   "Leader": "A type having a dot or short row of dots upon its face.",
   "Leader": "a row of dots, periods, or hyphens, used in tables of contents, etc., to lead the eye across a space to the right word or number.",
   "Leadership": "The office of a leader.",
   "Leadhillite": "A mineral of a yellowish or greenish white color, consisting of the sulphate and carbonate of lead; -- so called from having been first found at Leadhills, Scotland.",
   "Leading": "The act of guiding, directing, governing, or enticing; guidance.",
   "Leading": "Suggestion; hint; example.",
   "Leadman": "One who leads a dance.",
   "Leadsman": "The man who heaves the lead.",
   "Leadwort": "A genus of maritime herbs (Plumbago). P. Europaea has lead-colored spots on the leaves, and nearly lead-colored flowers.",
   "Leaf": "A colored, usually green, expansion growing from the side of a stem or rootstock, in which the sap for the use of the plant is elaborated under the influence of light; one of the parts of a plant which collectively constitute its foliage.",
   "Leaf": "A special organ of vegetation in the form of a lateral outgrowth from the stem, whether appearing as a part of the foliage, or as a cotyledon, a scale, a bract, a spine, or a tendril.",
   "Leaf": "Something which is like a leaf in being wide and thin and having a flat surface, or in being attached to a larger body by one edge or end; as : (a) A part of a book or folded sheet containing two pages upon its opposite sides. (b) A side, division, or part, that slides or is hinged, as of window shutters, folding doors, etc. (c) The movable side of a table. (d) A very thin plate; as, gold leaf. (e) A portion of fat lying in a separate fold or layer. (f) One of the teeth of a pinion, especially when small.",
   "Leafage": "Leaves, collectively; foliage.",
   "Leafcup": "A coarse American composite weed (Polymnia Uvedalia).",
   "Leafet": "A leaflet.",
   "Leafiness": "The state of being leafy.",
   "Leaflet": "A little leaf; also, a little printed leaf or a tract.",
   "Leaflet": "One of the divisions of a compound leaf; a foliole.",
   "Leaflet": "A leaflike organ or part; as, a leaflet of the gills of fishes.",
   "Leaf-nosed": "Having a leaflike membrane on the nose; -- said of certain bats, esp. of the genera Phyllostoma and Rhinonycteris. See Vampire.",
   "Leafstalk": "The stalk or petiole which supports a leaf.",
   "League": "A measure of length or distance, varying in different countries from about 2.4 to 4.6 English statute miles of 5.280 feet each, and used (as a land measure) chiefly on the continent of Europe, and in the Spanish parts of America. The marine league of England and the United States is equal to three marine, or geographical, miles of 6080 feet each.",
   "League": "A stone erected near a public road to mark the distance of a league.",
   "League": "An alliance or combination of two or more nations, parties, or persons, for the accomplishment of a purpose which requires a continued course of action, as for mutual defense, or for furtherance of commercial, religious, or political interests, etc.",
   "Leaguer": "The camp of a besieging army; a camp in general.",
   "Leaguer": "A siege or beleaguering.",
   "Leaguerer": "A besieger.",
   "Leak": "To let water or other fluid in or out through a hole, crevice, etc.; as, the cask leaks; the roof leaks; the boat leaks.",
   "Leak": "To enter or escape, as a fluid, through a hole, crevice, etc. ; to pass gradually into, or out of, something; -- usually with in or out.",
   "Leakage": "A leaking; also, the quantity that enters or issues by leaking.",
   "Leakage": "An allowance of a certain rate per cent for the leaking of casks, or waste of liquors by leaking.",
   "Leakiness": "The quality of being leaky.",
   "Leam": "A cord or strap for leading a dog.",
   "Leamer": "A dog held by a leam.",
   "Lean": "That part of flesh which consist principally of muscle without the fat.",
   "Lean": "Unremunerative copy or work.",
   "Leaning": "The act, or state, of inclining; inclination; tendency; as, a leaning towards Calvinism.",
   "Leanness": "The condition or quality of being lean.",
   "Lean-to": "A shed or slight building placed against the wall of a larger structure and having a single-pitched roof; -- called also penthouse, and to-fall.",
   "Leap": "A basket.",
   "Leap": "A weel or wicker trap for fish.",
   "Leap": "The act of leaping, or the space passed by leaping; a jump; a spring; a bound.",
   "Leap": "Copulation with, or coverture of, a female beast.",
   "Leap": "A fault.",
   "Leap": "A passing from one note to another by an interval, especially by a long one, or by one including several other and intermediate intervals.",
   "Leaper": "One who, or that which, leaps.",
   "Leaper": "A kind of hooked instrument for untwisting old cordage.",
   "Leapfrog": "A play among boys, in which one stoops down and another leaps over him by placing his hands on the shoulders of the former.",
   "Leapful": "A basketful.",
   "Lear": "Lore; lesson.",
   "Lear": "An annealing oven. See Leer, n.",
   "Learner": "One who learns; a scholar.",
   "Learning": "The acquisition of knowledge or skill; as, the learning of languages; the learning of telegraphy.",
   "Learning": "The knowledge or skill received by instruction or study; acquired knowledge or ideas in any branch of science or literature; erudition; literature; science; as, he is a man of great learning.",
   "Leasehold": "A tenure by lease; specifically, land held as personalty under a lease for years.",
   "Leaseholder": "A tenant under a lease.",
   "Leaser": "One who leases or gleans.",
   "Leaser": "A liar.",
   "Leash": "A thong of leather, or a long cord, by which a falconer holds his hawk, or a courser his dog.",
   "Leash": "A brace and a half; a tierce; three; three creatures of any kind, especially greyhounds, foxes, bucks, and hares; hence, the number three in general.",
   "Leash": "A string with a loop at the end for lifting warp threads, in a loom.",
   "Leasow": "A pasture.",
   "Leat": "An artificial water trench, esp. one to or from a mill.",
   "Leather": "The skin of an animal, or some part of such skin, tanned, tawed, or otherwise dressed for use; also, dressed hides, collectively.",
   "Leather": "The skin.",
   "Leatherback": "A large sea turtle (Sphargis coriacea), having no bony shell on its back. It is common in the warm and temperate parts of the Atlantic, and sometimes weighs over a thousand pounds; -- called also leather turtle, leathery turtle, leather-backed tortoise, etc.",
   "Leatheret": "Alt. of Leatherette",
   "Leatherette": "An imitation of leather, made of paper and cloth.",
   "Leatherhead": "The friar bird.",
   "Leatherneck": "The sordid friar bird of Australia (Tropidorhynchus sordidus).",
   "Leatherwood": "A small branching shrub (Dirca palustris), with a white, soft wood, and a tough, leathery bark, common in damp woods in the Northern United States; -- called also moosewood, and wicopy.",
   "Leave": "Liberty granted by which restraint or illegality is removed; permission; allowance; license.",
   "Leave": "The act of leaving or departing; a formal parting; a leaving; farewell; adieu; -- used chiefly in the phrase, to take leave, i. e., literally, to take permission to go.",
   "Leaven": "Any substance that produces, or is designed to produce, fermentation, as in dough or liquids; esp., a portion of fermenting dough, which, mixed with a larger quantity of dough, produces a general change in the mass, and renders it light; yeast; barm.",
   "Leaven": "Anything which makes a general assimilating (especially a corrupting) change in the mass.",
   "Leavening": "The act of making light, or causing to ferment, by means of leaven.",
   "Leavening": "That which leavens or makes light.",
   "Leaver": "One who leaves, or withdraws.",
   "Leaves": "pl. of Leaf.",
   "Leave-taking": "Taking of leave; parting compliments.",
   "Leaviness": "Leafiness.",
   "Leban": "Alt. of Lebban",
   "Lebban": "Coagulated sour milk diluted with water; -- a common beverage among the Arabs. Also, a fermented liquor made of the same.",
   "Lecama": "The hartbeest.",
   "Lecanomancy": "divination practiced with water in a basin, by throwing three stones into it, and invoking the demon whose aid was sought.",
   "Lecanorin": "See Lecanoric.",
   "Leche": "See water buck, under 3d Buck.",
   "Lecher": "A man given to lewdness; one addicted, in an excessive degree, to the indulgence of sexual desire, or to illicit commerce with women.",
   "Lecherer": "See Lecher, n.",
   "Lechery": "Free indulgence of lust; lewdness.",
   "Lechery": "Selfish pleasure; delight.",
   "Lecithin": "A complex, nitrogenous phosphorized substance widely distributed through the animal body, and especially conspicuous in the brain and nerve tissue, in yolk of eggs, and in the white blood corpuscles.",
   "Lectica": "A kind of litter or portable couch.",
   "Lection": "A lesson or selection, esp. of Scripture, read in divine service.",
   "Lection": "A reading; a variation in the text.",
   "Lectionary": "A book, or a list, of lections, for reading in divine service.",
   "Lector": "A reader of lections; formerly, a person designated to read lessons to the illiterate.",
   "Lecture": "The act of reading; as, the lecture of Holy Scripture.",
   "Lecture": "A discourse on any subject; especially, a formal or methodical discourse, intended for instruction; sometimes, a familiar discourse, in contrast with a sermon.",
   "Lecture": "A reprimand or formal reproof from one having authority.",
   "Lecture": "A rehearsal of a lesson.",
   "Lecturer": "One who lectures; an assistant preacher.",
   "Lectureship": "The office of a lecturer.",
   "Lecturn": "A choir desk, or reading desk, in some churches, from which the lections, or Scripture lessons, are chanted or read; hence, a reading desk. [Written also lectern and lettern.]",
   "Lecythis": "A genus of gigantic trees, chiefly Brazilian, of the order Myrtaceae, having woody capsules opening by an apical lid. Lecythis Zabucajo yields the delicious sapucaia nuts. L. Ollaria produces the monkey-pots, its capsules. Its bark separates into thin sheets, like paper, used by the natives for cigarette wrappers.",
   "Leden": "Alt. of Ledden",
   "Ledden": "Language; speech; voice; cry.",
   "Ledge": "A shelf on which articles may be laid; also, that which resembles such a shelf in form or use, as a projecting ridge or part, or a molding or edge in joinery.",
   "Ledge": "A shelf, ridge, or reef, of rocks.",
   "Ledge": "A layer or stratum.",
   "Ledge": "A lode; a limited mass of rock bearing valuable mineral.",
   "Ledge": "A piece of timber to support the deck, placed athwartship between beams.",
   "Ledgement": "See Ledgment.",
   "Ledger": "A book in which a summary of accounts is laid up or preserved; the final book of record in business transactions, in which all debits and credits from the journal, etc., are placed under appropriate heads.",
   "Ledger": "A large flat stone, esp. one laid over a tomb.",
   "Ledger": "A horizontal piece of timber secured to the uprights and supporting floor timbers, a staircase, scaffolding, or the like. It differs from an intertie in being intended to carry weight.",
   "Ledgment": "A string-course or horizontal suit of moldings, such as the base moldings of a building.",
   "Ledgment": "The development of the surface of a body on a plane, so that the dimensions of the different sides may be easily ascertained.",
   "Lee": "That which settles at the bottom, as of a cask of liquor (esp. wine); sediment; dregs; -- used now only in the plural.",
   "Lee": "A sheltered place; esp., a place protected from the wind by some object; the side sheltered from the wind; shelter; protection; as, the lee of a mountain, an island, or a ship.",
   "Lee": "That part of the hemisphere, as one stands on shipboard, toward which the wind blows. See Lee, a.",
   "Leeboard": "A board, or frame of planks, lowered over the side of a vessel to lessen her leeway when closehauled, by giving her greater draught.",
   "Leech": "See 2d Leach.",
   "Leech": "The border or edge at the side of a sail.",
   "Leech": "A physician or surgeon; a professor of the art of healing.",
   "Leech": "Any one of numerous genera and species of annulose worms, belonging to the order Hirudinea, or Bdelloidea, esp. those species used in medicine, as Hirudo medicinalis of Europe, and allied species.",
   "Leech": "A glass tube of peculiar construction, adapted for drawing blood from a scarified part by means of a vacuum.",
   "Leechcraft": "The art of healing; skill of a physician.",
   "Leed": "Alt. of Leede",
   "Leede": "A caldron; a copper kettle.",
   "Leek": "A plant of the genus Allium (A. Porrum), having broadly linear succulent leaves rising from a loose oblong cylindrical bulb. The flavor is stronger than that of the common onion.",
   "Leer": "An oven in which glassware is annealed.",
   "Leer": "The cheek.",
   "Leer": "Complexion; aspect; appearance.",
   "Leer": "A distorted expression of the face, or an indirect glance of the eye, conveying a sinister or immodest suggestion.",
   "Leere": "Tape or braid; an ornament.",
   "Lees": "A leash.",
   "Leet": "A portion; a list, esp. a list of candidates for an office.",
   "Leet": "A court-leet; the district within the jurisdiction of a court-leet; the day on which a court-leet is held.",
   "Leet": "The European pollock.",
   "Leetman": "One subject to the jurisdiction of a court-leet.",
   "Leeward": "The lee side; the lee.",
   "Leeway": "The lateral movement of a ship to the leeward of her course; drift.",
   "Left": "That part of surrounding space toward which the left side of one's body is turned; as, the house is on the left when you face North.",
   "Left": "Those members of a legislative assembly (as in France) who are in the opposition; the advanced republicans and extreme radicals. They have their seats at the left-hand side of the presiding officer. See Center, and Right.",
   "Left-handedness": "Alt. of Left-handiness",
   "Left-handiness": "The state or quality of being left-handed; awkwardness.",
   "Leg": "A limb or member of an animal used for supporting the body, and in running, climbing, and swimming; esp., that part of the limb between the knee and foot.",
   "Leg": "That which resembles a leg in form or use; especially, any long and slender support on which any object rests; as, the leg of a table; the leg of a pair of compasses or dividers.",
   "Leg": "The part of any article of clothing which covers the leg; as, the leg of a stocking or of a pair of trousers.",
   "Leg": "A bow, esp. in the phrase to make a leg; probably from drawing the leg backward in bowing.",
   "Leg": "A disreputable sporting character; a blackleg.",
   "Leg": "The course and distance made by a vessel on one tack or between tacks.",
   "Leg": "An extension of the boiler downward, in the form of a narrow space between vertical plates, sometimes nearly surrounding the furnace and ash pit, and serving to support the boiler; -- called also water leg.",
   "Leg": "The case containing the lower part of the belt which carries the buckets.",
   "Leg": "A fielder whose position is on the outside, a little in rear of the batter.",
   "Legacy": "A gift of property by will, esp. of money or personal property; a bequest. Also Fig.; as, a legacy of dishonor or disease.",
   "Legacy": "A business with which one is intrusted by another; a commission; -- obsolete, except in the phrases last legacy, dying legacy, and the like.",
   "Legalism": "Strictness, or the doctrine of strictness, in conforming to law.",
   "Legalist": "One who practices or advocates strict conformity to law; in theology, one who holds to the law of works. See Legal, 2 (a).",
   "Legality": "The state or quality of being legal; conformity to law.",
   "Legality": "A conformity to, and resting upon, the letter of the law.",
   "Legalization": "The act of making legal.",
   "Legatary": "A legatee.",
   "Legate": "An ambassador or envoy.",
   "Legate": "An ecclesiastic representing the pope and invested with the authority of the Holy See.",
   "Legate": "An official assistant given to a general or to the governor of a province.",
   "Legate": "Under the emperors, a governor sent to a province.",
   "Legatee": "One to whom a legacy is bequeathed.",
   "Legateship": "The office of a legate.",
   "Legation": "The sending forth or commissioning one person to act for another.",
   "Legation": "A legate, or envoy, and the persons associated with him in his mission; an embassy; or, in stricter usage, a diplomatic minister and his suite; a deputation.",
   "Legation": "The place of business or official residence of a diplomatic minister at a foreign court or seat of government.",
   "Legation": "A district under the jurisdiction of a legate.",
   "Legator": "A testator; one who bequeaths a legacy.",
   "Legatura": "A tie or brace; a syncopation.",
   "Legature": "Legateship.",
   "Legement": "See Ledgment.",
   "Legend": "That which is appointed to be read; especially, a chronicle or register of the lives of saints, formerly read at matins, and in the refectories of religious houses.",
   "Legend": "A story respecting saints; especially, one of a marvelous nature.",
   "Legend": "Any wonderful story coming down from the past, but not verifiable by historical record; a myth; a fable.",
   "Legend": "An inscription, motto, or title, esp. one surrounding the field in a medal or coin, or placed upon an heraldic shield or beneath an engraving or illustration.",
   "Legendary": "A book of legends; a tale or narrative.",
   "Legendary": "One who relates legends.",
   "Leger": "Anything that lies in a place; that which, or one who, remains in a place.",
   "Leger": "A minister or ambassador resident at a court or seat of government.",
   "Leger": "A ledger.",
   "Legerdemain": "Sleight of hand; a trick of sleight of hand; hence, any artful deception or trick.",
   "Legerdemainist": "One who practices sleight of hand; a prestidigitator.",
   "Legerity": "Lightness; nimbleness.",
   "Legging": "Alt. of Leggin",
   "Leggin": "A cover for the leg, like a long gaiter.",
   "Leghorn": "A straw plaiting used for bonnets and hats, made from the straw of a particular kind of wheat, grown for the purpose in Tuscany, Italy; -- so called from Leghorn, the place of exportation.",
   "Legibility": "The quality of being legible; legibleness.",
   "Legibleness": "The state or quality of being legible.",
   "Legion": "A body of foot soldiers and cavalry consisting of different numbers at different periods, -- from about four thousand to about six thousand men, -- the cavalry being about one tenth.",
   "Legion": "A military force; an army; military bands.",
   "Legion": "A great number; a multitude.",
   "Legion": "A group of orders inferior to a class.",
   "Legionary": "A member of a legion.",
   "Legionry": "A body of legions; legions, collectively.",
   "Legislation": "The act of legislating; preparation and enactment of laws; the laws enacted.",
   "Legislator": "A lawgiver; one who makes laws for a state or community; a member of a legislative body.",
   "Legislatorship": "The office of a legislator.",
   "Legislatress": "Alt. of Legislatrix",
   "Legislatrix": "A woman who makes laws.",
   "Legislature": "The body of persons in a state or kingdom invested with power to make and repeal laws; a legislative body.",
   "Legist": "One skilled in the laws; a writer on law.",
   "Legitimateness": "The state or quality of being legitimate; lawfulness; genuineness.",
   "Legitimation": "The act of making legitimate.",
   "Legitimation": "Lawful birth.",
   "Legitimatist": "See Legitimist.",
   "Legitimism": "The principles or plans of legitimists.",
   "Legitimist": "One who supports legitimate authority; esp., one who believes in hereditary monarchy, as a divine right.",
   "Legitimist": "Specifically, a supporter of the claims of the elder branch of the Bourbon dynasty to the crown of France.",
   "Leguleian": "A lawyer.",
   "Legume": "A pod dehiscent into two pieces or valves, and having the seed attached at one suture, as that of the pea.",
   "Legume": "The fruit of leguminous plants, as peas, beans, lupines; pulse.",
   "Legumen": "Same as Legume.",
   "Legumin": "An albuminous substance resembling casein, found as a characteristic ingredient of the seeds of leguminous and grain-bearing plants.",
   "Leiger": "See Leger, n., 2.",
   "Leiotrichan": "One of the Leiotrichi.",
   "Leipoa": "A genus of Australian gallinaceous birds including but a single species (Leipoa ocellata), about the size of a turkey. Its color is variegated, brown, black, white, and gray. Called also native pheasant.",
   "Leister": "Alt. of Lister",
   "Lister": "A spear armed with three or more prongs, for striking fish.",
   "Leisure": "Freedom from occupation or business; vacant time; time free from employment.",
   "Leisure": "Time at one's command, free from engagement; convenient opportunity; hence, convenience; ease.",
   "Leitmotif": "See Leading motive, under Leading, a.",
   "Leman": "A sweetheart, of either sex; a gallant, or a mistress; -- usually in a bad sense.",
   "Leme": "A ray or glimmer of light; a gleam.",
   "Lemma": "A preliminary or auxiliary proposition demonstrated or accepted for immediate use in the demonstration of some other proposition, as in mathematics or logic.",
   "Lemman": "A leman.",
   "Lemming": "Any one of several species of small arctic rodents of the genera Myodes and Cuniculus, resembling the meadow mice in form. They are found in both hemispheres.",
   "Lemniscata": "Alt. of Lemniscate",
   "Lemniscate": "A curve in the form of the figure 8, with both parts symmetrical, generated by the point in which a tangent to an equilateral hyperbola meets the perpendicular on it drawn from the center.",
   "Lemniscus": "One of two oval bodies hanging from the interior walls of the body in the Acanthocephala.",
   "Lemon": "An oval or roundish fruit resembling the orange, and containing a pulp usually intensely acid. It is produced by a tropical tree of the genus Citrus, the common fruit known in commerce being that of the species C. Limonum or C. Medica (var. Limonum). There are many varieties of the fruit, some of which are sweet.",
   "Lemon": "The tree which bears lemons; the lemon tree.",
   "Lemonade": "A beverage consisting of lemon juice mixed with water and sweetened.",
   "Lemur": "One of a family (Lemuridae) of nocturnal mammals allied to the monkeys, but of small size, and having a sharp and foxlike muzzle, and large eyes. They feed upon birds, insects, and fruit, and are mostly natives of Madagascar and the neighboring islands, one genus (Galago) occurring in Africa. The slow lemur or kukang of the East Indies is Nycticebus tardigradus. See Galago, Indris, and Colugo.",
   "Lemuria": "A hypothetical land, or continent, supposed by some to have existed formerly in the Indian Ocean, of which Madagascar is a remnant.",
   "Lemuroid": "One of the Lemuroidea.",
   "Lena": "A procuress.",
   "Lender": "One who lends.",
   "Lending": "The act of one who lends.",
   "Lending": "That which is lent or furnished.",
   "Lene": "The smooth breathing (spiritus lenis).",
   "Lene": "Any one of the lene consonants, as p, k, or t (or Gr. /, /, /).",
   "Lengthiness": "The state or quality of being lengthy; prolixity.",
   "Lenience": "Alt. of Leniency",
   "Leniency": "The quality or state of being lenient; lenity; clemency.",
   "Lenient": "A lenitive; an emollient.",
   "Leniment": "An assuasive.",
   "Lenitive": "A medicine or application that has the quality of easing pain or protecting from the action of irritants.",
   "Lenitive": "A mild purgative; a laxative.",
   "Lenitive": "That which softens or mitigates; that which tends to allay passion, excitement, or pain; a palliative.",
   "Lenitiveness": "The quality of being lenitive.",
   "Lenitude": "The quality or habit of being lenient; lenity.",
   "Lenity": "The state or quality of being lenient; mildness of temper or disposition; gentleness of treatment; softness; tenderness; clemency; -- opposed to severity and rigor.",
   "Leno": "A light open cotton fabric used for window curtains.",
   "Lens": "A piece of glass, or other transparent substance, ground with two opposite regular surfaces, either both curved, or one curved and the other plane, and commonly used, either singly or combined, in optical instruments, for changing the direction of rays of light, and thus magnifying objects, or otherwise modifying vision. In practice, the curved surfaces are usually spherical, though rarely cylindrical, or of some other figure.",
   "Lent": "A fast of forty days, beginning with Ash Wednesday and continuing till Easter, observed by some Christian churches as commemorative of the fast of our Savior.",
   "Lenten": "Lent.",
   "Lenten": "Of or pertaining to the fast called Lent; used in, or suitable to, Lent; as, the Lenten season.",
   "Lenten": "Spare; meager; plain; somber; unostentatious; not abundant or showy.",
   "Lententide": "The season of Lenten or Lent.",
   "Lenticel": "One of the small, oval, rounded spots upon the stem or branch of a plant, from which the underlying tissues may protrude or roots may issue, either in the air, or more commonly when the stem or branch is covered with water or earth.",
   "Lenticel": "A small, lens-shaped gland on the under side of some leaves.",
   "Lenticelle": "Lenticel.",
   "Lenticula": "A kind of eruption upon the skin; lentigo; freckle.",
   "Lenticula": "A lens of small size.",
   "Lenticula": "A lenticel.",
   "Lentigo": "A freckly eruption on the skin; freckles.",
   "Lentil": "A leguminous plant of the genus Ervum (Ervum Lens), of small size, common in the fields in Europe. Also, its seed, which is used for food on the continent.",
   "Lentiscus": "Alt. of Lentisk",
   "Lentisk": "A tree; the mastic. See Mastic.",
   "L'envoi": "Alt. of L'envoy",
   "L'envoy": "One or more detached verses at the end of a literary composition, serving to convey the moral, or to address the poem to a particular person; -- orig. employed in old French poetry.",
   "L'envoy": "A conclusion; a result.",
   "Leo": "The Lion, the fifth sign of the zodiac, marked thus [/] in almanacs.",
   "Leo": "A northern constellation east of Cancer, containing the bright star Regulus at the end of the handle of the Sickle.",
   "Leod": "People; a nation; a man.",
   "Leon": "A lion.",
   "Leonid": "One of the shooting stars which constitute the star shower that recurs near the fourteenth of November at intervals of about thirty-three years; -- so called because these shooting stars appear on the heavens to move in lines directed from the constellation Leo.",
   "Leontodon": "A genus of liguliflorous composite plants, including the fall dandelion (L. autumnale), and formerly the true dandelion; -- called also lion's tooth.",
   "Leopard": "A large, savage, carnivorous mammal (Felis leopardus). It is of a yellow or fawn color, with rings or roselike clusters of black spots along the back and sides. It is found in Southern Asia and Africa. By some the panther (Felis pardus) is regarded as a variety of leopard.",
   "Leopardwood": "See Letterwood.",
   "Lepadite": "Same as Lepadoid.",
   "Lepadoid": "A stalked barnacle of the genus Lepas, or family Lepadidae; a goose barnacle. Also used adjectively.",
   "Lepal": "A sterile transformed stamen.",
   "Lepas": "Any one of various species of Lepas, a genus of pedunculated barnacles found attached to floating timber, bottoms of ships, Gulf weed, etc.; -- called also goose barnacle. See Barnacle.",
   "Leper": "A person affected with leprosy.",
   "Lepidine": "An organic base, C9H6.N.CH3, metameric with quinaldine, and obtained by the distillation of cinchonine.",
   "Lepidodendrid": "One of an extinct family of trees allied to the modern club mosses, and including Lepidodendron and its allies.",
   "Lepidodendroid": "A lepidodendrid.",
   "Lepidodendron": "A genus of fossil trees of the Devonian and Carboniferous ages, having the exterior marked with scars, mostly in quincunx order, produced by the separation of the leafstalks.",
   "Lepidoganoid": "Any one of a division (Lepidoganoidei) of ganoid fishes, including those that have scales forming a coat of mail. Also used adjectively.",
   "Lepidolite": "A species of mica, of a lilac or rose-violet color, containing lithia. It usually occurs in masses consisting of small scales. See Mica.",
   "Lepidomelane": "An iron-potash mica, of a raven-black color, usually found in granitic rocks in small six-sided tables, or as an aggregation of minute opaque scales. See Mica.",
   "Lepidopter": "One of the Lepidoptera.",
   "Lepidopterist": "One who studies the Lepidoptera.",
   "Lepidosiren": "An eel-shaped ganoid fish of the order Dipnoi, having both gills and lungs. It inhabits the rivers of South America. The name is also applied to a related African species (Protopterus annectens). The lepidosirens grow to a length of from four to six feet. Called also doko.",
   "Lepisma": "A genus of wingless thysanurous insects having an elongated flattened body, covered with shining scales and terminated by seven unequal bristles. A common species (Lepisma saccharina) is found in houses, and often injures books and furniture. Called also shiner, silver witch, silver moth, and furniture bug.",
   "Lepra": "Leprosy.",
   "Lepre": "Leprosy.",
   "Leprosity": "The state or quality of being leprous or scaly; also, a scale.",
   "Leprosy": "A cutaneous disease which first appears as blebs or as reddish, shining, slightly prominent spots, with spreading edges. These are often followed by an eruption of dark or yellowish prominent nodules, frequently producing great deformity. In one variety of the disease, anaesthesia of the skin is a prominent symptom. In addition there may be wasting of the muscles, falling out of the hair and nails, and distortion of the hands and feet with destruction of the bones and joints. It is incurable, and is probably contagious.",
   "Lepry": "Leprosy.",
   "Leptocardian": "One of the Leptocardia.",
   "Leptodactyl": "A bird or other animal having slender toes.",
   "Leptology": "A minute and tedious discourse on trifling things.",
   "Leptomeningitis": "Inflammation of the pia mater or of the arachnoid membrane.",
   "Leptothrix": "A genus of bacteria, characterized by having their filaments very long, slender, and indistinctly articulated.",
   "Leptothrix": "Having the form of a little chain; -- applied to bacteria when, as in multiplication by fission, they form a chain of filiform individuals.",
   "Leptus": "The six-legged young, or larva, of certain mites; -- sometimes used as a generic name. See Harvest mite, under Harvest.",
   "Leptynite": "See Granulite.",
   "Lere": "Learning; lesson; lore.",
   "Lere": "Flesh; skin.",
   "Lernaea": "A Linnaean genus of parasitic Entomostraca, -- the same as the family Lernaeidae.",
   "Lernean": "One of a family (Lernaeidae) of parasitic Crustacea found attached to fishes and other marine animals. Some species penetrate the skin and flesh with the elongated head, and feed on the viscera. See Illust. in Appendix.",
   "Lerot": "A small European rodent (Eliomys nitela), allied to the dormouse.",
   "Les": "A leash.",
   "Lese-majesty": "See Leze majesty.",
   "Lesion": "A hurt; an injury.",
   "Lesion": "Loss sustained from failure to fulfill a bargain or contract.",
   "Lesion": "Any morbid change in the exercise of functions or the texture of organs.",
   "Less": "A smaller portion or quantity.",
   "Less": "The inferior, younger, or smaller.",
   "Lessener": "One who, or that which, lessens.",
   "Lesson": "Anything read or recited to a teacher by a pupil or learner; something, as a portion of a book, assigned to a pupil to be studied or learned at one time.",
   "Lesson": "That which is learned or taught by an express effort; instruction derived from precept, experience, observation, or deduction; a precept; a doctrine; as, to take or give a lesson in drawing.",
   "Lesson": "A portion of Scripture read in divine service for instruction; as, here endeth the first lesson.",
   "Lesson": "A severe lecture; reproof; rebuke; warning.",
   "Lesson": "An exercise; a composition serving an educational purpose; a study.",
   "Lest": "Lust; desire; pleasure.",
   "Let": "A retarding; hindrance; obstacle; impediment; delay; -- common in the phrase without let or hindrance, but elsewhere archaic.",
   "Let": "A stroke in which a ball touches the top of the net in passing over.",
   "Letch": "Strong desire; passion. (Archaic).",
   "Lethal": "One of the higher alcohols of the paraffine series obtained from spermaceti as a white crystalline solid. It is so called because it occurs in the ethereal salt of lauric acid.",
   "Lethality": "The quality of being lethal; mortality.",
   "Lethargy": "Morbid drowsiness; continued or profound sleep, from which a person can scarcely be awaked.",
   "Lethargy": "A state of inaction or indifference.",
   "Lethe": "Death.",
   "Lethe": "A river of Hades whose waters when drunk caused forgetfulness of the past.",
   "Lethe": "Oblivion; a draught of oblivion; forgetfulness.",
   "Letheon": "Sulphuric ether used as an anaesthetic agent.",
   "Let-off": "A device for letting off, releasing, or giving forth, as the warp from the cylinder of a loom.",
   "Letter": "One who lets or permits; one who lets anything for hire.",
   "Letter": "One who retards or hinders.",
   "Letter": "A mark or character used as the representative of a sound, or of an articulation of the human organs of speech; a first element of written language.",
   "Letter": "A written or printed communication; a message expressed in intelligible characters on something adapted to conveyance, as paper, parchment, etc.; an epistle.",
   "Letter": "A writing; an inscription.",
   "Letter": "Verbal expression; literal statement or meaning; exact signification or requirement.",
   "Letter": "A single type; type, collectively; a style of type.",
   "Letter": "Learning; erudition; as, a man of letters.",
   "Letter": "A letter; an epistle.",
   "Letterer": "One who makes, inscribes, or engraves, alphabetical letters.",
   "Lettering": "The act or business of making, or marking with, letters, as by cutting or painting.",
   "Lettering": "The letters made; as, the lettering of a sign.",
   "Lettern": "See Lecturn.",
   "Letterpress": "Print; letters and words impressed on paper or other material by types; -- often used of the reading matter in distinction from the illustrations.",
   "Letterure": "Letters; literature.",
   "Letterwood": "The beautiful and highly elastic wood of a tree of the genus Brosimum (B. Aubletii), found in Guiana; -- so called from black spots in it which bear some resemblance to hieroglyphics; also called snakewood, and leopardwood. It is much used for bows and for walking sticks.",
   "Lettic": "The language of the Letts; Lettish.",
   "Lettic": "The language of the Lettic race, including Lettish, Lithuanian, and Old Prussian.",
   "Lettish": "The language spoken by the Letts. See Lettic.",
   "Lettrure": "See Letterure.",
   "Lettuce": "A composite plant of the genus Lactuca (L. sativa), the leaves of which are used as salad. Plants of this genus yield a milky juice, from which lactucarium is obtained. The commonest wild lettuce of the United States is L. Canadensis.",
   "Letuary": "Electuary.",
   "Let-up": "Abatement; also, cessation; as, it blew a gale for three days without any let-up.",
   "Leucadendron": "A genus of evergreen shrubs from the Cape of Good Hope, having handsome foliage. Leucadendron argenteum is the silverboom of the colonists.",
   "Leucaniline": "A colorless, crystalline, organic base, obtained from rosaniline by reduction, and also from other sources. It forms colorless salts.",
   "Leuchaemia": "See Leucocythaemia.",
   "Leucin": "A white, crystalline, nitrogenous substance formed in the decomposition of albuminous matter by pancreatic digestion, by the action of boiling dilute sulphuric acid, and by putrefaction. It is also found as a constituent of various tissues and organs, as the spleen, pancreas, etc., and likewise in the vegetable kingdom. Chemically it is to be considered as amido-caproic acid.",
   "Leucite": "A mineral having a glassy fracture, occurring in translucent trapezohedral crystals. It is a silicate of alumina and potash. It is found in the volcanic rocks of Italy, especially at Vesuvius.",
   "Leucite": "A leucoplast.",
   "Leucitoid": "The trapezohedron or tetragonal trisoctahedron; -- so called as being the form of the mineral leucite.",
   "Leucocyte": "A colorless corpuscle, as one of the white blood corpuscles, or those found in lymph, marrow of bone, connective tissue, etc.",
   "Leucocythaemia": "Alt. of Leucocythemia",
   "Leucocythemia": "A disease in which the white corpuscles of the blood are largely increased in number, and there is enlargement of the spleen, or the lymphatic glands; leuchaemia.",
   "Leucocytogenesis": "The formation of leucocytes.",
   "Leucoethiops": "An albino.",
   "Leucoline": "A nitrogenous organic base from coal tar, and identical with quinoline. Cf. Quinoline.",
   "Leucoma": "A white opacity in the cornea of the eye; -- called also albugo.",
   "Leucomaine": "An animal base or alkaloid, appearing in the tissue during life; hence, a vital alkaloid, as distinguished from a ptomaine or cadaveric poison.",
   "Leucopathy": "The state of an albino, or of a white child of black parents.",
   "Leucophane": "A mineral of a greenish yellow color; it is a silicate of glucina, lime, and soda with fluorine. Called also leucophanite.",
   "Leucophlegmacy": "A dropsical habit of body, or the commencement of anasarca; paleness, with viscid juices and cold sweats.",
   "Leucophyll": "A colorless substance isomeric with chlorophyll, contained in parts of plants capable of becoming green.",
   "Leucoplast": "Alt. of Leucoplastid",
   "Leucoplastid": "One of certain very minute whitish or colorless granules occurring in the protoplasm of plants and supposed to be the nuclei around which starch granules will form.",
   "Leucopyrite": "A mineral of a color between white and steel-gray, with a metallic luster, and consisting chiefly of arsenic and iron.",
   "Leucorrhoea": "A discharge of a white, yellowish, or greenish, viscid mucus, resulting from inflammation or irritation of the membrane lining the genital organs of the female; the whites.",
   "Leucoryx": "A large antelope of North Africa (Oryx leucoryx), allied to the gemsbok.",
   "Leucoscope": "An instrument, devised by Professor Helmholtz, for testing the color perception of the eye, or for comparing different lights, as to their constituent colors or their relative whiteness.",
   "Leucosphere": "The inner corona.",
   "Leucoxene": "A nearly opaque white mineral, in part identical with titanite, observed in some igneous rocks as the result of the alteration of titanic iron.",
   "Leukaemia": "Leucocythaemia.",
   "Leuke": "Alt. of Leukeness",
   "Leukeness": "See Luke, etc.",
   "Leukoplast": "See Leucoplast.",
   "Levana": "A goddess who protected newborn infants.",
   "Levant": "The countries washed by the eastern part of the Mediterranean and its contiguous waters.",
   "Levant": "A levanter (the wind so called).",
   "Levanter": "A strong easterly wind peculiar to the Mediterranean.",
   "Levantine": "Of or pertaining to the Levant.",
   "Levantine": "A native or inhabitant of the Levant.",
   "Levantine": "A stout twilled silk fabric, formerly made in the Levant.",
   "Levation": "The act of raising; elevation; upward motion, as that produced by the action of a levator muscle.",
   "Levator": "A muscle that serves to raise some part, as the lip or the eyelid.",
   "Levator": "A surgical instrument used to raise a depressed part of the skull.",
   "Levee": "The act of rising.",
   "Levee": "A morning assembly or reception of visitors, -- in distinction from a soiree, or evening assembly; a matinee; hence, also, any general or somewhat miscellaneous gathering of guests, whether in the daytime or evening; as, the president's levee.",
   "Levee": "An embankment to prevent inundation; as, the levees along the Mississippi; sometimes, the steep bank of a river.",
   "Leveful": "Allowable; permissible; lawful.",
   "Level": "A line or surface to which, at every point, a vertical or plumb line is perpendicular; a line or surface which is everywhere parallel to the surface of still water; -- this is the true level, and is a curve or surface in which all points are equally distant from the center of the earth, or rather would be so if the earth were an exact sphere.",
   "Level": "A horizontal line or plane; that is, a straight line or a plane which is tangent to a true level at a given point and hence parallel to the horizon at that point; -- this is the apparent level at the given point.",
   "Level": "An approximately horizontal line or surface at a certain degree of altitude, or distance from the center of the earth; as, to climb from the level of the coast to the level of the plateau and then descend to the level of the valley or of the sea.",
   "Level": "Hence, figuratively, a certain position, rank, standard, degree, quality, character, etc., conceived of as in one of several planes of different elevation.",
   "Level": "A uniform or average height; a normal plane or altitude; a condition conformable to natural law or which will secure a level surface; as, moving fluids seek a level.",
   "Level": "An instrument by which to find a horizontal line, or adjust something with reference to a horizontal line.",
   "Level": "A measurement of the difference of altitude of two points, by means of a level; as, to take a level.",
   "Level": "A horizontal passage, drift, or adit, in a mine.",
   "Leveler": "One who, or that which, levels.",
   "Leveler": "One who would remove social inequalities or distinctions; a socialist.",
   "Leveling": "The act or operation of making level.",
   "Leveling": "The art or operation of using a leveling instrument for finding a horizontal line, for ascertaining the differences of level between different points of the earth's surface included in a survey, for establishing grades, etc., as in finding the descent of a river, or locating a line of railroad.",
   "Levelism": "The disposition or endeavor to level all distinctions of rank in society.",
   "Levelness": "The state or quality of being level.",
   "Leven": "Lightning.",
   "Lever": "A rigid piece which is capable of turning about one point, or axis (the fulcrum), and in which are two or more other points where forces are applied; -- used for transmitting and modifying force and motion. Specif., a bar of metal, wood, or other rigid substance, used to exert a pressure, or sustain a weight, at one point of its length, by receiving a force or power at a second, and turning at a third on a fixed point called a fulcrum. It is usually named as the first of the six mechanical powers, and is of three kinds, according as either the fulcrum F, the weight W, or the power P, respectively, is situated between the other two, as in the figures.",
   "Lever": "A bar, as a capstan bar, applied to a rotatory piece to turn it.",
   "Lever": "An arm on a rock shaft, to give motion to the shaft or to obtain motion from it.",
   "Leverage": "The action of a lever; mechanical advantage gained by the lever.",
   "Leveret": "A hare in the first year of its age.",
   "Leverock": "A lark.",
   "Leverwood": "The American hop hornbeam (Ostrya Virginica), a small tree with very tough wood.",
   "Levesel": "A leafy shelter; a place covered with foliage.",
   "Levet": "A trumpet call for rousing soldiers; a reveille.",
   "Leviathan": "An aquatic animal, described in the book of Job, ch. xli., and mentioned in other passages of Scripture.",
   "Leviathan": "The whale, or a great whale.",
   "Levier": "One who levies.",
   "Levigation": "The act or operation of levigating.",
   "Levin": "Lightning.",
   "Leviner": "A swift hound.",
   "Levir": "A husband's brother; -- used in reference to levirate marriages.",
   "Leviration": "Levirate marriage or marriages.",
   "Levitation": "Lightness; buoyancy; act of making light.",
   "Levitation": "The act or process of making buoyant.",
   "Levite": "One of the tribe or family of Levi; a descendant of Levi; esp., one subordinate to the priests (who were of the same tribe) and employed in various duties connected with the tabernacle first, and afterward the temple, such as the care of the building, bringing of wood and other necessaries for the sacrifices, the music of the services, etc.",
   "Levite": "A priest; -- so called in contempt or ridicule.",
   "Leviticus": "The third canonical book of the Old Testament, containing the laws and regulations relating to the priests and Levites among the Hebrews, or the body of the ceremonial law.",
   "Levity": "The quality of weighing less than something else of equal bulk; relative lightness, especially as shown by rising through, or floating upon, a contiguous substance; buoyancy; -- opposed to gravity.",
   "Levity": "Lack of gravity and earnestness in deportment or character; trifling gayety; frivolity; sportiveness; vanity.",
   "Levity": "Lack of steadiness or constancy; disposition to change; fickleness; volatility.",
   "Levulin": "A substance resembling dextrin, obtained from the bulbs of the dahlia, the artichoke, and other sources, as a colorless, spongy, amorphous material. It is so called because by decomposition it yields levulose.",
   "Levulosan": "An unfermentable carbohydrate obtained by gently heating levulose.",
   "Levulose": "A sirupy variety of sugar, rarely obtained crystallized, occurring widely in honey, ripe fruits, etc., and hence called also fruit sugar. It is called levulose, because it rotates the plane of polarization to the left.",
   "Levy": "A name formerly given in Pennsylvania, Maryland, and Virginia to the Spanish real of one eighth of a dollar (or 12/ cents), valued at eleven pence when the dollar was rated at 7s. 6d.",
   "Levy": "The act of levying or collecting by authority; as, the levy of troops, taxes, etc.",
   "Levy": "That which is levied, as an army, force, tribute, etc.",
   "Levy": "The taking or seizure of property on executions to satisfy judgments, or on warrants for the collection of taxes; a collecting by execution.",
   "Levyne": "Alt. of Levynite",
   "Levynite": "A whitish, reddish, or yellowish, transparent or translucent mineral, allied to chabazite.",
   "Lewdster": "A lewd person.",
   "Lewis": "Alt. of Lewisson",
   "Lewisson": "An iron dovetailed tenon, made in sections, which can be fitted into a dovetail mortise; -- used in hoisting large stones, etc.",
   "Lewisson": "A kind of shears used in cropping woolen cloth.",
   "Lex": "Law; as, lex talionis, the law of retaliation; lex terrae, the law of the land; lex fori, the law of the forum or court; lex loci, the law of the place; lex mercatoria, the law or custom of merchants.",
   "Lexicographer": "The author or compiler of a lexicon or dictionary.",
   "Lexicographist": "A lexicographer.",
   "Lexicography": "The art, process, or occupation of making a lexicon or dictionary; the principles which are applied in making dictionaries.",
   "Lexicologist": "One versed in lexicology.",
   "Lexicology": "The science of the derivation and signification of words; that branch of learning which treats of the signification and application of words.",
   "Lexicon": "A vocabulary, or book containing an alphabetical arrangement of the words in a language or of a considerable number of them, with the definition of each; a dictionary; especially, a dictionary of the Greek, Hebrew, or Latin language.",
   "Lexiconist": "A writer of a lexicon.",
   "Lexigraphy": "The art or practice of defining words; definition of words.",
   "Lexiphanicism": "The use of pretentious words, language, or style.",
   "Ley": "Law.",
   "Ley": "See Lye.",
   "Ley": "Grass or meadow land; a lea.",
   "Leyser": "Leisure.",
   "Lherzolite": "An igneous rock consisting largely of chrysolite, with pyroxene and picotite (a variety of spinel containing chromium).",
   "Li": "A Chinese measure of distance, being a little more than one third of a mile.",
   "Li": "A Chinese copper coin; a cash. See Cash.",
   "Liability": "The state of being liable; as, the liability of an insurer; liability to accidents; liability to the law.",
   "Liability": "That which one is under obligation to pay, or for which one is liable.",
   "Liability": "the sum of one's pecuniary obligations; -- opposed to assets.",
   "Liableness": "Quality of being liable; liability.",
   "Liage": "Union by league; alliance.",
   "Liaison": "A union, or bond of union; an intimacy; especially, an illicit intimacy between a man and a woman.",
   "Liane": "Alt. of Liana",
   "Liana": "A luxuriant woody plant, climbing high trees and having ropelike stems. The grapevine often has the habit of a liane. Lianes are abundant in the forests of the Amazon region.",
   "Liar": "A person who knowingly utters falsehood; one who lies.",
   "Liard": "A French copper coin of one fourth the value of a sou.",
   "Lias": "The lowest of the three divisions of the Jurassic period; a name given in England and Europe to a series of marine limestones underlying the Oolite. See the Chart of Geology.",
   "Liassic": "Same as Lias.",
   "Libament": "Libation.",
   "Libation": "The act of pouring a liquid or liquor, usually wine, either on the ground or on a victim in sacrifice, in honor of some deity; also, the wine or liquid thus poured out.",
   "Libbard": "A leopard.",
   "Libel": "A brief writing of any kind, esp. a declaration, bill, certificate, request, supplication, etc.",
   "Libel": "Any defamatory writing; a lampoon; a satire.",
   "Libel": "A malicious publication expressed either in print or in writing, or by pictures, effigies, or other signs, tending to expose another to public hatred, contempt, or ridicule. Such publication is indictable at common law.",
   "Libel": "The crime of issuing a malicious defamatory publication.",
   "Libel": "A written declaration or statement by the plaintiff of his cause of action, and of the relief he seeks.",
   "Libelant": "One who libels; one who institutes a suit in an ecclesiastical or admiralty court.",
   "Libeler": "One who libels.",
   "Libelist": "A libeler.",
   "Li": "A small balance.",
   "Li": "A level, or leveling instrument.",
   "Libellulid": "A dragon fly.",
   "Liber": "The inner bark of plants, lying next to the wood. It usually contains a large proportion of woody, fibrous cells, and is, therefore, the part from which the fiber of the plant is obtained, as that of hemp, etc.",
   "Liberal": "One who favors greater freedom in political or religious matters; an opponent of the established systems; a reformer; in English politics, a member of the Liberal party, so called. Cf. Whig.",
   "Liberalism": "Liberal principles; the principles and methods of the liberals in politics or religion; specifically, the principles of the Liberal party.",
   "Liberalist": "A liberal.",
   "Liberality": "The quality or state of being liberal; liberal disposition or practice; freedom from narrowness or prejudice; generosity; candor; charity.",
   "Liberality": "A gift; a gratuity; -- sometimes in the plural; as, a prudent man is not impoverished by his liberalities.",
   "Liberalization": "The act of liberalizing.",
   "Liberalizer": "One who, or that which, liberalizes.",
   "Liberation": "The act of liberating or the state of being liberated.",
   "Liberator": "One who, or that which, liberates; a deliverer.",
   "Libertarian": "One who holds to the doctrine of free will.",
   "Libertarianism": "Libertarian principles or doctrines.",
   "Liberticide": "The destruction of civil liberty.",
   "Liberticide": "A destroyer of civil liberty.",
   "Libertinage": "Libertinism; license.",
   "Libertine": "A manumitted slave; a freedman; also, the son of a freedman.",
   "Libertine": "One of a sect of Anabaptists, in the fifteenth and early part of the sixteenth century, who rejected many of the customs and decencies of life, and advocated a community of goods and of women.",
   "Libertine": "One free from restraint; one who acts according to his impulses and desires; now, specifically, one who gives rein to lust; a rake; a debauchee.",
   "Libertine": "A defamatory name for a freethinker.",
   "Libertine": "Free from restraint; uncontrolled.",
   "Libertine": "Dissolute; licentious; profligate; loose in morals; as, libertine principles or manners.",
   "Libertinism": "The state of a libertine or freedman.",
   "Libertinism": "Licentious conduct; debauchery; lewdness.",
   "Libertinism": "Licentiousness of principle or opinion.",
   "Liberty": "The state of a free person; exemption from subjection to the will of another claiming ownership of the person or services; freedom; -- opposed to slavery, serfdom, bondage, or subjection.",
   "Liberty": "Freedom from imprisonment, bonds, or other restraint upon locomotion.",
   "Liberty": "A privilege conferred by a superior power; permission granted; leave; as, liberty given to a child to play, or to a witness to leave a court, and the like.",
   "Liberty": "Privilege; exemption; franchise; immunity enjoyed by prescription or by grant; as, the liberties of the commercial cities of Europe.",
   "Liberty": "The place within which certain immunities are enjoyed, or jurisdiction is exercised.",
   "Liberty": "A certain amount of freedom; permission to go freely within certain limits; also, the place or limits within which such freedom is exercised; as, the liberties of a prison.",
   "Liberty": "A privilege or license in violation of the laws of etiquette or propriety; as, to permit, or take, a liberty.",
   "Liberty": "The power of choice; freedom from necessity; freedom from compulsion or constraint in willing.",
   "Liberty": "A curve or arch in a bit to afford room for the tongue of the horse.",
   "Liberty": "Leave of absence; permission to go on shore.",
   "Libethenite": "A mineral of an olive-green color, commonly in orthorhombic crystals. It is a hydrous phosphate of copper.",
   "Libidinist": "One given to lewdness.",
   "Libidinosity": "The state or quality of being libidinous; libidinousness.",
   "Libken": "Alt. of Libkin",
   "Libkin": "A house or lodging.",
   "Libra": "The Balance; the seventh sign in the zodiac, which the sun enters at the autumnal equinox in September, marked thus / in almanacs, etc.",
   "Libra": "A southern constellation between Virgo and Scorpio.",
   "Librarian": "One who has the care or charge of a library.",
   "Librarian": "One who copies manuscript books.",
   "Librarianship": "The office of a librarian.",
   "Library": "A considerable collection of books kept for use, and not as merchandise; as, a private library; a public library.",
   "Library": "A building or apartment appropriated for holding such a collection of books.",
   "Libration": "The act or state of librating.",
   "Libration": "A real or apparent libratory motion, like that of a balance before coming to rest.",
   "Libration": "any one of five points in the plane of a system of two large astronomical bodies orbiting each other, as the Earth-moon system, where the gravitational pull of the two bodies on an object are approximately equal, and in opposite directions. A solid object moving in the same velocity and direction as such a libration point will remain in gravitational equilibrium with the two bodies of the system and not fall toward either body.",
   "Librettist": "One who makes a libretto.",
   "Libretto": "A book containing the words of an opera or extended piece of music.",
   "Libretto": "The words themselves.",
   "Lice": "pl. of Louse.",
   "License": "Authority or liberty given to do or forbear any act; especially, a formal permission from the proper authorities to perform certain acts or to carry on a certain business, which without such permission would be illegal; a grant of permission; as, a license to preach, to practice medicine, to sell gunpowder or intoxicating liquors.",
   "License": "The document granting such permission.",
   "License": "Excess of liberty; freedom abused, or used in contempt of law or decorum; disregard of law or propriety.",
   "License": "That deviation from strict fact, form, or rule, in which an artist or writer indulges, assuming that it will be permitted for the sake of the advantage or effect gained; as, poetic license; grammatical license, etc.",
   "Licensee": "The person to whom a license is given.",
   "Licenser": "One who gives a license; as, a licenser of the press.",
   "Licensure": "A licensing.",
   "Licentiate": "One who has a license to exercise a profession; as, a licentiate in medicine or theology.",
   "Licentiate": "A friar authorized to receive confessions and grant absolution in all places, independently of the local clergy.",
   "Licentiate": "One who acts without restraint, or takes a liberty, as if having a license therefor.",
   "Licentiate": "On the continent of Europe, a university degree intermediate between that of bachelor and that of doctor.",
   "Lichen": "One of a class of cellular, flowerless plants, (technically called Lichenes), having no distinction of leaf and stem, usually of scaly, expanded, frond-like forms, but sometimes erect or pendulous and variously branched. They derive their nourishment from the air, and generate by means of spores. The species are very widely distributed, and form irregular spots or patches, usually of a greenish or yellowish color, upon rocks, trees, and various bodies, to which they adhere with great tenacity. They are often improperly called rock moss or tree moss.",
   "Lichen": "A name given to several varieties of skin disease, esp. to one characterized by the eruption of small, conical or flat, reddish pimples, which, if unchecked, tend to spread and produce great and even fatal exhaustion.",
   "Lichenin": "A substance isomeric with starch, extracted from several species of moss and lichen, esp. from Iceland moss.",
   "Lichenographist": "One who describes lichens; one versed in lichenography.",
   "Lichenography": "A description of lichens; the science which illustrates the natural history of lichens.",
   "Lichenologist": "One versed in lichenology.",
   "Lichenology": "The science which treats of lichens.",
   "Lichi": "See Litchi.",
   "Lichwale": "The gromwell.",
   "Lichwort": "An herb, the wall pellitory. See Pellitory.",
   "Licitation": "The act of offering for sale to the highest bidder.",
   "Lick": "A slap; a quick stroke.",
   "Licker": "One who, or that which, licks.",
   "Licking": "A lapping with the tongue.",
   "Licking": "A flogging or castigation.",
   "Lickpenny": "A devourer or absorber of money.",
   "Lick-spigot": "A tapster.",
   "Lick-spittle": "An abject flatterer or parasite.",
   "Licorice": "A plant of the genus Glycyrrhiza (G. glabra), the root of which abounds with a sweet juice, and is much used in demulcent compositions.",
   "Licorice": "The inspissated juice of licorice root, used as a confection and for medicinal purposes.",
   "Licour": "Liquor.",
   "Lictor": "An officer who bore an ax and fasces or rods, as ensigns of his office. His duty was to attend the chief magistrates when they appeared in public, to clear the way, and cause due respect to be paid to them, also to apprehend and punish criminals.",
   "Lid": "That which covers the opening of a vessel or box, etc.; a movable cover; as, the lid of a chest or trunk.",
   "Lid": "The cover of the eye; an eyelid.",
   "Lid": "The cover of the spore cases of mosses.",
   "Lid": "A calyx which separates from the flower, and falls off in a single piece, as in the Australian Eucalypti.",
   "Lid": "The top of an ovary which opens transversely, as in the fruit of the purslane and the tree which yields Brazil nuts.",
   "Lidge": "Same as Ledge.",
   "Lie": "See Lye.",
   "Lie": "A falsehood uttered or acted for the purpose of deception; an intentional violation of truth; an untruth spoken with the intention to deceive.",
   "Lie": "A fiction; a fable; an untruth.",
   "Lie": "Anything which misleads or disappoints.",
   "Lie": "The position or way in which anything lies; the lay, as of land or country.",
   "Lieberkuhn": "A concave metallic mirror attached to the object-glass end of a microscope, to throw down light on opaque objects; a reflector.",
   "Lied": "A lay; a German song. It differs from the French chanson, and the Italian canzone, all three being national.",
   "Liedertafel": "A popular name for any society or club which meets for the practice of male part songs.",
   "Lief": "Same as Lif.",
   "Lief": "Dear; beloved.",
   "Lief": "Pleasing; agreeable; acceptable; preferable.",
   "Lief": "A dear one; a sweetheart.",
   "Liegance": "Same as Ligeance.",
   "Liege": "A free and independent person; specif., a lord paramount; a sovereign.",
   "Liege": "The subject of a sovereign or lord; a liegeman.",
   "Liegeman": "Same as Liege, n., 2.",
   "Lieger": "A resident ambassador.",
   "Liegiancy": "See Ligeance.",
   "Lien": "A legal claim; a charge upon real or personal property for the satisfaction of some debt or duty; a right in one to control or hold and retain the property of another until some claim of the former is paid or satisfied.",
   "Lienculus": "One of the small nodules sometimes found in the neighborhood of the spleen; an accessory or supplementary spleen.",
   "Lienteric": "A lientery.",
   "Lientery": "A diarrhea, in which the food is discharged imperfectly digested, or with but little change.",
   "Lier": "One who lies down; one who rests or remains, as in concealment.",
   "Lieu": "Place; room; stead; -- used only in the phrase in lieu of, that is, instead of.",
   "Lieutenancy": "The office, rank, or commission, of a lieutenant.",
   "Lieutenancy": "The body of lieutenants or subordinates.",
   "Lieutenant": "An officer who supplies the place of a superior in his absence; a representative of, or substitute for, another in the performance of any duty.",
   "Lieutenant": "A commissioned officer in the army, next below a captain.",
   "Lieutenant": "A commissioned officer in the British navy, in rank next below a commander.",
   "Lieutenant": "A commissioned officer in the United States navy, in rank next below a lieutenant commander.",
   "Lieutenantry": "See Lieutenancy.",
   "Lieutenantship": "Same as Lieutenancy, 1.",
   "Lif": "The fiber by which the petioles of the date palm are bound together, from which various kinds of cordage are made.",
   "Life": "The state of being which begins with generation, birth, or germination, and ends with death; also, the time during which this state continues; that state of an animal or plant in which all or any of its organs are capable of performing all or any of their functions; -- used of all animal and vegetable organisms.",
   "Life": "Of human beings: The union of the soul and body; also, the duration of their union; sometimes, the deathless quality or existence of the soul; as, man is a creature having an immortal life.",
   "Life": "The potential principle, or force, by which the organs of animals and plants are started and continued in the performance of their several and cooperative functions; the vital force, whether regarded as physical or spiritual.",
   "Life": "Figuratively: The potential or animating principle, also, the period of duration, of anything that is conceived of as resembling a natural organism in structure or functions; as, the life of a state, a machine, or a book; authority is the life of government.",
   "Life": "A certain way or manner of living with respect to conditions, circumstances, character, conduct, occupation, etc.; hence, human affairs; also, lives, considered collectively, as a distinct class or type; as, low life; a good or evil life; the life of Indians, or of miners.",
   "Life": "Animation; spirit; vivacity; vigor; energy.",
   "Life": "That which imparts or excites spirit or vigor; that upon which enjoyment or success depends; as, he was the life of the company, or of the enterprise.",
   "Life": "The living or actual form, person, thing, or state; as, a picture or a description from the life.",
   "Life": "A person; a living being, usually a human being; as, many lives were sacrificed.",
   "Life": "The system of animal nature; animals in general, or considered collectively.",
   "Life": "An essential constituent of life, esp. the blood.",
   "Life": "A history of the acts and events of a life; a biography; as, Johnson wrote the life of Milton.",
   "Life": "Enjoyment in the right use of the powers; especially, a spiritual existence; happiness in the favor of God; heavenly felicity.",
   "Life": "Something dear to one as one's existence; a darling; -- used as a term of endearment.",
   "Lifeblood": "The blood necessary to life; vital blood.",
   "Lifeblood": "Fig.: That which gives strength and energy.",
   "Lifeboat": "A strong, buoyant boat especially designed for saving the lives of shipwrecked people.",
   "Lifehold": "Land held by a life estate.",
   "Lifemate": "Companion for life.",
   "Life-preserver": "An apparatus, made in very various forms, and of various materials, for saving one from drowning by buoying up the body while in the water.",
   "Lifespring": "Spring or source of life.",
   "Lifestring": "A nerve, or string, that is imagined to be essential to life.",
   "Lifetime": "The time that life continues.",
   "Liflode": "Livelihood.",
   "Lift": "The sky; the atmosphere; the firmament.",
   "Lift": "Act of lifting; also, that which is lifted.",
   "Lift": "The space or distance through which anything is lifted; as, a long lift.",
   "Lift": "Help; assistance, as by lifting; as, to give one a lift in a wagon.",
   "Lift": "That by means of which a person or thing lifts or is lifted",
   "Lift": "A hoisting machine; an elevator; a dumb waiter.",
   "Lift": "A handle.",
   "Lift": "An exercising machine.",
   "Lift": "A rise; a degree of elevation; as, the lift of a lock in canals.",
   "Lift": "A lift gate. See Lift gate, below.",
   "Lift": "A rope leading from the masthead to the extremity of a yard below; -- used for raising or supporting the end of the yard.",
   "Lift": "One of the steps of a cone pulley.",
   "Lift": "A layer of leather in the heel.",
   "Lift": "That portion of the vibration of a balance during which the impulse is given.",
   "Lifter": "One who, or that which, lifts.",
   "Lifter": "A tool for lifting loose sand from the mold; also, a contrivance attached to a cope, to hold the sand together when the cope is lifted.",
   "Ligament": "Anything that ties or unites one thing or part to another; a bandage; a bond.",
   "Ligament": "A tough band or plate of dense, fibrous, connective tissue or fibrocartilage serving to unite bones or form joints.",
   "Ligament": "A band of connective tissue, or a membranous fold, which supports or retains an organ in place; as, the gastrophrenic ligament, connecting the diaphragm and stomach.",
   "Ligan": "Goods sunk in the sea, with a buoy attached in order that they may be found again. See Jetsam and Flotsam.",
   "Ligation": "The act of binding, or the state of being bound.",
   "Ligation": "That which binds; bond; connection.",
   "Ligator": "An instrument for ligating, or for placing and fastening a ligature.",
   "Ligature": "The act of binding.",
   "Ligature": "Anything that binds; a band or bandage.",
   "Ligature": "A thread or string for tying the blood vessels, particularly the arteries, to prevent hemorrhage.",
   "Ligature": "A thread or wire used to remove tumors, etc.",
   "Ligature": "The state of being bound or stiffened; stiffness; as, the ligature of a joint.",
   "Ligature": "Impotence caused by magic or charms.",
   "Ligature": "A curve or line connecting notes; a slur.",
   "Ligature": "A double character, or a type consisting of two or more letters or characters united, as ae, /, /.",
   "Ligeance": "The connection between sovereign and subject by which they were mutually bound, the former to protection and the securing of justice, the latter to faithful service; allegiance.",
   "Ligement": "See Ledgment.",
   "Ligger": "A baited line attached to a float, for night fishing. See Leger, a.",
   "Light": "That agent, force, or action in nature by the operation of which upon the organs of sight, objects are rendered visible or luminous.",
   "Light": "That which furnishes, or is a source of, light, as the sun, a star, a candle, a lighthouse, etc.",
   "Light": "The time during which the light of the sun is visible; day; especially, the dawn of day.",
   "Light": "The brightness of the eye or eyes.",
   "Light": "The medium through which light is admitted, as a window, or window pane; a skylight; in architecture, one of the compartments of a window made by a mullion or mullions.",
   "Light": "Life; existence.",
   "Light": "Open view; a visible state or condition; public observation; publicity.",
   "Light": "The power of perception by vision.",
   "Light": "That which illumines or makes clear to the mind; mental or spiritual illumination; enlightenment; knowledge; information.",
   "Light": "Prosperity; happiness; joy; felicity.",
   "Light": "The manner in which the light strikes upon a picture; that part of a picture which represents those objects upon which the light is supposed to fall; the more illuminated part of a landscape or other scene; -- opposed to shade. Cf. Chiaroscuro.",
   "Light": "Appearance due to the particular facts and circumstances presented to view; point of view; as, to state things fairly and put them in the right light.",
   "Light": "One who is conspicuous or noteworthy; a model or example; as, the lights of the age or of antiquity.",
   "Light": "A firework made by filling a case with a substance which burns brilliantly with a white or colored flame; as, a Bengal light.",
   "Light": "To set fire to; to cause to burn; to set burning; to ignite; to kindle; as, to light a candle or lamp; to light the gas; -- sometimes with up.",
   "Light": "To give light to; to illuminate; to fill with light; to spread over with light; -- often with up.",
   "Light": "To attend or conduct with a light; to show the way to by means of a light.",
   "Light-boat": "Light-ship.",
   "Lighter": "One who, or that which, lights; as, a lighter of lamps.",
   "Lighter": "A large boat or barge, mainly used in unloading or loading vessels which can not reach the wharves at the place of shipment or delivery.",
   "Lighterage": "The price paid for conveyance of goods on a lighter.",
   "Lighterage": "The act of unloading into a lighter, or of conveying by a lighter.",
   "Lighterman": "A person employed on, or who manages, a lighter.",
   "Light-horseman": "A soldier who serves in the light horse. See under 5th Light.",
   "Light-horseman": "A West Indian fish of the genus Ephippus, remarkable for its high dorsal fin and brilliant colors.",
   "Lighthouse": "A tower or other building with a powerful light at top, erected at the entrance of a port, or at some important point on a coast, to serve as a guide to mariners at night; a pharos.",
   "Lighting": "A name sometimes applied to the process of annealing metals.",
   "Lightman": "A man who carries or takes care of a light.",
   "Lightness": "The state, condition, or quality, of being light or not heavy; buoyancy; levity; fickleness; nimbleness; delicacy; grace.",
   "Lightness": "Illumination, or degree of illumination; as, the lightness of a room.",
   "Lightness": "Absence of depth or of duskiness in color; as, the lightness of a tint; lightness of complexion.",
   "Lightning": "A discharge of atmospheric electricity, accompanied by a vivid flash of light, commonly from one cloud to another, sometimes from a cloud to the earth. The sound produced by the electricity in passing rapidly through the atmosphere constitutes thunder.",
   "Lightning": "The act of making bright, or the state of being made bright; enlightenment; brightening, as of the mental powers.",
   "Light-o'-love": "An old tune of a dance, the name of which made it a proverbial expression of levity, especially in love matters.",
   "Light-o'-love": "Hence: A light or wanton woman.",
   "Lightroom": "A small room from which the magazine of a naval vessel is lighted, being separated from the magazine by heavy glass windows.",
   "Light-ship": "A vessel carrying at the masthead a brilliant light, and moored off a shoal or place of dangerous navigation as a guide for mariners.",
   "Lightwood": "Pine wood abounding in pitch, used for torches in the Southern United States; pine knots, dry sticks, and the like, for kindling a fire quickly or making a blaze.",
   "Lign-aloes": "Aloes wood, or agallochum. See Agallochum.",
   "Lign-aloes": "A fragrant tree mentioned in the Bible.",
   "Lignification": "A change in the character of a cell wall, by which it becomes harder. It is supposed to be due to an incrustation of lignin.",
   "Lignin": "A substance characterizing wood cells and differing from cellulose in its conduct with certain chemical reagents.",
   "Lignireose": "See Lignin.",
   "Lignite": "Mineral coal retaining the texture of the wood from which it was formed, and burning with an empyreumatic odor. It is of more recent origin than the anthracite and bituminous coal of the proper coal series. Called also brown coal, wood coal.",
   "Lignone": "See Lignin.",
   "Lignose": "See Lignin.",
   "Lignose": "An explosive compound of wood fiber and nitroglycerin. See Nitroglycerin.",
   "Lignum-vitae": "A tree (Guaiacum officinale) found in the warm latitudes of America, from which the guaiacum of medicine is procured. Its wood is very hard and heavy, and is used for various mechanical purposes, as for the wheels of ships' blocks, cogs, bearings, and the like. See Guaiacum.",
   "Ligroin": "A trade name applied somewhat indefinitely to some of the volatile products obtained in refining crude petroleum. It is a complex and variable mixture of several hydrocarbons, generally boils below 170� Fahr., and is more inflammable than safe kerosene. It is used as a solvent, as a carburetant for air gas, and for illumination in special lamps.",
   "Ligsam": "Same as Ligan.",
   "Ligula": "See Ligule.",
   "Ligula": "The central process, or front edge, of the labium of insects. It sometimes serves as a tongue or proboscis, as in bees.",
   "Ligula": "A tongue-shaped lobe of the parapodia of annelids. See Parapodium.",
   "Ligule": "The thin and scarious projection from the upper end of the sheath of a leaf of grass.",
   "Ligule": "A strap-shaped corolla of flowers of Compositae.",
   "Ligule": "A band of white matter in the wall of fourth ventricle of the brain.",
   "Ligure": "A kind of precious stone.",
   "Ligustrin": "A bitter principle found in the bark of the privet (Ligustrum vulgare), and extracted as a white crystalline substance with a warm, bitter taste; -- called also ligustron.",
   "Like": "That which is equal or similar to another; the counterpart; an exact resemblance; a copy.",
   "Like": "A liking; a preference; inclination; -- usually in pl.; as, we all have likes and dislikes.",
   "Likehood": "Likelihood.",
   "Likelihood": "Appearance; show; sign; expression.",
   "Likelihood": "Likeness; resemblance.",
   "Likelihood": "Appearance of truth or reality; probability; verisimilitude.",
   "Likeliness": "Likelihood; probability.",
   "Likeliness": "Suitableness; agreeableness.",
   "Likeness": "The state or quality of being like; similitude; resemblance; similarity; as, the likeness of the one to the other is remarkable.",
   "Likeness": "Appearance or form; guise.",
   "Likeness": "That which closely resembles; a portrait.",
   "Likeness": "A comparison; parable; proverb.",
   "Likerous": "Alt. of Likerousness",
   "Likerousness": "See Lickerish, Lickerishness.",
   "Likewise": "In like manner; also; moreover; too. See Also.",
   "Liking": "The state of being pleasing; a suiting. See On liking, below.",
   "Liking": "The state of being pleased with, or attracted toward, some thing or person; hence, inclination; desire; pleasure; preference; -- often with for, formerly with to; as, it is an amusement I have no liking for.",
   "Liking": "Appearance; look; figure; state of body as to health or condition.",
   "Lilac": "A shrub of the genus Syringa. There are six species, natives of Europe and Asia. Syringa vulgaris, the common lilac, and S. Persica, the Persian lilac, are frequently cultivated for the fragrance and beauty of their purplish or white flowers. In the British colonies various other shrubs have this name.",
   "Lilac": "A light purplish color like that of the flower of the purplish lilac.",
   "Lilacin": "See Syringin.",
   "Lilliputian": "A person or thing of very small size.",
   "Lilly-pilly": "An Australian myrtaceous tree (Eugenia Smithii), having smooth ovate leaves, and panicles of small white flowers. The wood is hard and fine-grained.",
   "Lilt": "Animated, brisk motion; spirited rhythm; sprightliness.",
   "Lilt": "A lively song or dance; a cheerful tune.",
   "Lily": "A plant and flower of the genus Lilium, endogenous bulbous plants, having a regular perianth of six colored pieces, six stamens, and a superior three-celled ovary.",
   "Lily": "A name given to handsome flowering plants of several genera, having some resemblance in color or form to a true lily, as Pancratium, Crinum, Amaryllis, Nerine, etc.",
   "Lily": "That end of a compass needle which should point to the north; -- so called as often ornamented with the figure of a lily or fleur-de-lis.",
   "Lilywort": "Any plant of the Lily family or order.",
   "Lim": "A limb.",
   "Lima": "The capital city of Peru, in South America.",
   "Limacina": "A genus of small spiral pteropods, common in the Arctic and Antarctic seas. It contributes to the food of the right whales.",
   "Lima/on": "A curve of the fourth degree, invented by Pascal. Its polar equation is r = a cos / + b.",
   "Limaille": "Filings of metal.",
   "Liman": "The deposit of slime at the mouth of a river; slime.",
   "Limation": "The act of filing or polishing.",
   "Limature": "The act of filing.",
   "Limature": "That which is filed off; filings.",
   "Limax": "A genus of airbreathing mollusks, including the common garden slugs. They have a small rudimentary shell. The breathing pore is on the right side of the neck. Several species are troublesome in gardens. See Slug.",
   "Limb": "A part of a tree which extends from the trunk and separates into branches and twigs; a large branch.",
   "Limb": "An arm or a leg of a human being; a leg, arm, or wing of an animal.",
   "Limb": "A thing or person regarded as a part or member of, or attachment to, something else.",
   "Limb": "An elementary piece of the mechanism of a lock.",
   "Limb": "A border or edge, in certain special uses.",
   "Limb": "The border or upper spreading part of a monopetalous corolla, or of a petal, or sepal; blade.",
   "Limb": "The border or edge of the disk of a heavenly body, especially of the sun and moon.",
   "Limb": "The graduated margin of an arc or circle, in an instrument for measuring angles.",
   "Limbat": "A cooling periodical wind in the Isle of Cyprus, blowing from the northwest from eight o'clock, A. M., to the middle of the day or later.",
   "Limbec": "An alembic; a still.",
   "Limber": "The shafts or thills of a wagon or carriage.",
   "Limber": "The detachable fore part of a gun carriage, consisting of two wheels, an axle, and a shaft to which the horses are attached. On top is an ammunition box upon which the cannoneers sit.",
   "Limber": "Gutters or conduits on each side of the keelson to afford a passage for water to the pump well.",
   "Limberness": "The quality or state of being limber; flexibleness.",
   "Limbo": "Alt. of Limbus",
   "Limbus": "An extramundane region where certain classes of souls were supposed to await the judgment.",
   "Limbus": "Hence: Any real or imaginary place of restraint or confinement; a prison; as, to put a man in limbo.",
   "Limbus": "A border or margin; as, the limbus of the cornea.",
   "Lime": "A thong by which a dog is led; a leash.",
   "Lime": "The linden tree. See Linden.",
   "Lime": "A fruit allied to the lemon, but much smaller; also, the tree which bears it. There are two kinds; Citrus Medica, var. acida which is intensely sour, and the sweet lime (C. Medica, var. Limetta) which is only slightly sour.",
   "Lime": "Birdlime.",
   "Lime": "Oxide of calcium; the white or gray, caustic substance, usually called quicklime, obtained by calcining limestone or shells, the heat driving off carbon dioxide and leaving lime. It develops great heat when treated with water, forming slacked lime, and is an essential ingredient of cement, plastering, mortar, etc.",
   "Limehound": "A dog used in hunting the wild boar; a leamer.",
   "Limekiln": "A kiln or furnace in which limestone or shells are burned and reduced to lime.",
   "Limenean": "A native or inhabitant of Lima.",
   "Limer": "A limehound; a limmer.",
   "Limestone": "A rock consisting chiefly of calcium carbonate or carbonate of lime. It sometimes contains also magnesium carbonate, and is then called magnesian or dolomitic limestone. Crystalline limestone is called marble.",
   "Limewater": "Water impregnated with lime; esp., an artificial solution of lime for medicinal purposes.",
   "Liminess": "The state or quality of being limy.",
   "Limitary": "That which serves to limit; a boundary; border land.",
   "Limitary": "A limiter. See Limiter, 2.",
   "Limitedness": "The quality of being limited.",
   "Limiter": "One who, or that which, limits.",
   "Limiter": "A friar licensed to beg within certain bounds, or whose duty was limited to a certain district.",
   "Limitour": "See Limiter, 2.",
   "Limmer": "A limehound; a leamer.",
   "Limmer": "A mongrel, as a cross between the mastiff and hound.",
   "Limmer": "A low, base fellow; also, a prostitute.",
   "Limmer": "A man rope at the side of a ladder.",
   "Lim": "A genus of fresh-water air-breathing mollusks, abundant in ponds and streams; -- called also pond snail.",
   "Limner": "A painter; an artist",
   "Limner": "One who paints portraits.",
   "Limner": "One who illuminates books.",
   "Limniad": "See Limoniad.",
   "Limning": "The act, process, or art of one who limns; the picture or decoration so produced.",
   "Limoges": "A city of Southern France.",
   "Limoniad": "A nymph of the meadows; -- called also Limniad.",
   "Limonin": "A bitter, white, crystalline substance found in orange and lemon seeds.",
   "Limonite": "Hydrous sesquioxide of iron, an important ore of iron, occurring in stalactitic, mammillary, or earthy forms, of a dark brown color, and yellowish brown powder. It includes bog iron. Also called brown hematite.",
   "Limosis": "A ravenous appetite caused by disease; excessive and morbid hunger.",
   "Limp": "A halt; the act of limping.",
   "Limp": "A scraper for removing poor ore or refuse from the sieve.",
   "Limper": "One who limps.",
   "Limpet": "In a general sense, any hatshaped, or conical, gastropod shell.",
   "Limpet": "Any one of many species of marine shellfish of the order Docoglossa, mostly found adhering to rocks, between tides.",
   "Limpet": "Any species of Siphonaria, a genus of limpet-shaped Pulmonifera, living between tides, on rocks.",
   "Limpet": "A keyhole limpet. See Fissurella.",
   "Limpidity": "The quality or state of being limpid.",
   "Limpidness": "Quality of being limpid; limpidity.",
   "Limpin": "A limpet.",
   "Limpitude": "Limpidity.",
   "Limpkin": "Either one of two species of wading birds of the genus Aramus, intermediate between the cranes and rails. The limpkins are remarkable for the great length of the toes. One species (A. giganteus) inhabits Florida and the West Indies; the other (A. scolopaceus) is found in South America. Called also courlan, and crying bird.",
   "Limpness": "The quality or state of being limp.",
   "Limu": "The Hawaiian name for seaweeds. Over sixty kinds are used as food, and have species names, as Limu Lipoa, Limu palawai, etc.",
   "Limule": "A limulus.",
   "Limulus": "The only existing genus of Merostomata. It includes only a few species from the East Indies, and one (Limulus polyphemus) from the Atlantic coast of North America. Called also Molucca crab, king crab, horseshoe crab, and horsefoot.",
   "Lin": "A pool or collection of water, particularly one above or below a fall of water.",
   "Lin": "A waterfall, or cataract; as, a roaring lin.",
   "Lin": "A steep ravine.",
   "Linage": "See Lineage.",
   "Linament": "Lint; esp., lint made into a tent for insertion into wounds or ulcers.",
   "Linarite": "A hydrous sulphate of lead and copper occurring in bright blue monoclinic crystals.",
   "Linch": "A ledge; a right-angled projection.",
   "Linchi": "An esculent swallow.",
   "Linchpin": "A pin used to prevent the wheel of a vehicle from sliding off the axletree.",
   "Lincture": "Alt. of Linctus",
   "Linctus": "Medicine taken by licking with the tongue.",
   "Lind": "The linden. See Linden.",
   "Linden": "A handsome tree (Tilia Europaea), having cymes of light yellow flowers, and large cordate leaves. The tree is common in Europe.",
   "Linden": "In America, the basswood, or Tilia Americana.",
   "Lindia": "A peculiar genus of rotifers, remarkable for the absence of ciliated disks. By some zoologists it is thought to be like the ancestral form of the Arthropoda.",
   "Line": "Flax; linen.",
   "Line": "The longer and finer fiber of flax.",
   "Line": "A linen thread or string; a slender, strong cord; also, a cord of any thickness; a rope; a hawser; as, a fishing line; a line for snaring birds; a clothesline; a towline.",
   "Line": "A more or less threadlike mark of pen, pencil, or graver; any long mark; as, a chalk line.",
   "Line": "The course followed by anything in motion; hence, a road or route; as, the arrow descended in a curved line; the place is remote from lines of travel.",
   "Line": "Direction; as, the line of sight or vision.",
   "Line": "A row of letters, words, etc., written or printed; esp., a row of words extending across a page or column.",
   "Line": "A short letter; a note; as, a line from a friend.",
   "Line": "A verse, or the words which form a certain number of feet, according to the measure.",
   "Line": "Course of conduct, thought, occupation, or policy; method of argument; department of industry, trade, or intellectual activity.",
   "Line": "That which has length, but not breadth or thickness.",
   "Line": "The exterior limit of a figure, plat, or territory; boundary; contour; outline.",
   "Line": "A threadlike crease marking the face or the hand; hence, characteristic mark.",
   "Line": "Lineament; feature; figure.",
   "Line": "A straight row; a continued series or rank; as, a line of houses, or of soldiers; a line of barriers.",
   "Line": "A series or succession of ancestors or descendants of a given person; a family or race; as, the ascending or descending line; the line of descent; the male line; a line of kings.",
   "Line": "A connected series of public conveyances, and hence, an established arrangement for forwarding merchandise, etc.; as, a line of stages; an express line.",
   "Line": "A circle of latitude or of longitude, as represented on a map.",
   "Line": "The equator; -- usually called the line, or equinoctial line; as, to cross the line.",
   "Line": "A long tape, or a narrow ribbon of steel, etc., marked with subdivisions, as feet and inches, for measuring; a tapeline.",
   "Line": "A measuring line or cord.",
   "Line": "That which was measured by a line, as a field or any piece of land set apart; hence, allotted place of abode.",
   "Line": "Instruction; doctrine.",
   "Line": "The proper relative position or adjustment of parts, not as to design or proportion, but with reference to smooth working; as, the engine is in line or out of line.",
   "Line": "The track and roadbed of a railway; railroad.",
   "Line": "A row of men who are abreast of one another, whether side by side or some distance apart; -- opposed to column.",
   "Line": "The regular infantry of an army, as distinguished from militia, guards, volunteer corps, cavalry, artillery, etc.",
   "Line": "A trench or rampart.",
   "Line": "Dispositions made to cover extended positions, and presenting a front in but one direction to an enemy.",
   "Line": "Form of a vessel as shown by the outlines of vertical, horizontal, and oblique sections.",
   "Line": "One of the straight horizontal and parallel prolonged strokes on and between which the notes are placed.",
   "Line": "A number of shares taken by a jobber.",
   "Line": "A series of various qualities and values of the same general class of articles; as, a full line of hosiery; a line of merinos, etc.",
   "Line": "The wire connecting one telegraphic station with another, or the whole of a system of telegraph wires under one management and name.",
   "Line": "The reins with which a horse is guided by his driver.",
   "Line": "A measure of length; one twelfth of an inch.",
   "Lineage": "Descent in a line from a common progenitor; progeny; race; descending line of offspring or ascending line of parentage.",
   "Lineality": "The quality of being lineal.",
   "Lineament": "One of the outlines, exterior features, or distinctive marks, of a body or figure, particularly of the face; feature; form; mark; -- usually in the plural.",
   "Lineation": "Delineation; a line or lines.",
   "Lineature": "Anything having outline.",
   "Lineman": "One who carries the line in surveying, etc.",
   "Lineman": "A man employed to examine the rails of a railroad to see if they are in good condition; also, a man employed to repair telegraph lines.",
   "Linen": "Made of linen; as, linen cloth; a linen stocking.",
   "Linen": "Resembling linen cloth; white; pale.",
   "Linen": "Thread or cloth made of flax or (rarely) of hemp; -- used in a general sense to include cambric, shirting, sheeting, towels, tablecloths, etc.",
   "Linen": "Underclothing, esp. the shirt, as being, in former times, chiefly made of linen.",
   "Linener": "A dealer in linen; a linen draper.",
   "Liner": "One who lines, as, a liner of shoes.",
   "Liner": "A vessel belonging to a regular line of packets; also, a line-of-battle ship; a ship of the line.",
   "Liner": "A thin piece placed between two parts to hold or adjust them, fill a space, etc.; a shim.",
   "Liner": "A lining within the cylinder, in which the piston works and between which and the outer shell of the cylinder a space is left to form a steam jacket.",
   "Liner": "A slab on which small pieces of marble, tile, etc., are fastened for grinding.",
   "Liner": "A ball which, when struck, flies through the air in a nearly straight line not far from the ground.",
   "Ling": "Heather (Calluna vulgaris).",
   "Linga": "Alt. of Lingam",
   "Lingam": "The phallic symbol under which Siva is principally worshiped in his character of the creative and reproductive power.",
   "Ling-bird": "The European meadow pipit; -- called also titling.",
   "Lingel": "A shoemaker's thread.",
   "Lingel": "A little tongue or thong of leather; a lacing for belts.",
   "Lingence": "A linctus.",
   "Lingerer": "One who lingers.",
   "Linget": "An ingot.",
   "Lingism": "A mode of treating certain diseases, as obesity, by gymnastics; -- proposed by Pehr Henrik Ling, a Swede. See Kinesiatrics.",
   "Lingle": "See Lingel.",
   "Lingo": "Language; speech; dialect.",
   "Lingot": "A linget or ingot; also, a mold for casting metals. See Linget.",
   "Lingua": "A tongue.",
   "Lingua": "A median process of the labium, at the under side of the mouth in insects, and serving as a tongue.",
   "Linguadental": "An articulation pronounced by the aid or use of the tongue and teeth.",
   "Lingual": "A consonant sound formed by the aid of the tongue; -- a term especially applied to certain articulations (as those of t, d, th, and n) and to the letters denoting them.",
   "Linguality": "The quality of being lingual.",
   "Linguist": "A master of the use of language; a talker.",
   "Linguist": "A person skilled in languages.",
   "Linguistics": "The science of languages, or of the origin, signification, and application of words; glossology.",
   "Lingula": "A tonguelike process or part.",
   "Lingula": "Any one of numerous species of brachiopod shells belonging to the genus Lingula, and related genera. See Brachiopoda, and Illustration in Appendix.",
   "Liniment": "A liquid or semiliquid preparation of a consistence thinner than an ointment, applied to the skin by friction, esp. one used as a sedative or a stimulant.",
   "Lining": "The act of one who lines; the act or process of making lines, or of inserting a lining.",
   "Lining": "That which covers the inner surface of anything, as of a garment or a box; also, the contents of anything.",
   "Link": "A torch made of tow and pitch, or the like.",
   "Link": "A single ring or division of a chain.",
   "Link": "Hence: Anything, whether material or not, which binds together, or connects, separate things; a part of a connected series; a tie; a bond.",
   "Link": "Anything doubled and closed like a link; as, a link of horsehair.",
   "Link": "Any one of the several elementary pieces of a mechanism, as the fixed frame, or a rod, wheel, mass of confined liquid, etc., by which relative motion of other parts is produced and constrained.",
   "Link": "Any intermediate rod or piece for transmitting force or motion, especially a short connecting rod with a bearing at each end; specifically (Steam Engine), the slotted bar, or connecting piece, to the opposite ends of which the eccentric rods are jointed, and by means of which the movement of the valve is varied, in a link motion.",
   "Link": "The length of one joint of Gunter's chain, being the hundredth part of it, or 7.92 inches, the chain being 66 feet in length. Cf. Chain, n., 4.",
   "Link": "A bond of affinity, or a unit of valence between atoms; -- applied to a unit of chemical force or attraction.",
   "Link": "Sausages; -- because linked together.",
   "Linkage": "The act of linking; the state of being linked; also, a system of links.",
   "Linkage": "Manner of linking or of being linked; -- said of the union of atoms or radicals in the molecule.",
   "Linkage": "A system of straight lines or bars, fastened together by joints, and having certain of their points fixed in a plane. It is used to describe straight lines and curves in the plane.",
   "Linkboy": "Alt. of Linkman",
   "Linkman": "A boy or man that carried a link or torch to light passengers.",
   "Linkwork": "A fabric consisting of links made of metal or other material fastened together; also, a chain.",
   "Linkwork": "Mechanism in which links, or intermediate connecting pieces, are employed to transmit motion from one part to another.",
   "Linnaeite": "A mineral of pale steel-gray color and metallic luster, occurring in isometric crystals, and also massive. It is a sulphide of cobalt containing some nickel or copper.",
   "Linne": "Flax. See Linen.",
   "Linnet": "Any one of several species of fringilline birds of the genera Linota, Acanthis, and allied genera, esp. the common European species (L. cannabina), which, in full summer plumage, is chestnut brown above, with the breast more or less crimson. The feathers of its head are grayish brown, tipped with crimson. Called also gray linnet, red linnet, rose linnet, brown linnet, lintie, lintwhite, gorse thatcher, linnet finch, and greater redpoll. The American redpoll linnet (Acanthis linaria) often has the crown and throat rosy. See Redpoll, and Twite.",
   "Linoleate": "A salt of linoleic acid.",
   "Linoleum": "Linseed oil brought to various degrees of hardness by some oxidizing process, as by exposure to heated air, or by treatment with chloride of sulphur. In this condition it is used for many of the purposes to which India rubber has been applied.",
   "Linoleum": "A kind of floor cloth made by laying hardened linseed oil mixed with ground cork on a canvas backing.",
   "Linoxin": "A resinous substance obtained as an oxidation product of linoleic acid.",
   "Linsang": "Any viverrine mammal of the genus Prionodon, inhabiting the East Indies and Southern Asia. The common East Indian linsang (P. gracilis) is white, crossed by broad, black bands. The Guinea linsang (Porana Richardsonii) is brown with black spots.",
   "Linseed": "The seeds of flax, from which linseed oil is obtained.",
   "Linsey": "Linsey-woolsey.",
   "Linsey-woolsey": "Cloth made of linen and wool, mixed.",
   "Linsey-woolsey": "Jargon.",
   "Linstock": "A pointed forked staff, shod with iron at the foot, to hold a lighted match for firing cannon.",
   "Lint": "Flax.",
   "Lint": "Linen scraped or otherwise made into a soft, downy or fleecy substance for dressing wounds and sores; also, fine ravelings, down, fluff, or loose short fibers from yarn or fabrics.",
   "Lintel": "A horizontal member spanning an opening, and carrying the superincumbent weight by means of its strength in resisting crosswise fracture.",
   "Lintie": "Alt. of Lintwhite",
   "Lintwhite": "See Linnet.",
   "Lintseed": "See Linseed.",
   "Linum": "A genus of herbaceous plants including the flax (Linum usitatissimum).",
   "Lion": "A large carnivorous feline mammal (Felis leo), found in Southern Asia and in most parts of Africa, distinct varieties occurring in the different countries. The adult male, in most varieties, has a thick mane of long shaggy hair that adds to his apparent size, which is less than that of the largest tigers. The length, however, is sometimes eleven feet to the base of the tail. The color is a tawny yellow or yellowish brown; the mane is darker, and the terminal tuft of the tail is black. In one variety, called the maneless lion, the male has only a slight mane.",
   "Lion": "A sign and a constellation; Leo.",
   "Lion": "An object of interest and curiosity, especially a person who is so regarded; as, he was quite a lion in London at that time.",
   "Lioncel": "A small lion, especially one of several borne in the same coat of arms.",
   "Lionel": "The whelp of a lioness; a young lion.",
   "Lioness": "A female lion.",
   "Lionet": "A young or small lion.",
   "Lion-heart": "A very brave person.",
   "Lionhood": "State of being a lion.",
   "Lionism": "An attracting of attention, as a lion; also, the treating or regarding as a lion.",
   "Lionship": "The state of being a lion.",
   "Lip": "One of the two fleshy folds which surround the orifice of the mouth in man and many other animals. In man the lips are organs of speech essential to certain articulations. Hence, by a figure they denote the mouth, or all the organs of speech, and sometimes speech itself.",
   "Lip": "An edge of an opening; a thin projecting part of anything; a kind of short open spout; as, the lip of a vessel.",
   "Lip": "The sharp cutting edge on the end of an auger.",
   "Lip": "One of the two opposite divisions of a labiate corolla.",
   "Lip": "The odd and peculiar petal in the Orchis family. See Orchidaceous.",
   "Lip": "One of the edges of the aperture of a univalve shell.",
   "Lipaemia": "A condition in which fat occurs in the blood.",
   "Liparian": "Any species of a family (Liparidae) of destructive bombycid moths, as the tussock moths.",
   "Liparite": "A quartzose trachyte; rhyolite.",
   "Liplet": "A little lip.",
   "Lipochrin": "A yellow coloring matter, soluble in ether, contained in the small round fat drops in the retinal epithelium cells. It is best obtained from the eyes of frogs.",
   "Lipogram": "A writing composed of words not having a certain letter or letters; -- as in the Odyssey of Tryphiodorus there was no A in the first book, no B in the second, and so on.",
   "Lipogrammatist": "One who makes a lipogram.",
   "Lipoma": "A tumor consisting of fat or adipose tissue.",
   "Lipothymy": "A fainting; a swoon.",
   "Lippitude": "Soreness of eyes; the state of being blear-eyed; blearedness.",
   "Lipyl": "A hypothetical radical of glycerin.",
   "Liquation": "The act or operation of making or becoming liquid; also, the capacity of becoming liquid.",
   "Liquation": "The process of separating, by heat, an easily fusible metal from one less fusible; eliquation.",
   "Liquefacient": "That which serves to liquefy.",
   "Liquefacient": "An agent, as mercury, iodine, etc., which promotes the liquefying processes of the system, and increases the secretions.",
   "Liquefaction": "The act or operation of making or becoming liquid; especially, the conversion of a solid into a liquid by the sole agency of heat.",
   "Liquefaction": "The state of being liquid.",
   "Liquefaction": "The act, process, or method, of reducing a gas or vapor to a liquid by means of cold or pressure; as, the liquefaction of oxygen or hydrogen.",
   "Liquefier": "That which liquefies.",
   "Liquescency": "The quality or state of being liquescent.",
   "Liqueur": "An aromatic alcoholic cordial.",
   "Liquid": "A substance whose parts change their relative position on the slightest pressure, and therefore retain no definite form; any substance in the state of liquidity; a fluid that is not aeriform.",
   "Liquid": "A letter which has a smooth, flowing sound, or which flows smoothly after a mute; as, l and r, in bla, bra. M and n also are called liquids.",
   "Liquidambar": "A genus consisting of two species of tall trees having star-shaped leaves, and woody burlike fruit. Liquidambar styraciflua is the North American sweet qum, and L. Orientalis is found in Asia Minor.",
   "Liquidambar": "The balsamic juice which is obtained from these trees by incision. The liquid balsam of the Oriental tree is liquid storax.",
   "Liquidamber": "See Liquidambar.",
   "Liquidation": "The act or process of liquidating; the state of being liquidated.",
   "Liquidator": "One who, or that which, liquidates.",
   "Liquidator": "An officer appointed to conduct the winding up of a company, to bring and defend actions and suits in its name, and to do all necessary acts on behalf of the company.",
   "Liquidity": "The state or quality of being liquid.",
   "Liquidness": "The quality or state of being liquid; liquidity; fluency.",
   "Liquor": "Any liquid substance, as water, milk, blood, sap, juice, or the like.",
   "Liquor": "Specifically, alcoholic or spirituous fluid, either distilled or fermented, as brandy, wine, whisky, beer, etc.",
   "Liquor": "A solution of a medicinal substance in water; -- distinguished from tincture and aqua.",
   "Liquorice": "See Licorice.",
   "Lira": "An Italian coin equivalent in value to the French franc.",
   "Lirella": "A linear apothecium furrowed along the middle; the fruit of certain lichens.",
   "Liriodendron": "A genus of large and very beautiful trees of North America, having smooth, shining leaves, and handsome, tuliplike flowers; tulip tree; whitewood; -- called also canoewood. Liriodendron tulipifera is the only extant species, but there were several others in the Cretaceous epoch.",
   "Liripipe": "See Liripoop.",
   "Liripoop": "A pendent part of the old clerical tippet; afterwards, a tippet; a scarf; -- worn also by doctors, learned men, etc.",
   "Liripoop": "Acuteness; smartness; also, a smart trick or stratagem.",
   "Liripoop": "A silly person.",
   "Liroconite": "A hydrated arseniate of copper, occurring in obtuse pyramidal crystals of a sky-blue or verdigris-green color.",
   "Lisbon": "A sweet, light-colored species of wine, produced in the province of Estremadura, and so called as being shipped from Lisbon, in Portugal.",
   "Lisle": "A city of France celebrated for certain manufactures.",
   "Lisne": "A cavity or hollow.",
   "Lisp": "The habit or act of lisping. See Lisp, v. i., 1.",
   "Lisper": "One who lisps.",
   "Liss": "Release; remission; ease; relief.",
   "List": "A line inclosing or forming the extremity of a piece of ground, or field of combat; hence, in the plural (lists), the ground or field inclosed for a race or combat.",
   "List": "Inclination; desire.",
   "List": "An inclination to one side; as, the ship has a list to starboard.",
   "List": "A strip forming the woven border or selvedge of cloth, particularly of broadcloth, and serving to strengthen it; hence, a strip of cloth; a fillet.",
   "List": "A limit or boundary; a border.",
   "List": "The lobe of the ear; the ear itself.",
   "List": "A stripe.",
   "List": "A roll or catalogue, that is row or line; a record of names; as, a list of names, books, articles; a list of ratable estate.",
   "List": "A little square molding; a fillet; -- called also listel.",
   "List": "A narrow strip of wood, esp. sapwood, cut from the edge of a plank or board.",
   "List": "A piece of woolen cloth with which the yarns are grasped by a workman.",
   "List": "The first thin coat of tin.",
   "List": "A wirelike rim of tin left on an edge of the plate after it is coated.",
   "Listel": "Same as List, n., 6.",
   "Listener": "One who listens; a hearkener.",
   "Lister": "One who makes a list or roll.",
   "Lister": "Same as Leister.",
   "Listerism": "The systematic use of antiseptics in the performance of operations and the treatment of wounds; -- so called from Joseph Lister, an English surgeon.",
   "Listing": "The act or process of one who lists (in any sense of the verb); as, the listing of a door; the listing of a stock at the Stock Exchange.",
   "Listing": "The selvedge of cloth; list.",
   "Listing": "The sapwood cut from the edge of a board.",
   "Listing": "The throwing up of the soil into ridges, -- a method adopted in the culture of beets and some garden crops.",
   "Litany": "A solemn form of supplication in the public worship of various churches, in which the clergy and congregation join, the former leading and the latter responding in alternate sentences. It is usually of a penitential character.",
   "Litarge": "Litharge.",
   "Litchi": "The fruit of a tree native to China (Nephelium Litchi). It is nutlike, having a rough but tender shell, containing an aromatic pulp, and a single large seed. In the dried fruit which is exported the pulp somewhat resembles a raisin in color and form.",
   "Liter": "Alt. of Litre",
   "Litre": "A measure of capacity in the metric system, being a cubic decimeter, equal to 61.022 cubic inches, or 2.113 American pints, or 1.76 English pints.",
   "Literacy": "State of being literate.",
   "Literal": "Literal meaning.",
   "Literalism": "That which accords with the letter; a mode of interpreting literally; adherence to the letter.",
   "Literalism": "The tendency or disposition to represent objects faithfully, without abstraction, conventionalities, or idealization.",
   "Literalist": "One who adheres to the letter or exact word; an interpreter according to the letter.",
   "Literalty": "The state or quality of being literal.",
   "Literalization": "The act of literalizing; reduction to a literal meaning.",
   "Literalizer": "A literalist.",
   "Literalness": "The quality or state of being literal; literal import.",
   "Literate": "One educated, but not having taken a university degree; especially, such a person who is prepared to take holy orders.",
   "Literate": "A literary man.",
   "Literation": "The act or process of representing by letters.",
   "Literator": "One who teaches the letters or elements of knowledge; a petty schoolmaster.",
   "Literator": "A person devoted to the study of literary trifles, esp. trifles belonging to the literature of a former age.",
   "Literator": "A learned person; a literatus.",
   "Literature": "Learning; acquaintance with letters or books.",
   "Literature": "The collective body of literary productions, embracing the entire results of knowledge and fancy preserved in writing; also, the whole body of literary productions or writings upon a given subject, or in reference to a particular science or branch of knowledge, or of a given country or period; as, the literature of Biblical criticism; the literature of chemistry.",
   "Literature": "The class of writings distinguished for beauty of style or expression, as poetry, essays, or history, in distinction from scientific treatises and works which contain positive knowledge; belles-lettres.",
   "Literature": "The occupation, profession, or business of doing literary work.",
   "Literatus": "A learned man; a man acquainted with literature; -- chiefly used in the plural.",
   "Lith": "A joint or limb; a division; a member; a part formed by growth, and articulated to, or symmetrical with, other parts.",
   "Lithaemia": "A condition in which uric (lithic) acid is present in the blood.",
   "Lithagogue": "A medicine having, or supposed to have, the power of expelling calculous matter with the urine.",
   "Litharge": "Lead monoxide; a yellowish red substance, obtained as an amorphous powder, or crystallized in fine scales, by heating lead moderately in a current of air or by calcining lead nitrate or carbonate. It is used in making flint glass, in glazing earthenware, in making red lead minium, etc. Called also massicot.",
   "Lithargyrum": "Crystallized litharge, obtained by fusion in the form of fine yellow scales.",
   "Lithate": "A salt of lithic or uric acid; a urate.",
   "Litheness": "The quality or state of being lithe; flexibility; limberness.",
   "Lithia": "The oxide of lithium; a strong alkaline caustic similar to potash and soda, but weaker. See Lithium.",
   "Lithiasis": "The formation of stony concretions or calculi in any part of the body, especially in the bladder and urinary passages.",
   "Lithic": "A medicine which tends to prevent stone in the bladder.",
   "Lithiophilite": "A phosphate of manganese and lithium; a variety of triphylite.",
   "Lithium": "A metallic element of the alkaline group, occurring in several minerals, as petalite, spodumene, lepidolite, triphylite, etc., and otherwise widely disseminated, though in small quantities.",
   "Lithocarp": "Fossil fruit; a fruit petrified; a carpolite.",
   "Lithochromatics": "See Lithochromics.",
   "Lithochromics": "The art of printing colored pictures on canvas from oil paintings on stone.",
   "Lithoclast": "An instrument for crushing stones in the bladder.",
   "Lithocyst": "A sac containing small, calcareous concretions (otoliths). They are found in many Medusae, and other invertebrates, and are supposed to be auditory organs.",
   "Lithodome": "Any one of several species of bivalves, which form holes in limestone, in which they live; esp., any species of the genus Lithodomus.",
   "Lithodomus": "A genus of elongated bivalve shells, allied to the mussels, and remarkable for their ability to bore holes for shelter, in solid limestone, shells, etc. Called also Lithophagus.",
   "Lithofracteur": "An explosive compound of nitroglycerin. See Nitroglycerin.",
   "Lithogenesy": "The doctrine or science of the origin of the minerals composing the globe.",
   "Lithoglyph": "An engraving on a gem.",
   "Lithoglypher": "One who curs or engraves precious stones.",
   "Lithoglyptics": "The art of cutting and engraving gems.",
   "Lithograph": "A print made by lithography.",
   "Lithographer": "One who lithographs; one who practices lithography.",
   "Lithography": "The art or process of putting designs or writing, with a greasy material, on stone, and of producing printed impressions therefrom. The process depends, in the main, upon the antipathy between grease and water, which prevents a printing ink containing oil from adhering to wetted parts of the stone not covered by the design. See Lithographic limestone, under Lithographic.",
   "Litholatry": "The worship of a stone or stones.",
   "Lithologist": "One who is skilled in lithology.",
   "Lithology": "The science which treats of rocks, as regards their mineral constitution and classification, and their mode of occurrence in nature.",
   "Lithology": "A treatise on stones found in the body.",
   "Lithomancy": "Divination by means of stones.",
   "Lithomarge": "A clay of a fine smooth texture, and very sectile.",
   "Lithontriptic": "A lithontriptic remedy or agent, as distilled water.",
   "Lithontriptist": "Same as Lithotriptist.",
   "Lithontriptor": "See Lithotriptor.",
   "Lithophane": "Porcelain impressed with figures which are made distinct by transmitted light, -- as when hung in a window, or used as a lamp shade.",
   "Lithophosphor": "A stone that becomes phosphoric by heat.",
   "Lithophotography": "Same as Photolithography.",
   "Lithophyll": "A fossil leaf or impression of a leaf.",
   "Lithophyse": "A spherulitic cavity often with concentric chambers, observed in some volcanic rocks, as in rhyolitic lavas. It is supposed to be produced by expanding gas, whence the name.",
   "Lithophyte": "A hard, or stony, plantlike organism, as the gorgonians, corals, and corallines, esp. those gorgonians having a calcareous axis. All the lithophytes except the corallines are animals.",
   "Lithosian": "Any one of various species of moths belonging to the family Lithosidae. Many of them are beautifully colored.",
   "Lithotint": "A kind of lithography by which the effect of a tinted drawing is produced, as if made with India ink.",
   "Lithotint": "A picture produced by this process.",
   "Lithotome": "A stone so formed by nature as to appear as if cut by art.",
   "Lithotome": "An instrument used for cutting the bladder in operations for the stone.",
   "Lithotomist": "One who performs the operation of cutting for stone in the bladder, or one who is skilled in the operation.",
   "Lithotomy": "The operation, art, or practice of cutting for stone in the bladder.",
   "Lithotripsy": "The operation of crushing a stone in the bladder with an instrument called lithotriptor or lithotrite; lithotrity.",
   "Lithotriptist": "One skilled in breaking and extracting stone in the bladder.",
   "Lithotriptor": "An instrument for triturating the stone in the bladder; a lithotrite.",
   "Lithotritist": "A lithotriptist.",
   "Lithotrity": "The operation of breaking a stone in the bladder into small pieces capable of being voided.",
   "Lithotype": "A kind of stereotype plate made by lithotypy; also, that which in printed from it. See Lithotypy.",
   "Lithotypy": "The art or process of making a kind of hard, stereotypeplate, by pressing into a mold, taken from a page of type or other matter, a composition of gum shell-lac and sand of a fine quality, together with a little tar and linseed oil, all in a heated state.",
   "Lithoxyl": "Petrified wood.",
   "Lithuanian": "A native, or one of the people, of Lithuania; also, the language of the Lithuanian people.",
   "Litigant": "A person engaged in a lawsuit.",
   "Litigation": "The act or process of litigating; a suit at law; a judicial contest.",
   "Litigator": "One who litigates.",
   "Litigiousness": "The state of being litigious; disposition to engage in or carry on lawsuits.",
   "Litmus": "A dyestuff extracted from certain lichens (Roccella tinctoria, Lecanora tartarea, etc.), as a blue amorphous mass which consists of a compound of the alkaline carbonates with certain coloring matters related to orcin and orcein.",
   "Litraneter": "An instrument for ascertaining the specific gravity of liquids.",
   "Litre": "Same as Liter.",
   "Litter": "A bed or stretcher so arranged that a person, esp. a sick or wounded person, may be easily carried in or upon it.",
   "Litter": "Straw, hay, etc., scattered on a floor, as bedding for animals to rest on; also, a covering of straw for plants.",
   "Litter": "Things lying scattered about in a manner indicating slovenliness; scattered rubbish.",
   "Litter": "Disorder or untidiness resulting from scattered rubbish, or from thongs lying about uncared for; as, a room in a state of litter.",
   "Litter": "The young brought forth at one time, by a sow or other multiparous animal, taken collectively. Also Fig.",
   "Litterateur": "One who occupies himself with literature; a literary man; a literatus.",
   "Little": "That which is little; a small quantity, amount, space, or the like.",
   "Little": "A small degree or scale; miniature.",
   "Little-ease": "An old slang name for the pillory, stocks, etc., of a prison.",
   "Littleness": "The state or quality of being little; as, littleness of size, thought, duration, power, etc.",
   "Littorina": "A genus of small pectinibranch mollusks, having thick spiral shells, abundant between tides on nearly all rocky seacoasts. They feed on seaweeds. The common periwinkle is a well-known example. See Periwinkle.",
   "Littress": "A smooth kind of cartridge paper used for making cards.",
   "Lituite": "Any species of ammonites of the genus Lituites. They are found in the Cretaceous formation.",
   "Liturgics": "The science of worship; history, doctrine, and interpretation of liturgies.",
   "Liturgiologist": "One versed in liturgiology.",
   "Liturgiology": "The science treating of liturgical matters; a treatise on, or description of, liturgies.",
   "Liturgist": "One who favors or adheres strictly to a liturgy.",
   "Lituus": "A curved staff used by the augurs in quartering the heavens.",
   "Lituus": "An instrument of martial music; a kind of trumpet of a somewhat curved form and shrill note.",
   "Lituus": "A spiral whose polar equation is r2/ = a; that is, a curve the square of whose radius vector varies inversely as the angle which the radius vector makes with a given line.",
   "Live": "Life.",
   "Live-forever": "A plant (Sedum Telephium) with fleshy leaves, which has extreme powers of resisting drought; garden ox-pine.",
   "Livelihed": "See Livelihood.",
   "Livelihood": "Subsistence or living, as dependent on some means of support; support of life; maintenance.",
   "Livelihood": "Liveliness; appearance of life.",
   "Liveliness": "The quality or state of being lively or animated; sprightliness; vivacity; animation; spirit; as, the liveliness of youth, contrasted with the gravity of age.",
   "Liveliness": "An appearance of life, animation, or spirit; as, the liveliness of the eye or the countenance in a portrait.",
   "Liveliness": "Briskness; activity; effervescence, as of liquors.",
   "Livelode": "Course of life; means of support; livelihood.",
   "Liver": "One who, or that which, lives.",
   "Liver": "A resident; a dweller; as, a liver in Brooklyn.",
   "Liver": "One whose course of life has some marked characteristic (expressed by an adjective); as, a free liver.",
   "Liver": "A very large glandular and vascular organ in the visceral cavity of all vertebrates.",
   "Liver": "The glossy ibis (Ibis falcinellus); -- said to have given its name to the city of Liverpool.",
   "Livering": "A kind of pudding or sausage made of liver or pork.",
   "Liverleaf": "Same as Liverwort.",
   "Liverwort": "A ranunculaceous plant (Anemone Hepatica) with pretty white or bluish flowers and a three-lobed leaf; -- called also squirrel cups.",
   "Liverwort": "A flowerless plant (Marchantia polymorpha), having an irregularly lobed, spreading, and forking frond.",
   "Livery": "The act of delivering possession of lands or tenements.",
   "Livery": "The writ by which possession is obtained.",
   "Livery": "Release from wardship; deliverance.",
   "Livery": "That which is delivered out statedly or formally, as clothing, food, etc.",
   "Livery": "The uniform clothing issued by feudal superiors to their retainers and serving as a badge when in military service.",
   "Livery": "The peculiar dress by which the servants of a nobleman or gentleman are distinguished; as, a claret-colored livery.",
   "Livery": "Hence, also, the peculiar dress or garb appropriated by any association or body of persons to their own use; as, the livery of the London tradesmen, of a priest, of a charity school, etc.; also, the whole body or company of persons wearing such a garb, and entitled to the privileges of the association; as, the whole livery of London.",
   "Livery": "Hence, any characteristic dress or outward appearance.",
   "Livery": "An allowance of food statedly given out; a ration, as to a family, to servants, to horses, etc.",
   "Livery": "The feeding, stabling, and care of horses for compensation; boarding; as, to keep one's horses at livery.",
   "Livery": "The keeping of horses in readiness to be hired temporarily for riding or driving; the state of being so kept.",
   "Livery": "A low grade of wool.",
   "Liveryman": "One who wears a livery, as a servant.",
   "Liveryman": "A freeman of the city, in London, who, having paid certain fees, is entitled to wear the distinguishing dress or livery of the company to which he belongs, and also to enjoy certain other privileges, as the right of voting in an election for the lord mayor, sheriffs, chamberlain, etc.",
   "Liveryman": "One who keeps a livery stable.",
   "Lives": "pl. of Life.",
   "Lividity": "The state or quality of being livid.",
   "Lividness": "Lividity.",
   "Living": "The state of one who, or that which, lives; lives; life; existence.",
   "Living": "Manner of life; as, riotous living; penurious living; earnest living.",
   "Living": "Means of subsistence; sustenance; estate.",
   "Living": "Power of continuing life; the act of living, or living comfortably.",
   "Living": "The benefice of a clergyman; an ecclesiastical charge which a minister receives.",
   "Livingness": "The state or quality of being alive; possession of energy or vigor; animation; quickening.",
   "Livinian": "A native or an inhabitant of Livonia; the language (allied to the Finnish) of the Livonians.",
   "Livor": "Malignity.",
   "Livraison": "A part of a book or literary composition printed and delivered by itself; a number; a part.",
   "Livre": "A French money of account, afterward a silver coin equal to 20 sous. It is not now in use, having been superseded by the franc.",
   "Lixiviation": "Lixiviating; the process of separating a soluble substance form one that is insoluble, by washing with some solvent, as water; leaching.",
   "Lixivium": "A solution of alkaline salts extracted from wood ashes; hence, any solution obtained by lixiviation.",
   "Liza": "The American white mullet (Mugil curema).",
   "Lizard": "Any one of the numerous species of reptiles belonging to the order Lacertilia; sometimes, also applied to reptiles of other orders, as the Hatteria.",
   "Lizard": "A piece of rope with thimble or block spliced into one or both of the ends.",
   "Lizard": "A piece of timber with a forked end, used in dragging a heavy stone, a log, or the like, from a field.",
   "Llama": "A South American ruminant (Auchenia llama), allied to the camels, but much smaller and without a hump. It is supposed to be a domesticated variety of the guanaco. It was formerly much used as a beast of burden in the Andes.",
   "Llanero": "One of the inhabitants of the llanos of South America.",
   "Llano": "An extensive plain with or without vegetation.",
   "Lloyd's": "An association of underwriters and others in London, for the collection and diffusion of marine intelligence, the insurance, classification, registration, and certifying of vessels, and the transaction of business of various kinds connected with shipping.",
   "Lloyd's": "A part of the Royal Exchange, in London, appropriated to the use of underwriters and insurance brokers; -- called also Lloyd's Rooms.",
   "Loach": "Any one of several small, fresh-water, cyprinoid fishes of the genera Cobitis, Nemachilus, and allied genera, having six or more barbules around the mouth. They are found in Europe and Asia. The common European species (N. barbatulus) is used as a food fish.",
   "Loader": "One who, or that which, loads; a mechanical contrivance for loading, as a gun.",
   "Loading": "The act of putting a load on or into.",
   "Loading": "A load; cargo; burden.",
   "Loadmanage": "Alt. of Lodemanage",
   "Lodemanage": "Pilotage; skill of a pilot or loadsman.",
   "Loadsman": "Alt. of Lodesman",
   "Lodesman": "A pilot.",
   "Loadstar": "Alt. of Lodestar",
   "Lodestar": "A star that leads; a guiding star; esp., the polestar; the cynosure.",
   "Loadstone": "Alt. of Lodestone",
   "Lodestone": "A piece of magnetic iron ore possessing polarity like a magnetic needle. See Magnetite.",
   "Loaf": "Any thick lump, mass, or cake; especially, a large regularly shaped or molded mass, as of bread, sugar, or cake.",
   "Loafer": "One who loafs; a lazy lounger.",
   "Loam": "A kind of soil; an earthy mixture of clay and sand, with organic matter to which its fertility is chiefly due.",
   "Loam": "A mixture of sand, clay, and other materials, used in making molds for large castings, often without a pattern.",
   "Loan": "A loanin.",
   "Loan": "The act of lending; a lending; permission to use; as, the loan of a book, money, services.",
   "Loan": "That which one lends or borrows, esp. a sum of money lent at interest; as, he repaid the loan.",
   "Loanin": "Alt. of Loaning",
   "Loaning": "An open space between cultivated fields through which cattle are driven, and where the cows are sometimes milked; also, a lane.",
   "Loanmonger": "A dealer in, or negotiator of, loans.",
   "Loather": "One who loathes.",
   "Loathing": "Extreme disgust; a feeling of aversion, nausea, abhorrence, or detestation.",
   "Loathliness": "Loathsomeness.",
   "Loathness": "Unwillingness; reluctance.",
   "Loaves": "pl. of Loaf.",
   "Lob": "A dull, heavy person.",
   "Lob": "Something thick and heavy.",
   "Lob": "The European pollock.",
   "Lobby": "A passage or hall of communication, especially when large enough to serve also as a waiting room. It differs from an antechamber in that a lobby communicates between several rooms, an antechamber to one only; but this distinction is not carefully preserved.",
   "Lobby": "That part of a hall of legislation not appropriated to the official use of the assembly; hence, the persons, collectively, who frequent such a place to transact business with the legislators; any persons, not members of a legislative body, who strive to influence its proceedings by personal agency.",
   "Lobby": "An apartment or passageway in the fore part of an old-fashioned cabin under the quarter-deck.",
   "Lobby": "A confined place for cattle, formed by hedges. trees, or other fencing, near the farmyard.",
   "Lobbyist": "A member of the lobby; a person who solicits members of a legislature for the purpose of influencing legislation.",
   "Lobcock": "A dull, sluggish person; a lubber; a lob.",
   "Lobe": "Any projection or division, especially one of a somewhat rounded form",
   "Lobe": "A rounded projection or division of a leaf.",
   "Lobe": "A membranous flap on the sides of the toes of certain birds, as the coot.",
   "Lobe": "A round projecting part of an organ, as of the liver, lungs, brain, etc. See Illust. of Brain.",
   "Lobe": "The projecting part of a cam wheel or of a non-circular gear wheel.",
   "Lobefoot": "A bird having lobate toes; esp., a phalarope.",
   "Lobelet": "A small lobe; a lobule.",
   "Lobelia": "A genus of plants, including a great number of species. Lobelia inflata, or Indian tobacco, is an annual plant of North America, whose leaves contain a poisonous white viscid juice, of an acrid taste. It has often been used in medicine as an emetic, expectorant, etc. L. cardinalis is the cardinal flower, remarkable for the deep and vivid red color of its flowers.",
   "Lobelin": "A yellowish green resin from Lobelia, used as an emetic and diaphoretic.",
   "Lobeline": "A poisonous narcotic alkaloid extracted from the leaves of Indian tobacco (Lobelia inflata) as a yellow oil, having a tobaccolike taste and odor.",
   "Loblolly": "Gruel; porridge; -- so called among seamen.",
   "Lobscouse": "A combination of meat with vegetables, bread, etc., usually stewed, sometimes baked; an olio.",
   "Lobspound": "A prison.",
   "Lobster": "Any large macrurous crustacean used as food, esp. those of the genus Homarus; as the American lobster (H. Americanus), and the European lobster (H. vulgaris). The Norwegian lobster (Nephrops Norvegicus) is similar in form. All these have a pair of large unequal claws. The spiny lobsters of more southern waters, belonging to Palinurus, Panulirus, and allied genera, have no large claws. The fresh-water crayfishes are sometimes called lobsters.",
   "Lobule": "A small lobe; a subdivision of a lobe.",
   "Lobulette": "A little lobule, or subdivision of a lobule.",
   "Lobworm": "The lugworm.",
   "Local": "A train which receives and deposits passengers or freight along the line of the road; a train for the accommodation of a certain district.",
   "Local": "On newspaper cant, an item of news relating to the place where the paper is published.",
   "Locale": "A place, spot, or location.",
   "Locale": "A principle, practice, form of speech, or other thing of local use, or limited to a locality.",
   "Localism": "The state or quality of being local; affection for a particular place.",
   "Localism": "A method of speaking or acting peculiar to a certain district; a local idiom or phrase.",
   "Locality": "The state, or condition, of belonging to a definite place, or of being contained within definite limits.",
   "Locality": "Position; situation; a place; a spot; esp., a geographical place or situation, as of a mineral or plant.",
   "Locality": "Limitation to a county, district, or place; as, locality of trial.",
   "Locality": "The perceptive faculty concerned with the ability to remember the relative positions of places.",
   "Localization": "Act of localizing, or state of being localized.",
   "Location": "The act or process of locating.",
   "Location": "Situation; place; locality.",
   "Location": "That which is located; a tract of land designated in place.",
   "Location": "A leasing on rent.",
   "Location": "A contract for the use of a thing, or service of a person, for hire.",
   "Location": "The marking out of the boundaries, or identifying the place or site of, a piece of land, according to the description given in an entry, plan, map, etc.",
   "Locative": "The locative case.",
   "Locator": "One who locates, or is entitled to locate, land or a mining claim.",
   "Loch": "A lake; a bay or arm of the sea.",
   "Loch": "A kind of medicine to be taken by licking with the tongue; a lambative; a lincture.",
   "Lochage": "An officer who commanded a company; a captain.",
   "Lochan": "A small lake; a pond.",
   "Loche": "See Loach.",
   "Lock": "A tuft of hair; a flock or small quantity of wool, hay, or other like substance; a tress or ringlet of hair.",
   "Lock": "Anything that fastens; specifically, a fastening, as for a door, a lid, a trunk, a drawer, and the like, in which a bolt is moved by a key so as to hold or to release the thing fastened.",
   "Lock": "A fastening together or interlacing; a closing of one thing upon another; a state of being fixed or immovable.",
   "Lock": "A place from which egress is prevented, as by a lock.",
   "Lock": "The barrier or works which confine the water of a stream or canal.",
   "Lock": "An inclosure in a canal with gates at each end, used in raising or lowering boats as they pass from one level to another; -- called also lift lock.",
   "Lock": "That part or apparatus of a firearm by which the charge is exploded; as, a matchlock, flintlock, percussion lock, etc.",
   "Lock": "A device for keeping a wheel from turning.",
   "Lock": "A grapple in wrestling.",
   "Lockage": "Materials for locks in a canal, or the works forming a lock or locks.",
   "Lockage": "Toll paid for passing the locks of a canal.",
   "Lockage": "Amount of elevation and descent made by the locks of a canal.",
   "Lock-down": "A contrivance to fasten logs together in rafting; -- used by lumbermen.",
   "Locked-jaw": "See Lockjaw.",
   "Locken": "The globeflower (Trollius).",
   "Locker": "One who, or that which, locks.",
   "Locker": "A drawer, cupboard, compartment, or chest, esp. one in a ship, that may be closed with a lock.",
   "Locket": "A small lock; a catch or spring to fasten a necklace or other ornament.",
   "Locket": "A little case for holding a miniature or lock of hair, usually suspended from a necklace or watch chain.",
   "Lockjaw": "A contraction of the muscles of the jaw by which its motion is suspended; a variety of tetanus.",
   "Lockman": "A public executioner.",
   "Lockout": "The closing of a factory or workshop by an employer, usually in order to bring the workmen to satisfactory terms by a suspension of wages.",
   "Lockram": "A kind of linen cloth anciently used in England, originally imported from Brittany.",
   "Locksmith": "An artificer whose occupation is to make or mend locks.",
   "Lockup": "A place where persons under arrest are temporarily locked up; a watchhouse.",
   "Lock-weir": "A waste weir for a canal, discharging into a lock chamber.",
   "Loco": "A plant (Astragalus Hornii) growing in the Southwestern United States, which is said to poison horses and cattle, first making them insane. The name is also given vaguely to several other species of the same genus. Called also loco weed.",
   "Locofoco": "A friction match.",
   "Locofoco": "A nickname formerly given to a member of the Democratic party.",
   "Locomotion": "The act of moving from place to place.",
   "Locomotion": "The power of moving from place to place, characteristic of the higher animals and some of the lower forms of plant life.",
   "Locomotive": "A locomotive engine; a self-propelling wheel carriage, especially one which bears a steam boiler and one or more steam engines which communicate motion to the wheels and thus propel the carriage, -- used to convey goods or passengers, or to draw wagons, railroad cars, etc. See Illustration in Appendix.",
   "Locomotiveness": "Alt. of Locomotivity",
   "Locomotivity": "The power of changing place.",
   "Loculament": "The cell of a pericarp in which the seed is lodged.",
   "Locule": "A little hollow; a loculus.",
   "Loculus": "One of the spaces between the septa in the Anthozoa.",
   "Loculus": "One of the compartments of a several-celled ovary; loculament.",
   "Locus": "A place; a locality.",
   "Locus": "The line traced by a point which varies its position according to some determinate law; the surface described by a point or line that moves according to a given law.",
   "Locust": "Any one of numerous species of long-winged, migratory, orthopterous insects, of the family Acrididae, allied to the grasshoppers; esp., (Edipoda, / Pachytylus, migratoria, and Acridium perigrinum, of Southern Europe, Asia, and Africa. In the United States the related species with similar habits are usually called grasshoppers. See Grasshopper.",
   "Locust": "The locust tree. See Locust Tree (definition, note, and phrases).",
   "Locusta": "The spikelet or flower cluster of grasses.",
   "Locustella": "The European cricket warbler.",
   "Locution": "Speech or discourse; a phrase; a form or mode of expression.",
   "Locutory": "A room for conversation; especially, a room in monasteries, where the monks were allowed to converse.",
   "Lodde": "The capelin.",
   "Lode": "A water course or way; a reach of water.",
   "Lode": "A metallic vein; any regular vein or course, whether metallic or not.",
   "Lodemanage": "Pilotage.",
   "Lode-ship": "An old name for a pilot boat.",
   "Lodesman": "Same as Loadsman.",
   "Lodestar": "Same as Loadstar.",
   "Lodestone": "Same as Loadstone.",
   "Lodge": "A shelter in which one may rest; as: (a) A shed; a rude cabin; a hut; as, an Indian's lodge.",
   "Lodge": "A small dwelling house, as for a gamekeeper or gatekeeper of an estate.",
   "Lodge": "A den or cave.",
   "Lodge": "The meeting room of an association; hence, the regularly constituted body of members which meets there; as, a masonic lodge.",
   "Lodge": "The chamber of an abbot, prior, or head of a college.",
   "Lodge": "The space at the mouth of a level next the shaft, widened to permit wagons to pass, or ore to be deposited for hoisting; -- called also platt.",
   "Lodge": "A collection of objects lodged together.",
   "Lodge": "A family of North American Indians, or the persons who usually occupy an Indian lodge, -- as a unit of enumeration, reckoned from four to six persons; as, the tribe consists of about two hundred lodges, that is, of about a thousand individuals.",
   "Lodge": "To give shelter or rest to; especially, to furnish a sleeping place for; to harbor; to shelter; hence, to receive; to hold.",
   "Lodge": "To drive to shelter; to track to covert.",
   "Lodge": "To deposit for keeping or preservation; as, the men lodged their arms in the arsenal.",
   "Lodge": "To cause to stop or rest in; to implant.",
   "Lodge": "To lay down; to prostrate.",
   "Lodgement": "See Lodgment.",
   "Lodger": "One who, or that which, lodges; one who occupies a hired room in another's house.",
   "Lodging": "The act of one who, or that which, lodges.",
   "Lodging": "A place of rest, or of temporary habitation; esp., a sleeping apartment; -- often in the plural with a singular meaning.",
   "Lodging": "Abiding place; harbor; cover.",
   "Lodicule": "One of the two or three delicate membranous scales which are next to the stamens in grasses.",
   "Loellingite": "A tin-white arsenide of iron, isomorphous with arsenopyrite.",
   "Loess": "A quaternary deposit, usually consisting of a fine yellowish earth, on the banks of the Rhine and other large rivers.",
   "Loft": "That which is lifted up; an elevation.",
   "Loft": "The room or space under a roof and above the ceiling of the uppermost story.",
   "Loft": "A gallery or raised apartment in a church, hall, etc.; as, an organ loft.",
   "Loft": "A floor or room placed above another; a story.",
   "Loftiness": "The state or quality of being lofty.",
   "Log": "A Hebrew measure of liquids, containing 2.37 gills.",
   "Log": "A bulky piece of wood which has not been shaped by hewing or sawing.",
   "Log": "An apparatus for measuring the rate of a ship's motion through the water.",
   "Log": "Hence: The record of the rate of ship's speed or of her daily progress; also, the full nautical record of a ship's cruise or voyage; a log slate; a log book.",
   "Log": "A record and tabulated statement of the work done by an engine, as of a steamship, of the coal consumed, and of other items relating to the performance of machinery during a given time.",
   "Log": "A weight or block near the free end of a hoisting rope to prevent it from being drawn through the sheave.",
   "Logan": "A rocking or balanced stone.",
   "Logarithm": "One of a class of auxiliary numbers, devised by John Napier, of Merchiston, Scotland (1550-1617), to abridge arithmetical calculations, by the use of addition and subtraction in place of multiplication and division.",
   "Log-chip": "A thin, flat piece of board in the form of a quadrant of a circle attached to the log line; -- called also log-ship. See 2d Log, n., 2.",
   "Logcock": "The pileated woodpecker.",
   "Loge": "A lodge; a habitation.",
   "Loggan": "See Logan.",
   "Loggat": "A small log or piece of wood.",
   "Loggat": "An old game in England, played by throwing pieces of wood at a stake set in the ground.",
   "Logger": "One engaged in logging. See Log, v. i.",
   "Loggerhead": "A blockhead; a dunce; a numskull.",
   "Loggerhead": "A spherical mass of iron, with a long handle, used to heat tar.",
   "Loggerhead": "An upright piece of round timber, in a whaleboat, over which a turn of the line is taken when it is running out too fast.",
   "Loggerhead": "A very large marine turtle (Thalassochelys caretta, / caouana), common in the warmer parts of the Atlantic Ocean, from Brazil to Cape Cod; -- called also logger-headed turtle.",
   "Loggerhead": "An American shrike (Lanius Ludovicianus), similar to the butcher bird, but smaller. See Shrike.",
   "Loggerheads": "The knapweed.",
   "Loggia": "A roofed open gallery. It differs from a veranda in being more architectural, and in forming more decidedly a part of the main edifice to which it is attached; from a porch, in being intended not for entrance but for an out-of-door sitting-room.",
   "Logging": "The business of felling trees, cutting them into logs, and transporting the logs to sawmills or to market.",
   "Logic": "The science or art of exact reasoning, or of pure and formal thought, or of the laws according to which the processes of pure thinking should be conducted; the science of the formation and application of general notions; the science of generalization, judgment, classification, reasoning, and systematic arrangement; correct reasoning.",
   "Logic": "A treatise on logic; as, Mill's Logic.",
   "Logicality": "Logicalness.",
   "Logicalness": "The quality of being logical.",
   "Logician": "A person skilled in logic.",
   "Logics": "See Logic.",
   "Logistics": "That branch of the military art which embraces the details of moving and supplying armies. The meaning of the word is by some writers extended to include strategy.",
   "Logistics": "A system of arithmetic, in which numbers are expressed in a scale of 60; logistic arithmetic.",
   "Logman": "A man who carries logs.",
   "Logodaedaly": "Verbal legerdemain; a playing with words.",
   "Logogram": "A word letter; a phonogram, that, for the sake of brevity, represents a word; as, |, i. e., t, for it. Cf. Grammalogue.",
   "Logographer": "A chronicler; one who writes history in a condensed manner with short simple sentences.",
   "Logographer": "One skilled in logography.",
   "Logography": "A method of printing in which whole words or syllables, cast as single types, are used.",
   "Logography": "A mode of reporting speeches without using shorthand, -- a number of reporters, each in succession, taking down three or four words.",
   "Logogriph": "A sort of riddle in which it is required to discover a chosen word from various combinations of its letters, or of some of its letters, which form other words; -- thus, to discover the chosen word chatter form cat, hat, rat, hate, rate, etc.",
   "Logomachist": "One who contends about words.",
   "Logomachy": "Contention in words merely, or a contention about words; a war of words.",
   "Logomachy": "A game of word making.",
   "Logos": "A word; reason; speech.",
   "Logos": "The divine Word; Christ.",
   "Logotype": "A single type, containing two or more letters; as, ae, Ae, /, /, /, etc. ; -- called also ligature.",
   "Logroller": "One who engages in logrolling.",
   "Logrolling": "The act or process of rolling logs from the place where they were felled to the stream which floats them to the sawmill or to market. In this labor neighboring camps of loggers combine to assist each other in turn.",
   "Logrolling": "Hence: A combining to assist another in consideration of receiving assistance in return; -- sometimes used of a disreputable mode of accomplishing political schemes or ends.",
   "Log-ship": "A part of the log. See Log-chip, and 2d Log, n., 2.",
   "Logwood": "The heartwood of a tree (Haematoxylon Campechianum), a native of South America, It is a red, heavy wood, containing a crystalline substance called haematoxylin, and is used largely in dyeing. An extract from this wood is used in medicine as an astringent. Also called Campeachy wood, and bloodwood.",
   "Lohock": "See Loch, a medicine.",
   "Loin": "That part of a human being or quadruped, which extends on either side of the spinal column between the hip bone and the false ribs. In human beings the loins are also called the reins. See Illust. of Beef.",
   "Loir": "A large European dormouse (Myoxus glis).",
   "Loiterer": "One who loiters; an idler.",
   "Loiterer": "An idle vagrant; a tramp.",
   "Lok": "Alt. of Loki",
   "Loki": "The evil deity, the author of all calamities and mischief, answering to the African of the Persians.",
   "Locao": "A green vegetable dye imported from China.",
   "Loke": "A private path or road; also, the wicket or hatch of a door.",
   "Lokorys": "Liquorice.",
   "Loligo": "A genus of cephalopods, including numerous species of squids, common on the coasts of America and Europe. They are much used for fish bait.",
   "Lollard": "One of a sect of early reformers in Germany.",
   "Lollard": "One of the followers of Wyclif in England.",
   "Lollardism": "Alt. of Lollardy",
   "Lollardy": "The doctrines or principles of the Lollards.",
   "Loller": "One who lolls.",
   "Loller": "An idle vagabond.",
   "Loller": "A Lollard.",
   "Lollipop": "A kind of sugar confection which dissolves easily in the mouth.",
   "Loma": "A lobe; a membranous fringe or flap.",
   "Lombard": "A native or inhabitant of Lombardy.",
   "Lombard": "A money lender or banker; -- so called because the business of banking was first carried on in London by Lombards.",
   "Lombard": "Same as Lombard-house.",
   "Lombard": "A form of cannon formerly in use.",
   "Lombardeer": "A pawnbroker.",
   "Lombard-house": "Alt. of Lombar-house",
   "Lombar-house": "A bank or a pawnbroker's shop.",
   "Lombar-house": "A public institution for lending money to the poor at a moderate interest, upon articles deposited and pledged; -- called also mont de piete.",
   "Loment": "An elongated pod, consisting, like the legume, of two valves, but divided transversely into small cells, each containing a single seed.",
   "Lomonite": "Same as Laumontite.",
   "Lond": "Land.",
   "London": "The capital city of England.",
   "Londoner": "A native or inhabitant of London.",
   "Londonism": "A characteristic of Londoners; a mode of speaking peculiar to London.",
   "Lone": "A lane. See Loanin.",
   "Loneliness": "The condition of being lonely; solitude; seclusion.",
   "Loneliness": "The state of being unfrequented by human beings; as, the loneliness of a road.",
   "Loneliness": "Love of retirement; disposition to solitude.",
   "Loneliness": "A feeling of depression resulting from being alone.",
   "Loneness": "Solitude; seclusion.",
   "Long": "A note formerly used in music, one half the length of a large, twice that of a breve.",
   "Long": "A long sound, syllable, or vowel.",
   "Long": "The longest dimension; the greatest extent; -- in the phrase, the long and the short of it, that is, the sum and substance of it.",
   "Longan": "A pulpy fruit related to the litchi, and produced by an evergreen East Indian tree (Nephelium Longan).",
   "Longanimity": "Disposition to bear injuries patiently; forbearance; patience.",
   "Longbeak": "The American redbellied snipe (Macrorhamphus scolopaceus); -- called also long-billed dowitcher.",
   "Longboat": "Formerly, the largest boat carried by a merchant vessel, corresponding to the launch of a naval vessel.",
   "Longbow": "The ordinary bow, not mounted on a stock; -- so called in distinction from the crossbow when both were used as weapons of war. Also, sometimes, such a bow of about the height of a man, as distinguished from a much shorter one.",
   "Longe": "A thrust. See Lunge.",
   "Longe": "The training ground for a horse.",
   "Longe": "Same as 4th Lunge.",
   "Longer": "One who longs for anything.",
   "Longevity": "Long duration of life; length of life.",
   "Longhand": "The written characters used in the common method of writing; -- opposed to shorthand.",
   "Longhorn": "A long-horned animal, as a cow, goat, or beetle. See Long-horned.",
   "Longicorn": "One of the Longicornia.",
   "Longiloquence": "Long-windedness.",
   "Longimetry": "The art or practice of measuring distances or lengths.",
   "Longing": "An eager desire; a craving; a morbid appetite; an earnest wish; an aspiration.",
   "Longinquity": "Greatness of distance; remoteness.",
   "Longipalp": "One of a tribe of beetles, having long maxillary palpi.",
   "Longiroster": "One of the Longirostres.",
   "Longitude": "Length; measure or distance along the longest line; -- distinguished from breadth or thickness; as, the longitude of a room; rare now, except in a humorous sense.",
   "Longitude": "The arc or portion of the equator intersected between the meridian of a given place and the meridian of some other place from which longitude is reckoned, as from Greenwich, England, or sometimes from the capital of a country, as from Washington or Paris. The longitude of a place is expressed either in degrees or in time; as, that of New York is 74� or 4 h. 56 min. west of Greenwich.",
   "Longitude": "The distance in degrees, reckoned from the vernal equinox, on the ecliptic, to a circle at right angles to the ecliptic passing through the heavenly body whose longitude is designated; as, the longitude of Capella is 79�.",
   "Longitudinal": "A railway sleeper lying parallel with the rail.",
   "Longlegs": "A daddy longlegs.",
   "Longness": "Length.",
   "Longnose": "The European garfish.",
   "Longshanks": "The stilt.",
   "Longshoreman": "One of a class of laborers employed about the wharves of a seaport, especially in loading and unloading vessels.",
   "Long-sight": "Long-sightedness.",
   "Long-sightedness": "The state or condition of being long-sighted; hence, sagacity; shrewdness.",
   "Long-sightedness": "See Hypermetropia.",
   "Longspur": "Any one of several species of fringilline birds of the genus Calcarius (or Plectrophanes), and allied genera. The Lapland longspur (C. Lapponicus), the chestnut-colored longspur (C. ornatus), and other species, inhabit the United States.",
   "Long-stop": "One who is set to stop balls which pass the wicket keeper.",
   "Long-sufferance": "Forbearance to punish or resent.",
   "Long-suffering": "Bearing injuries or provocation for a long time; patient; not easily provoked.",
   "Long-suffering": "Long patience of offense.",
   "Longtail": "An animal, particularly a log, having an uncut tail. Cf. Curtail. Dog.",
   "Long-tongue": "The wryneck.",
   "Longulite": "A kind of crystallite having a (slender) acicular form.",
   "Loo": "An old game played with five, or three, cards dealt to each player from a full pack. When five cards are used the highest card is the knave of clubs or (if so agreed upon) the knave of trumps; -- formerly called lanterloo.",
   "Loob": "The clay or slimes washed from tin ore in dressing.",
   "Looby": "An awkward, clumsy fellow; a lubber.",
   "Looch": "See 2d Loch.",
   "Loof": "The spongelike fibers of the fruit of a cucurbitaceous plant (Luffa Aegyptiaca); called also vegetable sponge.",
   "Loof": "Formerly, some appurtenance of a vessel which was used in changing her course; -- probably a large paddle put over the lee bow to help bring her head nearer to the wind.",
   "Loof": "The part of a ship's side where the planking begins to curve toward bow and stern.",
   "Look": "The act of looking; a glance; a sight; a view; -- often in certain phrases; as, to have, get, take, throw, or cast, a look.",
   "Look": "Expression of the eyes and face; manner; as, a proud or defiant look.",
   "Look": "Hence; Appearance; aspect; as, the house has a gloomy look; the affair has a bad look.",
   "Lookdown": "See Moonfish (b).",
   "Looker": "One who looks.",
   "Looking": "The act of one who looks; a glance.",
   "Looking": "The manner in which one looks; appearance; countenance; face.",
   "Looking-glass": "A mirror made of glass on which has been placed a backing of some reflecting substance, as quicksilver.",
   "Lookout": "A careful looking or watching for any object or event.",
   "Lookout": "The place from which such observation is made.",
   "Lookout": "A person engaged in watching.",
   "Lookout": "Object or duty of forethought and care; responsibility.",
   "Lool": "A vessel used to receive the washings of ores of metals.",
   "Loom": "See Loon, the bird.",
   "Loom": "A frame or machine of wood or other material, in which a weaver forms cloth out of thread; a machine for interweaving yarn or threads into a fabric, as in knitting or lace making.",
   "Loom": "That part of an oar which is near the grip or handle and inboard from the rowlock.",
   "Loom": "The state of looming; esp., an unnatural and indistinct appearance of elevation or enlargement of anything, as of land or of a ship, seen by one at sea.",
   "Loom-gale": "A gentle gale of wind.",
   "Looming": "The indistinct and magnified appearance of objects seen in particular states of the atmosphere. See Mirage.",
   "Loon": "A sorry fellow; a worthless person; a rogue.",
   "Loon": "Any one of several aquatic, wed-footed, northern birds of the genus Urinator (formerly Colymbus), noted for their expertness in diving and swimming under water. The common loon, or great northern diver (Urinator imber, or Colymbus torquatus), and the red-throated loon or diver (U. septentrionalis), are the best known species. See Diver.",
   "Loop": "A mass of iron in a pasty condition gathered into a ball for the tilt hammer or rolls.",
   "Loop": "A fold or doubling of a thread, cord, rope, etc., through which another thread, cord, etc., can be passed, or which a hook can be hooked into; an eye, as of metal; a staple; a noose; a bight.",
   "Loop": "A small, narrow opening; a loophole.",
   "Loop": "A curve of any kind in the form of a loop.",
   "Loop": "A wire forming part of a main circuit and returning to the point from which it starts.",
   "Loop": "The portion of a vibrating string, air column, etc., between two nodes; -- called also ventral segment.",
   "Looper": "An instrument, as a bodkin, for forming a loop in yarn, a cord, etc.",
   "Looper": "The larva of any species of geometrid moths. See Geometrid.",
   "Loophole": "A small opening, as in the walls of fortification, or in the bulkhead of a ship, through which small arms or other weapons may be discharged at an enemy.",
   "Loophole": "A hole or aperture that gives a passage, or the means of escape or evasion.",
   "Looping": "The running together of the matter of an ore into a mass, when the ore is only heated for calcination.",
   "Looplight": "A small narrow opening or window in a tower or fortified wall; a loophole.",
   "Loord": "A dull, stupid fellow; a drone.",
   "Loos": "Praise; fame; reputation.",
   "Loose": "Freedom from restraint.",
   "Loose": "A letting go; discharge.",
   "Loosener": "One who, or that which, loosens.",
   "Looseness": "The state, condition, or quality, of being loose; as, the looseness of a cord; looseness of style; looseness of morals or of principles.",
   "Loosestrife": "The name of several species of plants of the genus Lysimachia, having small star-shaped flowers, usually of a yellow color.",
   "Loosestrife": "Any species of the genus Lythrum, having purple, or, in some species, crimson flowers.",
   "Loot": "The act of plundering.",
   "Loot": "Plunder; booty; especially, the boot taken in a conquered or sacked city.",
   "Looter": "A plunderer.",
   "Loover": "See Louver.",
   "Lop": "A flea.",
   "Lop": "That which is lopped from anything, as branches from a tree.",
   "Lope": "A leap; a long step.",
   "Lope": "An easy gait, consisting of long running strides or leaps.",
   "Lopeman": "Leaper; ropedancer.",
   "Loper": "One who, or that which, lopes; esp., a horse that lopes.",
   "Loper": "A swivel at one end of a ropewalk, used in laying the strands.",
   "Lophine": "A nitrogenous organic base obtained by the oxidation of amarine, and regarded as a derivative of benzoic aldehyde. It is obtained in long white crystalline tufts, -- whence its name.",
   "Lophiomys": "A very singular rodent (Lophiomys Imhausi) of Northeastern Africa. It is the only known representative of a special family (Lophiomyidae), remarkable for the structure of the skull. It has handlike feet, and the hair is peculiar in structure and arrangement.",
   "Lophobranch": "One of the Lophobranchii.",
   "Lophophore": "A disk which surrounds the mouth and bears the tentacles of the Bryozoa. See Phylactolemata.",
   "Lophosteon": "The central keel-bearing part of the sternum in birds.",
   "Loppard": "A tree, the top of which has been lopped off.",
   "Lopper": "One who lops or cuts off.",
   "Lopping": "A cutting off, as of branches; that which is cut off; leavings.",
   "Lopseed": "A perennial herb (Phryma Leptostachya), having slender seedlike fruits.",
   "Loquaciousness": "Loquacity.",
   "Loquacity": "The habit or practice of talking continually or excessively; inclination to talk too much; talkativeness; garrulity.",
   "Loquat": "The fruit of the Japanese medlar (Photinia Japonica). It is as large as a small plum, but grows in clusters, and contains four or five large seeds. Also, the tree itself.",
   "Loral": "Of or pertaining to the lores.",
   "Lorcha": "A kind of light vessel used on the coast of China, having the hull built on a European model, and the rigging like that of a Chinese junk.",
   "Lord": "A hump-backed person; -- so called sportively.",
   "Lord": "One who has power and authority; a master; a ruler; a governor; a prince; a proprietor, as of a manor.",
   "Lord": "A titled nobleman., whether a peer of the realm or not; a bishop, as a member of the House of Lords; by courtesy; the son of a duke or marquis, or the eldest son of an earl; in a restricted sense, a boron, as opposed to noblemen of higher rank.",
   "Lord": "A title bestowed on the persons above named; and also, for honor, on certain official persons; as, lord advocate, lord chamberlain, lord chancellor, lord chief justice, etc.",
   "Lord": "A husband.",
   "Lord": "One of whom a fee or estate is held; the male owner of feudal land; as, the lord of the soil; the lord of the manor.",
   "Lord": "The Supreme Being; Jehovah.",
   "Lord": "The Savior; Jesus Christ.",
   "Lording": "The son of a lord; a person of noble lineage.",
   "Lording": "A little lord; a lordling; a lord, in contempt or ridicule.",
   "Lordkin": "A little lord.",
   "Lordliness": "The state or quality of being lordly.",
   "Lordling": "A little or insignificant lord.",
   "Lordolatry": "Worship of, or reverence for, a lord as such.",
   "Lordosis": "A curvature of the spine forwards, usually in the lumbar region.",
   "Lordosis": "Any abnormal curvature of the bones.",
   "Lordship": "The state or condition of being a lord; hence (with his or your), a title applied to a lord (except an archbishop or duke, who is called Grace) or a judge (in Great Britain), etc.",
   "Lordship": "Seigniory; domain; the territory over which a lord holds jurisdiction; a manor.",
   "Lordship": "Dominion; power; authority.",
   "Lore": "The space between the eye and bill, in birds, and the corresponding region in reptiles and fishes.",
   "Lore": "The anterior portion of the cheeks of insects.",
   "Lorel": "A good for nothing fellow; a vagabond.",
   "Loresman": "An instructor.",
   "Lorette": "In France, a name for a woman who is supported by her lovers, and devotes herself to idleness, show, and pleasure; -- so called from the church of Notre Dame de Lorette, in Paris, near which many of them resided.",
   "Lorettine": "One of a order of nuns founded in 1812 at Loretto, in Kentucky. The members of the order (called also Sisters of Loretto, or Friends of Mary at the Foot of the Cross) devote themselves to the cause of education and the care of destitute orphans, their labors being chiefly confined to the Western United States.",
   "Lorgnette": "An opera glass",
   "Lorgnette": "elaborate double eyeglasses.",
   "Lori": "Same as Lory.",
   "Lorica": "A cuirass, originally of leather, afterward of plates of metal or horn sewed on linen or the like.",
   "Lorica": "Lute for protecting vessels from the fire.",
   "Lorica": "The protective case or shell of an infusorian or rotifer.",
   "Loricate": "An animal covered with bony scales, as crocodiles among reptiles, and the pangolins among mammals.",
   "Lorication": "The act of loricating; the protecting substance put on; a covering of scales or plates.",
   "Lorikeet": "Any one numerous species of small brush-tongued parrots or lories, found mostly in Australia, New Guinea and the adjacent islands, with some forms in the East Indies. They are arboreal in their habits and feed largely upon the honey of flowers. They belong to Trichoglossus, Loriculus, and several allied genera.",
   "Lorimer": "Alt. of Loriner",
   "Loriner": "A maker of bits, spurs, and metal mounting for bridles and saddles; hence, a saddler.",
   "Loring": "Instructive discourse.",
   "Loriot": "The golden oriole of Europe. See Oriole.",
   "Loris": "Any one of several species of small lemurs of the genus Stenops. They have long, slender limbs and large eyes, and are arboreal in their habits. The slender loris (S. gracilis), of Ceylon, in one of the best known species.",
   "Lorrie": "Alt. of Lorry",
   "Lorry": "A small cart or wagon, as those used on the tramways in mines to carry coal or rubbish; also, a barrow or truck for shifting baggage, as at railway stations.",
   "Lory": "Any one of many species of small parrots of the family Trichoglossidae, generally having the tongue papillose at the tip, and the mandibles straighter and less toothed than in common parrots. They are found in the East Indies, Australia, New Guinea, and the adjacent islands. They feed mostly on soft fruits and on the honey of flowers.",
   "Los": "Praise. See Loos.",
   "Losange": "See Lozenge.",
   "Losel": "One who loses by sloth or neglect; a worthless person; a lorel.",
   "Losenger": "A flatterer; a deceiver; a cozener.",
   "Losengerie": "Flattery; deceit; trickery.",
   "Loser": "One who loses.",
   "Lot": "That which happens without human design or forethought; chance; accident; hazard; fortune; fate.",
   "Lot": "Anything (as a die, pebble, ball, or slip of paper) used in determining a question by chance, or without man's choice or will; as, to cast or draw lots.",
   "Lot": "The part, or fate, which falls to one, as it were, by chance, or without his planning.",
   "Lot": "A separate portion; a number of things taken collectively; as, a lot of stationery; -- colloquially, sometimes of people; as, a sorry lot; a bad lot.",
   "Lot": "A distinct portion or plot of land, usually smaller than a field; as, a building lot in a city.",
   "Lot": "A large quantity or number; a great deal; as, to spend a lot of money; lots of people think so.",
   "Lot": "A prize in a lottery.",
   "Lote": "A large tree (Celtis australis), found in the south of Europe. It has a hard wood, and bears a cherrylike fruit. Called also nettle tree.",
   "Lote": "The European burbot.",
   "Lothario": "A gay seducer of women; a libertine.",
   "Lotion": "A washing, especially of the skin for the purpose of rendering it fair.",
   "Lotion": "A liquid preparation for bathing the skin, or an injured or diseased part, either for a medicinal purpose, or for improving its appearance.",
   "Loto": "See Lotto.",
   "Lotong": "An East Indian monkey (Semnopithecus femoralis).",
   "Lotos": "See Lotus.",
   "Lottery": "A scheme for the distribution of prizes by lot or chance; esp., a gaming scheme in which one or more tickets bearing particular numbers draw prizes, and the rest of tickets are blanks. Fig. : An affair of chance.",
   "Lottery": "Allotment; thing allotted.",
   "Lotto": "A game of chance, played with cards, on which are inscribed numbers, and any contrivance (as a wheel containing numbered balls) for determining a set of numbers by chance. The player holding a card having on it the set of numbers drawn from the wheel takes the stakes after a certain percentage of them has been deducted for the dealer. A variety of lotto is called keno.",
   "Loture": "See Lotion.",
   "Lotus": "A name of several kinds of water lilies; as Nelumbium speciosum, used in religious ceremonies, anciently in Egypt, and to this day in Asia; Nelumbium luteum, the American lotus; and Nymphaea Lotus and N. caerulea, the respectively white-flowered and blue-flowered lotus of modern Egypt, which, with Nelumbium speciosum, are figured on its ancient monuments.",
   "Lotus": "The lotus of the lotuseaters, probably a tree found in Northern Africa, Sicily, Portugal, and Spain (Zizyphus Lotus), the fruit of which is mildly sweet. It was fabled by the ancients to make strangers who ate of it forget their native country, or lose all desire to return to it.",
   "Lotus": "The lote, or nettle tree. See Lote.",
   "Lotus": "A genus (Lotus) of leguminous plants much resembling clover.",
   "Lotus": "An ornament much used in Egyptian architecture, generally asserted to have been suggested by the Egyptian water lily.",
   "Lotus-eater": "Alt. of Lotos-eater",
   "Lotos-eater": "One who ate the fruit or leaf of the lotus, and, as a consequence, gave himself up to indolence and daydreams; one of the Lotophagi.",
   "Loudness": "The quality or state of being loud.",
   "Lough": "A loch or lake; -- so spelt in Ireland.",
   "Lounge": "An idle gait or stroll; the state of reclining indolently; a place of lounging.",
   "Lounge": "A piece of furniture resembling a sofa, upon which one may lie or recline.",
   "Lounger": "One who lounges; ar idler.",
   "Loup": "See 1st Loop.",
   "Loup-cervier": "The Canada lynx. See Lynx.",
   "Loup-loup": "The Pomeranian or Spitz dog.",
   "Lour": "An Asiatic sardine (Clupea Neohowii), valued for its oil.",
   "Louri": "See Lory.",
   "Louse": "Any one of numerous species of small, wingless, suctorial, parasitic insects belonging to a tribe (Pediculina), now usually regarded as degraded Hemiptera. To this group belong of the lice of man and other mammals; as, the head louse of man (Pediculus capitis), the body louse (P. vestimenti), and the crab louse (Phthirius pubis), and many others. See Crab louse, Dog louse, Cattle louse, etc., under Crab, Dog, etc.",
   "Louse": "Any one of numerous small mandibulate insects, mostly parasitic on birds, and feeding on the feathers. They are known as Mallophaga, or bird lice, though some occur on the hair of mammals. They are usually regarded as degraded Pseudoneuroptera. See Mallophaga.",
   "Louse": "Any one of the numerous species of aphids, or plant lice. See Aphid.",
   "Louse": "Any small crustacean parasitic on fishes. See Branchiura, and Ichthvophthira.",
   "Lousewort": "Any species of Pedicularis, a genus of perennial herbs. It was said to make sheep that fed on it lousy.",
   "Lousiness": "The state or quality of being lousy.",
   "Lout": "A clownish, awkward fellow; a bumpkin.",
   "Loutou": "A crested black monkey (Semnopithecus maurus) of Java.",
   "Louver": "Alt. of Louvre",
   "Louvre": "A small lantern. See Lantern, 2 (a).",
   "Lovage": "An umbelliferous plant (Levisticum officinale), sometimes used in medicine as an aromatic stimulant.",
   "Love": "A feeling of strong attachment induced by that which delights or commands admiration; preeminent kindness or devotion to another; affection; tenderness; as, the love of brothers and sisters.",
   "Love": "Especially, devoted attachment to, or tender or passionate affection for, one of the opposite sex.",
   "Love": "Courtship; -- chiefly in the phrase to make love, i. e., to court, to woo, to solicit union in marriage.",
   "Love": "Affection; kind feeling; friendship; strong liking or desire; fondness; good will; -- opposed to hate; often with of and an object.",
   "Love": "Due gratitude and reverence to God.",
   "Love": "The object of affection; -- often employed in endearing address.",
   "Love": "Cupid, the god of love; sometimes, Venus.",
   "Love": "A thin silk stuff.",
   "Love": "A climbing species of Clematis (C. Vitalba).",
   "Love": "Nothing; no points scored on one side; -- used in counting score at tennis, etc.",
   "Love": "To have a feeling of love for; to regard with affection or good will; as, to love one's children and friends; to love one's country; to love one's God.",
   "Love": "To regard with passionate and devoted affection, as that of one sex for the other.",
   "Love": "To take delight or pleasure in; to have a strong liking or desire for, or interest in; to be pleased with; to like; as, to love books; to love adventures.",
   "Love-drury": "Affection.",
   "Lovee": "One who is loved.",
   "Loveliness": "The state or quality of being lovely.",
   "Lovelock": "A long lock of hair hanging prominently by itself; an earlock; -- worn by men of fashion in the reigns of Elizabeth and James I.",
   "Love-making": "Courtship.",
   "Lovemonger": "One who deals in affairs of love.",
   "Lover": "One who loves; one who is in love; -- usually limited, in the singular, to a person of the male sex.",
   "Lover": "A friend; one strongly attached to another; one who greatly desires the welfare of any person or thing; as, a lover of his country.",
   "Lover": "One who has a strong liking for anything, as books, science, or music.",
   "Lover": "Alt. of Lovery",
   "Lovery": "See Louver.",
   "Love-sickness": "The state of being love-sick.",
   "Loving-kindness": "Tender regard; mercy; favor.",
   "Lovingness": "Affection; kind regard.",
   "Lovyer": "A lover.",
   "Low": "The calling sound ordinarily made by cows and other bovine animals.",
   "Low": "A hill; a mound; a grave.",
   "Low": "Fire; a flame; a light.",
   "Low": "The lowest trump, usually the deuce; the lowest trump dealt or drawn.",
   "Lowbell": "A bell used in fowling at night, to frighten birds, and, with a sudden light, to make them fly into a net.",
   "Lowbell": "A bell to be hung on the neck of a sheep.",
   "Low-churchism": "The principles of the low-church party.",
   "Low-churchman": "One who holds low-church principles.",
   "Low-churchmanship": "The state of being a low-churchman.",
   "Lower": "Cloudiness; gloominess.",
   "Lower": "A frowning; sullenness.",
   "Lowing": "The calling sound made by cows and other bovine animals.",
   "Lowk": "See Louk.",
   "Lowland": "Land which is low with respect to the neighboring country; a low or level country; -- opposed to highland.",
   "Lowlander": "A native or inhabitant of the Lowlands, especially of the Lowlands of Scotland, as distinguished from Highlander.",
   "Lowlihood": "Alt. of Lowlihead",
   "Lowlihead": "A lowly state.",
   "Lowliness": "The state or quality of being lowly; humility; humbleness of mind.",
   "Lowliness": "Low condition, especially as to manner of life.",
   "Low-mindedness": "The quality of being lowminded; meanness; baseness.",
   "Lown": "A low fellow.",
   "Lowness": "The state or quality of being low.",
   "Lowry": "An open box car used on railroads. Compare Lorry.",
   "Loxodromics": "The art or method of sailing on the loxodromic or rhumb line.",
   "Loxodremism": "The act or process of tracing a loxodromic curve; the act of moving as if in a loxodromic curve.",
   "Loxodromy": "The science of loxodromics.",
   "Loy": "A long, narrow spade for stony lands.",
   "Loyalist": "A person who adheres to his sovereign or to the lawful authority; especially, one who maintains his allegiance to his prince or government, and defends his cause in times of revolt or revolution.",
   "Loyalness": "Loyalty.",
   "Loyalty": "The state or quality of being loyal; fidelity to a superior, or to duty, love, etc.",
   "Lozenge": "A diamond-shaped figure usually with the upper and lower angles slightly acute, borne upon a shield or escutcheon. Cf. Fusil.",
   "Lozenge": "A form of the escutcheon used by women instead of the shield which is used by men.",
   "Lozenge": "A figure with four equal sides, having two acute and two obtuse angles; a rhomb.",
   "Lozenge": "Anything in the form of lozenge.",
   "Lozenge": "A small cake of sugar and starch, flavored, and often medicated. -- originally in the form of a lozenge.",
   "Lubbard": "A lubber.",
   "Lubber": "A heavy, clumsy, or awkward fellow; a sturdy drone; a clown.",
   "Lubricant": "That which lubricates; specifically, a substance, as oil, grease, plumbago, etc., used for reducing the friction of the working parts of machinery.",
   "Lubrication": "The act of lubricating; the act of making slippery.",
   "Lubricator": "One who, or that which, lubricates.",
   "Lubricator": "A contrivance, as an oil cup, for supplying a lubricant to machinery.",
   "Lubricity": "Smoothness; freedom from friction; also, property, which diminishes friction; as, the lubricity of oil.",
   "Lubricity": "Slipperiness; instability; as, the lubricity of fortune.",
   "Lubricity": "Lasciviousness; propensity to lewdness; lewdness; lechery; incontinency.",
   "Lubrification": "Alt. of Lubrifaction",
   "Lubrifaction": "The act of lubricating, or making smooth.",
   "Lucarne": "A dormer window.",
   "Luce": "A pike when full grown.",
   "Lucency": "The quality of being lucent.",
   "Lucern": "A sort of hunting dog; -- perhaps from Lucerne, in Switzerland.",
   "Lucern": "An animal whose fur was formerly much in request (by some supposed to be the lynx).",
   "Lucern": "A leguminous plant (Medicago sativa), having bluish purple cloverlike flowers, cultivated for fodder; -- called also alfalfa.",
   "Lucern": "A lamp.",
   "Lucernaria": "A genus of acalephs, having a bell-shaped body with eight groups of short tentacles around the margin. It attaches itself by a sucker at the base of the pedicel.",
   "Lucernarian": "One of the Lucernarida.",
   "Lucerne": "See Lucern, the plant.",
   "Lucid": "Shining; bright; resplendent; as, the lucid orbs of heaven.",
   "Lucid": "Clear; transparent.",
   "Lucid": "Presenting a clear view; easily understood; clear.",
   "Lucid": "Bright with the radiance of intellect; not darkened or confused by delirium or madness; marked by the regular operations of reason; as, a lucid interval.",
   "Lucidity": "The quality or state of being lucid.",
   "Lucidness": "The quality of being lucid; lucidity.",
   "Lucifer": "The planet Venus, when appearing as the morning star; -- applied in Isaiah by a metaphor to a king of Babylon.",
   "Lucifer": "Hence, Satan.",
   "Lucifer": "A match made of a sliver of wood tipped with a combustible substance, and ignited by friction; -- called also lucifer match, and locofoco. See Locofoco.",
   "Lucifer": "A genus of free-swimming macruran Crustacea, having a slender body and long appendages.",
   "Luciferian": "One of the followers of Lucifer, bishop of Cagliari, in the fourth century, who separated from the orthodox churches because they would not go as far as he did in opposing the Arians.",
   "Lucimeter": "an instrument for measuring the intensity of light; a photometer.",
   "Luck": "That which happens to a person; an event, good or ill, affecting one's interests or happiness, and which is deemed casual; a course or series of such events regarded as occurring by chance; chance; hap; fate; fortune; often, one's habitual or characteristic fortune; as, good, bad, ill, or hard luck. Luck is often used for good luck; as, luck is better than skill.",
   "Luckiness": "The state or quality of being lucky; as, the luckiness of a man or of an event.",
   "Luckiness": "Good fortune; favorable issue or event.",
   "Lucre": "Gain in money or goods; profit; riches; -- often in an ill sense.",
   "Luctation": "Effort to overcome in contest; struggle; endeavor.",
   "Lucubrate": "To study by candlelight or a lamp; to study by night.",
   "Lucubration": "The act of lucubrating, or studying by candlelight; nocturnal study; meditation.",
   "Lucubration": "That which is composed by night; that which is produced by meditation in retirement; hence (loosely) any literary composition.",
   "Lucubrator": "One who studies by night; also, one who produces lucubrations.",
   "Lucule": "A spot or fleck on the sun brighter than the surrounding surface.",
   "Lucullite": "A variety of black limestone, often polished for ornamental purposes.",
   "Lucuma": "An American genus of sapotaceous trees bearing sweet and edible fruits.",
   "Luddite": "One of a number of riotous persons in England, who for six years (1811-17) tried to prevent the use of labor-saving machinery by breaking it, burning factories, etc.; -- so called from Ned Lud, a half-witted man who some years previously had broken stocking frames.",
   "Ludification": "The act of deriding.",
   "Ludlamite": "A mineral occurring in small, green, transparent, monoclinic crystals. It is a hydrous phosphate of iron.",
   "Ludwigite": "A borate of iron and magnesia, occurring in fibrous masses of a blackish green color.",
   "Lues": "Disease, especially of a contagious kind.",
   "Luff": "The side of a ship toward the wind.",
   "Luff": "The act of sailing a ship close to the wind.",
   "Luff": "The roundest part of a ship's bow.",
   "Luff": "The forward or weather leech of a sail, especially of the jib, spanker, and other fore-and-aft sails.",
   "Luffer": "See Louver.",
   "Lug": "The ear, or its lobe.",
   "Lug": "That which projects like an ear, esp. that by which anything is supported, carried, or grasped, or to which a support is fastened; an ear; as, the lugs of a kettle; the lugs of a founder's flask; the lug (handle) of a jug.",
   "Lug": "A projecting piece to which anything, as a rod, is attached, or against which anything, as a wedge or key, bears, or through which a bolt passes, etc.",
   "Lug": "The leather loop or ear by which a shaft is held up.",
   "Lug": "The lugworm.",
   "Lug": "The act of lugging; as, a hard lug; that which is lugged; as, the pack is a heavy lug.",
   "Lug": "Anything which moves slowly.",
   "Lug": "A rod or pole.",
   "Lug": "A measure of length, being 16/ feet; a rod, pole, or perch.",
   "Luggage": "That which is lugged; anything cumbrous and heavy to be carried; especially, a traveler's trunks, baggage, etc., or their contents.",
   "Lugger": "A small vessel having two or three masts, and a running bowsprit, and carrying lugsails. See Illustration in Appendix.",
   "Lugger": "An Indian falcon (Falco jugger), similar to the European lanner and the American prairie falcon.",
   "Lugmark": "A mark cut into the ear of an animal to identify it; an earmark.",
   "Lugsail": "A square sail bent upon a yard that hangs obliquely to the mast and is raised or lowered with the sail.",
   "Lugworm": "A large marine annelid (Arenicola marina) having a row of tufted gills along each side of the back. It is found burrowing in sandy beaches, both in America and Europe, and is used for bait by European fishermen. Called also lobworm, and baitworm.",
   "Lull": "The power or quality of soothing; that which soothes; a lullaby.",
   "Lull": "A temporary cessation of storm or confusion.",
   "Luller": "One who, or that which, lulls.",
   "Lum": "A chimney.",
   "Lum": "A ventilating chimney over the shaft of a mine.",
   "Lum": "A woody valley; also, a deep pool.",
   "Lumachel": "Alt. of Lumachella",
   "Lumachella": "A grayish brown limestone, containing fossil shells, which reflect a beautiful play of colors. It is also called fire marble, from its fiery reflections.",
   "Lumbago": "A rheumatic pain in the loins and the small of the back.",
   "Lumber": "A pawnbroker's shop, or room for storing articles put in pawn; hence, a pledge, or pawn.",
   "Lumber": "Old or refuse household stuff; things cumbrous, or bulky and useless, or of small value.",
   "Lumber": "Timber sawed or split into the form of beams, joists, boards, planks, staves, hoops, etc.; esp., that which is smaller than heavy timber.",
   "Lumberer": "One employed in lumbering, cutting, and getting logs from the forest for lumber; a lumberman.",
   "Lumbering": "The business of cutting or getting timber or logs from the forest for lumber.",
   "Lumberman": "One who is engaged in lumbering as a business or employment.",
   "Lumbosacral": "Of or pertaining to the loins and sacrum; as, the lumbosacral nerve, a branch of one of the lumber nerves which passes over the sacrum.",
   "Lumbric": "An earthworm, or a worm resembling an earthworm.",
   "Lumbrical": "A lumbrical muscle.",
   "Lumbricus": "A genus of annelids, belonging to the Oligochaeta, and including the common earthworms. See Earthworm.",
   "Luminary": "Any body that gives light, especially one of the heavenly bodies.",
   "Luminary": "One who illustrates any subject, or enlightens mankind; as, Newton was a distinguished luminary.",
   "Lumination": "Illumination.",
   "Luminosity": "The quality or state of being luminous; luminousness.",
   "Lummox": "A fat, ungainly, stupid person; an awkward bungler.",
   "Lump": "A small mass of matter of irregular shape; an irregular or shapeless mass; as, a lump of coal; a lump of iron ore.",
   "Lump": "A mass or aggregation of things.",
   "Lump": "A projection beneath the breech end of a gun barrel.",
   "Lumper": "The European eelpout; -- called also lumpen.",
   "Lumper": "One who lumps.",
   "Lumper": "A laborer who is employed to load or unload vessels when in harbor.",
   "Lumpfish": "A large, thick, clumsy, marine fish (Cyclopterus lumpus) of Europe and America. The color is usually translucent sea green, sometimes purplish. It has a dorsal row of spiny tubercles, and three rows on each side, but has no scales. The ventral fins unite and form a ventral sucker for adhesion to stones and seaweeds. Called also lumpsucker, cock-paddle, sea owl.",
   "Lumpsucker": "The lumprish.",
   "Luna": "The moon.",
   "Luna": "Silver.",
   "Lunacy": "Insanity or madness; properly, the kind of insanity which is broken by intervals of reason, -- formerly supposed to be influenced by the changes of the moon; any form of unsoundness of mind, except idiocy; mental derangement or alienation.",
   "Lunacy": "A morbid suspension of good sense or judgment, as through fanaticism.",
   "Lunar": "A lunar distance.",
   "Lunar": "The middle bone of the proximal series of the carpus; -- called also semilunar, and intermedium.",
   "Lunarian": "An inhabitant of the moon.",
   "Lunary": "A low fleshy fern (Botrychium Lunaria) with lunate segments of the leaf or frond.",
   "Lunatic": "A person affected by lunacy; an insane person, esp. one who has lucid intervals; a madman; a person of unsound mind.",
   "Lunation": "The period of a synodic revolution of the moon, or the time from one new moon to the next; varying in length, at different times, from about 29/ to 29/ days, the average length being 29 d., 12h., 44m., 2.9s.",
   "Lunch": "A luncheon; specifically, a light repast between breakfast and dinner.",
   "Luncheon": "A lump of food.",
   "Luncheon": "A portion of food taken at any time except at a regular meal; an informal or light repast, as between breakfast and dinner.",
   "Lune": "Anything in the shape of a half moon.",
   "Lune": "A figure in the form of a crescent, bounded by two intersecting arcs of circles.",
   "Lune": "A fit of lunacy or madness; a period of frenzy; a crazy or unreasonable freak.",
   "Lunet": "A little moon or satellite.",
   "Lunette": "A fieldwork consisting of two faces, forming a salient angle, and two parallel flanks. See Bastion.",
   "Lunette": "A half horseshoe, which wants the sponge.",
   "Lunette": "A kind of watch crystal which is more than ordinarily flattened in the center; also, a species of convexoconcave lens for spectacles.",
   "Lunette": "A piece of felt to cover the eye of a vicious horse.",
   "Lunette": "Any surface of semicircular or segmental form; especially, the piece of wall between the curves of a vault and its springing line.",
   "Lunette": "An iron shoe at the end of the stock of a gun carriage.",
   "Lung": "An organ for aerial respiration; -- commonly in the plural.",
   "Lunge": "A sudden thrust or pass, as with a sword.",
   "Lunge": "Same as Namaycush.",
   "Lungfish": "Any fish belonging to the Dipnoi; -- so called because they have both lungs and gills.",
   "Lungie": "A guillemot.",
   "Lungis": "A lingerer; a dull, drowsy fellow.",
   "Lungoor": "A long-tailed monkey (Semnopithecus schislaceus), from the mountainous districts of India.",
   "Lungworm": "Any one of several species of parasitic nematoid worms which infest the lungs and air passages of cattle, sheep, and other animals, often proving fatal. The lungworm of cattle (Strongylus micrurus) and that of sheep (S. filaria) are the best known.",
   "Lungwort": "An herb of the genus Pulmonaria (P. officinalis), of Europe; -- so called because the spotted appearance of the leaves resembles that of a diseased lung.",
   "Lungwort": "Any plant of the genus Mertensia (esp. M. Virginica and M. Sibirica) plants nearly related to Pulmonaria. The American lungwort is Mertensia Virginica, Virginia cowslip.",
   "Lunistice": "The farthest point of the moon's northing and southing, in its monthly revolution.",
   "Lunt": "The match cord formerly used in firing cannon.",
   "Lunt": "A puff of smoke.",
   "Lunula": "Same as Lunule.",
   "Lunule": "Anything crescent-shaped; a crescent-shaped part or mark; a lunula, a lune.",
   "Lunule": "A lune. See Lune.",
   "Lunule": "A small or narrow crescent.",
   "Lunule": "A special area in front of the beak of many bivalve shells. It sometimes has the shape of a double crescent, but is oftener heart-shaped. See Illust. of Bivalve.",
   "Lunulet": "A small spot, shaped like a half-moon or crescent; as, the lunulet on the wings of many insects.",
   "Lunulite": "Any bryozoan of the genus Lunulites, having a more or less circular form.",
   "Lupercal": "A grotto on the Palatine Hill sacred to Lupercus, the Lycean Pan.",
   "Lupine": "A leguminous plant of the genus Lupinus, especially L. albus, the seeds of which have been used for food from ancient times. The common species of the Eastern United States is L. perennis. There are many species in California.",
   "Lupine": "Wolfish; ravenous.",
   "Lupinin": "A glucoside found in the seeds of several species of lupine, and extracted as a yellowish white crystalline substance.",
   "Lupinine": "An alkaloid found in several species of lupine (Lupinus luteus, L. albus, etc.), and extracted as a bitter crystalline substance.",
   "Lupulin": "A bitter principle extracted from hops.",
   "Lupulin": "The fine yellow resinous powder found upon the strobiles or fruit of hops, and containing this bitter principle.",
   "Lupuline": "An alkaloid extracted from hops as a colorless volatile liquid.",
   "Lupus": "A cutaneous disease occurring under two distinct forms.",
   "Lupus": "The Wolf, a constellation situated south of Scorpio.",
   "Lurcation": "Gluttony; gormandizing.",
   "Lurch": "An old game played with dice and counters; a variety of the game of tables.",
   "Lurch": "A double score in cribbage for the winner when his adversary has been left in the lurch.",
   "Lurch": "A sudden roll of a ship to one side, as in heavy weather; hence, a swaying or staggering movement to one side, as that by a drunken man. Fig.: A sudden and capricious inclination of the mind.",
   "Lurcher": "One that lurches or lies in wait; one who watches to pilfer, or to betray or entrap; a poacher.",
   "Lurcher": "One of a mongrel breed of dogs said to have been a cross between the sheep dog, greyhound, and spaniel. It hunts game silently, by scent, and is often used by poachers.",
   "Lurcher": "A glutton; a gormandizer.",
   "Lurchline": "The line by which a fowling net was pulled over so as to inclose the birds.",
   "Lurdan": "A blockhead.",
   "Lure": "A contrivance somewhat resembling a bird, and often baited with raw meat; -- used by falconers in recalling hawks.",
   "Lure": "Any enticement; that which invites by the prospect of advantage or pleasure; a decoy.",
   "Lure": "A velvet smoothing brush.",
   "Lure": "To draw to the lure; hence, to allure or invite by means of anything that promises pleasure or advantage; to entice; to attract.",
   "Lurg": "A large marine annelid (Nephthys caeca), inhabiting the sandy shores of Europe and America. It is whitish, with a pearly luster, and grows to the length of eight or ten inches.",
   "Lurker": "One who lurks.",
   "Lurker": "A small fishing boat.",
   "Lurry": "A confused heap; a throng, as of persons; a jumble, as of sounds.",
   "Lusern": "A lynx. See 1st Lucern and Loup-cervier.",
   "Lushburg": "See Lussheburgh.",
   "Lusitanian": "One of the people of Lusitania.",
   "Lusk": "A lazy fellow; a lubber.",
   "Lussheburgh": "A spurious coin of light weight imported into England from Luxemburg, or Lussheburgh, as it was formerly called.",
   "Lust": "Pleasure.",
   "Lust": "Inclination; desire.",
   "Lust": "Longing desire; eagerness to possess or enjoy; -- in a had sense; as, the lust of gain.",
   "Lust": "Licentious craving; sexual appetite.",
   "Lust": "Hence: Virility; vigor; active power.",
   "Lust": "To list; to like.",
   "Lust": "To have an eager, passionate, and especially an inordinate or sinful desire, as for the gratification of the sexual appetite or of covetousness; -- often with after.",
   "Luster": "One who lusts.",
   "Luster": "A period of five years; a lustrum.",
   "Luster": "Alt. of Lustre",
   "Lustre": "Brilliancy; splendor; brightness; glitter.",
   "Lustre": "Renown; splendor; distinction; glory.",
   "Lustre": "A candlestick, chandelier, girandole, or the like, generally of an ornamental character.",
   "Lustre": "The appearance of the surface of a mineral as affected by, or dependent upon, peculiarities of its reflecting qualities.",
   "Lustre": "A substance which imparts luster to a surface, as plumbago and some of the glazes.",
   "Lustre": "A fabric of wool and cotton with a lustrous surface, -- used for women's dresses.",
   "Lustering": "The act or process of imparting a luster, as to pottery.",
   "Lustering": "The brightening of a metal in the crucible when it becomes pure, as in certain refining processes.",
   "Lustihead": "See Lustihood.",
   "Lustihood": "State of being lusty; vigor of body.",
   "Lustiness": "State of being lusty; vigor; strength.",
   "Lustration": "The act of lustrating or purifying.",
   "Lustration": "A sacrifice, or ceremony, by which cities, fields, armies, or people, defiled by crimes, pestilence, or other cause of uncleanness, were purified.",
   "Lustre": "Same as Luster.",
   "Lustring": "A kind of glossy silk fabric. See Lutestring.",
   "Lustrum": "A lustration or purification, especially the purification of the whole Roman people, which was made by the censors once in five years. Hence: A period of five years.",
   "Lustwort": "See Sundew.",
   "Lutanist": "A person that plays on the lute.",
   "Lutation": "The act or method of luting vessels.",
   "Lute": "A cement of clay or other tenacious infusible substance for sealing joints in apparatus, or the mouths of vessels or tubes, or for coating the bodies of retorts, etc., when exposed to heat; -- called also luting.",
   "Lute": "A packing ring, as of rubber, for fruit jars, etc.",
   "Lute": "A straight-edged piece of wood for striking off superfluous clay from mold.",
   "Lutein": "A substance of a strongly marked yellow color, extracted from the yelk of eggs, and from the tissue of the corpus luteum.",
   "Lutenist": "Same as Lutanist.",
   "Luteolin": "A yellow dyestuff obtained from the foliage of the dyer's broom (Reseda luteola).",
   "Luter": "One who plays on a lute.",
   "Luter": "One who applies lute.",
   "Lutestring": "A plain, stout, lustrous silk, used for ladies' dresses and for ribbon.",
   "Luth": "The leatherback.",
   "Lutheran": "One who accepts or adheres to the doctrines of Luther or the Lutheran Church.",
   "Lutheranism": "Alt. of Lutherism",
   "Lutherism": "The doctrines taught by Luther or held by the Lutheran Church.",
   "Luthern": "A dormer window. See Dormer.",
   "Lutidine": "Any one of several metameric alkaloids, C5H3N.(CH3)2, of the pyridine series, obtained from bone oil as liquids, and having peculiar pungent odors. These alkaloids are also called respectively dimethyl pyridine, ethyl pyridine, etc.",
   "Luting": "See Lute, a cement.",
   "Lutist": "One who plays on a lute.",
   "Lutulence": "The state or quality of being lutulent.",
   "Luwack": "See Paradoxure.",
   "Luxation": "The act of luxating, or the state of being luxated; a dislocation.",
   "Luxe": "Luxury.",
   "Luxullianite": "A kind of granite from Luxullian, Cornwall, characterized by the presence of radiating groups of minute tourmaline crystals.",
   "Luxuriance": "The state or quality of being luxuriant; rank, vigorous growth; excessive abundance produced by rank growth.",
   "Luxuriancy": "The state or quality of being luxuriant; luxuriance.",
   "Luxuriation": "The act or process luxuriating.",
   "Luxuriety": "Luxuriance.",
   "Luxurist": "One given to luxury.",
   "Luxury": "A free indulgence in costly food, dress, furniture, or anything expensive which gratifies the appetites or tastes.",
   "Luxury": "Anything which pleases the senses, and is also costly, or difficult to obtain; an expensive rarity; as, silks, jewels, and rare fruits are luxuries; in some countries ice is a great luxury.",
   "Luxury": "Lechery; lust.",
   "Luxury": "Luxuriance; exuberance.",
   "Luz": "A bone of the human body which was supposed by certain Rabbinical writers to be indestructible. Its location was a matter of dispute.",
   "Lyam": "A leash.",
   "Lycanthrope": "A human being fabled to have been changed into a wolf; a werewolf.",
   "Lycanthrope": "One affected with lycanthropy.",
   "Lycanthropia": "See Lycanthropy, 2.",
   "Lycanthropist": "One affected by the disease lycanthropy.",
   "Lycanthropy": "The supposed act of turning one's self or another person into a wolf.",
   "Lycanthropy": "A kind of erratic melancholy, in which the patient imagines himself a wolf, and imitates the actions of that animal.",
   "Lyceum": "A place of exercise with covered walks, in the suburbs of Athens, where Aristotle taught philosophy.",
   "Lyceum": "A house or apartment appropriated to instruction by lectures or disquisitions.",
   "Lyceum": "A higher school, in Europe, which prepares youths for the university.",
   "Lyceum": "An association for debate and literary improvement.",
   "Lychee": "See Litchi.",
   "Lychnis": "A genus of Old World plants belonging to the Pink family (Caryophyllaceae). Most of the species have brilliantly colored flowers and cottony leaves, which may have anciently answered as wicks for lamps. The botanical name is in common use for the garden species. The corn cockle (Lychnis Githago) is a common weed in wheat fields.",
   "Lychnobite": "One who labors at night and sleeps in the day.",
   "Lychnoscope": "Same as Low side window, under Low, a.",
   "Lycine": "A weak base identical with betaine; -- so called because found in the boxthorn (Lycium barbarum). See Betaine.",
   "Lycoperdon": "A genus of fungi, remarkable for the great quantity of spores, forming a fine dust, which is thrown out like smoke when the plant is compressed or burst; puffball.",
   "Lycopod": "A plant of the genus Lycopodium.",
   "Lycopode": "Same as Lycopodium powder. See under Lycopodium.",
   "Lycopodite": "An old name for a fossil club moss.",
   "Lycopodium": "A genus of mosslike plants, the type of the order Lycopodiaceae; club moss.",
   "Lyden": "See Leden.",
   "Lydine": "A violet dye derived from aniline.",
   "Lye": "A strong caustic alkaline solution of potassium salts, obtained by leaching wood ashes. It is much used in making soap, etc.",
   "Lye": "A short side line, connected with the main line; a turn-out; a siding.",
   "Lye": "A falsehood.",
   "Lyerman": "The cicada.",
   "Lygodium": "A genus of ferns with twining or climbing fronds, bearing stalked and variously-lobed divisions in pairs.",
   "Lying-in": "The state attending, and consequent to, childbirth; confinement.",
   "Lying-in": "The act of bearing a child.",
   "Lym": "Alt. of Lymhound",
   "Lymhound": "A dog held in a leam; a bloodhound; a limehound.",
   "Lymail": "See Limaille.",
   "Lymph": "A spring of water; hence, water, or a pure, transparent liquid like water.",
   "Lymph": "An alkaline colorless fluid, contained in the lymphatic vessels, coagulable like blood, but free from red blood corpuscles. It is absorbed from the various tissues and organs of the body, and is finally discharged by the thoracic and right lymphatic ducts into the great veins near the heart.",
   "Lymph": "A fibrinous material exuded from the blood vessels in inflammation. In the process of healing it is either absorbed, or is converted into connective tissue binding the inflamed surfaces together.",
   "Lymphadenitis": "Inflammation of the lymphatic glands; -- called also lymphitis.",
   "Lymphadenoma": "See Lymphoma.",
   "Lymphangeitis": "Inflammation of the lymphatic vessels.",
   "Lymphatic": "One of the lymphatic or absorbent vessels, which carry lymph and discharge it into the veins; lymph duct; lymphatic duct.",
   "Lymphatic": "A mad enthusiast; a lunatic.",
   "Lymphitis": "See Lymphadenitis.",
   "Lymphography": "A description of the lymphatic vessels, their origin and uses.",
   "Lymphoma": "A tumor having a structure resembling that of a lymphatic gland; -- called also lymphadenoma.",
   "Lyn": "A waterfall. See Lin.",
   "Lyncher": "One who assists in lynching.",
   "Lynde": "Alt. of Lynden",
   "Lynden": "See Linden.",
   "Lyne": "Linen.",
   "Lynx": "Any one of several species of feline animals of the genus Felis, and subgenus Lynx. They have a short tail, and usually a pencil of hair on the tip of the ears.",
   "Lynx": "One of the northern constellations.",
   "Lyra": "A northern constellation, the Harp, containing a white star of the first magnitude, called Alpha Lyrae, or Vega.",
   "Lyra": "The middle portion of the ventral surface of the fornix of the brain; -- so called from the arrangement of the lines with which it is marked in the human brain.",
   "Lyraid": "Same as Lyrid.",
   "Lyre": "A stringed instrument of music; a kind of harp much used by the ancients, as an accompaniment to poetry.",
   "Lyre": "One of the constellations; Lyra. See Lyra.",
   "Lyric": "A lyric poem; a lyrical composition.",
   "Lyric": "A composer of lyric poems.",
   "Lyric": "A verse of the kind usually employed in lyric poetry; -- used chiefly in the plural.",
   "Lyric": "The words of a song.",
   "Lyricism": "A lyric composition.",
   "Lyrid": "One of the group of shooting stars which come into the air in certain years on or about the 19th of April; -- so called because the apparent path among the stars the stars if produced back wards crosses the constellation Lyra.",
   "Lyrie": "A European fish (Peristethus cataphractum), having the body covered with bony plates, and having three spines projecting in front of the nose; -- called also noble, pluck, pogge, sea poacher, and armed bullhead.",
   "Lyrism": "The act of playing on a lyre or harp.",
   "Lyrist": "A musician who plays on the harp or lyre; a composer of lyrical poetry.",
   "Lysimeter": "An instrument for measuring the water that percolates through a certain depth of soil.",
   "Lysis": "The resolution or favorable termination of a disease, coming on gradually and not marked by abrupt change.",
   "Lyssa": "Hydrophobia.",
   "Lythe": "The European pollack; -- called also laith, and leet.",
   "Lytta": "A fibrous and muscular band lying within the longitudinal axis of the tongue in many mammals, as the dog.",
    }


def get_l_words():
    return copy.deepcopy(l_words)
