"""create tables

Revision ID: a80fb051a659
Revises:
Create Date: 2020-11-24 12:05:33.044466

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = 'a80fb051a659'
down_revision = None
branch_labels = ("quetz",)
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        'channels',
        sa.Column('name', sa.String(), nullable=False),
        sa.Column('description', sa.String(), nullable=True),
        sa.Column('private', sa.Boolean(), nullable=True),
        sa.Column('mirror_channel_url', sa.String(), nullable=True),
        sa.Column('mirror_mode', sa.String(), nullable=True),
        sa.Column('timestamp_mirror_sync', sa.Integer(), nullable=True),
        sa.PrimaryKeyConstraint('name'),
    )
    op.create_index(op.f('ix_channels_name'), 'channels', ['name'], unique=False)
    op.create_table(
        'users',
        sa.Column('id', sa.LargeBinary(length=16), nullable=False),
        sa.Column('username', sa.String(), nullable=True),
        sa.Column('role', sa.String(), nullable=True),
        sa.PrimaryKeyConstraint('id'),
    )
    op.create_index(op.f('ix_users_id'), 'users', ['id'], unique=False)
    op.create_index(op.f('ix_users_username'), 'users', ['username'], unique=True)
    op.create_table(
        'api_keys',
        sa.Column('key', sa.String(), nullable=False),
        sa.Column('description', sa.String(), nullable=True),
        sa.Column('deleted', sa.Boolean(), nullable=True),
        sa.Column('user_id', sa.LargeBinary(length=16), nullable=True),
        sa.Column('owner_id', sa.LargeBinary(length=16), nullable=True),
        sa.ForeignKeyConstraint(
            ['owner_id'],
            ['users.id'],
        ),
        sa.ForeignKeyConstraint(
            ['user_id'],
            ['users.id'],
        ),
        sa.PrimaryKeyConstraint('key'),
    )
    op.create_index(op.f('ix_api_keys_key'), 'api_keys', ['key'], unique=False)
    op.create_table(
        'channel_members',
        sa.Column('channel_name', sa.String(), nullable=False),
        sa.Column('user_id', sa.LargeBinary(length=16), nullable=False),
        sa.Column('role', sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ['channel_name'],
            ['channels.name'],
        ),
        sa.ForeignKeyConstraint(
            ['user_id'],
            ['users.id'],
        ),
        sa.PrimaryKeyConstraint('channel_name', 'user_id'),
    )
    op.create_index(
        op.f('ix_channel_members_channel_name'),
        'channel_members',
        ['channel_name'],
        unique=False,
    )
    op.create_index(
        op.f('ix_channel_members_user_id'), 'channel_members', ['user_id'], unique=False
    )
    op.create_table(
        'identities',
        sa.Column('provider', sa.String(), nullable=False),
        sa.Column('identity_id', sa.String(), nullable=False),
        sa.Column('username', sa.String(), nullable=True),
        sa.Column('user_id', sa.LargeBinary(length=16), nullable=True),
        sa.ForeignKeyConstraint(
            ['user_id'],
            ['users.id'],
        ),
        sa.PrimaryKeyConstraint('provider', 'identity_id'),
    )
    op.create_index(
        'identity_index', 'identities', ['provider', 'identity_id'], unique=True
    )
    op.create_table(
        'packages',
        sa.Column('name', sa.String(), nullable=False),
        sa.Column('channel_name', sa.String(), nullable=False),
        sa.Column('description', sa.Text(), nullable=True),
        sa.Column('summary', sa.Text(), nullable=True),
        sa.Column('channeldata', sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ['channel_name'],
            ['channels.name'],
        ),
        sa.PrimaryKeyConstraint('name', 'channel_name'),
    )
    op.create_index(
        op.f('ix_packages_channel_name'), 'packages', ['channel_name'], unique=False
    )
    op.create_index(op.f('ix_packages_name'), 'packages', ['name'], unique=False)
    op.create_table(
        'profiles',
        sa.Column('name', sa.String(), nullable=True),
        sa.Column('avatar_url', sa.String(), nullable=True),
        sa.Column('user_id', sa.LargeBinary(length=16), nullable=False),
        sa.ForeignKeyConstraint(
            ['user_id'],
            ['users.id'],
        ),
        sa.PrimaryKeyConstraint('user_id'),
    )
    op.create_table(
        'package_members',
        sa.Column('channel_name', sa.String(), nullable=False),
        sa.Column('package_name', sa.String(), nullable=False),
        sa.Column('user_id', sa.LargeBinary(length=16), nullable=False),
        sa.Column('role', sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ['channel_name', 'package_name'],
            ['packages.channel_name', 'packages.name'],
        ),
        sa.ForeignKeyConstraint(
            ['channel_name'],
            ['channels.name'],
        ),
        sa.ForeignKeyConstraint(
            ['user_id'],
            ['users.id'],
        ),
        sa.PrimaryKeyConstraint('channel_name', 'package_name', 'user_id'),
    )
    op.create_index(
        op.f('ix_package_members_channel_name'),
        'package_members',
        ['channel_name'],
        unique=False,
    )
    op.create_index(
        op.f('ix_package_members_package_name'),
        'package_members',
        ['package_name'],
        unique=False,
    )
    op.create_index(
        op.f('ix_package_members_user_id'), 'package_members', ['user_id'], unique=False
    )
    op.create_table(
        'package_versions',
        sa.Column('id', sa.LargeBinary(length=16), nullable=False),
        sa.Column('channel_name', sa.String(), nullable=True),
        sa.Column('package_name', sa.String(), nullable=True),
        sa.Column(
            'package_format',
            sa.Enum('tarbz2', 'conda', name='packageformatenum'),
            nullable=True,
        ),
        sa.Column('platform', sa.String(), nullable=True),
        sa.Column('version', sa.String(), nullable=True),
        sa.Column('build_string', sa.String(), nullable=True),
        sa.Column('build_number', sa.Integer(), nullable=True),
        sa.Column('version_order', sa.Integer(), nullable=True),
        sa.Column('filename', sa.String(), nullable=True),
        sa.Column('info', sa.String(), nullable=True),
        sa.Column('uploader_id', sa.LargeBinary(length=16), nullable=True),
        sa.Column(
            'time_created',
            sa.DateTime(timezone=True),
            server_default=sa.text('(CURRENT_TIMESTAMP)'),
            nullable=True,
        ),
        sa.Column(
            'time_modified',
            sa.DateTime(timezone=True),
            server_default=sa.text('(CURRENT_TIMESTAMP)'),
            nullable=True,
        ),
        sa.ForeignKeyConstraint(
            ['channel_name', 'package_name'],
            ['packages.channel_name', 'packages.name'],
        ),
        sa.ForeignKeyConstraint(
            ['channel_name'],
            ['channels.name'],
        ),
        sa.ForeignKeyConstraint(
            ['uploader_id'],
            ['users.id'],
        ),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint(
            'channel_name',
            'package_name',
            'package_format',
            'platform',
            'version',
            'build_string',
            'build_number',
            name='package_version_index',
        ),
    )
    op.create_index(
        'package_version_name_index',
        'package_versions',
        ['channel_name', 'package_name'],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('package_version_name_index', table_name='package_versions')
    op.drop_table('package_versions')
    op.drop_index(op.f('ix_package_members_user_id'), table_name='package_members')
    op.drop_index(op.f('ix_package_members_package_name'), table_name='package_members')
    op.drop_index(op.f('ix_package_members_channel_name'), table_name='package_members')
    op.drop_table('package_members')
    op.drop_table('profiles')
    op.drop_index(op.f('ix_packages_name'), table_name='packages')
    op.drop_index(op.f('ix_packages_channel_name'), table_name='packages')
    op.drop_table('packages')
    op.drop_index('identity_index', table_name='identities')
    op.drop_table('identities')
    op.drop_index(op.f('ix_channel_members_user_id'), table_name='channel_members')
    op.drop_index(op.f('ix_channel_members_channel_name'), table_name='channel_members')
    op.drop_table('channel_members')
    op.drop_index(op.f('ix_api_keys_key'), table_name='api_keys')
    op.drop_table('api_keys')
    op.drop_index(op.f('ix_users_username'), table_name='users')
    op.drop_index(op.f('ix_users_id'), table_name='users')
    op.drop_table('users')
    op.drop_index(op.f('ix_channels_name'), table_name='channels')
    op.drop_table('channels')
    # ### end Alembic commands ###
