"""case insensitive channel names

Revision ID: a3ffa287d074
Revises: a80fb051a659
Create Date: 2020-12-07 14:10:27.374580

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = 'a3ffa287d074'
down_revision = 'a80fb051a659'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    if op.get_context().dialect.name == 'postgresql':
        op.execute(
            "CREATE COLLATION IF NOT EXISTS nocase (provider = icu, "
            "locale = 'und-u-ks-level2', "
            "deterministic = false)"
        )
    with op.batch_alter_table("channels") as batch_op:
        batch_op.alter_column("name", type_=sa.types.String(100, collation="nocase"))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("channels") as batch_op:
        batch_op.alter_column("name", type_=sa.types.String(None, collation=None))
    if op.get_context().dialect.name == 'postgresql':
        op.execute("DROP COLLATION nocase;")
    # ### end Alembic commands ###
