"""adding download metrics

Revision ID: 8d1e9a9e0b1f
Revises: 794249a0b1bd
Create Date: 2020-12-18 12:29:29.994522

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = '8d1e9a9e0b1f'
down_revision = '794249a0b1bd'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###

    enum_values = ('hour', 'day', 'month', 'year')
    if op.get_context().dialect.name == 'postgresql':
        intervaltype = sa.dialects.postgresql.ENUM(
            *enum_values, name='intervaltype', create_type=True
        )
    else:
        intervaltype = sa.Enum(*enum_values, name='intervaltype')
    op.create_table(
        'package_version_metrics',
        sa.Column('package_version_id', sa.LargeBinary(length=16), nullable=False),
        sa.Column('metric_name', sa.String(length=255), nullable=False),
        sa.Column(
            'period',
            intervaltype,
            nullable=False,
        ),
        sa.Column('count', sa.Integer(), nullable=False, server_default=sa.text("0")),
        sa.Column('timestamp', sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(
            ['package_version_id'],
            ['package_versions.id'],
        ),
        sa.PrimaryKeyConstraint(
            'package_version_id', 'metric_name', 'period', 'timestamp'
        ),
    )
    op.add_column(
        'package_versions', sa.Column('download_count', sa.Integer(), nullable=True)
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('package_versions', 'download_count')
    op.drop_table('package_version_metrics')
    if op.get_context().dialect.name == 'postgresql':
        op.execute("DROP TYPE intervaltype;")
    # ### end Alembic commands ###
