"""adding url and platforms dirs

Revision ID: 0653794b6252
Revises: 53f81aba78ce
Create Date: 2021-01-11 18:18:44.530101

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '0653794b6252'
down_revision = '53f81aba78ce'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('aggregated_metrics', schema=None) as batch_op:
        batch_op.alter_column(
            'period',
            existing_type=postgresql.INTERVAL(),
            type_=sa.Enum('hour', 'day', 'month', 'year', name='intervaltype'),
            existing_nullable=True,
        )

    with op.batch_alter_table('packages', schema=None) as batch_op:
        batch_op.add_column(sa.Column('platforms', sa.String(), nullable=True))
        batch_op.add_column(sa.Column('url', sa.String(), nullable=True))

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('packages', schema=None) as batch_op:
        batch_op.drop_column('url')
        batch_op.drop_column('platforms')

    with op.batch_alter_table('aggregated_metrics', schema=None) as batch_op:
        batch_op.alter_column(
            'period',
            existing_type=sa.Enum('hour', 'day', 'month', 'year', name='intervaltype'),
            type_=postgresql.INTERVAL(),
            existing_nullable=True,
        )

    # ### end Alembic commands ###
