<a id="mypy-boto3-codeguru-reviewer"></a>

# mypy-boto3-codeguru-reviewer

[![PyPI - mypy-boto3-codeguru-reviewer](https://img.shields.io/pypi/v/mypy-boto3-codeguru-reviewer.svg?color=blue)](https://pypi.org/project/mypy-boto3-codeguru-reviewer)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-codeguru-reviewer.svg?color=blue)](https://pypi.org/project/mypy-boto3-codeguru-reviewer)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-codeguru-reviewer?color=blue)](https://pypistats.org/packages/mypy-boto3-codeguru-reviewer)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.CodeGuruReviewer 1.18.22](https://boto3.amazonaws.com/v1/documentation/api/1.18.22/reference/services/codeguru-reviewer.html#CodeGuruReviewer)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-codeguru-reviewer docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_codeguru_reviewer/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-codeguru-reviewer](#mypy-boto3-codeguru-reviewer)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `CodeGuruReviewer` service.

```bash
python -m pip install boto3-stubs[codeguru-reviewer]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[codeguru-reviewer]` in your environment:
  `python -m pip install 'boto3-stubs[codeguru-reviewer]'`

Both type checking and auto-complete should work for `CodeGuruReviewer`
service. No explicit type annotations required, write your `boto3` code as
usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[codeguru-reviewer]` in your environment:
  `python -m pip install 'boto3-stubs[codeguru-reviewer]'`

Both type checking and auto-complete should work for `CodeGuruReviewer`
service. No explicit type annotations required, write your `boto3` code as
usual. Auto-complete can be slow on big projects or if you have a lot of
installed `boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[codeguru-reviewer]` in your environment:
  `python -m pip install 'boto3-stubs[codeguru-reviewer]'`
- Run `mypy` as usual

Type checking should work for `CodeGuruReviewer` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[codeguru-reviewer]` in your environment:
  `python -m pip install 'boto3-stubs[codeguru-reviewer]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `CodeGuruReviewer` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`CodeGuruReviewerClient` provides annotations for
`boto3.client("codeguru-reviewer")`.

```python
import boto3

from mypy_boto3_codeguru_reviewer import CodeGuruReviewerClient

client: CodeGuruReviewerClient = boto3.client("codeguru-reviewer")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CodeGuruReviewerClient = session.client("codeguru-reviewer")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_codeguru_reviewer.paginator` module contains type annotations for
all paginators.

```python
from mypy_boto3_codeguru_reviewer import CodeGuruReviewerClient
from mypy_boto3_codeguru_reviewer.paginator import (
    ListRepositoryAssociationsPaginator,
)

client: CodeGuruReviewerClient = boto3.client("codeguru-reviewer")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_repository_associations_paginator: ListRepositoryAssociationsPaginator = client.get_paginator("list_repository_associations")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_codeguru_reviewer.waiter` module contains type annotations for all
waiters.

```python
from mypy_boto3_codeguru_reviewer import CodeGuruReviewerClient
from mypy_boto3_codeguru_reviewer.waiter import (
    CodeReviewCompletedWaiter,
    RepositoryAssociationSucceededWaiter,
)

client: CodeGuruReviewerClient = boto3.client("codeguru-reviewer")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
code_review_completed_waiter: CodeReviewCompletedWaiter = client.get_waiter("code_review_completed")
repository_association_succeeded_waiter: RepositoryAssociationSucceededWaiter = client.get_waiter("repository_association_succeeded")
```

<a id="literals"></a>

### Literals

`mypy_boto3_codeguru_reviewer.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_codeguru_reviewer.literals import (
    AnalysisTypeType,
    CodeReviewCompletedWaiterName,
    EncryptionOptionType,
    JobStateType,
    ListRepositoryAssociationsPaginatorName,
    ProviderTypeType,
    ReactionType,
    RecommendationCategoryType,
    RepositoryAssociationStateType,
    RepositoryAssociationSucceededWaiterName,
    TypeType,
    VendorNameType,
)

def check_value(value: AnalysisTypeType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_codeguru_reviewer.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_codeguru_reviewer.type_defs import (
    AssociateRepositoryRequestRequestTypeDef,
    AssociateRepositoryResponseTypeDef,
    BranchDiffSourceCodeTypeTypeDef,
    CodeArtifactsTypeDef,
    CodeCommitRepositoryTypeDef,
    CodeReviewSummaryTypeDef,
    CodeReviewTypeDef,
    CodeReviewTypeTypeDef,
    CommitDiffSourceCodeTypeTypeDef,
    CreateCodeReviewRequestRequestTypeDef,
    CreateCodeReviewResponseTypeDef,
    DescribeCodeReviewRequestRequestTypeDef,
    DescribeCodeReviewResponseTypeDef,
    DescribeRecommendationFeedbackRequestRequestTypeDef,
    DescribeRecommendationFeedbackResponseTypeDef,
    DescribeRepositoryAssociationRequestRequestTypeDef,
    DescribeRepositoryAssociationResponseTypeDef,
    DisassociateRepositoryRequestRequestTypeDef,
    DisassociateRepositoryResponseTypeDef,
    EventInfoTypeDef,
    KMSKeyDetailsTypeDef,
    ListCodeReviewsRequestRequestTypeDef,
    ListCodeReviewsResponseTypeDef,
    ListRecommendationFeedbackRequestRequestTypeDef,
    ListRecommendationFeedbackResponseTypeDef,
    ListRecommendationsRequestRequestTypeDef,
    ListRecommendationsResponseTypeDef,
    ListRepositoryAssociationsRequestRequestTypeDef,
    ListRepositoryAssociationsResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    MetricsSummaryTypeDef,
    MetricsTypeDef,
    PaginatorConfigTypeDef,
    PutRecommendationFeedbackRequestRequestTypeDef,
    RecommendationFeedbackSummaryTypeDef,
    RecommendationFeedbackTypeDef,
    RecommendationSummaryTypeDef,
    RepositoryAnalysisTypeDef,
    RepositoryAssociationSummaryTypeDef,
    RepositoryAssociationTypeDef,
    RepositoryHeadSourceCodeTypeTypeDef,
    RepositoryTypeDef,
    RequestMetadataTypeDef,
    ResponseMetadataTypeDef,
    S3BucketRepositoryTypeDef,
    S3RepositoryDetailsTypeDef,
    S3RepositoryTypeDef,
    SourceCodeTypeTypeDef,
    TagResourceRequestRequestTypeDef,
    ThirdPartySourceRepositoryTypeDef,
    UntagResourceRequestRequestTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AssociateRepositoryRequestRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-codeguru-reviewer` version is the same as related `boto3` version
and follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-codeguru-reviewer docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_codeguru_reviewer/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
