/*
 * Decompiled with CFR 0.152.
 */
package patsy;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jpmml.python.Token;
import patsy.FormulaParserConstants;

public class PatsyToken {
    private List<Token> tokens = null;

    public PatsyToken(Token token) {
        this(Collections.singletonList(token));
    }

    public PatsyToken(List<Token> tokens) {
        this.setTokens(tokens);
    }

    public String toString() {
        List<Token> tokens = this.getTokens();
        return tokens.stream().map(token -> token.image + " -> " + FormulaParserConstants.tokenImage[token.kind] + " (" + token.kind + ")").collect(Collectors.joining(", ", "[", "]"));
    }

    public int getKind() {
        List<Token> tokens = this.getTokens();
        if (tokens.size() == 1) {
            Token token = tokens.get(0);
            switch (token.kind) {
                case 33: 
                case 34: 
                case 35: {
                    return -1;
                }
            }
            return token.kind;
        }
        return -1;
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    void setTokens(List<Token> tokens) {
        this.tokens = Objects.requireNonNull(tokens);
    }
}

