/*
 * Decompiled with CFR 0.152.
 */
package pandas.core;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jpmml.python.CustomPythonObject;
import org.jpmml.python.HasArray;
import pandas.core.Block;
import pandas.core.Index;

public class BlockManager
extends CustomPythonObject {
    private static final String[] INIT_ATTRIBUTES = new String[]{"blocks", "axes"};
    private static final String[] SETSTATE_ATTRIBUTES = new String[]{"axes_array", "block_values", "block_items"};

    public BlockManager(String module, String name) {
        super(module, name);
    }

    public List<Index> getAxesArray() {
        if (this.containsKey("axes_array")) {
            return this.getList("axes_array", Index.class);
        }
        return this.getList("axes", Index.class);
    }

    public List<Index> getBlockItems() {
        if (this.containsKey("block_items")) {
            return this.getList("block_items", Index.class);
        }
        throw new UnsupportedOperationException();
    }

    public BlockManager setBlockItems(List<Index> blockItems) {
        this.put("block_items", blockItems);
        return this;
    }

    public List<HasArray> getBlockValues() {
        if (this.containsKey("block_values")) {
            return this.getList("block_values", HasArray.class);
        }
        Object[] blocks = this.getTuple("blocks");
        return Arrays.stream(blocks).map(block -> (HasArray)((Block)((Object)((Object)block))).get("values")).collect(Collectors.toList());
    }

    public BlockManager setBlockValues(List<HasArray> blockValues) {
        this.put("block_values", blockValues);
        return this;
    }

    @Override
    public void __init__(Object[] args) {
        if (args.length == 0) {
            super.__init__(args);
        } else {
            super.__setstate__(BlockManager.createAttributeMap(INIT_ATTRIBUTES, args));
        }
    }

    @Override
    public void __setstate__(Object[] args) {
        if (args.length > 3) {
            Object[] newArgs = new Object[3];
            System.arraycopy(args, 0, newArgs, 0, newArgs.length);
            args = newArgs;
        }
        super.__setstate__(BlockManager.createAttributeMap(SETSTATE_ATTRIBUTES, args));
    }
}

