import * as iam from '@aws-cdk/aws-iam';
import { Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { ISecret } from './secret';
/**
 * Construction properties for a ResourcePolicy.
 *
 * @stability stable
 */
export interface ResourcePolicyProps {
    /**
     * The secret to attach a resource-based permissions policy.
     *
     * @stability stable
     */
    readonly secret: ISecret;
}
/**
 * Secret Resource Policy.
 *
 * @stability stable
 */
export declare class ResourcePolicy extends Resource {
    /**
     * The IAM policy document for this policy.
     *
     * @stability stable
     */
    readonly document: iam.PolicyDocument;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: ResourcePolicyProps);
}
