# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class DisplayApplianceInfo(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, culture_name=None, custom_fields=None, date_signed=None, document_data=None, document_pages=None, dynamic_system_settings=None, envelope_data=None, image=None, is_non_display_appliance_template=None, locale_policy=None, page_data=None, recipient_data=None, translate_height=None, update_tab_module=None):
        """
        DisplayApplianceInfo - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'culture_name': 'str',
            'custom_fields': 'list[DisplayApplianceCustomField]',
            'date_signed': 'str',
            'document_data': 'list[DisplayApplianceDocument]',
            'document_pages': 'list[DisplayApplianceDocumentPage]',
            'dynamic_system_settings': 'dict(str, object)',
            'envelope_data': 'DisplayApplianceEnvelope',
            'image': 'str',
            'is_non_display_appliance_template': 'bool',
            'locale_policy': 'dict(str, str)',
            'page_data': 'list[DisplayAppliancePage]',
            'recipient_data': 'list[DisplayApplianceRecipient]',
            'translate_height': 'bool',
            'update_tab_module': 'bool'
        }

        self.attribute_map = {
            'culture_name': 'cultureName',
            'custom_fields': 'customFields',
            'date_signed': 'dateSigned',
            'document_data': 'documentData',
            'document_pages': 'documentPages',
            'dynamic_system_settings': 'dynamicSystemSettings',
            'envelope_data': 'envelopeData',
            'image': 'image',
            'is_non_display_appliance_template': 'isNonDisplayApplianceTemplate',
            'locale_policy': 'localePolicy',
            'page_data': 'pageData',
            'recipient_data': 'recipientData',
            'translate_height': 'translateHeight',
            'update_tab_module': 'updateTabModule'
        }

        self._culture_name = culture_name
        self._custom_fields = custom_fields
        self._date_signed = date_signed
        self._document_data = document_data
        self._document_pages = document_pages
        self._dynamic_system_settings = dynamic_system_settings
        self._envelope_data = envelope_data
        self._image = image
        self._is_non_display_appliance_template = is_non_display_appliance_template
        self._locale_policy = locale_policy
        self._page_data = page_data
        self._recipient_data = recipient_data
        self._translate_height = translate_height
        self._update_tab_module = update_tab_module

    @property
    def culture_name(self):
        """
        Gets the culture_name of this DisplayApplianceInfo.
        

        :return: The culture_name of this DisplayApplianceInfo.
        :rtype: str
        """
        return self._culture_name

    @culture_name.setter
    def culture_name(self, culture_name):
        """
        Sets the culture_name of this DisplayApplianceInfo.
        

        :param culture_name: The culture_name of this DisplayApplianceInfo.
        :type: str
        """

        self._culture_name = culture_name

    @property
    def custom_fields(self):
        """
        Gets the custom_fields of this DisplayApplianceInfo.
        An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.

        :return: The custom_fields of this DisplayApplianceInfo.
        :rtype: list[DisplayApplianceCustomField]
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields):
        """
        Sets the custom_fields of this DisplayApplianceInfo.
        An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.

        :param custom_fields: The custom_fields of this DisplayApplianceInfo.
        :type: list[DisplayApplianceCustomField]
        """

        self._custom_fields = custom_fields

    @property
    def date_signed(self):
        """
        Gets the date_signed of this DisplayApplianceInfo.
        

        :return: The date_signed of this DisplayApplianceInfo.
        :rtype: str
        """
        return self._date_signed

    @date_signed.setter
    def date_signed(self, date_signed):
        """
        Sets the date_signed of this DisplayApplianceInfo.
        

        :param date_signed: The date_signed of this DisplayApplianceInfo.
        :type: str
        """

        self._date_signed = date_signed

    @property
    def document_data(self):
        """
        Gets the document_data of this DisplayApplianceInfo.
        

        :return: The document_data of this DisplayApplianceInfo.
        :rtype: list[DisplayApplianceDocument]
        """
        return self._document_data

    @document_data.setter
    def document_data(self, document_data):
        """
        Sets the document_data of this DisplayApplianceInfo.
        

        :param document_data: The document_data of this DisplayApplianceInfo.
        :type: list[DisplayApplianceDocument]
        """

        self._document_data = document_data

    @property
    def document_pages(self):
        """
        Gets the document_pages of this DisplayApplianceInfo.
        

        :return: The document_pages of this DisplayApplianceInfo.
        :rtype: list[DisplayApplianceDocumentPage]
        """
        return self._document_pages

    @document_pages.setter
    def document_pages(self, document_pages):
        """
        Sets the document_pages of this DisplayApplianceInfo.
        

        :param document_pages: The document_pages of this DisplayApplianceInfo.
        :type: list[DisplayApplianceDocumentPage]
        """

        self._document_pages = document_pages

    @property
    def dynamic_system_settings(self):
        """
        Gets the dynamic_system_settings of this DisplayApplianceInfo.
        

        :return: The dynamic_system_settings of this DisplayApplianceInfo.
        :rtype: dict(str, object)
        """
        return self._dynamic_system_settings

    @dynamic_system_settings.setter
    def dynamic_system_settings(self, dynamic_system_settings):
        """
        Sets the dynamic_system_settings of this DisplayApplianceInfo.
        

        :param dynamic_system_settings: The dynamic_system_settings of this DisplayApplianceInfo.
        :type: dict(str, object)
        """

        self._dynamic_system_settings = dynamic_system_settings

    @property
    def envelope_data(self):
        """
        Gets the envelope_data of this DisplayApplianceInfo.

        :return: The envelope_data of this DisplayApplianceInfo.
        :rtype: DisplayApplianceEnvelope
        """
        return self._envelope_data

    @envelope_data.setter
    def envelope_data(self, envelope_data):
        """
        Sets the envelope_data of this DisplayApplianceInfo.

        :param envelope_data: The envelope_data of this DisplayApplianceInfo.
        :type: DisplayApplianceEnvelope
        """

        self._envelope_data = envelope_data

    @property
    def image(self):
        """
        Gets the image of this DisplayApplianceInfo.
        

        :return: The image of this DisplayApplianceInfo.
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image):
        """
        Sets the image of this DisplayApplianceInfo.
        

        :param image: The image of this DisplayApplianceInfo.
        :type: str
        """

        self._image = image

    @property
    def is_non_display_appliance_template(self):
        """
        Gets the is_non_display_appliance_template of this DisplayApplianceInfo.
        

        :return: The is_non_display_appliance_template of this DisplayApplianceInfo.
        :rtype: bool
        """
        return self._is_non_display_appliance_template

    @is_non_display_appliance_template.setter
    def is_non_display_appliance_template(self, is_non_display_appliance_template):
        """
        Sets the is_non_display_appliance_template of this DisplayApplianceInfo.
        

        :param is_non_display_appliance_template: The is_non_display_appliance_template of this DisplayApplianceInfo.
        :type: bool
        """

        self._is_non_display_appliance_template = is_non_display_appliance_template

    @property
    def locale_policy(self):
        """
        Gets the locale_policy of this DisplayApplianceInfo.
        

        :return: The locale_policy of this DisplayApplianceInfo.
        :rtype: dict(str, str)
        """
        return self._locale_policy

    @locale_policy.setter
    def locale_policy(self, locale_policy):
        """
        Sets the locale_policy of this DisplayApplianceInfo.
        

        :param locale_policy: The locale_policy of this DisplayApplianceInfo.
        :type: dict(str, str)
        """

        self._locale_policy = locale_policy

    @property
    def page_data(self):
        """
        Gets the page_data of this DisplayApplianceInfo.
        

        :return: The page_data of this DisplayApplianceInfo.
        :rtype: list[DisplayAppliancePage]
        """
        return self._page_data

    @page_data.setter
    def page_data(self, page_data):
        """
        Sets the page_data of this DisplayApplianceInfo.
        

        :param page_data: The page_data of this DisplayApplianceInfo.
        :type: list[DisplayAppliancePage]
        """

        self._page_data = page_data

    @property
    def recipient_data(self):
        """
        Gets the recipient_data of this DisplayApplianceInfo.
        

        :return: The recipient_data of this DisplayApplianceInfo.
        :rtype: list[DisplayApplianceRecipient]
        """
        return self._recipient_data

    @recipient_data.setter
    def recipient_data(self, recipient_data):
        """
        Sets the recipient_data of this DisplayApplianceInfo.
        

        :param recipient_data: The recipient_data of this DisplayApplianceInfo.
        :type: list[DisplayApplianceRecipient]
        """

        self._recipient_data = recipient_data

    @property
    def translate_height(self):
        """
        Gets the translate_height of this DisplayApplianceInfo.
        

        :return: The translate_height of this DisplayApplianceInfo.
        :rtype: bool
        """
        return self._translate_height

    @translate_height.setter
    def translate_height(self, translate_height):
        """
        Sets the translate_height of this DisplayApplianceInfo.
        

        :param translate_height: The translate_height of this DisplayApplianceInfo.
        :type: bool
        """

        self._translate_height = translate_height

    @property
    def update_tab_module(self):
        """
        Gets the update_tab_module of this DisplayApplianceInfo.
        

        :return: The update_tab_module of this DisplayApplianceInfo.
        :rtype: bool
        """
        return self._update_tab_module

    @update_tab_module.setter
    def update_tab_module(self, update_tab_module):
        """
        Sets the update_tab_module of this DisplayApplianceInfo.
        

        :param update_tab_module: The update_tab_module of this DisplayApplianceInfo.
        :type: bool
        """

        self._update_tab_module = update_tab_module

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
