#!/usr/bin/python
# -*- coding: utf-8 -*-
"""Shape-Out - miscellaneous methods for GUI"""
from __future__ import division, print_function, unicode_literals

import wx
from . import icon


def getMainIcon(pxlength=32):
    """ *pxlength* is the side length in pixels of the icon """
    # Set window icon
    iconBMP = icon.getMainBitmap()
    # scale
    image = wx.ImageFromBitmap(iconBMP)
    image = image.Scale(pxlength, pxlength, wx.IMAGE_QUALITY_HIGH)
    iconBMP = wx.BitmapFromImage(image)
    iconICO = wx.IconFromBitmap(iconBMP)
    return iconICO
