# coding: utf-8

"""
    symbl.ai APIs

    <h1>Symbl's APIs for external consumers.</h1> <h2>Language Insights API</h2> Symbl's Language Insights API provides an interface for applications to perform the analysis on the raw text and get insights from it. The API automatically detects sentence boundaries and punctuates the sentences, and also returns the updated messages in the response. Conversations are the most unstructured piece of information that we represent information in, and which most of the leads to lot of loss of information by not being able to capture them correctly.<br/> Language Insights API focuses on understanding such texts and generate the useful and important information from them. <br/> Currently the API supports detection of the Action Items in any type of unstructured text. In future the same API will also have support to detect \"Information\" and \"Event\", where Information is any informational piece and Event is a reference to something that has happened in the past.<br/> <h2>Telephony Integration</h2> Symbl can currently integrate with two types of telephony endpoints: 1. SIP trunks<br/> 2. PSTN endpoints<br/> Results are sent via HTTP WebHooks as and when they are available.<br/> <h2>Flow</h2> 1. External Application invokes REST API to join a meeting/session, with the mode (SIP/PSTN) and joining details<br/> 2. Symbl joins the meeting via SIP or PSTN integration<br/> 3. Symbl continuously processes the audio stream received<br/> 4. Symbl calls WebHook whenever transcription results are available<br/>  # noqa: E501

    OpenAPI spec version: 0.0.1
    Contact: info@symbl.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class EntitiesTag(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'type': 'str',
        'text': 'str',
        'message_refs': 'list[object]',
        'value': 'str',
        'start': 'datetime',
        'end': 'datetime',
        'custom_type': 'str'
    }

    attribute_map = {
        'type': 'type',
        'text': 'text',
        'message_refs': 'messageRefs',
        'value': 'value',
        'start': 'start',
        'end': 'end',
        'custom_type': 'customType'
    }

    def __init__(self, type=None, text=None, message_refs=None, value=None, start=None, end=None, custom_type=None):  # noqa: E501
        """EntitiesTag - a model defined in Swagger"""  # noqa: E501
        self._type = None
        self._text = None
        self._message_refs = None
        self._value = None
        self._start = None
        self._end = None
        self._custom_type = None
        self.discriminator = None
        self.type = type
        self.text = text
        self.message_refs = message_refs
        if value is not None:
            self.value = value
        if start is not None:
            self.start = start
        if end is not None:
            self.end = end
        if custom_type is not None:
            self.custom_type = custom_type

    @property
    def type(self):
        """Gets the type of this EntitiesTag.  # noqa: E501


        :return: The type of this EntitiesTag.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this EntitiesTag.


        :param type: The type of this EntitiesTag.  # noqa: E501
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def text(self):
        """Gets the text of this EntitiesTag.  # noqa: E501


        :return: The text of this EntitiesTag.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this EntitiesTag.


        :param text: The text of this EntitiesTag.  # noqa: E501
        :type: str
        """
        if text is None:
            raise ValueError("Invalid value for `text`, must not be `None`")  # noqa: E501

        self._text = text

    @property
    def message_refs(self):
        """Gets the message_refs of this EntitiesTag.  # noqa: E501


        :return: The message_refs of this EntitiesTag.  # noqa: E501
        :rtype: list[object]
        """
        return self._message_refs

    @message_refs.setter
    def message_refs(self, message_refs):
        """Sets the message_refs of this EntitiesTag.


        :param message_refs: The message_refs of this EntitiesTag.  # noqa: E501
        :type: list[object]
        """
        if message_refs is None:
            raise ValueError("Invalid value for `message_refs`, must not be `None`")  # noqa: E501

        self._message_refs = message_refs

    @property
    def value(self):
        """Gets the value of this EntitiesTag.  # noqa: E501


        :return: The value of this EntitiesTag.  # noqa: E501
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this EntitiesTag.


        :param value: The value of this EntitiesTag.  # noqa: E501
        :type: str
        """

        self._value = value

    @property
    def start(self):
        """Gets the start of this EntitiesTag.  # noqa: E501


        :return: The start of this EntitiesTag.  # noqa: E501
        :rtype: datetime
        """
        return self._start

    @start.setter
    def start(self, start):
        """Sets the start of this EntitiesTag.


        :param start: The start of this EntitiesTag.  # noqa: E501
        :type: datetime
        """

        self._start = start

    @property
    def end(self):
        """Gets the end of this EntitiesTag.  # noqa: E501


        :return: The end of this EntitiesTag.  # noqa: E501
        :rtype: datetime
        """
        return self._end

    @end.setter
    def end(self, end):
        """Sets the end of this EntitiesTag.


        :param end: The end of this EntitiesTag.  # noqa: E501
        :type: datetime
        """

        self._end = end

    @property
    def custom_type(self):
        """Gets the custom_type of this EntitiesTag.  # noqa: E501


        :return: The custom_type of this EntitiesTag.  # noqa: E501
        :rtype: str
        """
        return self._custom_type

    @custom_type.setter
    def custom_type(self, custom_type):
        """Sets the custom_type of this EntitiesTag.


        :param custom_type: The custom_type of this EntitiesTag.  # noqa: E501
        :type: str
        """

        self._custom_type = custom_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EntitiesTag, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EntitiesTag):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
