# coding: utf-8

"""
    symbl.ai APIs

    <h1>Symbl's APIs for external consumers.</h1> <h2>Language Insights API</h2> Symbl's Language Insights API provides an interface for applications to perform the analysis on the raw text and get insights from it. The API automatically detects sentence boundaries and punctuates the sentences, and also returns the updated messages in the response. Conversations are the most unstructured piece of information that we represent information in, and which most of the leads to lot of loss of information by not being able to capture them correctly.<br/> Language Insights API focuses on understanding such texts and generate the useful and important information from them. <br/> Currently the API supports detection of the Action Items in any type of unstructured text. In future the same API will also have support to detect \"Information\" and \"Event\", where Information is any informational piece and Event is a reference to something that has happened in the past.<br/> <h2>Telephony Integration</h2> Symbl can currently integrate with two types of telephony endpoints: 1. SIP trunks<br/> 2. PSTN endpoints<br/> Results are sent via HTTP WebHooks as and when they are available.<br/> <h2>Flow</h2> 1. External Application invokes REST API to join a meeting/session, with the mode (SIP/PSTN) and joining details<br/> 2. Symbl joins the meeting via SIP or PSTN integration<br/> 3. Symbl continuously processes the audio stream received<br/> 4. Symbl calls WebHook whenever transcription results are available<br/>  # noqa: E501

    OpenAPI spec version: 0.0.1
    Contact: info@symbl.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Body(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'content_type': 'str',
        'create_paragraphs': 'bool',
        'phrases': 'list[V1conversationsconversationIdtranscriptPhrases]',
        'show_speaker_separation': 'bool'
    }

    attribute_map = {
        'content_type': 'contentType',
        'create_paragraphs': 'createParagraphs',
        'phrases': 'phrases',
        'show_speaker_separation': 'showSpeakerSeparation'
    }

    def __init__(self, content_type=None, create_paragraphs=None, phrases=None, show_speaker_separation=None):  # noqa: E501
        """Body - a model defined in Swagger"""  # noqa: E501
        self._content_type = None
        self._create_paragraphs = None
        self._phrases = None
        self._show_speaker_separation = None
        self.discriminator = None
        if content_type is not None:
            self.content_type = content_type
        if create_paragraphs is not None:
            self.create_paragraphs = create_paragraphs
        if phrases is not None:
            self.phrases = phrases
        if show_speaker_separation is not None:
            self.show_speaker_separation = show_speaker_separation

    @property
    def content_type(self):
        """Gets the content_type of this Body.  # noqa: E501


        :return: The content_type of this Body.  # noqa: E501
        :rtype: str
        """
        return self._content_type

    @content_type.setter
    def content_type(self, content_type):
        """Sets the content_type of this Body.


        :param content_type: The content_type of this Body.  # noqa: E501
        :type: str
        """

        self._content_type = content_type

    @property
    def create_paragraphs(self):
        """Gets the create_paragraphs of this Body.  # noqa: E501


        :return: The create_paragraphs of this Body.  # noqa: E501
        :rtype: bool
        """
        return self._create_paragraphs

    @create_paragraphs.setter
    def create_paragraphs(self, create_paragraphs):
        """Sets the create_paragraphs of this Body.


        :param create_paragraphs: The create_paragraphs of this Body.  # noqa: E501
        :type: bool
        """

        self._create_paragraphs = create_paragraphs

    @property
    def phrases(self):
        """Gets the phrases of this Body.  # noqa: E501


        :return: The phrases of this Body.  # noqa: E501
        :rtype: list[V1conversationsconversationIdtranscriptPhrases]
        """
        return self._phrases

    @phrases.setter
    def phrases(self, phrases):
        """Sets the phrases of this Body.


        :param phrases: The phrases of this Body.  # noqa: E501
        :type: list[V1conversationsconversationIdtranscriptPhrases]
        """

        self._phrases = phrases

    @property
    def show_speaker_separation(self):
        """Gets the show_speaker_separation of this Body.  # noqa: E501


        :return: The show_speaker_separation of this Body.  # noqa: E501
        :rtype: bool
        """
        return self._show_speaker_separation

    @show_speaker_separation.setter
    def show_speaker_separation(self, show_speaker_separation):
        """Sets the show_speaker_separation of this Body.


        :param show_speaker_separation: The show_speaker_separation of this Body.  # noqa: E501
        :type: bool
        """

        self._show_speaker_separation = show_speaker_separation

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Body, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Body):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
