# symbl-rest
<h1>Symbl's APIs for external consumers.</h1> <h2>Language Insights API</h2> Symbl's Language Insights API provides an interface for applications to perform the analysis on the raw text and get insights from it. The API automatically detects sentence boundaries and punctuates the sentences, and also returns the updated messages in the response. Conversations are the most unstructured piece of information that we represent information in, and which most of the leads to lot of loss of information by not being able to capture them correctly.<br/> Language Insights API focuses on understanding such texts and generate the useful and important information from them. <br/> Currently the API supports detection of the Action Items in any type of unstructured text. In future the same API will also have support to detect \"Information\" and \"Event\", where Information is any informational piece and Event is a reference to something that has happened in the past.<br/> <h2>Telephony Integration</h2> Symbl can currently integrate with two types of telephony endpoints: 1. SIP trunks<br/> 2. PSTN endpoints<br/> Results are sent via HTTP WebHooks as and when they are available.<br/> <h2>Flow</h2> 1. External Application invokes REST API to join a meeting/session, with the mode (SIP/PSTN) and joining details<br/> 2. Symbl joins the meeting via SIP or PSTN integration<br/> 3. Symbl continuously processes the audio stream received<br/> 4. Symbl calls WebHook whenever transcription results are available<br/>

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.0.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import symbl_rest 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import symbl_rest
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import symbl_rest
from symbl_rest.rest import ApiException
from pprint import pprint

# Configure API key authorization: bearerAuth
configuration = symbl_rest.Configuration()
configuration.api_key['x-api-key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['x-api-key'] = 'Bearer'

# create an instance of the API class
api_instance = symbl_rest.ActionItemsApi(symbl_rest.ApiClient(configuration))
conversation_id = 'conversation_id_example' # str | ID of the conversation

try:
    # Retrieve action items from conversations
    api_response = api_instance.get_action_items_by_conversation_id(conversation_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ActionItemsApi->get_action_items_by_conversation_id: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.symbl.ai*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ActionItemsApi* | [**get_action_items_by_conversation_id**](docs/ActionItemsApi.md#get_action_items_by_conversation_id) | **GET** /v1/conversations/{conversationId}/action-items | Retrieve action items from conversations
*AnalyticsApi* | [**get_analytics_by_conversation_id**](docs/AnalyticsApi.md#get_analytics_by_conversation_id) | **GET** /v1/conversations/{conversationId}/analytics | Retrieves speaker ratio, talk time etc from Conversations
*AsyncApi* | [**add_audio**](docs/AsyncApi.md#add_audio) | **POST** /v1/process/audio | Audio - Submit New Audio File (wav/mp3)
*AsyncApi* | [**add_audio_url**](docs/AsyncApi.md#add_audio_url) | **POST** /v1/process/audio/url | Audio(URL)  - Submit New Conversation
*AsyncApi* | [**add_text**](docs/AsyncApi.md#add_text) | **POST** /v1/process/text | Add new Text Messages
*AsyncApi* | [**add_video**](docs/AsyncApi.md#add_video) | **POST** /v1/process/video | Video - Submit New Video File (mp4)
*AsyncApi* | [**add_video_url**](docs/AsyncApi.md#add_video_url) | **POST** /v1/process/video/url | Video (URL)  - Submit New Conversation
*AsyncApi* | [**append_audio**](docs/AsyncApi.md#append_audio) | **PUT** /v1/process/audio/{conversationId} | Audio - Submit New Audio File (wav/mp3)
*AsyncApi* | [**append_audio_url**](docs/AsyncApi.md#append_audio_url) | **PUT** /v1/process/audio/url/{conversationId} | Audio(URL)  - Submit New Conversation
*AsyncApi* | [**append_text**](docs/AsyncApi.md#append_text) | **PUT** /v1/process/text/{conversationId} | Text - Append to Existing Conversation
*AsyncApi* | [**append_video**](docs/AsyncApi.md#append_video) | **PUT** /v1/process/video/{conversationId} | Video - Submit New Video File (mp4)
*AsyncApi* | [**append_video_url**](docs/AsyncApi.md#append_video_url) | **PUT** /v1/process/video/url/{conversationId} | Video (URL)  - Submit New Conversation
*AuthenticationApi* | [**generate_token**](docs/AuthenticationApi.md#generate_token) | **POST** /oauth2/token:generate | Generates the token from the given credentials
*AuthenticationApi* | [**refresh_token**](docs/AuthenticationApi.md#refresh_token) | **POST** /oauth2/token:refresh | Authenticate and refresh the current valid token
*AuthenticationApi* | [**revoke_token**](docs/AuthenticationApi.md#revoke_token) | **DELETE** /oauth2/token:revoke | Revoke the given token
*ConnectionToEndpointApi* | [**connect_to_endpoint**](docs/ConnectionToEndpointApi.md#connect_to_endpoint) | **POST** /v1/endpoint:connect | Connect to your SIP or PSTN endpoint, and control the connection
*ConversationDataApi* | [**get_conversation_by_conversation_id**](docs/ConversationDataApi.md#get_conversation_by_conversation_id) | **GET** /v1/conversations/{conversationId} | Retrieve Conversation data/meta-data from Conversations
*ConversationsApi* | [**delete_conversation_by_conversation_id**](docs/ConversationsApi.md#delete_conversation_by_conversation_id) | **DELETE** /v1/conversations/{conversationId} | deletes conversation and all related entities
*ConversationsApi* | [**get_action_items_by_conversation_id**](docs/ConversationsApi.md#get_action_items_by_conversation_id) | **GET** /v1/conversations/{conversationId}/action-items | Retrieve action items from conversations
*ConversationsApi* | [**get_analytics_by_conversation_id**](docs/ConversationsApi.md#get_analytics_by_conversation_id) | **GET** /v1/conversations/{conversationId}/analytics | Retrieves speaker ratio, talk time etc from Conversations
*ConversationsApi* | [**get_conversation_by_conversation_id**](docs/ConversationsApi.md#get_conversation_by_conversation_id) | **GET** /v1/conversations/{conversationId} | Retrieve Conversation data/meta-data from Conversations
*ConversationsApi* | [**get_entities_by_conversation_id**](docs/ConversationsApi.md#get_entities_by_conversation_id) | **GET** /v1/conversations/{conversationId}/entities | Extract Entities from Conversation
*ConversationsApi* | [**get_follow_ups_by_conversation_id**](docs/ConversationsApi.md#get_follow_ups_by_conversation_id) | **GET** /v1/conversations/{conversationId}/follow-ups | Retrieve follow ups from conversations
*ConversationsApi* | [**get_formatted_transcript_by_conversation_id**](docs/ConversationsApi.md#get_formatted_transcript_by_conversation_id) | **POST** /v1/conversations/{conversationId}/transcript | Returns a formatted transcript in Markdown and SRT format.
*ConversationsApi* | [**get_insights_by_conversation_id**](docs/ConversationsApi.md#get_insights_by_conversation_id) | **GET** /v1/conversations/{conversationId}/insights | Retrieve insights from Conversations
*ConversationsApi* | [**get_intents_by_conversation_id**](docs/ConversationsApi.md#get_intents_by_conversation_id) | **GET** /v1/conversations/{conversationId}/intents | Retrieve intents from conversation
*ConversationsApi* | [**get_members_by_conversation_id**](docs/ConversationsApi.md#get_members_by_conversation_id) | **GET** /v1/conversations/{conversationId}/members | Retrieve members from Conversations
*ConversationsApi* | [**get_messages_by_conversation_id**](docs/ConversationsApi.md#get_messages_by_conversation_id) | **GET** /v1/conversations/{conversationId}/messages | Retrieve messages from Conversations
*ConversationsApi* | [**get_questions_by_conversation_id**](docs/ConversationsApi.md#get_questions_by_conversation_id) | **GET** /v1/conversations/{conversationId}/questions | Retrieve questions from conversation
*ConversationsApi* | [**get_topics_by_conversation_id**](docs/ConversationsApi.md#get_topics_by_conversation_id) | **GET** /v1/conversations/{conversationId}/topics | Retrieve topics from conversation
*ConversationsApi* | [**get_trackers_by_conversation_id**](docs/ConversationsApi.md#get_trackers_by_conversation_id) | **GET** /v1/conversations/{conversationId}/trackers | Track the Words and Phrases
*ConversationsApi* | [**put_members_information_by_members_id**](docs/ConversationsApi.md#put_members_information_by_members_id) | **PUT** /v1/conversations/{conversationId}/members/{id} | Update an existing member in an conversation.
*ConversationsApi* | [**put_speakers_event_by_conversation_id**](docs/ConversationsApi.md#put_speakers_event_by_conversation_id) | **PUT** /v1/conversations/{conversationId}/speakers | Speaker Events API provides the functionality to update Speakers who spoke in the conversation after it has been processed.
*DeleteConversationApi* | [**delete_conversation_by_conversation_id**](docs/DeleteConversationApi.md#delete_conversation_by_conversation_id) | **DELETE** /v1/conversations/{conversationId} | deletes conversation and all related entities
*EntitiesApi* | [**get_entities_by_conversation_id**](docs/EntitiesApi.md#get_entities_by_conversation_id) | **GET** /v1/conversations/{conversationId}/entities | Extract Entities from Conversation
*ExternalEventWebHookApi* | [**external_event_web_hook**](docs/ExternalEventWebHookApi.md#external_event_web_hook) | **POST** /v1/event/{connectionId} | WebHook for external events
*FollowUpsApi* | [**get_follow_ups_by_conversation_id**](docs/FollowUpsApi.md#get_follow_ups_by_conversation_id) | **GET** /v1/conversations/{conversationId}/follow-ups | Retrieve follow ups from conversations
*FormattedTranscriptApi* | [**get_formatted_transcript_by_conversation_id**](docs/FormattedTranscriptApi.md#get_formatted_transcript_by_conversation_id) | **POST** /v1/conversations/{conversationId}/transcript | Returns a formatted transcript in Markdown and SRT format.
*InsightsApi* | [**get_insights_by_conversation_id**](docs/InsightsApi.md#get_insights_by_conversation_id) | **GET** /v1/conversations/{conversationId}/insights | Retrieve insights from Conversations
*IntentsApi* | [**get_intents_by_conversation_id**](docs/IntentsApi.md#get_intents_by_conversation_id) | **GET** /v1/conversations/{conversationId}/intents | Retrieve intents from conversation
*JobsApi* | [**get_job_status**](docs/JobsApi.md#get_job_status) | **GET** /v1/job/{jobId} | Retrieve status of a Job
*MembersApi* | [**get_members_by_conversation_id**](docs/MembersApi.md#get_members_by_conversation_id) | **GET** /v1/conversations/{conversationId}/members | Retrieve members from Conversations
*MessagesApi* | [**get_messages_by_conversation_id**](docs/MessagesApi.md#get_messages_by_conversation_id) | **GET** /v1/conversations/{conversationId}/messages | Retrieve messages from Conversations
*MetricApi* | [**add_metric_entry**](docs/MetricApi.md#add_metric_entry) | **POST** /v1/metric/{metricId}/entry | Add new Metric Entry
*MetricApi* | [**get_metric_by_id**](docs/MetricApi.md#get_metric_by_id) | **GET** /v1/metric/{metricId} | Retrieve Metric
*MetricEntryApi* | [**add_metric_entry**](docs/MetricEntryApi.md#add_metric_entry) | **POST** /v1/metric/{metricId}/entry | Add new Metric Entry
*PutMembersInformationApi* | [**put_members_information_by_members_id**](docs/PutMembersInformationApi.md#put_members_information_by_members_id) | **PUT** /v1/conversations/{conversationId}/members/{id} | Update an existing member in an conversation.
*PutSpeakerEventsApi* | [**put_speakers_event_by_conversation_id**](docs/PutSpeakerEventsApi.md#put_speakers_event_by_conversation_id) | **PUT** /v1/conversations/{conversationId}/speakers | Speaker Events API provides the functionality to update Speakers who spoke in the conversation after it has been processed.
*QuestionsApi* | [**get_questions_by_conversation_id**](docs/QuestionsApi.md#get_questions_by_conversation_id) | **GET** /v1/conversations/{conversationId}/questions | Retrieve questions from conversation
*TopicsApi* | [**get_topics_by_conversation_id**](docs/TopicsApi.md#get_topics_by_conversation_id) | **GET** /v1/conversations/{conversationId}/topics | Retrieve topics from conversation
*TrackersApi* | [**get_trackers_by_conversation_id**](docs/TrackersApi.md#get_trackers_by_conversation_id) | **GET** /v1/conversations/{conversationId}/trackers | Track the Words and Phrases

## Documentation For Models

 - [Action](docs/Action.md)
 - [ActionItemListResponse](docs/ActionItemListResponse.md)
 - [AnalyticsListResponse](docs/AnalyticsListResponse.md)
 - [AnalyticsMembersInfo](docs/AnalyticsMembersInfo.md)
 - [AnalyticsMembersInfoOverlap](docs/AnalyticsMembersInfoOverlap.md)
 - [AnalyticsMembersInfoOverlapOverlappingMembers](docs/AnalyticsMembersInfoOverlapOverlappingMembers.md)
 - [AnalyticsMembersInfoPace](docs/AnalyticsMembersInfoPace.md)
 - [AnalyticsMembersInfoTalkTime](docs/AnalyticsMembersInfoTalkTime.md)
 - [AnalyticsMetricsInfo](docs/AnalyticsMetricsInfo.md)
 - [AsyncAudioUrlParameters](docs/AsyncAudioUrlParameters.md)
 - [AsyncConfidenceThreshold](docs/AsyncConfidenceThreshold.md)
 - [AsyncDetectPhrases](docs/AsyncDetectPhrases.md)
 - [AsyncEnableAllTrackers](docs/AsyncEnableAllTrackers.md)
 - [AsyncEntitiesPayload](docs/AsyncEntitiesPayload.md)
 - [AsyncMeetingName](docs/AsyncMeetingName.md)
 - [AsyncMessagesField](docs/AsyncMessagesField.md)
 - [AsyncMessagesFieldInner](docs/AsyncMessagesFieldInner.md)
 - [AsyncResponse](docs/AsyncResponse.md)
 - [AsyncTextParameters](docs/AsyncTextParameters.md)
 - [AsyncTrackers](docs/AsyncTrackers.md)
 - [AsyncTrackersInner](docs/AsyncTrackersInner.md)
 - [AsyncVideoUrlParameters](docs/AsyncVideoUrlParameters.md)
 - [AudioConfig](docs/AudioConfig.md)
 - [Avatar](docs/Avatar.md)
 - [Body](docs/Body.md)
 - [ConversationActionItem](docs/ConversationActionItem.md)
 - [ConversationDataListResponse](docs/ConversationDataListResponse.md)
 - [ConversationFollowUp](docs/ConversationFollowUp.md)
 - [ConversationInsightItem](docs/ConversationInsightItem.md)
 - [ConversationIntent](docs/ConversationIntent.md)
 - [ConversationMessage](docs/ConversationMessage.md)
 - [ConversationQuestion](docs/ConversationQuestion.md)
 - [ConversationSpeakersEvents](docs/ConversationSpeakersEvents.md)
 - [ConversationTopic](docs/ConversationTopic.md)
 - [CustomEntities](docs/CustomEntities.md)
 - [DurationPayload](docs/DurationPayload.md)
 - [Endpoint](docs/Endpoint.md)
 - [EndpointConnectRequest](docs/EndpointConnectRequest.md)
 - [EndpointConnectResponse](docs/EndpointConnectResponse.md)
 - [EndpointRequestData](docs/EndpointRequestData.md)
 - [EntitiesListResponse](docs/EntitiesListResponse.md)
 - [EntitiesTag](docs/EntitiesTag.md)
 - [Error](docs/Error.md)
 - [ExternalEvent](docs/ExternalEvent.md)
 - [FollowUpListResponse](docs/FollowUpListResponse.md)
 - [FormattedTranscript](docs/FormattedTranscript.md)
 - [FormattedTranscriptResponse](docs/FormattedTranscriptResponse.md)
 - [FromPayload](docs/FromPayload.md)
 - [GenericError](docs/GenericError.md)
 - [Grant](docs/Grant.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InsightsListResponse](docs/InsightsListResponse.md)
 - [Intent](docs/Intent.md)
 - [IntentListResponse](docs/IntentListResponse.md)
 - [JobResponse](docs/JobResponse.md)
 - [Language](docs/Language.md)
 - [LocationTrunc](docs/LocationTrunc.md)
 - [MatchesItems](docs/MatchesItems.md)
 - [MatchesItemsInsightRefs](docs/MatchesItemsInsightRefs.md)
 - [MatchesItemsMessageRefs](docs/MatchesItemsMessageRefs.md)
 - [MemberListResponse](docs/MemberListResponse.md)
 - [MembersInfo](docs/MembersInfo.md)
 - [MessageListResponse](docs/MessageListResponse.md)
 - [Metric](docs/Metric.md)
 - [MetricEntry](docs/MetricEntry.md)
 - [MetricEntryCreate](docs/MetricEntryCreate.md)
 - [MetricEntryResponse](docs/MetricEntryResponse.md)
 - [MetricLabel](docs/MetricLabel.md)
 - [MetricResponse](docs/MetricResponse.md)
 - [ModelFrom](docs/ModelFrom.md)
 - [ParentRef](docs/ParentRef.md)
 - [Phrase](docs/Phrase.md)
 - [PutMembersInformationPayload](docs/PutMembersInformationPayload.md)
 - [PutMembersInformationResponse](docs/PutMembersInformationResponse.md)
 - [PutSpeakersEventsPayload](docs/PutSpeakersEventsPayload.md)
 - [PutSpeakersEventsResponse](docs/PutSpeakersEventsResponse.md)
 - [QuestionListResponse](docs/QuestionListResponse.md)
 - [RefreshTokenRequest](docs/RefreshTokenRequest.md)
 - [RevokeTokenRequest](docs/RevokeTokenRequest.md)
 - [Sentiment](docs/Sentiment.md)
 - [SentimentPolarity](docs/SentimentPolarity.md)
 - [SessionTrunc](docs/SessionTrunc.md)
 - [SessionUser](docs/SessionUser.md)
 - [SummaryInfo](docs/SummaryInfo.md)
 - [Tag](docs/Tag.md)
 - [TextPayload](docs/TextPayload.md)
 - [TimeZone](docs/TimeZone.md)
 - [Token](docs/Token.md)
 - [TopicListResponse](docs/TopicListResponse.md)
 - [TrackersListResponse](docs/TrackersListResponse.md)
 - [UnauthorizedError](docs/UnauthorizedError.md)
 - [UserTrunc](docs/UserTrunc.md)
 - [V1conversationsconversationIdtranscriptPhrases](docs/V1conversationsconversationIdtranscriptPhrases.md)
 - [Word](docs/Word.md)

## Documentation For Authorization


## bearerAuth

- **Type**: API key
- **API key parameter name**: x-api-key
- **Location**: HTTP header


## Author

info@symbl.ai
