import re

MAVEDB_EXPERIMENT_SET_URN_DIGITS = 8
MAVEDB_URN_MAX_LENGTH = 64
MAVEDB_URN_NAMESPACE = "mavedb"

# Temp URN
MAVEDB_TMP_URN_PATTERN = r"tmp:[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}"
MAVEDB_TMP_URN_RE = re.compile(MAVEDB_TMP_URN_PATTERN)

# Old temp URN
MAVEDB_OLD_TMP_URN_PATTERN = r"^tmp:[A-Za-z0-9]{16}$"
MAVEDB_OLD_TMP_URN_RE = re.compile(MAVEDB_OLD_TMP_URN_PATTERN)

# Experiment set URN
MAVEDB_EXPERIMENT_SET_URN_PATTERN = rf"urn:{MAVEDB_URN_NAMESPACE}:\d{{{MAVEDB_EXPERIMENT_SET_URN_DIGITS}}}"
MAVEDB_EXPERIMENT_SET_URN_RE = re.compile(MAVEDB_EXPERIMENT_SET_URN_PATTERN)

# Experiment URN
MAVEDB_EXPERIMENT_URN_PATTERN = rf"{MAVEDB_EXPERIMENT_SET_URN_PATTERN}-([a-z]+|0)"
MAVEDB_EXPERIMENT_URN_RE = re.compile(MAVEDB_EXPERIMENT_URN_PATTERN)

# Score set URN
MAVEDB_SCORE_SET_URN_PATTERN = rf"{MAVEDB_EXPERIMENT_URN_PATTERN}-[1-9]\d*"
MAVEDB_SCORE_SET_URN_RE = re.compile(MAVEDB_SCORE_SET_URN_PATTERN)

# Variant URN
MAVEDB_VARIANT_URN_PATTERN = rf"{MAVEDB_SCORE_SET_URN_PATTERN}#[1-9]\d*"
MAVEDB_VARIANT_URN_RE = re.compile(MAVEDB_VARIANT_URN_PATTERN)

# Collection URN
MAVEDB_COLLECTION_URN_PATTERN = r"urn:mavedb:collection-[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}"
MAVEDB_COLLECTION_URN_RE = re.compile(MAVEDB_COLLECTION_URN_PATTERN)

# Any URN
MAVEDB_ANY_URN_PATTERN = "|".join(
    [
        rf"({p})"
        for p in (
            MAVEDB_TMP_URN_PATTERN,
            MAVEDB_EXPERIMENT_SET_URN_PATTERN,
            MAVEDB_EXPERIMENT_URN_PATTERN,
            MAVEDB_SCORE_SET_URN_PATTERN,
            MAVEDB_VARIANT_URN_PATTERN,
        )
    ]
)
MAVEDB_ANY_URN_RE = re.compile(MAVEDB_ANY_URN_PATTERN)
