"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsLoadBalancerController = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s = require("cdk8s");
const constructs_1 = require("constructs");
/**
 * Generate aws-load-balancer-controller config yaml.
 *
 * see https://github.com/kubernetes-sigs/aws-aws-load-balancer-controller/blob/master/docs/install/v2_0_0_full.yaml
 *
 * @stability stable
 */
class AwsLoadBalancerController extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, options) {
        var _b;
        super(scope, id);
        this.serviceAccountName = 'aws-load-balancer-controller';
        this.deploymentName = 'aws-load-balancer-controller';
        this.clusterName = options.clusterName;
        this.namespace = 'default';
        // ingressclassparams elbv2 k8s aws CRD.
        new cdk8s.ApiObject(this, 'aws-load-balancer-controller-ingclassparams-crd', {
            apiVersion: 'apiextensions.k8s.io/v1',
            kind: 'CustomResourceDefinition',
            metadata: {
                annotations: {
                    'controller-gen.kubebuilder.io/version': 'v0.5.0',
                },
                creationTimestamp: null,
                name: 'ingressclassparams.elbv2.k8s.aws',
            },
            spec: {
                group: 'elbv2.k8s.aws',
                names: {
                    kind: 'IngressClassParams',
                    listKind: 'IngressClassParamsList',
                    plural: 'ingressclassparams',
                    singular: 'ingressclassparams',
                },
                scope: 'Cluster',
                versions: [
                    {
                        additionalPrinterColumns: [
                            {
                                description: 'The Ingress Group name',
                                jsonPath: '.spec.group.name',
                                name: 'GROUP-NAME',
                                type: 'string',
                            },
                            {
                                description: 'The AWS Load Balancer scheme',
                                jsonPath: '.spec.scheme',
                                name: 'SCHEME',
                                type: 'string',
                            },
                            {
                                description: 'The AWS Load Balancer ipAddressType',
                                jsonPath: '.spec.ipAddressType',
                                name: 'IP-ADDRESS-TYPE',
                                type: 'string',
                            },
                            {
                                jsonPath: '.metadata.creationTimestamp',
                                name: 'AGE',
                                type: 'date',
                            },
                        ],
                        name: 'v1beta1',
                        schema: {
                            openAPIV3Schema: {
                                description: 'IngressClassParams is the Schema for the IngressClassParams API',
                                properties: {
                                    apiVersion: {
                                        description: 'APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
                                        type: 'string',
                                    },
                                    kind: {
                                        description: 'Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
                                        type: 'string',
                                    },
                                    metadata: {
                                        type: 'object',
                                    },
                                    spec: {
                                        description: 'IngressClassParamsSpec defines the desired state of IngressClassParams',
                                        properties: {
                                            group: {
                                                description: 'Group defines the IngressGroup for all Ingresses that belong to IngressClass with this IngressClassParams.',
                                                properties: {
                                                    name: {
                                                        description: 'Name is the name of IngressGroup.',
                                                        type: 'string',
                                                    },
                                                },
                                                required: [
                                                    'name',
                                                ],
                                                type: 'object',
                                            },
                                            ipAddressType: {
                                                description: 'IPAddressType defines the ip address type for all Ingresses that belong to IngressClass with this IngressClassParams.',
                                                enum: [
                                                    'ipv4',
                                                    'dualstack',
                                                ],
                                                type: 'string',
                                            },
                                            namespaceSelector: {
                                                description: 'NamespaceSelector restrict the namespaces of Ingresses that are allowed to specify the IngressClass with this IngressClassParams. * if absent or present but empty, it selects all namespaces.',
                                                properties: {
                                                    matchExpressions: {
                                                        description: 'matchExpressions is a list of label selector requirements. The requirements are ANDed.',
                                                        items: {
                                                            description: 'A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.',
                                                            properties: {
                                                                key: {
                                                                    description: 'key is the label key that the selector applies to.',
                                                                    type: 'string',
                                                                },
                                                                operator: {
                                                                    description: "operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.",
                                                                    type: 'string',
                                                                },
                                                                values: {
                                                                    description: 'values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.',
                                                                    items: {
                                                                        type: 'string',
                                                                    },
                                                                    type: 'array',
                                                                },
                                                            },
                                                            required: [
                                                                'key',
                                                                'operator',
                                                            ],
                                                            type: 'object',
                                                        },
                                                        type: 'array',
                                                    },
                                                    matchLabels: {
                                                        additionalProperties: {
                                                            type: 'string',
                                                        },
                                                        description: 'matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.',
                                                        type: 'object',
                                                    },
                                                },
                                                type: 'object',
                                            },
                                            scheme: {
                                                description: 'Scheme defines the scheme for all Ingresses that belong to IngressClass with this IngressClassParams.',
                                                enum: [
                                                    'internal',
                                                    'internet-facing',
                                                ],
                                                type: 'string',
                                            },
                                            tags: {
                                                description: 'Tags defines list of Tags on AWS resources provisioned for Ingresses that belong to IngressClass with this IngressClassParams.',
                                                items: {
                                                    description: 'Tag defines a AWS Tag on resources.',
                                                    properties: {
                                                        key: {
                                                            description: 'The key of the tag.',
                                                            type: 'string',
                                                        },
                                                        value: {
                                                            description: 'The value of the tag.',
                                                            type: 'string',
                                                        },
                                                    },
                                                    required: [
                                                        'key',
                                                        'value',
                                                    ],
                                                    type: 'object',
                                                },
                                                type: 'array',
                                            },
                                        },
                                        type: 'object',
                                    },
                                },
                                type: 'object',
                            },
                        },
                        served: true,
                        storage: true,
                        subresources: {},
                    },
                ],
            },
        });
        // targetgroupbindings  elbv2 k8s aws CRD.
        new cdk8s.ApiObject(this, 'aws-load-balancer-controller-tgbinding-crd', {
            apiVersion: 'apiextensions.k8s.io/v1',
            kind: 'CustomResourceDefinition',
            metadata: {
                annotations: {
                    'controller-gen.kubebuilder.io/version': 'v0.5.0',
                },
                creationTimestamp: null,
                name: 'targetgroupbindings.elbv2.k8s.aws',
            },
            spec: {
                group: 'elbv2.k8s.aws',
                names: {
                    kind: 'TargetGroupBinding',
                    listKind: 'TargetGroupBindingList',
                    plural: 'targetgroupbindings',
                    singular: 'targetgroupbinding',
                },
                scope: 'Namespaced',
                versions: [
                    {
                        additionalPrinterColumns: [
                            {
                                description: "The Kubernetes Service's name",
                                jsonPath: '.spec.serviceRef.name',
                                name: 'SERVICE-NAME',
                                type: 'string',
                            },
                            {
                                description: "The Kubernetes Service's port",
                                jsonPath: '.spec.serviceRef.port',
                                name: 'SERVICE-PORT',
                                type: 'string',
                            },
                            {
                                description: "The AWS TargetGroup's TargetType",
                                jsonPath: '.spec.targetType',
                                name: 'TARGET-TYPE',
                                type: 'string',
                            },
                            {
                                description: "The AWS TargetGroup's Amazon Resource Name",
                                jsonPath: '.spec.targetGroupARN',
                                name: 'ARN',
                                priority: 1,
                                type: 'string',
                            },
                            {
                                jsonPath: '.metadata.creationTimestamp',
                                name: 'AGE',
                                type: 'date',
                            },
                        ],
                        name: 'v1alpha1',
                        schema: {
                            openAPIV3Schema: {
                                description: 'TargetGroupBinding is the Schema for the TargetGroupBinding API',
                                properties: {
                                    apiVersion: {
                                        description: 'APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
                                        type: 'string',
                                    },
                                    kind: {
                                        description: 'Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
                                        type: 'string',
                                    },
                                    metadata: {
                                        type: 'object',
                                    },
                                    spec: {
                                        description: 'TargetGroupBindingSpec defines the desired state of TargetGroupBinding',
                                        properties: {
                                            networking: {
                                                description: 'networking provides the networking setup for ELBV2 LoadBalancer to access targets in TargetGroup.',
                                                properties: {
                                                    ingress: {
                                                        description: 'List of ingress rules to allow ELBV2 LoadBalancer to access targets in TargetGroup.',
                                                        items: {
                                                            properties: {
                                                                from: {
                                                                    description: 'List of peers which should be able to access the targets in TargetGroup. At least one NetworkingPeer should be specified.',
                                                                    items: {
                                                                        description: 'NetworkingPeer defines the source/destination peer for networking rules.',
                                                                        properties: {
                                                                            ipBlock: {
                                                                                description: 'IPBlock defines an IPBlock peer. If specified, none of the other fields can be set.',
                                                                                properties: {
                                                                                    cidr: {
                                                                                        description: 'CIDR is the network CIDR. Both IPV4 or IPV6 CIDR are accepted.',
                                                                                        type: 'string',
                                                                                    },
                                                                                },
                                                                                required: [
                                                                                    'cidr',
                                                                                ],
                                                                                type: 'object',
                                                                            },
                                                                            securityGroup: {
                                                                                description: 'SecurityGroup defines a SecurityGroup peer. If specified, none of the other fields can be set.',
                                                                                properties: {
                                                                                    groupID: {
                                                                                        description: 'GroupID is the EC2 SecurityGroupID.',
                                                                                        type: 'string',
                                                                                    },
                                                                                },
                                                                                required: [
                                                                                    'groupID',
                                                                                ],
                                                                                type: 'object',
                                                                            },
                                                                        },
                                                                        type: 'object',
                                                                    },
                                                                    type: 'array',
                                                                },
                                                                ports: {
                                                                    description: 'List of ports which should be made accessible on the targets in TargetGroup. If ports is empty or unspecified, it defaults to all ports with TCP.',
                                                                    items: {
                                                                        properties: {
                                                                            port: {
                                                                                'anyOf': [
                                                                                    {
                                                                                        type: 'integer',
                                                                                    },
                                                                                    {
                                                                                        type: 'string',
                                                                                    },
                                                                                ],
                                                                                'description': 'The port which traffic must match. When NodePort endpoints(instance TargetType) is used, this must be a numerical port. When Port endpoints(ip TargetType) is used, this can be either numerical or named port on pods. if port is unspecified, it defaults to all ports.',
                                                                                'x-kubernetes-int-or-string': true,
                                                                            },
                                                                            protocol: {
                                                                                description: 'The protocol which traffic must match. If protocol is unspecified, it defaults to TCP.',
                                                                                enum: [
                                                                                    'TCP',
                                                                                    'UDP',
                                                                                ],
                                                                                type: 'string',
                                                                            },
                                                                        },
                                                                        type: 'object',
                                                                    },
                                                                    type: 'array',
                                                                },
                                                            },
                                                            required: [
                                                                'from',
                                                                'ports',
                                                            ],
                                                            type: 'object',
                                                        },
                                                        type: 'array',
                                                    },
                                                },
                                                type: 'object',
                                            },
                                            serviceRef: {
                                                description: 'serviceRef is a reference to a Kubernetes Service and ServicePort.',
                                                properties: {
                                                    name: {
                                                        description: 'Name is the name of the Service.',
                                                        type: 'string',
                                                    },
                                                    port: {
                                                        'anyOf': [
                                                            {
                                                                type: 'integer',
                                                            },
                                                            {
                                                                type: 'string',
                                                            },
                                                        ],
                                                        'description': 'Port is the port of the ServicePort.',
                                                        'x-kubernetes-int-or-string': true,
                                                    },
                                                },
                                                required: [
                                                    'name',
                                                    'port',
                                                ],
                                                type: 'object',
                                            },
                                            targetGroupARN: {
                                                description: 'targetGroupARN is the Amazon Resource Name (ARN) for the TargetGroup.',
                                                type: 'string',
                                            },
                                            targetType: {
                                                description: 'targetType is the TargetType of TargetGroup. If unspecified, it will be automatically inferred.',
                                                enum: [
                                                    'instance',
                                                    'ip',
                                                ],
                                                type: 'string',
                                            },
                                        },
                                        required: [
                                            'serviceRef',
                                            'targetGroupARN',
                                        ],
                                        type: 'object',
                                    },
                                    status: {
                                        description: 'TargetGroupBindingStatus defines the observed state of TargetGroupBinding',
                                        properties: {
                                            observedGeneration: {
                                                description: 'The generation observed by the TargetGroupBinding controller.',
                                                format: 'int64',
                                                type: 'integer',
                                            },
                                        },
                                        type: 'object',
                                    },
                                },
                                type: 'object',
                            },
                        },
                        served: true,
                        storage: false,
                        subresources: {
                            status: {},
                        },
                    },
                    {
                        additionalPrinterColumns: [
                            {
                                description: "The Kubernetes Service's name",
                                jsonPath: '.spec.serviceRef.name',
                                name: 'SERVICE-NAME',
                                type: 'string',
                            },
                            {
                                description: "The Kubernetes Service's port",
                                jsonPath: '.spec.serviceRef.port',
                                name: 'SERVICE-PORT',
                                type: 'string',
                            },
                            {
                                description: "The AWS TargetGroup's TargetType",
                                jsonPath: '.spec.targetType',
                                name: 'TARGET-TYPE',
                                type: 'string',
                            },
                            {
                                description: "The AWS TargetGroup's Amazon Resource Name",
                                jsonPath: '.spec.targetGroupARN',
                                name: 'ARN',
                                priority: 1,
                                type: 'string',
                            },
                            {
                                jsonPath: '.metadata.creationTimestamp',
                                name: 'AGE',
                                type: 'date',
                            },
                        ],
                        name: 'v1beta1',
                        schema: {
                            openAPIV3Schema: {
                                description: 'TargetGroupBinding is the Schema for the TargetGroupBinding API',
                                properties: {
                                    apiVersion: {
                                        description: 'APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
                                        type: 'string',
                                    },
                                    kind: {
                                        description: 'Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
                                        type: 'string',
                                    },
                                    metadata: {
                                        type: 'object',
                                    },
                                    spec: {
                                        description: 'TargetGroupBindingSpec defines the desired state of TargetGroupBinding',
                                        properties: {
                                            networking: {
                                                description: 'networking defines the networking rules to allow ELBV2 LoadBalancer to access targets in TargetGroup.',
                                                properties: {
                                                    ingress: {
                                                        description: 'List of ingress rules to allow ELBV2 LoadBalancer to access targets in TargetGroup.',
                                                        items: {
                                                            description: "NetworkingIngressRule defines a particular set of traffic that is allowed to access TargetGroup's targets.",
                                                            properties: {
                                                                from: {
                                                                    description: 'List of peers which should be able to access the targets in TargetGroup. At least one NetworkingPeer should be specified.',
                                                                    items: {
                                                                        description: 'NetworkingPeer defines the source/destination peer for networking rules.',
                                                                        properties: {
                                                                            ipBlock: {
                                                                                description: 'IPBlock defines an IPBlock peer. If specified, none of the other fields can be set.',
                                                                                properties: {
                                                                                    cidr: {
                                                                                        description: 'CIDR is the network CIDR. Both IPV4 or IPV6 CIDR are accepted.',
                                                                                        type: 'string',
                                                                                    },
                                                                                },
                                                                                required: [
                                                                                    'cidr',
                                                                                ],
                                                                                type: 'object',
                                                                            },
                                                                            securityGroup: {
                                                                                description: 'SecurityGroup defines a SecurityGroup peer. If specified, none of the other fields can be set.',
                                                                                properties: {
                                                                                    groupID: {
                                                                                        description: 'GroupID is the EC2 SecurityGroupID.',
                                                                                        type: 'string',
                                                                                    },
                                                                                },
                                                                                required: [
                                                                                    'groupID',
                                                                                ],
                                                                                type: 'object',
                                                                            },
                                                                        },
                                                                        type: 'object',
                                                                    },
                                                                    type: 'array',
                                                                },
                                                                ports: {
                                                                    description: 'List of ports which should be made accessible on the targets in TargetGroup. If ports is empty or unspecified, it defaults to all ports with TCP.',
                                                                    items: {
                                                                        description: 'NetworkingPort defines the port and protocol for networking rules.',
                                                                        properties: {
                                                                            port: {
                                                                                'anyOf': [
                                                                                    {
                                                                                        type: 'integer',
                                                                                    },
                                                                                    {
                                                                                        type: 'string',
                                                                                    },
                                                                                ],
                                                                                'description': 'The port which traffic must match. When NodePort endpoints(instance TargetType) is used, this must be a numerical port. When Port endpoints(ip TargetType) is used, this can be either numerical or named port on pods. if port is unspecified, it defaults to all ports.',
                                                                                'x-kubernetes-int-or-string': true,
                                                                            },
                                                                            protocol: {
                                                                                description: 'The protocol which traffic must match. If protocol is unspecified, it defaults to TCP.',
                                                                                enum: [
                                                                                    'TCP',
                                                                                    'UDP',
                                                                                ],
                                                                                type: 'string',
                                                                            },
                                                                        },
                                                                        type: 'object',
                                                                    },
                                                                    type: 'array',
                                                                },
                                                            },
                                                            required: [
                                                                'from',
                                                                'ports',
                                                            ],
                                                            type: 'object',
                                                        },
                                                        type: 'array',
                                                    },
                                                },
                                                type: 'object',
                                            },
                                            nodeSelector: {
                                                description: 'node selector for instance type target groups to only register certain nodes',
                                                properties: {
                                                    matchExpressions: {
                                                        description: 'matchExpressions is a list of label selector requirements. The requirements are ANDed.',
                                                        items: {
                                                            description: 'A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.',
                                                            properties: {
                                                                key: {
                                                                    description: 'key is the label key that the selector applies to.',
                                                                    type: 'string',
                                                                },
                                                                operator: {
                                                                    description: "operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.",
                                                                    type: 'string',
                                                                },
                                                                values: {
                                                                    description: 'values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.',
                                                                    items: {
                                                                        type: 'string',
                                                                    },
                                                                    type: 'array',
                                                                },
                                                            },
                                                            required: [
                                                                'key',
                                                                'operator',
                                                            ],
                                                            type: 'object',
                                                        },
                                                        type: 'array',
                                                    },
                                                    matchLabels: {
                                                        additionalProperties: {
                                                            type: 'string',
                                                        },
                                                        description: 'matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.',
                                                        type: 'object',
                                                    },
                                                },
                                                type: 'object',
                                            },
                                            serviceRef: {
                                                description: 'serviceRef is a reference to a Kubernetes Service and ServicePort.',
                                                properties: {
                                                    name: {
                                                        description: 'Name is the name of the Service.',
                                                        type: 'string',
                                                    },
                                                    port: {
                                                        'anyOf': [
                                                            {
                                                                type: 'integer',
                                                            },
                                                            {
                                                                type: 'string',
                                                            },
                                                        ],
                                                        'description': 'Port is the port of the ServicePort.',
                                                        'x-kubernetes-int-or-string': true,
                                                    },
                                                },
                                                required: [
                                                    'name',
                                                    'port',
                                                ],
                                                type: 'object',
                                            },
                                            targetGroupARN: {
                                                description: 'targetGroupARN is the Amazon Resource Name (ARN) for the TargetGroup.',
                                                minLength: 1,
                                                type: 'string',
                                            },
                                            targetType: {
                                                description: 'targetType is the TargetType of TargetGroup. If unspecified, it will be automatically inferred.',
                                                enum: [
                                                    'instance',
                                                    'ip',
                                                ],
                                                type: 'string',
                                            },
                                        },
                                        required: [
                                            'serviceRef',
                                            'targetGroupARN',
                                        ],
                                        type: 'object',
                                    },
                                    status: {
                                        description: 'TargetGroupBindingStatus defines the observed state of TargetGroupBinding',
                                        properties: {
                                            observedGeneration: {
                                                description: 'The generation observed by the TargetGroupBinding controller.',
                                                format: 'int64',
                                                type: 'integer',
                                            },
                                        },
                                        type: 'object',
                                    },
                                },
                                type: 'object',
                            },
                        },
                        served: true,
                        storage: true,
                        subresources: {
                            status: {},
                        },
                    },
                ],
            },
        });
        new cdk8s.Helm(this, 'helmawsLoadBalancerController', {
            chart: 'eks/aws-load-balancer-controller',
            releaseName: 'aws-load-balancer-controller',
            values: {
                clusterName: options.clusterName,
                serviceAccount: {
                    create: (_b = options.createServiceAccount) !== null && _b !== void 0 ? _b : true,
                    name: this.serviceAccountName,
                },
            },
        });
    }
}
exports.AwsLoadBalancerController = AwsLoadBalancerController;
_a = JSII_RTTI_SYMBOL_1;
AwsLoadBalancerController[_a] = { fqn: "cdk8s-aws-load-balancer-controller.AwsLoadBalancerController", version: "2.2.1" };
//# sourceMappingURL=data:application/json;base64,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