"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsLoadBalancePolicy = exports.VersionsLists = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
/**
 * @stability stable
 */
var VersionsLists;
(function (VersionsLists) {
    VersionsLists["AWS_LOAD_BALANCER_CONTROLLER_POLICY_V1"] = "v1";
    VersionsLists["AWS_LOAD_BALANCER_CONTROLLER_POLICY_V2"] = "v2";
})(VersionsLists = exports.VersionsLists || (exports.VersionsLists = {}));
const awsLoadBalancerControllerPolicyV1 = {
    actions: [
        'acm:DescribeCertificate',
        'acm:ListCertificates',
        'acm:GetCertificate',
        'ec2:AuthorizeSecurityGroupIngress',
        'ec2:CreateSecurityGroup',
        'ec2:CreateTags',
        'ec2:DeleteTags',
        'ec2:DeleteSecurityGroup',
        'ec2:DescribeAccountAttributes',
        'ec2:DescribeAddresses',
        'ec2:DescribeInstances',
        'ec2:DescribeInstanceStatus',
        'ec2:DescribeInternetGateways',
        'ec2:DescribeNetworkInterfaces',
        'ec2:DescribeSecurityGroups',
        'ec2:DescribeSubnets',
        'ec2:DescribeTags',
        'ec2:DescribeVpcs',
        'ec2:ModifyInstanceAttribute',
        'ec2:ModifyNetworkInterfaceAttribute',
        'ec2:RevokeSecurityGroupIngress',
        'elasticloadbalancing:AddListenerCertificates',
        'elasticloadbalancing:AddTags',
        'elasticloadbalancing:CreateListener',
        'elasticloadbalancing:CreateLoadBalancer',
        'elasticloadbalancing:CreateRule',
        'elasticloadbalancing:CreateTargetGroup',
        'elasticloadbalancing:DeleteListener',
        'elasticloadbalancing:DeleteLoadBalancer',
        'elasticloadbalancing:DeleteRule',
        'elasticloadbalancing:DeleteTargetGroup',
        'elasticloadbalancing:DeregisterTargets',
        'elasticloadbalancing:DescribeListenerCertificates',
        'elasticloadbalancing:DescribeListeners',
        'elasticloadbalancing:DescribeLoadBalancers',
        'elasticloadbalancing:DescribeLoadBalancerAttributes',
        'elasticloadbalancing:DescribeRules',
        'elasticloadbalancing:DescribeSSLPolicies',
        'elasticloadbalancing:DescribeTags',
        'elasticloadbalancing:DescribeTargetGroups',
        'elasticloadbalancing:DescribeTargetGroupAttributes',
        'elasticloadbalancing:DescribeTargetHealth',
        'elasticloadbalancing:ModifyListener',
        'elasticloadbalancing:ModifyLoadBalancerAttributes',
        'elasticloadbalancing:ModifyRule',
        'elasticloadbalancing:ModifyTargetGroup',
        'elasticloadbalancing:ModifyTargetGroupAttributes',
        'elasticloadbalancing:RegisterTargets',
        'elasticloadbalancing:RemoveListenerCertificates',
        'elasticloadbalancing:RemoveTags',
        'elasticloadbalancing:SetIpAddressType',
        'elasticloadbalancing:SetSecurityGroups',
        'elasticloadbalancing:SetSubnets',
        'elasticloadbalancing:SetWebAcl',
        'iam:CreateServiceLinkedRole',
        'iam:GetServerCertificate',
        'iam:ListServerCertificates',
        'cognito-idp:DescribeUserPoolClient',
        'waf-regional:GetWebACLForResource',
        'waf-regional:GetWebACL',
        'waf-regional:AssociateWebACL',
        'waf-regional:DisassociateWebACL',
        'tag:GetResources',
        'tag:TagResources',
        'waf:GetWebACL',
        'wafv2:GetWebACL',
        'wafv2:GetWebACLForResource',
        'wafv2:AssociateWebACL',
        'wafv2:DisassociateWebACL',
        'shield:DescribeProtection',
        'shield:GetSubscriptionState',
        'shield:DeleteProtection',
        'shield:CreateProtection',
        'shield:DescribeSubscription',
    ],
    resources: ['*'],
};
const awsLoadBalancerControllerPolicyV2 = [
    [
        {
            Effect: 'Allow',
            Action: [
                'iam:CreateServiceLinkedRole',
                'ec2:DescribeAccountAttributes',
                'ec2:DescribeAddresses',
                'ec2:DescribeAvailabilityZones',
                'ec2:DescribeInternetGateways',
                'ec2:DescribeVpcs',
                'ec2:DescribeSubnets',
                'ec2:DescribeSecurityGroups',
                'ec2:DescribeInstances',
                'ec2:DescribeNetworkInterfaces',
                'ec2:DescribeTags',
                'ec2:GetCoipPoolUsage',
                'ec2:DescribeCoipPools',
                'elasticloadbalancing:DescribeLoadBalancers',
                'elasticloadbalancing:DescribeLoadBalancerAttributes',
                'elasticloadbalancing:DescribeListeners',
                'elasticloadbalancing:DescribeListenerCertificates',
                'elasticloadbalancing:DescribeSSLPolicies',
                'elasticloadbalancing:DescribeRules',
                'elasticloadbalancing:DescribeTargetGroups',
                'elasticloadbalancing:DescribeTargetGroupAttributes',
                'elasticloadbalancing:DescribeTargetHealth',
                'elasticloadbalancing:DescribeTags',
            ],
            Resource: '*',
        },
        {
            Effect: 'Allow',
            Action: [
                'cognito-idp:DescribeUserPoolClient',
                'acm:ListCertificates',
                'acm:DescribeCertificate',
                'iam:ListServerCertificates',
                'iam:GetServerCertificate',
                'waf-regional:GetWebACL',
                'waf-regional:GetWebACLForResource',
                'waf-regional:AssociateWebACL',
                'waf-regional:DisassociateWebACL',
                'wafv2:GetWebACL',
                'wafv2:GetWebACLForResource',
                'wafv2:AssociateWebACL',
                'wafv2:DisassociateWebACL',
                'shield:GetSubscriptionState',
                'shield:DescribeProtection',
                'shield:CreateProtection',
                'shield:DeleteProtection',
            ],
            Resource: '*',
        },
        {
            Effect: 'Allow',
            Action: [
                'ec2:AuthorizeSecurityGroupIngress',
                'ec2:RevokeSecurityGroupIngress',
            ],
            Resource: '*',
        },
        {
            Effect: 'Allow',
            Action: [
                'ec2:CreateSecurityGroup',
            ],
            Resource: '*',
        },
        {
            Effect: 'Allow',
            Action: [
                'ec2:CreateTags',
            ],
            Resource: 'arn:aws:ec2:*:*:security-group/*',
            Condition: {
                StringEquals: {
                    'ec2:CreateAction': 'CreateSecurityGroup',
                },
                Null: {
                    'aws:RequestTag/elbv2.k8s.aws/cluster': 'false',
                },
            },
        },
        {
            Effect: 'Allow',
            Action: [
                'ec2:CreateTags',
                'ec2:DeleteTags',
            ],
            Resource: 'arn:aws:ec2:*:*:security-group/*',
            Condition: {
                Null: {
                    'aws:RequestTag/elbv2.k8s.aws/cluster': 'true',
                    'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
                },
            },
        },
        {
            Effect: 'Allow',
            Action: [
                'ec2:AuthorizeSecurityGroupIngress',
                'ec2:RevokeSecurityGroupIngress',
                'ec2:DeleteSecurityGroup',
            ],
            Resource: '*',
            Condition: {
                Null: {
                    'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
                },
            },
        },
        {
            Effect: 'Allow',
            Action: [
                'elasticloadbalancing:CreateLoadBalancer',
                'elasticloadbalancing:CreateTargetGroup',
            ],
            Resource: '*',
            Condition: {
                Null: {
                    'aws:RequestTag/elbv2.k8s.aws/cluster': 'false',
                },
            },
        },
        {
            Effect: 'Allow',
            Action: [
                'elasticloadbalancing:CreateListener',
                'elasticloadbalancing:DeleteListener',
                'elasticloadbalancing:CreateRule',
                'elasticloadbalancing:DeleteRule',
            ],
            Resource: '*',
        },
        {
            Effect: 'Allow',
            Action: [
                'elasticloadbalancing:AddTags',
                'elasticloadbalancing:RemoveTags',
            ],
            Resource: [
                'arn:aws:elasticloadbalancing:*:*:targetgroup/*/*',
                'arn:aws:elasticloadbalancing:*:*:loadbalancer/net/*/*',
                'arn:aws:elasticloadbalancing:*:*:loadbalancer/app/*/*',
            ],
            Condition: {
                Null: {
                    'aws:RequestTag/elbv2.k8s.aws/cluster': 'true',
                    'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
                },
            },
        },
        {
            Effect: 'Allow',
            Action: [
                'elasticloadbalancing:AddTags',
                'elasticloadbalancing:RemoveTags',
            ],
            Resource: [
                'arn:aws:elasticloadbalancing:*:*:listener/net/*/*/*',
                'arn:aws:elasticloadbalancing:*:*:listener/app/*/*/*',
                'arn:aws:elasticloadbalancing:*:*:listener-rule/net/*/*/*',
                'arn:aws:elasticloadbalancing:*:*:listener-rule/app/*/*/*',
            ],
        },
        {
            Effect: 'Allow',
            Action: [
                'elasticloadbalancing:ModifyLoadBalancerAttributes',
                'elasticloadbalancing:SetIpAddressType',
                'elasticloadbalancing:SetSecurityGroups',
                'elasticloadbalancing:SetSubnets',
                'elasticloadbalancing:DeleteLoadBalancer',
                'elasticloadbalancing:ModifyTargetGroup',
                'elasticloadbalancing:ModifyTargetGroupAttributes',
                'elasticloadbalancing:DeleteTargetGroup',
            ],
            Resource: '*',
            Condition: {
                Null: {
                    'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
                },
            },
        },
        {
            Effect: 'Allow',
            Action: [
                'elasticloadbalancing:RegisterTargets',
                'elasticloadbalancing:DeregisterTargets',
            ],
            Resource: 'arn:aws:elasticloadbalancing:*:*:targetgroup/*/*',
        },
        {
            Effect: 'Allow',
            Action: [
                'elasticloadbalancing:SetWebAcl',
                'elasticloadbalancing:ModifyListener',
                'elasticloadbalancing:AddListenerCertificates',
                'elasticloadbalancing:RemoveListenerCertificates',
                'elasticloadbalancing:ModifyRule',
            ],
            Resource: '*',
        },
    ],
];
/**
 * awsLoadBalancePolicy class ,help you add policy to your Iam Role for service account.
 *
 * @stability stable
 */
class AwsLoadBalancePolicy {
    /**
     * @stability stable
     */
    static addPolicy(version, role) {
        if (version == 'v1') {
            role.addToPolicy(new iam.PolicyStatement(awsLoadBalancerControllerPolicyV1));
            return role;
        }
        if (version == 'v2') {
            awsLoadBalancerControllerPolicyV2.forEach(element => {
                role.addToPrincipalPolicy(iam.PolicyStatement.fromJson(element));
            });
            return role;
        }
    }
}
exports.AwsLoadBalancePolicy = AwsLoadBalancePolicy;
_a = JSII_RTTI_SYMBOL_1;
AwsLoadBalancePolicy[_a] = { fqn: "cdk8s-aws-load-balancer-controller.AwsLoadBalancePolicy", version: "2.2.1" };
;
//# sourceMappingURL=data:application/json;base64,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