# -*- coding: utf-8 -*-
# Generated by Django 1.10.1 on 2016-11-17 16:57
from __future__ import unicode_literals

from django.db import migrations


def set_post_year(apps, schema_editor):
    """
    Re-saves every scrobble, so that its auto-generated `post_year` can
    be set.
    """
    Scrobble = apps.get_model('lastfm', 'Scrobble')
    for row in Scrobble.objects.all():
        row.post_year = row.post_time.year
        row.save()


class Migration(migrations.Migration):

    dependencies = [
        ('lastfm', '0006_scrobble_post_year'),
    ]

    operations = [
        migrations.RunPython(set_post_year, reverse_code=migrations.RunPython.noop),
    ]

