"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnHealthcheck = exports.Method = exports.HttpVersion = exports.toJson_CfnHealthcheckProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnHealthcheckProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnHealthcheckProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'CheckInterval': obj.checkInterval,
        'Comment': obj.comment,
        'ExpectedResponse': obj.expectedResponse,
        'Host': obj.host,
        'HttpVersion': obj.httpVersion,
        'Initial': obj.initial,
        'Method': obj.method,
        'Name': obj.name,
        'Path': obj.path,
        'Threshold': obj.threshold,
        'Timeout': obj.timeout,
        'Window': obj.window,
        'ServiceId': obj.serviceId,
        'VersionId': obj.versionId,
        'HealthcheckName': obj.healthcheckName,
        'Version': obj.version,
        'CreatedAt': obj.createdAt?.toISOString(),
        'UpdatedAt': obj.updatedAt?.toISOString(),
        'DeletedAt': obj.deletedAt?.toISOString(),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnHealthcheckProps = toJson_CfnHealthcheckProps;
/* eslint-enable max-len, quote-props */
/**
 * Whether to use version 1.0 or 1.1 HTTP.
 *
 * @schema HttpVersion
 */
var HttpVersion;
(function (HttpVersion) {
    /** 1.0 */
    HttpVersion["VALUE_1_0"] = "1.0";
    /** 1.1 */
    HttpVersion["VALUE_1_1"] = "1.1";
})(HttpVersion = exports.HttpVersion || (exports.HttpVersion = {}));
/**
 * Which HTTP method to use.
 *
 * @schema Method
 */
var Method;
(function (Method) {
    /** HEAD */
    Method["HEAD"] = "HEAD";
    /** GET */
    Method["GET"] = "GET";
    /** POST */
    Method["POST"] = "POST";
})(Method = exports.Method || (exports.Method = {}));
/**
 * A CloudFormation `Fastly::Services::Healthcheck`
 *
 * @cloudformationResource Fastly::Services::Healthcheck
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers.git
 */
class CfnHealthcheck extends cdk.CfnResource {
    /**
     * Create a new `Fastly::Services::Healthcheck`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnHealthcheck.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnHealthcheckProps(props) });
        this.props = props;
    }
}
exports.CfnHealthcheck = CfnHealthcheck;
_a = JSII_RTTI_SYMBOL_1;
CfnHealthcheck[_a] = { fqn: "@cdk-cloudformation/fastly-services-healthcheck.CfnHealthcheck", version: "1.0.0-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnHealthcheck.CFN_RESOURCE_TYPE_NAME = "Fastly::Services::Healthcheck";
//# sourceMappingURL=data:application/json;base64,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