import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage a Fastly service health check.
 *
 * @schema CfnHealthcheckProps
 */
export interface CfnHealthcheckProps {
    /**
     * @schema CfnHealthcheckProps#CheckInterval
     */
    readonly checkInterval?: number;
    /**
     * @schema CfnHealthcheckProps#Comment
     */
    readonly comment?: string;
    /**
     * @schema CfnHealthcheckProps#ExpectedResponse
     */
    readonly expectedResponse?: number;
    /**
     * @schema CfnHealthcheckProps#Host
     */
    readonly host?: string;
    /**
     * @schema CfnHealthcheckProps#HttpVersion
     */
    readonly httpVersion?: HttpVersion;
    /**
     * @schema CfnHealthcheckProps#Initial
     */
    readonly initial?: number;
    /**
     * @schema CfnHealthcheckProps#Method
     */
    readonly method?: Method;
    /**
     * @schema CfnHealthcheckProps#Name
     */
    readonly name: string;
    /**
     * @schema CfnHealthcheckProps#Path
     */
    readonly path?: string;
    /**
     * @schema CfnHealthcheckProps#Threshold
     */
    readonly threshold?: number;
    /**
     * @schema CfnHealthcheckProps#Timeout
     */
    readonly timeout?: number;
    /**
     * @schema CfnHealthcheckProps#Window
     */
    readonly window?: number;
    /**
     * @schema CfnHealthcheckProps#ServiceId
     */
    readonly serviceId: string;
    /**
     * @schema CfnHealthcheckProps#VersionId
     */
    readonly versionId: string;
    /**
     * @schema CfnHealthcheckProps#HealthcheckName
     */
    readonly healthcheckName?: string;
    /**
     * @schema CfnHealthcheckProps#Version
     */
    readonly version?: string;
    /**
     * @schema CfnHealthcheckProps#CreatedAt
     */
    readonly createdAt?: Date;
    /**
     * @schema CfnHealthcheckProps#UpdatedAt
     */
    readonly updatedAt?: Date;
    /**
     * @schema CfnHealthcheckProps#DeletedAt
     */
    readonly deletedAt?: Date;
}
/**
 * Converts an object of type 'CfnHealthcheckProps' to JSON representation.
 */
export declare function toJson_CfnHealthcheckProps(obj: CfnHealthcheckProps | undefined): Record<string, any> | undefined;
/**
 * Whether to use version 1.0 or 1.1 HTTP.
 *
 * @schema HttpVersion
 */
export declare enum HttpVersion {
    /** 1.0 */
    VALUE_1_0 = "1.0",
    /** 1.1 */
    VALUE_1_1 = "1.1"
}
/**
 * Which HTTP method to use.
 *
 * @schema Method
 */
export declare enum Method {
    /** HEAD */
    HEAD = "HEAD",
    /** GET */
    GET = "GET",
    /** POST */
    POST = "POST"
}
/**
 * A CloudFormation `Fastly::Services::Healthcheck`
 *
 * @cloudformationResource Fastly::Services::Healthcheck
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers.git
 */
export declare class CfnHealthcheck extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Fastly::Services::Healthcheck";
    /**
     * Resource props.
     */
    readonly props: CfnHealthcheckProps;
    /**
     * Create a new `Fastly::Services::Healthcheck`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnHealthcheckProps);
}
