#################### Maintained by Hatch ####################
# This file is auto-generated by hatch. If you'd like to customize this file
# please add your changes near the bottom marked for 'USER OVERRIDES'.
# EVERYTHING ELSE WILL BE OVERWRITTEN by hatch.
#############################################################
from io import open

from setuptools import find_packages, setup

with open('lotusops/__init__.py', 'r') as f:
    for line in f:
        if line.startswith('__version__'):
            version = line.strip().split('=')[1].strip(' \'"')
            break
    else:
        version = '0.0.1'

with open('README.md', 'r', encoding='utf-8') as f:
    readme = f.read()

REQUIRES = ['toml']

import versioneer

commands = versioneer.get_cmdclass()

import config

kwargs = {
    'name': 'lotusops',
    'version': version,
    'description': '',
    'long_description': readme,
    'author': 'gaojunying',
    'author_email': 'gustav0125@outlook.com',
    'maintainer': 'gaojunying',
    'maintainer_email': 'gustav0125@outlook.com',
    'url': 'https://github.com/deep2essence/lotusops',
    'license': 'MIT/Apache-2.0',
    'entry_points':{
        "console_scripts":config.entry_points
    },   
    'classifiers': [
        'Development Status :: 4 - Beta',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'License :: OSI Approved :: Apache Software License',
        'Natural Language :: English',
        'Operating System :: OS Independent',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: Implementation :: CPython',
        'Programming Language :: Python :: Implementation :: PyPy',
    ],
    'install_requires': REQUIRES,
    'tests_require': ['coverage', 'pytest'],
    'packages': find_packages(exclude=('tests', 'tests.*')),
    'cmdclass':commands,
    'data_files':[('/etc/lotusops/config/', ['config/setting.toml'])]

}

#################### BEGIN USER OVERRIDES ####################
# Add your customizations in this section.

###################### END USER OVERRIDES ####################

setup(**kwargs)
